/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.xml;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.CriteriaEvaluationException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.query.eval.CriteriaEvaluator;
import com.metamatrix.query.eval.LookupEvaluator;
import com.metamatrix.query.processor.xml.Condition;
import com.metamatrix.query.processor.xml.ProcessorEnvironment;
import com.metamatrix.query.processor.xml.Program;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CriteriaCondition
extends Condition {
    protected Criteria criteria;
    private List resultSetNames;

    public CriteriaCondition(Criteria criteria, List resultSetNames, Program thenProgram) {
        super(thenProgram);
        this.criteria = criteria;
        this.resultSetNames = resultSetNames;
    }

    public List getResultSetNames() {
        return this.resultSetNames;
    }

    public boolean evaluate(ProcessorEnvironment env) throws BlockedException, MetaMatrixComponentException {
        HashMap<ElementSymbol, Integer> elementMap = Collections.EMPTY_MAP;
        ArrayList data = Collections.EMPTY_LIST;
        if (this.resultSetNames != null) {
            elementMap = new HashMap<ElementSymbol, Integer>();
            data = new ArrayList();
            Iterator i = this.resultSetNames.iterator();
            while (i.hasNext()) {
                String rsName = (String)i.next();
                Map indexes = env.getElementMap(rsName);
                List groupData = env.getCurrentRow(rsName);
                int endIndex = data.size();
                if (groupData == null) continue;
                data.addAll(groupData);
                Iterator j = indexes.entrySet().iterator();
                while (j.hasNext()) {
                    Map.Entry entry = j.next();
                    ElementSymbol key = (ElementSymbol)entry.getKey();
                    if (elementMap.containsKey(key)) continue;
                    Integer index = (Integer)entry.getValue();
                    int newIndex = index + endIndex;
                    elementMap.put(key, new Integer(newIndex));
                }
            }
        }
        try {
            return CriteriaEvaluator.evaluate((Criteria)this.criteria, elementMap, data, (LookupEvaluator)env.getDataManager(), (CommandContext)env.getProcessorContext());
        }
        catch (CriteriaEvaluationException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    public String toString() {
        return this.criteria.toString();
    }
}

