/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.xml;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.common.buffer.TupleSource;
import com.metamatrix.common.buffer.TupleSourceID;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.processor.ProcessorDataManager;
import com.metamatrix.query.processor.ProcessorPlan;
import com.metamatrix.query.processor.xml.AbstractProcessorEnvironment;
import com.metamatrix.query.processor.xml.DocumentInProgress;
import com.metamatrix.query.processor.xml.ProcessorEnvironment;
import com.metamatrix.query.processor.xml.ProcessorInstruction;
import com.metamatrix.query.processor.xml.Program;
import com.metamatrix.query.processor.xml.XMLPlan;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class AbstractProcessorEnvironment
implements ProcessorEnvironment {
    private XMLPlan plan;
    private Map resultSetStates = new HashMap();
    private TupleSourceMap tupleSourceMap = new TupleSourceMap(this, null);
    private LinkedList tupleSourceRecursionStack = new LinkedList();
    private LinkedList programStack = new LinkedList();
    private DocumentInProgress documentInProgress;
    private Collection stagingTableGroupsSymbols;
    private Map rowLimits = new HashMap();
    private String xmlFormat;
    private String xmlResultsForm;
    private GroupSymbol documentGroup;

    protected AbstractProcessorEnvironment() {
    }

    ResultSetState getResultSetState(String resultSetName) {
        String resultSetKey = resultSetName.toUpperCase();
        ResultSetState state = (ResultSetState)this.resultSetStates.get(resultSetKey);
        return state;
    }

    public void initialize(XMLPlan plan) {
        this.plan = plan;
    }

    public void reset(Program initialProgram) {
        this.programStack = new LinkedList();
        ProgramState programState = new ProgramState(null);
        ProgramState.access$302((ProgramState)programState, (Program)initialProgram);
        this.programStack.addFirst(programState);
        this.resetResultSetStates();
        this.tupleSourceMap = new TupleSourceMap(this, null);
        this.tupleSourceRecursionStack = new LinkedList();
        this.documentInProgress = null;
    }

    private void resetResultSetStates() {
        Iterator entries = this.resultSetStates.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            ResultSetState state = (ResultSetState)entry.getValue();
            if (state.maskedState == null) continue;
            while (state.maskedState != null) {
                state = state.maskedState;
            }
            entry.setValue(state);
        }
    }

    protected XMLPlan getPlan() {
        return this.plan;
    }

    public void registerResultSet(String resultSetName, Object command, List referencesBoundToResultSet, List replacementExpressions) throws MetaMatrixComponentException {
        String resultSetKey = resultSetName.toUpperCase();
        ResultSetState state = new ResultSetState();
        state.resultSetName = resultSetKey;
        state.resultSetObject = command;
        state.references = referencesBoundToResultSet;
        state.replacementExpressions = replacementExpressions;
        ResultSetState maskedState = (ResultSetState)this.resultSetStates.get(resultSetKey);
        if (maskedState != null) {
            state.maskedState = maskedState;
        }
        this.resultSetStates.put(resultSetKey, state);
    }

    public void deregisterResultSet(String resultSetName) {
        String resultSetKey = resultSetName.toUpperCase();
        ResultSetState state = (ResultSetState)this.resultSetStates.remove(resultSetKey);
        if (state.maskedState != null) {
            this.resultSetStates.put(resultSetKey, state.maskedState);
            List currentRow = this.tupleSourceMap.getCurrentRow(resultSetKey);
            Map elementMap = this.tupleSourceMap.getElementMap(resultSetKey);
            ResultSetState.access$400((ResultSetState)state.maskedState, (List)currentRow, (Map)elementMap);
        }
    }

    public void cacheTupleSources() {
        this.tupleSourceRecursionStack.addFirst(this.tupleSourceMap);
        this.tupleSourceMap = new TupleSourceMap(this, null);
        LogManager.logTrace("XML_PLAN", new Object[]{"Processor Environment cached results, " + this.tupleSourceRecursionStack.size() + " cached."});
    }

    public void uncacheTupleSources() {
        this.tupleSourceMap = (TupleSourceMap)this.tupleSourceRecursionStack.removeFirst();
        LogManager.logTrace("XML_PLAN", new Object[]{"Processor Environment uncached results, " + this.tupleSourceRecursionStack.size() + " cached."});
    }

    public abstract void loadResultSet(String var1) throws MetaMatrixComponentException;

    public Program getCurrentProgram() {
        if (this.programStack.size() > 0) {
            ProgramState programState = (ProgramState)this.programStack.getFirst();
            return ProgramState.access$300((ProgramState)programState);
        }
        return null;
    }

    public boolean isRecursiveProgramInStack() {
        Iterator stackedPrograms = this.programStack.iterator();
        ProgramState programState = (ProgramState)stackedPrograms.next();
        while (ProgramState.access$500((ProgramState)programState) == 0 && stackedPrograms.hasNext()) {
            programState = (ProgramState)stackedPrograms.next();
        }
        return ProgramState.access$500((ProgramState)programState) > 0;
    }

    public void incrementCurrentProgramCounter() {
        ProgramState programState = (ProgramState)this.programStack.getFirst();
        ProgramState.access$608((ProgramState)programState);
        while (this.programStack.size() > 1 && ProgramState.access$600((ProgramState)programState) >= ProgramState.access$300((ProgramState)programState).getProcessorInstructions().size()) {
            this.programStack.removeFirst();
            if (LogManager.isMessageToBeRecorded("XML_PLAN", 6)) {
                LogManager.logTrace("XML_PLAN", new Object[]{"Processor Environment popped program w/ recursion count " + ProgramState.access$500((ProgramState)programState), "; " + this.programStack.size(), " programs left."});
            }
            programState = (ProgramState)this.programStack.getFirst();
        }
    }

    public void pushProgram(Program program) {
        this.pushProgram(program, false);
    }

    public void pushProgram(Program program, boolean isRecursive) {
        ProgramState programState = new ProgramState(null);
        ProgramState.access$302((ProgramState)programState, (Program)program);
        if (isRecursive) {
            ProgramState previousState = this.getProgramState(program);
            if (previousState != null) {
                ProgramState.access$502((ProgramState)programState, (int)(ProgramState.access$500((ProgramState)previousState) + 1));
            } else {
                ProgramState.access$502((ProgramState)programState, (int)1);
            }
            LogManager.logTrace("XML_PLAN", new Object[]{"Pushed recursive program w/ recursion count " + ProgramState.access$500((ProgramState)programState)});
        } else {
            LogManager.logTrace("XML_PLAN", new Object[]{"Pushed non-recursive program w/ recursion count " + ProgramState.access$500((ProgramState)programState)});
        }
        this.programStack.addFirst(programState);
    }

    public ProcessorInstruction getCurrentInstruction() {
        ProgramState programState = (ProgramState)this.programStack.getFirst();
        if (programState != null && ProgramState.access$300((ProgramState)programState).getProcessorInstructions().isEmpty()) {
            this.incrementCurrentProgramCounter();
            programState = (ProgramState)this.programStack.getFirst();
        }
        if (programState == null) {
            return null;
        }
        return ProgramState.access$300((ProgramState)programState).getInstructionAt(ProgramState.access$600((ProgramState)programState));
    }

    public int getProgramRecursionCount(Program program) {
        ProgramState programState = this.getProgramState(program);
        if (programState == null) {
            return 0;
        }
        return ProgramState.access$500((ProgramState)programState);
    }

    private ProgramState getProgramState(Program program) {
        ProgramState result = null;
        Iterator stackedPrograms = this.programStack.iterator();
        while (stackedPrograms.hasNext()) {
            ProgramState programState = (ProgramState)stackedPrograms.next();
            Program stackedProgram = ProgramState.access$300((ProgramState)programState);
            if (stackedProgram != program) continue;
            result = programState;
            break;
        }
        return result;
    }

    public void deliverResults(String resultSetName, TupleSourceID tsID, TupleSource source) throws MetaMatrixComponentException {
        source.openSource();
        String resultSetKey = resultSetName.toUpperCase();
        this.tupleSourceMap.setTupleSource(resultSetKey, source);
        this.tupleSourceMap.setTupleSourceID(resultSetKey, tsID);
    }

    public List getCurrentRow(String resultSetName) {
        return this.tupleSourceMap.getCurrentRow(resultSetName);
    }

    public boolean iterateCursor(String resultSetName) throws MetaMatrixComponentException, MetaMatrixProcessingException {
        String resultSetKey = resultSetName.toUpperCase();
        this.tupleSourceMap.incrementCurrentRow(resultSetKey);
        List row = this.tupleSourceMap.getCurrentRow(resultSetKey);
        ResultSetState state = (ResultSetState)this.resultSetStates.get(resultSetKey);
        if (row != null) {
            if (state.references != null) {
                boolean useMaskedTupleSource = false;
                Map elementMap = this.getElementMap(resultSetName, useMaskedTupleSource);
                this.tupleSourceMap.setElementMap(resultSetKey, elementMap);
                ResultSetState.access$400((ResultSetState)state, (List)row, (Map)elementMap);
            }
            return true;
        }
        return false;
    }

    public void closeResultSet(String resultSetName) throws MetaMatrixComponentException {
        String resultSetKey = resultSetName.toUpperCase();
        TupleSource source = this.tupleSourceMap.getTupleSource(resultSetKey);
        if (source != null) {
            source.closeSource();
            TupleSourceID tsID = this.tupleSourceMap.getTupleSourceID(resultSetKey);
            if (tsID != null) {
                this.plan.removeTupleSource(resultSetKey, tsID);
            }
            this.tupleSourceMap.removeResultSet(resultSetKey);
        }
    }

    public Map getElementMap(String resultSetName) throws MetaMatrixComponentException {
        return this.getElementMap(resultSetName, true);
    }

    private Map getElementMap(String resultSetName, boolean useMaskedTupleSource) throws MetaMatrixComponentException {
        TupleSource source;
        HashMap elementMap = new HashMap();
        String resultSetKey = resultSetName.toUpperCase();
        TupleSourceMap temp = this.tupleSourceMap;
        if (useMaskedTupleSource && !this.tupleSourceRecursionStack.isEmpty()) {
            temp = (TupleSourceMap)this.tupleSourceRecursionStack.getLast();
        }
        if ((source = temp.getTupleSource(resultSetKey)) == null) {
            throw new MetaMatrixComponentException(QueryExecPlugin.Util.getString("ERR.015.006.0037", (Object)resultSetName));
        }
        List schema = source.getSchema();
        if (schema == null) {
            throw new MetaMatrixComponentException(QueryExecPlugin.Util.getString("ERR.015.006.0038"));
        }
        for (int index = 0; index < schema.size(); ++index) {
            elementMap.put(schema.get(index), new Integer(index));
        }
        return elementMap;
    }

    public boolean resultSetExists(String resultSetName) {
        String resultSetKey = resultSetName.toUpperCase();
        return this.tupleSourceMap.getTupleSource(resultSetKey) != null;
    }

    public DocumentInProgress getDocumentInProgress() {
        return this.documentInProgress;
    }

    public void setDocumentInProgress(DocumentInProgress documentInProgress) {
        this.documentInProgress = documentInProgress;
    }

    public String getXMLFormat() {
        return this.xmlFormat;
    }

    public void setXMLFormat(String xmlFormat) {
        this.xmlFormat = xmlFormat;
    }

    public String getXMLResultsForm() {
        return this.xmlResultsForm;
    }

    public void setXMLResultsForm(String xmlResultsForm) {
        this.xmlResultsForm = xmlResultsForm;
    }

    public boolean isTempGroup(GroupSymbol groupSymbol) {
        return this.stagingTableGroupsSymbols.contains(groupSymbol);
    }

    public TupleSource getTempGroupSource(String tempGroupName) {
        String resultSetKey = tempGroupName.toUpperCase();
        TupleSource result = this.tupleSourceMap.getTupleSource(resultSetKey);
        if (result == null) {
            Iterator i = this.tupleSourceRecursionStack.iterator();
            while (result == null && i.hasNext()) {
                TupleSourceMap temp = (TupleSourceMap)i.next();
                result = temp.getTupleSource(resultSetKey);
            }
        }
        return result;
    }

    protected Collection getStagingTableGroupsSymbols() {
        return this.stagingTableGroupsSymbols;
    }

    public void setStagingTableGroupsSymbols(Collection stagingTableGroupsSymbols) {
        this.stagingTableGroupsSymbols = stagingTableGroupsSymbols;
    }

    private void setRowLimits(Map rowLimits) {
        this.rowLimits = rowLimits;
    }

    public void setRowLimit(String resultSetKey, int rowLimitValue, boolean exceptionOnRowLimit) {
        this.rowLimits.put(resultSetKey, new RowLimit(rowLimitValue, exceptionOnRowLimit));
    }

    public ProcessorDataManager getDataManager() {
        return this.plan.getDataManager();
    }

    public CommandContext getProcessorContext() {
        return this.plan.getContext();
    }

    public Collection getChildPlans() {
        ArrayList<Object> result = new ArrayList<Object>();
        Iterator i = this.resultSetStates.values().iterator();
        while (i.hasNext()) {
            ResultSetState state = (ResultSetState)i.next();
            if (!(state.resultSetObject instanceof ProcessorPlan)) continue;
            result.add(state.resultSetObject);
        }
        return result;
    }

    public abstract Object clone();

    protected void copyIntoClone(AbstractProcessorEnvironment clone) {
        clone.setStagingTableGroupsSymbols(this.getStagingTableGroupsSymbols());
        ProgramState initialProgramState = (ProgramState)this.programStack.getLast();
        ProgramState newState = new ProgramState(null);
        ProgramState.access$302((ProgramState)newState, (Program)ProgramState.access$300((ProgramState)initialProgramState));
        ProgramState.access$602((ProgramState)newState, (int)0);
        ProgramState.access$502((ProgramState)newState, (int)0);
        clone.programStack.addFirst(newState);
        clone.setStagingTableGroupsSymbols(new ArrayList(this.stagingTableGroupsSymbols));
        if (!this.rowLimits.isEmpty()) {
            clone.setRowLimits(new HashMap(this.rowLimits));
        }
        clone.setXMLFormat(this.getXMLFormat());
        clone.setXMLResultsForm(this.getXMLResultsForm());
        Iterator i = this.resultSetStates.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            ResultSetState value = (ResultSetState)entry.getValue();
            while (value.maskedState != null) {
                value = value.maskedState;
            }
            clone.resultSetStates.put(entry.getKey(), value.clone());
        }
    }

    public GroupSymbol getDocumentGroup() {
        return this.documentGroup;
    }

    public void setDocumentGroup(GroupSymbol documentGroup) {
        this.documentGroup = documentGroup;
    }

    static /* synthetic */ Map access$100(AbstractProcessorEnvironment x0) {
        return x0.rowLimits;
    }
}

