/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.xml;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.query.mapping.relational.QueryNode;
import com.metamatrix.query.mapping.xml.MappingDocument;
import com.metamatrix.query.mapping.xml.MappingSourceNode;
import com.metamatrix.query.mapping.xml.MappingVisitor;
import com.metamatrix.query.mapping.xml.Navigator;
import com.metamatrix.query.mapping.xml.ResultSetInfo;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.xml.QueryUtil;
import com.metamatrix.query.optimizer.xml.XMLPlannerEnvironment;
import com.metamatrix.query.optimizer.xml.XMLQueryPlanner;
import com.metamatrix.query.resolver.command.SimpleQueryResolver;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Option;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.visitor.GroupCollectorVisitor;
import java.util.Collection;

public class XMLStagaingQueryPlanner {
    static void stageQueries(MappingDocument doc, final XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        MappingVisitor queryPlanVisitor = new MappingVisitor(){

            public void visit(MappingSourceNode sourceNode) {
                try {
                    XMLStagaingQueryPlanner.stagePlannedQuery(sourceNode, planEnv);
                }
                catch (Exception e) {
                    throw new MetaMatrixRuntimeException((Throwable)e);
                }
            }
        };
        XMLStagaingQueryPlanner.planWalk(doc, queryPlanVisitor);
    }

    private static void planWalk(MappingDocument doc, MappingVisitor visitor) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        try {
            Navigator walker = new Navigator(true, visitor);
            doc.acceptVisitor((MappingVisitor)walker);
        }
        catch (MetaMatrixRuntimeException e) {
            if (e.getCause() instanceof QueryPlannerException) {
                throw (QueryPlannerException)e.getCause();
            }
            if (e.getCause() instanceof QueryMetadataException) {
                throw (QueryMetadataException)e.getCause();
            }
            if (e.getCause() instanceof MetaMatrixComponentException) {
                throw (MetaMatrixComponentException)e.getCause();
            }
            throw e;
        }
    }

    static boolean stagePlannedQuery(MappingSourceNode sourceNode, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        Option option = planEnv.xmlCommand.getOption();
        if (sourceNode.isRootSourceNode()) {
            return false;
        }
        if (sourceNode.getAliasResultName() != null) {
            return false;
        }
        String groupName = sourceNode.getActualResultSetName();
        ResultSetInfo rsInfo = sourceNode.getResultSetInfo();
        if (!rsInfo.isCriteriaRaised()) {
            return false;
        }
        QueryNode queryNode = QueryUtil.getQueryNode(groupName, planEnv.getGlobalMetadata());
        if (queryNode.getBindings() != null && !queryNode.getBindings().isEmpty()) {
            return false;
        }
        Object metadataID = planEnv.getGlobalMetadata().getGroupID(sourceNode.getResultName());
        if (SimpleQueryResolver.isNoCacheGroup(planEnv.getGlobalMetadata(), metadataID, option)) {
            return false;
        }
        metadataID = planEnv.getGlobalMetadata().getGroupID(sourceNode.getActualResultSetName());
        if (SimpleQueryResolver.isNoCacheGroup(planEnv.getGlobalMetadata(), metadataID, option)) {
            return false;
        }
        Query stagableQuery = (Query)QueryUtil.getQueryFromQueryNode(groupName, planEnv);
        Collection groups = GroupCollectorVisitor.getGroupsIgnoreInlineViews((LanguageObject)stagableQuery, (boolean)false);
        if (groups.size() == 1) {
            GroupSymbol group = (GroupSymbol)groups.iterator().next();
            if (planEnv.isStagingTable((group = QueryUtil.createResolvedGroup((GroupSymbol)group.clone(), (QueryMetadataInterface)planEnv.getGlobalMetadata())).getMetadataID()) && stagableQuery.getCriteria() == null) {
                return false;
            }
        }
        stagableQuery = (Query)stagableQuery.clone();
        String stagingGroupName = planEnv.getStagedResultName(groupName);
        if (!XMLQueryPlanner.planStagaingQuery((boolean)true, (String)groupName, (String)stagingGroupName, (Query)stagableQuery, (XMLPlannerEnvironment)planEnv)) {
            return false;
        }
        sourceNode.addStagingTable(stagingGroupName);
        return true;
    }
}

