/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.NodeFactory;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.RuleConstants;
import com.metamatrix.query.optimizer.relational.rules.RulePushSelectCriteria;
import com.metamatrix.query.resolver.util.ResolverUtil;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Insert;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.util.CommandContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class RulePlaceAccess
implements OptimizerRule {
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryMetadataException, MetaMatrixComponentException {
        List nodes = NodeEditor.findAllNodes((PlanNode)plan, (int)19);
        boolean foundAccessPatterns = false;
        Iterator nodeIter = nodes.iterator();
        while (nodeIter.hasNext()) {
            PlanNode node = (PlanNode)nodeIter.next();
            boolean isInsertOrSelectInto = false;
            Object req = node.getProperty((Object)NodeConstants.Info.ATOMIC_REQUEST);
            if (req == null) {
                req = node.getProperty((Object)NodeConstants.Info.NESTED_COMMAND);
            }
            if (req instanceof Insert) {
                isInsertOrSelectInto = true;
            } else {
                PlanNode parent = node.getParent();
                if (parent.getType() == 11 && parent.getProperty((Object)NodeConstants.Info.INTO_GROUP) != null) {
                    isInsertOrSelectInto = true;
                }
            }
            PlanNode apNode = node;
            if (node.getChildCount() == 0) {
                PlanNode accessNode = NodeFactory.getNewNode((int)3);
                accessNode.addGroups((Collection)node.getGroups());
                RulePlaceAccess.copyDependentHints(node, accessNode);
                Object hint = node.removeProperty((Object)NodeConstants.Info.IS_OPTIONAL);
                if (hint != null) {
                    accessNode.setProperty((Object)NodeConstants.Info.IS_OPTIONAL, hint);
                }
                NodeEditor.insertNode((PlanNode)node.getParent(), (PlanNode)node, (PlanNode)accessNode);
                apNode = accessNode;
            }
            if (isInsertOrSelectInto || !RulePlaceAccess.addAccessPatternsProperty(apNode, metadata)) continue;
            foundAccessPatterns = true;
        }
        if (!foundAccessPatterns) {
            rules.remove(RuleConstants.ACCESS_PATTERN_VALIDATION);
        }
        return plan;
    }

    static void copyDependentHints(PlanNode node, PlanNode copyTo) {
        Object hint = node.getProperty((Object)NodeConstants.Info.MAKE_DEP);
        if (hint != null) {
            copyTo.setProperty((Object)NodeConstants.Info.MAKE_DEP, hint);
        }
        if ((hint = node.getProperty((Object)NodeConstants.Info.MAKE_NOT_DEP)) != null) {
            copyTo.setProperty((Object)NodeConstants.Info.MAKE_NOT_DEP, hint);
        }
    }

    public String toString() {
        return "PlaceAccess";
    }

    static boolean addAccessPatternsProperty(PlanNode node, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        Map values;
        if (node.hasCollectionProperty((Object)NodeConstants.Info.ACCESS_PATTERNS)) {
            return false;
        }
        List patternElements = ResolverUtil.getAccessPatternElementsInGroups((QueryMetadataInterface)metadata, (Collection)node.getGroups(), (boolean)false);
        if (patternElements == null) {
            return false;
        }
        Command command = (Command)node.getProperty((Object)NodeConstants.Info.NESTED_COMMAND);
        if (command != null && (values = command.getVariableValues()) != null) {
            LinkedList<Object> ids = new LinkedList<Object>();
            Iterator i = values.keySet().iterator();
            while (i.hasNext()) {
                String elementName = (String)i.next();
                Object id = metadata.getElementID(elementName);
                ids.add(id);
            }
            List elements = ResolverUtil.resolveElements((GroupSymbol)command.getVirtualGroup(), (QueryMetadataInterface)metadata, ids);
            if (RulePushSelectCriteria.satisfyAccessPatterns(patternElements, elements)) {
                return false;
            }
        }
        Collections.sort(patternElements);
        node.setProperty((Object)NodeConstants.Info.ACCESS_PATTERNS, (Object)patternElements);
        return true;
    }
}

