/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.ant.com.ning.http.client.providers.netty;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLEngine;
import org.sonatype.aether.ant.com.ning.http.client.AsyncHandler;
import org.sonatype.aether.ant.com.ning.http.client.AsyncHttpClientConfig;
import org.sonatype.aether.ant.com.ning.http.client.AsyncHttpProvider;
import org.sonatype.aether.ant.com.ning.http.client.Body;
import org.sonatype.aether.ant.com.ning.http.client.ConnectionsPool;
import org.sonatype.aether.ant.com.ning.http.client.Cookie;
import org.sonatype.aether.ant.com.ning.http.client.FluentCaseInsensitiveStringsMap;
import org.sonatype.aether.ant.com.ning.http.client.HttpResponseBodyPart;
import org.sonatype.aether.ant.com.ning.http.client.HttpResponseHeaders;
import org.sonatype.aether.ant.com.ning.http.client.HttpResponseStatus;
import org.sonatype.aether.ant.com.ning.http.client.ListenableFuture;
import org.sonatype.aether.ant.com.ning.http.client.MaxRedirectException;
import org.sonatype.aether.ant.com.ning.http.client.PerRequestConfig;
import org.sonatype.aether.ant.com.ning.http.client.ProgressAsyncHandler;
import org.sonatype.aether.ant.com.ning.http.client.ProxyServer;
import org.sonatype.aether.ant.com.ning.http.client.RandomAccessBody;
import org.sonatype.aether.ant.com.ning.http.client.Realm;
import org.sonatype.aether.ant.com.ning.http.client.Request;
import org.sonatype.aether.ant.com.ning.http.client.RequestBuilder;
import org.sonatype.aether.ant.com.ning.http.client.Response;
import org.sonatype.aether.ant.com.ning.http.client.filter.FilterContext;
import org.sonatype.aether.ant.com.ning.http.client.filter.FilterException;
import org.sonatype.aether.ant.com.ning.http.client.filter.IOExceptionFilter;
import org.sonatype.aether.ant.com.ning.http.client.filter.ResponseFilter;
import org.sonatype.aether.ant.com.ning.http.client.listener.TransferCompletionHandler;
import org.sonatype.aether.ant.com.ning.http.client.ntlm.NTLMEngine;
import org.sonatype.aether.ant.com.ning.http.client.ntlm.NTLMEngineException;
import org.sonatype.aether.ant.com.ning.http.client.providers.netty.BodyChunkedInput;
import org.sonatype.aether.ant.com.ning.http.client.providers.netty.BodyFileRegion;
import org.sonatype.aether.ant.com.ning.http.client.providers.netty.NettyAsyncHttpProviderConfig;
import org.sonatype.aether.ant.com.ning.http.client.providers.netty.NettyConnectListener;
import org.sonatype.aether.ant.com.ning.http.client.providers.netty.NettyConnectionsPool;
import org.sonatype.aether.ant.com.ning.http.client.providers.netty.NettyResponse;
import org.sonatype.aether.ant.com.ning.http.client.providers.netty.NettyResponseFuture;
import org.sonatype.aether.ant.com.ning.http.client.providers.netty.ResponseBodyPart;
import org.sonatype.aether.ant.com.ning.http.client.providers.netty.ResponseHeaders;
import org.sonatype.aether.ant.com.ning.http.client.providers.netty.ResponseStatus;
import org.sonatype.aether.ant.com.ning.http.client.providers.netty.spnego.SpnegoEngine;
import org.sonatype.aether.ant.com.ning.http.multipart.MultipartRequestEntity;
import org.sonatype.aether.ant.com.ning.http.util.AsyncHttpProviderUtils;
import org.sonatype.aether.ant.com.ning.http.util.AuthenticatorUtils;
import org.sonatype.aether.ant.com.ning.http.util.CleanupChannelGroup;
import org.sonatype.aether.ant.com.ning.http.util.ProxyUtils;
import org.sonatype.aether.ant.com.ning.http.util.SslUtils;
import org.sonatype.aether.ant.com.ning.http.util.UTF8UrlEncoder;
import org.sonatype.aether.ant.org.jboss.netty.bootstrap.ClientBootstrap;
import org.sonatype.aether.ant.org.jboss.netty.buffer.ChannelBuffer;
import org.sonatype.aether.ant.org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.sonatype.aether.ant.org.jboss.netty.buffer.ChannelBuffers;
import org.sonatype.aether.ant.org.jboss.netty.channel.Channel;
import org.sonatype.aether.ant.org.jboss.netty.channel.ChannelFuture;
import org.sonatype.aether.ant.org.jboss.netty.channel.ChannelFutureProgressListener;
import org.sonatype.aether.ant.org.jboss.netty.channel.ChannelHandlerContext;
import org.sonatype.aether.ant.org.jboss.netty.channel.ChannelPipeline;
import org.sonatype.aether.ant.org.jboss.netty.channel.ChannelPipelineFactory;
import org.sonatype.aether.ant.org.jboss.netty.channel.ChannelStateEvent;
import org.sonatype.aether.ant.org.jboss.netty.channel.Channels;
import org.sonatype.aether.ant.org.jboss.netty.channel.DefaultChannelFuture;
import org.sonatype.aether.ant.org.jboss.netty.channel.ExceptionEvent;
import org.sonatype.aether.ant.org.jboss.netty.channel.FileRegion;
import org.sonatype.aether.ant.org.jboss.netty.channel.MessageEvent;
import org.sonatype.aether.ant.org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.sonatype.aether.ant.org.jboss.netty.channel.group.ChannelGroup;
import org.sonatype.aether.ant.org.jboss.netty.channel.socket.ClientSocketChannelFactory;
import org.sonatype.aether.ant.org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.sonatype.aether.ant.org.jboss.netty.channel.socket.oio.OioClientSocketChannelFactory;
import org.sonatype.aether.ant.org.jboss.netty.handler.codec.http.CookieEncoder;
import org.sonatype.aether.ant.org.jboss.netty.handler.codec.http.DefaultCookie;
import org.sonatype.aether.ant.org.jboss.netty.handler.codec.http.DefaultHttpChunkTrailer;
import org.sonatype.aether.ant.org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.sonatype.aether.ant.org.jboss.netty.handler.codec.http.HttpChunk;
import org.sonatype.aether.ant.org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.sonatype.aether.ant.org.jboss.netty.handler.codec.http.HttpClientCodec;
import org.sonatype.aether.ant.org.jboss.netty.handler.codec.http.HttpContentCompressor;
import org.sonatype.aether.ant.org.jboss.netty.handler.codec.http.HttpContentDecompressor;
import org.sonatype.aether.ant.org.jboss.netty.handler.codec.http.HttpMethod;
import org.sonatype.aether.ant.org.jboss.netty.handler.codec.http.HttpRequest;
import org.sonatype.aether.ant.org.jboss.netty.handler.codec.http.HttpResponse;
import org.sonatype.aether.ant.org.jboss.netty.handler.codec.http.HttpVersion;
import org.sonatype.aether.ant.org.jboss.netty.handler.ssl.SslHandler;
import org.sonatype.aether.ant.org.jboss.netty.handler.stream.ChunkedFile;
import org.sonatype.aether.ant.org.jboss.netty.handler.stream.ChunkedWriteHandler;
import org.sonatype.aether.ant.org.slf4j.Logger;
import org.sonatype.aether.ant.org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NettyAsyncHttpProvider
extends SimpleChannelUpstreamHandler
implements AsyncHttpProvider<HttpResponse> {
    private static final String HTTP_HANDLER = "httpHandler";
    static final String SSL_HANDLER = "sslHandler";
    private static final String HTTPS = "https";
    private static final String HTTP = "http";
    private static final Logger log = LoggerFactory.getLogger(NettyAsyncHttpProvider.class);
    private final ClientBootstrap plainBootstrap;
    private final ClientBootstrap secureBootstrap;
    private static final int MAX_BUFFERED_BYTES = 8192;
    private final AsyncHttpClientConfig config;
    private final AtomicBoolean isClose = new AtomicBoolean(false);
    private final ClientSocketChannelFactory socketChannelFactory;
    private final ChannelGroup openChannels = new CleanupChannelGroup("asyncHttpClient"){

        public boolean remove(Object o) {
            boolean removed = super.remove(o);
            if (removed && NettyAsyncHttpProvider.this.trackConnections) {
                NettyAsyncHttpProvider.this.maxConnections.decrementAndGet();
            }
            return removed;
        }
    };
    private final ConnectionsPool<String, Channel> connectionsPool;
    private final AtomicInteger maxConnections = new AtomicInteger();
    private final NettyAsyncHttpProviderConfig asyncHttpProviderConfig;
    private boolean executeConnectAsync = false;
    public static final ThreadLocal<Boolean> IN_IO_THREAD = new ThreadLocalBoolean();
    private final boolean trackConnections;
    private final boolean useRawUrl;
    private static final NTLMEngine ntlmEngine = new NTLMEngine();
    private static final SpnegoEngine spnegoEngine = new SpnegoEngine();

    public NettyAsyncHttpProvider(AsyncHttpClientConfig config) {
        this.asyncHttpProviderConfig = config.getAsyncHttpProviderConfig() != null && NettyAsyncHttpProviderConfig.class.isAssignableFrom(config.getAsyncHttpProviderConfig().getClass()) ? (NettyAsyncHttpProviderConfig)NettyAsyncHttpProviderConfig.class.cast(config.getAsyncHttpProviderConfig()) : new NettyAsyncHttpProviderConfig();
        this.socketChannelFactory = this.asyncHttpProviderConfig != null && this.asyncHttpProviderConfig.getProperty("useBlockingIO") != null ? new OioClientSocketChannelFactory(config.executorService()) : new NioClientSocketChannelFactory(Executors.newCachedThreadPool(), config.executorService());
        this.plainBootstrap = new ClientBootstrap(this.socketChannelFactory);
        this.secureBootstrap = new ClientBootstrap(this.socketChannelFactory);
        this.config = config;
        ConnectionsPool<String, Channel> cp = config.getConnectionsPool();
        if (cp == null && config.getAllowPoolingConnection()) {
            cp = new NettyConnectionsPool(this);
        } else if (cp == null) {
            cp = new NonConnectionsPool();
        }
        this.connectionsPool = cp;
        this.configureNetty();
        this.trackConnections = config.getMaxTotalConnections() != -1;
        this.useRawUrl = config.isUseRawUrl();
    }

    public String toString() {
        return String.format("NettyAsyncHttpProvider:\n\t- maxConnections: %d\n\t- openChannels: %s\n\t- connectionPools: %s", this.maxConnections.get(), this.openChannels.toString(), this.connectionsPool.toString());
    }

    void configureNetty() {
        if (this.asyncHttpProviderConfig != null) {
            for (Map.Entry<String, Object> entry : this.asyncHttpProviderConfig.propertiesSet()) {
                this.plainBootstrap.setOption(entry.getKey(), entry.getValue());
            }
        }
        this.plainBootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                pipeline.addLast(NettyAsyncHttpProvider.HTTP_HANDLER, new HttpClientCodec());
                if (NettyAsyncHttpProvider.this.config.getRequestCompressionLevel() > 0) {
                    pipeline.addLast("deflater", new HttpContentCompressor(NettyAsyncHttpProvider.this.config.getRequestCompressionLevel()));
                }
                if (NettyAsyncHttpProvider.this.config.isCompressionEnabled()) {
                    pipeline.addLast("inflater", new HttpContentDecompressor());
                }
                pipeline.addLast("chunkedWriter", new ChunkedWriteHandler());
                pipeline.addLast("httpProcessor", NettyAsyncHttpProvider.this);
                return pipeline;
            }
        });
        DefaultChannelFuture.setUseDeadLockChecker(false);
        if (this.asyncHttpProviderConfig != null) {
            if (this.asyncHttpProviderConfig.getProperty("asyncConnect") != null) {
                this.executeConnectAsync = true;
            } else if (this.asyncHttpProviderConfig.getProperty("disableNestedRequest") != null) {
                DefaultChannelFuture.setUseDeadLockChecker(true);
            }
        }
    }

    void constructSSLPipeline(final NettyConnectListener<?> cl) {
        this.secureBootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                try {
                    pipeline.addLast(NettyAsyncHttpProvider.SSL_HANDLER, new SslHandler(NettyAsyncHttpProvider.this.createSSLEngine()));
                }
                catch (Throwable ex) {
                    NettyAsyncHttpProvider.this.abort(cl.future(), ex);
                }
                pipeline.addLast(NettyAsyncHttpProvider.HTTP_HANDLER, new HttpClientCodec());
                if (NettyAsyncHttpProvider.this.config.isCompressionEnabled()) {
                    pipeline.addLast("inflater", new HttpContentDecompressor());
                }
                pipeline.addLast("chunkedWriter", new ChunkedWriteHandler());
                pipeline.addLast("httpProcessor", NettyAsyncHttpProvider.this);
                return pipeline;
            }
        });
        if (this.asyncHttpProviderConfig != null) {
            for (Map.Entry<String, Object> entry : this.asyncHttpProviderConfig.propertiesSet()) {
                this.secureBootstrap.setOption(entry.getKey(), entry.getValue());
            }
        }
    }

    private Channel lookupInCache(URI uri) {
        Channel channel = this.connectionsPool.poll(AsyncHttpProviderUtils.getBaseUrl(uri));
        if (channel != null) {
            log.debug("Using cached Channel {}\n for uri {}\n", channel, (Object)uri);
            try {
                return this.verifyChannelPipeline(channel, uri.getScheme());
            }
            catch (Exception ex) {
                log.debug(ex.getMessage(), ex);
            }
        }
        return null;
    }

    private SSLEngine createSSLEngine() throws IOException, GeneralSecurityException {
        SSLEngine sslEngine = this.config.getSSLEngineFactory().newSSLEngine();
        if (sslEngine == null) {
            sslEngine = SslUtils.getSSLEngine();
        }
        return sslEngine;
    }

    private Channel verifyChannelPipeline(Channel channel, String scheme) throws IOException, GeneralSecurityException {
        if (channel.getPipeline().get(SSL_HANDLER) != null && HTTP.equalsIgnoreCase(scheme)) {
            channel.getPipeline().remove(SSL_HANDLER);
        } else {
            if (channel.getPipeline().get(HTTP_HANDLER) != null && HTTP.equalsIgnoreCase(scheme)) {
                return channel;
            }
            if (channel.getPipeline().get(SSL_HANDLER) == null && HTTPS.equalsIgnoreCase(scheme)) {
                channel.getPipeline().addFirst(SSL_HANDLER, new SslHandler(this.createSSLEngine()));
            }
        }
        return channel;
    }

    protected final <T> void writeRequest(Channel channel, AsyncHttpClientConfig config, NettyResponseFuture<T> future, HttpRequest nettyRequest) {
        block32: {
            try {
                if (!channel.isOpen() || !channel.isConnected()) {
                    return;
                }
                Body body = null;
                if (!future.getNettyRequest().getMethod().equals(HttpMethod.CONNECT)) {
                    if (future.getRequest().getBodyGenerator() != null) {
                        try {
                            body = future.getRequest().getBodyGenerator().createBody();
                        }
                        catch (IOException ex) {
                            throw new IllegalStateException(ex);
                        }
                        long length = body.getContentLength();
                        if (length >= 0L) {
                            nettyRequest.setHeader("Content-Length", length);
                        } else {
                            nettyRequest.setHeader("Transfer-Encoding", "chunked");
                        }
                    } else {
                        body = null;
                    }
                }
                if (TransferCompletionHandler.class.isAssignableFrom(future.getAsyncHandler().getClass())) {
                    FluentCaseInsensitiveStringsMap h = new FluentCaseInsensitiveStringsMap();
                    for (String s : future.getNettyRequest().getHeaderNames()) {
                        for (String header : future.getNettyRequest().getHeaders(s)) {
                            h.add(s, header);
                        }
                    }
                    ((TransferCompletionHandler)TransferCompletionHandler.class.cast(future.getAsyncHandler())).transferAdapter(new NettyTransferAdapter(h, nettyRequest.getContent(), future.getRequest().getFile()));
                }
                if (future.getAndSetWriteHeaders(true)) {
                    try {
                        channel.write(nettyRequest).addListener(new ProgressListener(true, future.getAsyncHandler(), future));
                    }
                    catch (Throwable cause) {
                        log.debug(cause.getMessage(), cause);
                        try {
                            channel.close();
                        }
                        catch (RuntimeException ex) {
                            log.debug(ex.getMessage(), ex);
                        }
                        return;
                    }
                }
                if (!future.getAndSetWriteBody(true) || future.getNettyRequest().getMethod().equals(HttpMethod.CONNECT)) break block32;
                if (future.getRequest().getFile() != null) {
                    File file = future.getRequest().getFile();
                    long fileLength = 0L;
                    RandomAccessFile raf = new RandomAccessFile(file, "r");
                    try {
                        ChannelFuture writeFuture;
                        fileLength = raf.length();
                        if (channel.getPipeline().get(SslHandler.class) != null) {
                            writeFuture = channel.write(new ChunkedFile(raf, 0L, fileLength, 8192));
                            writeFuture.addListener(new ProgressListener(false, future.getAsyncHandler(), future));
                        } else {
                            OptimizedFileRegion region = new OptimizedFileRegion(raf, 0L, fileLength);
                            writeFuture = channel.write(region);
                            writeFuture.addListener(new ProgressListener(false, future.getAsyncHandler(), future));
                        }
                        break block32;
                    }
                    catch (IOException ex) {
                        if (raf != null) {
                            try {
                                raf.close();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        throw ex;
                    }
                }
                if (body != null) {
                    ChannelFuture writeFuture = channel.getPipeline().get(SslHandler.class) == null && body instanceof RandomAccessBody ? channel.write(new BodyFileRegion((RandomAccessBody)body)) : channel.write(new BodyChunkedInput(body));
                    final Body b = body;
                    writeFuture.addListener(new ProgressListener(false, future.getAsyncHandler(), future){

                        public void operationComplete(ChannelFuture cf) {
                            try {
                                b.close();
                            }
                            catch (IOException e) {
                                log.warn("Failed to close request body: {}", (Object)e.getMessage(), (Object)e);
                            }
                            super.operationComplete(cf);
                        }
                    });
                }
            }
            catch (Throwable ioe) {
                try {
                    channel.close();
                }
                catch (RuntimeException ex) {
                    log.debug(ex.getMessage(), ex);
                }
            }
        }
        try {
            future.touch();
            int delay = NettyAsyncHttpProvider.requestTimeout(config, future.getRequest().getPerRequestConfig());
            if (delay != -1) {
                ReaperFuture reaperFuture = new ReaperFuture(channel, future);
                ScheduledFuture<?> scheduledFuture = config.reaper().scheduleAtFixedRate(reaperFuture, delay, 500L, TimeUnit.MILLISECONDS);
                reaperFuture.setScheduledFuture(scheduledFuture);
                future.setReaperFuture(reaperFuture);
            }
        }
        catch (RejectedExecutionException ex) {
            this.abort(future, ex);
        }
    }

    protected static final HttpRequest buildRequest(AsyncHttpClientConfig config, Request request, URI uri, boolean allowConnect, ChannelBuffer buffer) throws IOException {
        String method = request.getMethod();
        if (allowConnect && (request.getProxyServer() != null || config.getProxyServer() != null) && HTTPS.equalsIgnoreCase(uri.getScheme())) {
            method = HttpMethod.CONNECT.toString();
        }
        return NettyAsyncHttpProvider.construct(config, request, new HttpMethod(method), uri, buffer);
    }

    private static HttpRequest construct(AsyncHttpClientConfig config, Request request, HttpMethod m, URI uri, ChannelBuffer buffer) throws IOException {
        boolean avoidProxy;
        Realm realm;
        DefaultHttpRequest nettyRequest;
        String host = uri.getHost();
        if (request.getVirtualHost() != null) {
            host = request.getVirtualHost();
        }
        if (m.equals(HttpMethod.CONNECT)) {
            nettyRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_0, m, AsyncHttpProviderUtils.getAuthority(uri));
        } else if (config.getProxyServer() != null || request.getProxyServer() != null) {
            nettyRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, m, uri.toString());
        } else {
            StringBuilder path = new StringBuilder(uri.getRawPath());
            if (uri.getQuery() != null) {
                path.append("?").append(uri.getRawQuery());
            }
            nettyRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, m, path.toString());
        }
        if (host != null) {
            if (uri.getPort() == -1) {
                nettyRequest.setHeader("Host", host);
            } else {
                nettyRequest.setHeader("Host", host + ":" + uri.getPort());
            }
        } else {
            host = "127.0.0.1";
        }
        if (!m.equals(HttpMethod.CONNECT)) {
            FluentCaseInsensitiveStringsMap h = request.getHeaders();
            if (h != null) {
                for (String name : h.keySet()) {
                    if ("host".equalsIgnoreCase(name)) continue;
                    Iterator i$ = h.get(name).iterator();
                    while (i$.hasNext()) {
                        String value = (String)i$.next();
                        nettyRequest.addHeader(name, value);
                    }
                }
            }
            if (config.isCompressionEnabled()) {
                nettyRequest.setHeader("Accept-Encoding", "gzip");
            }
        }
        ProxyServer proxyServer = request.getProxyServer() != null ? request.getProxyServer() : config.getProxyServer();
        Realm realm2 = realm = request.getRealm() != null ? request.getRealm() : config.getRealm();
        if (realm != null && realm.getUsePreemptiveAuth()) {
            switch (realm.getAuthScheme()) {
                case BASIC: {
                    nettyRequest.setHeader("Authorization", AuthenticatorUtils.computeBasicAuthentication(realm));
                    break;
                }
                case DIGEST: {
                    if (realm.getNonce() == null || realm.getNonce().equals("")) break;
                    try {
                        nettyRequest.setHeader("Authorization", AuthenticatorUtils.computeDigestAuthentication(realm));
                        break;
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new SecurityException(e);
                    }
                }
                case NTLM: {
                    try {
                        nettyRequest.setHeader("Authorization", ntlmEngine.generateType1Msg("NTLM " + realm.getNtlmDomain(), realm.getNtlmHost()));
                        break;
                    }
                    catch (NTLMEngineException e) {
                        IOException ie = new IOException();
                        ie.initCause(e);
                        throw ie;
                    }
                }
                case KERBEROS: 
                case SPNEGO: {
                    String challengeHeader = null;
                    String server = proxyServer == null ? host : proxyServer.getHost();
                    try {
                        challengeHeader = spnegoEngine.generateToken(server);
                    }
                    catch (Throwable e) {
                        IOException ie = new IOException();
                        ie.initCause(e);
                        throw ie;
                    }
                    nettyRequest.setHeader("Authorization", "Negotiate " + challengeHeader);
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Invalid Authentication %s", realm.toString()));
                }
            }
        }
        if (!request.getHeaders().containsKey("Connection")) {
            nettyRequest.setHeader("Connection", "keep-alive");
        }
        if (!(avoidProxy = ProxyUtils.avoidProxy(proxyServer, request))) {
            if (!request.getHeaders().containsKey("Proxy-Connection")) {
                nettyRequest.setHeader("Proxy-Connection", "keep-alive");
            }
            if (proxyServer.getPrincipal() != null) {
                nettyRequest.setHeader("Proxy-Authorization", AuthenticatorUtils.computeBasicAuthentication(proxyServer));
            }
        }
        if (request.getHeaders().getFirstValue("Accept") == null) {
            nettyRequest.setHeader("Accept", "*/*");
        }
        if (request.getHeaders().getFirstValue("User-Agent") == null && config.getUserAgent() != null) {
            nettyRequest.setHeader("User-Agent", config.getUserAgent());
        } else if (config.getUserAgent() != null) {
            nettyRequest.setHeader("User-Agent", config.getUserAgent());
        } else if (request.getHeaders().getFirstValue("User-Agent") != null) {
            nettyRequest.setHeader("User-Agent", request.getHeaders().getFirstValue("User-Agent"));
        } else {
            nettyRequest.setHeader("User-Agent", AsyncHttpProviderUtils.constructUserAgent(NettyAsyncHttpProvider.class));
        }
        if (!m.equals(HttpMethod.CONNECT)) {
            String reqType;
            if (request.getCookies() != null && !request.getCookies().isEmpty()) {
                CookieEncoder httpCookieEncoder = new CookieEncoder(false);
                for (Cookie c : request.getCookies()) {
                    DefaultCookie cookie = new DefaultCookie(c.getName(), c.getValue());
                    cookie.setPath(c.getPath());
                    cookie.setMaxAge(c.getMaxAge());
                    cookie.setDomain(c.getDomain());
                    httpCookieEncoder.addCookie(cookie);
                }
                nettyRequest.setHeader("Cookie", httpCookieEncoder.encode());
            }
            if (!("GET".equals(reqType = request.getMethod()) || "HEAD".equals(reqType) || "OPTION".equals(reqType) || "TRACE".equals(reqType))) {
                String bodyCharset;
                String string = bodyCharset = request.getBodyEncoding() == null ? "ISO-8859-1" : request.getBodyEncoding();
                if (buffer != null && buffer.writerIndex() != 0) {
                    nettyRequest.setHeader("Content-Length", buffer.writerIndex());
                    nettyRequest.setContent(buffer);
                } else if (request.getByteData() != null) {
                    nettyRequest.setHeader("Content-Length", String.valueOf(request.getByteData().length));
                    nettyRequest.setContent(ChannelBuffers.copiedBuffer(request.getByteData()));
                } else if (request.getStringData() != null) {
                    nettyRequest.setHeader("Content-Length", String.valueOf(request.getStringData().getBytes(bodyCharset).length));
                    nettyRequest.setContent(ChannelBuffers.copiedBuffer(request.getStringData(), bodyCharset));
                } else if (request.getStreamData() != null) {
                    int[] lengthWrapper = new int[1];
                    byte[] bytes = AsyncHttpProviderUtils.readFully(request.getStreamData(), lengthWrapper);
                    int length = lengthWrapper[0];
                    nettyRequest.setHeader("Content-Length", String.valueOf(length));
                    nettyRequest.setContent(ChannelBuffers.copiedBuffer(bytes, 0, length));
                } else if (request.getParams() != null) {
                    StringBuilder sb = new StringBuilder();
                    for (Map.Entry<String, List<String>> paramEntry : request.getParams()) {
                        String key = paramEntry.getKey();
                        for (String value : paramEntry.getValue()) {
                            if (sb.length() > 0) {
                                sb.append("&");
                            }
                            UTF8UrlEncoder.appendEncoded(sb, key);
                            sb.append("=");
                            UTF8UrlEncoder.appendEncoded(sb, value);
                        }
                    }
                    nettyRequest.setHeader("Content-Length", String.valueOf(sb.length()));
                    nettyRequest.setContent(ChannelBuffers.copiedBuffer(sb.toString().getBytes(bodyCharset)));
                    if (!request.getHeaders().containsKey("Content-Type")) {
                        nettyRequest.setHeader("Content-Type", "application/x-www-form-urlencoded");
                    }
                } else if (request.getParts() != null) {
                    int lenght = NettyAsyncHttpProvider.computeAndSetContentLength(request, nettyRequest);
                    if (lenght == -1) {
                        lenght = 8192;
                    }
                    MultipartRequestEntity mre = AsyncHttpProviderUtils.createMultipartRequestEntity(request.getParts(), request.getParams());
                    nettyRequest.setHeader("Content-Type", mre.getContentType());
                    nettyRequest.setHeader("Content-Length", String.valueOf(mre.getContentLength()));
                    ChannelBuffer b = ChannelBuffers.dynamicBuffer(lenght);
                    mre.writeRequest(new ChannelBufferOutputStream(b));
                    nettyRequest.setContent(b);
                } else if (request.getEntityWriter() != null) {
                    int lenght = NettyAsyncHttpProvider.computeAndSetContentLength(request, nettyRequest);
                    if (lenght == -1) {
                        lenght = 8192;
                    }
                    ChannelBuffer b = ChannelBuffers.dynamicBuffer(lenght);
                    request.getEntityWriter().writeEntity(new ChannelBufferOutputStream(b));
                    nettyRequest.setHeader("Content-Length", b.writerIndex());
                    nettyRequest.setContent(b);
                } else if (request.getFile() != null) {
                    File file = request.getFile();
                    if (!file.isFile()) {
                        throw new IOException(String.format("File %s is not a file or doesn't exist", file.getAbsolutePath()));
                    }
                    nettyRequest.setHeader("Content-Length", file.length());
                }
            }
        }
        return nettyRequest;
    }

    @Override
    public void close() {
        this.isClose.set(true);
        try {
            this.connectionsPool.destroy();
            this.openChannels.close();
            for (Channel channel : this.openChannels) {
                ChannelHandlerContext ctx = channel.getPipeline().getContext(NettyAsyncHttpProvider.class);
                if (!(ctx.getAttachment() instanceof NettyResponseFuture)) continue;
                NettyResponseFuture future = (NettyResponseFuture)ctx.getAttachment();
                future.setReaperFuture(null);
            }
            this.config.executorService().shutdown();
            this.config.reaper().shutdown();
            this.socketChannelFactory.releaseExternalResources();
            this.plainBootstrap.releaseExternalResources();
            this.secureBootstrap.releaseExternalResources();
        }
        catch (Throwable t) {
            log.warn("Unexpected error on close", t);
        }
    }

    @Override
    public Response prepareResponse(HttpResponseStatus status, HttpResponseHeaders headers, Collection<HttpResponseBodyPart> bodyParts) {
        return new NettyResponse(status, headers, bodyParts);
    }

    @Override
    public <T> ListenableFuture<T> execute(Request request, AsyncHandler<T> asyncHandler) throws IOException {
        return this.doConnect(request, asyncHandler, null, true, this.executeConnectAsync, false);
    }

    private <T> void execute(Request request, NettyResponseFuture<T> f, boolean useCache, boolean asyncConnect) throws IOException {
        this.doConnect(request, f.getAsyncHandler(), f, useCache, asyncConnect, false);
    }

    private <T> void execute(Request request, NettyResponseFuture<T> f, boolean useCache, boolean asyncConnect, boolean reclaimCache) throws IOException {
        this.doConnect(request, f.getAsyncHandler(), f, useCache, asyncConnect, reclaimCache);
    }

    private <T> ListenableFuture<T> doConnect(Request request, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> f, boolean useCache, boolean asyncConnect, boolean reclaimCache) throws IOException {
        ChannelFuture channelFuture;
        boolean useSSl;
        if (this.isClose.get()) {
            throw new IOException("Closed");
        }
        ProxyServer proxyServer = request.getProxyServer() != null ? request.getProxyServer() : this.config.getProxyServer();
        String requestUrl = this.useRawUrl ? request.getRawUrl() : request.getUrl();
        URI uri = AsyncHttpProviderUtils.createUri(requestUrl);
        Channel channel = null;
        if (useCache) {
            channel = f != null && f.reuseChannel() && f.channel() != null ? f.channel() : this.lookupInCache(uri);
        }
        ChannelBuffer bufferedBytes = null;
        if (f != null && f.getRequest().getFile() == null && !f.getNettyRequest().getMethod().getName().equals(HttpMethod.CONNECT.getName())) {
            bufferedBytes = f.getNettyRequest().getContent();
        }
        boolean bl = useSSl = uri.getScheme().compareToIgnoreCase(HTTPS) == 0 && proxyServer == null;
        if (channel != null && channel.isOpen() && channel.isConnected()) {
            HttpRequest nettyRequest = NettyAsyncHttpProvider.buildRequest(this.config, request, uri, false, bufferedBytes);
            if (f == null) {
                f = NettyAsyncHttpProvider.newFuture(uri, request, asyncHandler, nettyRequest, this.config, this);
            } else {
                f.setNettyRequest(nettyRequest);
            }
            f.setState(NettyResponseFuture.STATE.POOLED);
            f.attachChannel(channel, false);
            log.debug("\nUsing cached Channel {}\n for request \n{}\n", channel, (Object)nettyRequest);
            channel.getPipeline().getContext(NettyAsyncHttpProvider.class).setAttachment(f);
            try {
                this.writeRequest(channel, this.config, f, nettyRequest);
            }
            catch (IllegalStateException ex) {
                log.debug("writeRequest failure", ex);
                if (useSSl && ex.getMessage() != null && ex.getMessage().contains("SSLEngine")) {
                    log.debug("SSLEngine failure", ex);
                    f = null;
                }
                throw ex;
            }
            return f;
        }
        if (!reclaimCache && (!this.connectionsPool.canCacheConnection() || this.config.getMaxTotalConnections() > -1 && this.maxConnections.get() + 1 > this.config.getMaxTotalConnections())) {
            IOException ex = new IOException(String.format("Too many connections %s", this.config.getMaxTotalConnections()));
            try {
                asyncHandler.onThrowable(ex);
            }
            catch (Throwable t) {
                log.warn("!connectionsPool.canCacheConnection()", t);
            }
            throw ex;
        }
        NettyConnectListener<T> c = new NettyConnectListener.Builder<T>(this.config, request, asyncHandler, f, this, bufferedBytes).build(uri);
        boolean avoidProxy = ProxyUtils.avoidProxy(proxyServer, uri.getHost());
        if (useSSl) {
            this.constructSSLPipeline(c);
        }
        if (this.trackConnections) {
            this.maxConnections.incrementAndGet();
        }
        ClientBootstrap bootstrap = useSSl ? this.secureBootstrap : this.plainBootstrap;
        bootstrap.setOption("connectTimeoutMillis", this.config.getConnectionTimeoutInMs());
        if (System.getProperty("os.name").toLowerCase().indexOf("win") == -1) {
            bootstrap.setOption("reuseAddress", this.asyncHttpProviderConfig.getProperty("reuseAddress"));
        }
        try {
            channelFuture = proxyServer == null || avoidProxy ? bootstrap.connect(new InetSocketAddress(uri.getHost(), AsyncHttpProviderUtils.getPort(uri))) : bootstrap.connect(new InetSocketAddress(proxyServer.getHost(), proxyServer.getPort()));
        }
        catch (Throwable t) {
            this.abort(c.future(), t.getCause() == null ? t : t.getCause());
            return c.future();
        }
        boolean directInvokation = true;
        if (IN_IO_THREAD.get().booleanValue() && DefaultChannelFuture.isUseDeadLockChecker()) {
            directInvokation = false;
        }
        if (directInvokation && !asyncConnect && request.getFile() == null) {
            int timeOut;
            int n = timeOut = this.config.getConnectionTimeoutInMs() > 0 ? this.config.getConnectionTimeoutInMs() : Integer.MAX_VALUE;
            if (!channelFuture.awaitUninterruptibly(timeOut, TimeUnit.MILLISECONDS)) {
                this.abort(c.future(), new ConnectException("Connect times out"));
            }
            try {
                c.operationComplete(channelFuture);
            }
            catch (Exception e) {
                IOException ioe = new IOException(e.getMessage());
                ioe.initCause(e);
                throw ioe;
            }
        } else {
            channelFuture.addListener(c);
        }
        log.debug("\nNon cached request \n{}\n\nusing Channel \n{}\n", c.future().getNettyRequest(), (Object)channelFuture.getChannel());
        if (!c.future().isCancelled() || !c.future().isDone()) {
            this.openChannels.add(channelFuture.getChannel());
            c.future().attachChannel(channelFuture.getChannel(), false);
        }
        return c.future();
    }

    protected static int requestTimeout(AsyncHttpClientConfig config, PerRequestConfig perRequestConfig) {
        int prRequestTimeout;
        int result = perRequestConfig != null ? ((prRequestTimeout = perRequestConfig.getRequestTimeoutInMs()) != 0 ? prRequestTimeout : config.getRequestTimeoutInMs()) : config.getRequestTimeoutInMs();
        return result;
    }

    private void closeChannel(ChannelHandlerContext ctx) {
        this.connectionsPool.removeAll(ctx.getChannel());
        this.finishChannel(ctx);
    }

    private void finishChannel(ChannelHandlerContext ctx) {
        ctx.setAttachment(new DiscardEvent());
        if (ctx.getChannel() == null) {
            return;
        }
        log.debug("Closing Channel {} ", ctx.getChannel());
        try {
            ctx.getChannel().close();
        }
        catch (Throwable t) {
            log.debug("Error closing a connection", t);
        }
        if (ctx.getChannel() != null) {
            this.openChannels.remove(ctx.getChannel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived(final ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        block51: {
            super.messageReceived(ctx, e);
            IN_IO_THREAD.set(Boolean.TRUE);
            if (ctx.getAttachment() == null) {
                log.debug("ChannelHandlerContext wasn't having any attachment");
            }
            if (ctx.getAttachment() instanceof DiscardEvent) {
                return;
            }
            if (ctx.getAttachment() instanceof AsyncCallable) {
                if (e.getMessage() instanceof HttpChunk) {
                    HttpChunk chunk = (HttpChunk)e.getMessage();
                    if (chunk.isLast()) {
                        AsyncCallable ac = (AsyncCallable)ctx.getAttachment();
                        ac.call();
                    }
                } else {
                    AsyncCallable ac = (AsyncCallable)ctx.getAttachment();
                    ac.call();
                }
                ctx.setAttachment(new DiscardEvent());
                return;
            }
            if (!(ctx.getAttachment() instanceof NettyResponseFuture)) {
                return;
            }
            final NettyResponseFuture future = (NettyResponseFuture)ctx.getAttachment();
            future.touch();
            HttpRequest nettyRequest = future.getNettyRequest();
            AsyncHandler handler = future.getAsyncHandler();
            Request request = future.getRequest();
            HttpResponse response = null;
            try {
                if (e.getMessage() instanceof HttpResponse) {
                    boolean redirectEnabled;
                    response = (HttpResponse)e.getMessage();
                    log.debug("\n\nRequest {}\n\nResponse {}\n", nettyRequest, (Object)response);
                    future.setHttpResponse(response);
                    int statusCode = response.getStatus().getCode();
                    String ka = response.getHeader("Connection");
                    future.setKeepAlive(ka == null || ka.toLowerCase().equals("keep-alive"));
                    List<String> wwwAuth = this.getWwwAuth(response.getHeaders());
                    Realm realm = request.getRealm() != null ? request.getRealm() : this.config.getRealm();
                    ResponseStatus status = new ResponseStatus(future.getURI(), response, this);
                    FilterContext fc = new FilterContext.FilterContextBuilder().asyncHandler(handler).request(request).responseStatus(status).build();
                    for (ResponseFilter asyncFilter : this.config.getResponseFilters()) {
                        try {
                            if ((fc = asyncFilter.filter(fc)) != null) continue;
                            throw new NullPointerException("FilterContext is null");
                        }
                        catch (FilterException efe) {
                            this.abort(future, efe);
                        }
                    }
                    if (fc.replayRequest()) {
                        this.replayRequest(future, fc, response, ctx);
                        return;
                    }
                    if (statusCode == 401 && wwwAuth.size() > 0 && realm != null && !future.getAndSetAuth(true)) {
                        ProxyServer proxyServer;
                        final RequestBuilder builder = new RequestBuilder(future.getRequest());
                        future.setState(NettyResponseFuture.STATE.NEW);
                        if (!future.getURI().getPath().equalsIgnoreCase(realm.getUri())) {
                            builder.setUrl(future.getURI().toString());
                        }
                        Realm newRealm = null;
                        final FluentCaseInsensitiveStringsMap headers = request.getHeaders();
                        ProxyServer proxyServer2 = proxyServer = request.getProxyServer() != null ? request.getProxyServer() : this.config.getProxyServer();
                        if (wwwAuth.get(0).startsWith("NTLM") || wwwAuth.get(0).startsWith("Negotiate") && realm.getAuthScheme() == Realm.AuthScheme.NTLM) {
                            String password;
                            String ntlmDomain = proxyServer == null ? realm.getNtlmDomain() : proxyServer.getNtlmDomain();
                            String ntlmHost = proxyServer == null ? realm.getNtlmHost() : proxyServer.getHost();
                            String prinicipal = proxyServer == null ? realm.getPrincipal() : proxyServer.getPrincipal();
                            String string = password = proxyServer == null ? realm.getPassword() : proxyServer.getPassword();
                            if (!realm.isNtlmMessageType2Received()) {
                                String challengeHeader = ntlmEngine.generateType1Msg(ntlmDomain, ntlmHost);
                                headers.add("Authorization", "NTLM " + challengeHeader);
                                newRealm = new Realm.RealmBuilder().clone(realm).setScheme(realm.getAuthScheme()).setUri(URI.create(request.getUrl()).getPath()).setMethodName(request.getMethod()).setNtlmMessageType2Received(true).build();
                                future.getAndSetAuth(false);
                            } else {
                                String serverChallenge = wwwAuth.get(0).trim().substring("NTLM ".length());
                                String challengeHeader = ntlmEngine.generateType3Msg(prinicipal, password, ntlmDomain, ntlmHost, serverChallenge);
                                headers.remove("Authorization");
                                headers.add("Authorization", "NTLM " + challengeHeader);
                                newRealm = new Realm.RealmBuilder().clone(realm).setScheme(realm.getAuthScheme()).setUri(URI.create(request.getUrl()).getPath()).setMethodName(request.getMethod()).build();
                            }
                        } else if (wwwAuth.get(0).startsWith("Negotiate")) {
                            URI uri = URI.create(request.getUrl());
                            String host = request.getVirtualHost() == null ? uri.getHost() : request.getVirtualHost();
                            String server = proxyServer == null ? host : proxyServer.getHost();
                            try {
                                String challengeHeader = spnegoEngine.generateToken(server);
                                headers.remove("Authorization");
                                headers.add("Authorization", "Negotiate " + challengeHeader);
                                newRealm = new Realm.RealmBuilder().clone(realm).setScheme(realm.getAuthScheme()).setUri(uri.getPath()).setMethodName(request.getMethod()).setScheme(Realm.AuthScheme.KERBEROS).build();
                            }
                            catch (Throwable throwable) {
                                this.abort(future, throwable);
                                return;
                            }
                        } else {
                            newRealm = new Realm.RealmBuilder().clone(realm).setScheme(realm.getAuthScheme()).setUri(URI.create(request.getUrl()).getPath()).setMethodName(request.getMethod()).setUsePreemptiveAuth(true).parseWWWAuthenticateHeader(wwwAuth.get(0)).build();
                        }
                        final Realm nr = newRealm;
                        log.debug("Sending authentication to {}", (Object)request.getUrl());
                        AsyncCallable ac = new AsyncCallable(future){

                            public Object call() throws Exception {
                                NettyAsyncHttpProvider.this.drainChannel(ctx, future, future.getKeepAlive(), future.getURI());
                                NettyAsyncHttpProvider.this.nextRequest(((RequestBuilder)builder.setHeaders(headers).setRealm(nr)).build(), future);
                                return null;
                            }
                        };
                        if (future.getKeepAlive() && response.isChunked()) {
                            ctx.setAttachment(ac);
                        } else {
                            ac.call();
                        }
                        return;
                    }
                    if (statusCode == 100) {
                        future.getAndSetWriteHeaders(false);
                        future.getAndSetWriteBody(true);
                        this.writeRequest(ctx.getChannel(), this.config, future, nettyRequest);
                        return;
                    }
                    String proxyAuth = response.getHeader("Proxy-Authenticate");
                    if (statusCode == 407 && proxyAuth != null && future.getRequest().getRealm() != null && !future.getAndSetAuth(true)) {
                        log.debug("Sending proxy authentication to {}", (Object)request.getUrl());
                        this.nextRequest(future.getRequest(), future);
                        return;
                    }
                    if (future.getNettyRequest().getMethod().equals(HttpMethod.CONNECT) && statusCode == 200) {
                        ProxyServer proxyServer = request.getProxyServer() != null ? request.getProxyServer() : this.config.getProxyServer();
                        log.debug("Connected to {}:{}", (Object)proxyServer.getHost(), (Object)proxyServer.getPort());
                        if (future.getKeepAlive()) {
                            future.attachChannel(ctx.getChannel(), true);
                        }
                        RequestBuilder builder = new RequestBuilder(future.getRequest());
                        try {
                            log.debug("Connecting to proxy {} for scheme {}", proxyServer, (Object)request.getUrl());
                            this.upgradeProtocol(ctx.getChannel().getPipeline(), request.getUrl());
                        }
                        catch (Throwable ex) {
                            this.abort(future, ex);
                        }
                        this.nextRequest(builder.build(), future);
                        return;
                    }
                    boolean bl = redirectEnabled = request.isRedirectEnabled() ? true : this.config.isRedirectEnabled();
                    if (redirectEnabled && (statusCode == 302 || statusCode == 301)) {
                        if (future.incrementAndGetCurrentRedirectCount() < this.config.getMaxRedirects()) {
                            future.getAndSetAuth(false);
                            String location = response.getHeader("Location");
                            URI uri = AsyncHttpProviderUtils.getRedirectUri(future.getURI(), location);
                            if (!uri.toString().equalsIgnoreCase(future.getURI().toString())) {
                                final RequestBuilder builder = new RequestBuilder(future.getRequest());
                                final URI initialConnectionUri = future.getURI();
                                final boolean initialConnectionKeepAlive = future.getKeepAlive();
                                future.setURI(uri);
                                final String newUrl = uri.toString();
                                log.debug("Redirecting to {}", (Object)newUrl);
                                AsyncCallable ac = new AsyncCallable(future){

                                    public Object call() throws Exception {
                                        NettyAsyncHttpProvider.this.drainChannel(ctx, future, initialConnectionKeepAlive, initialConnectionUri);
                                        NettyAsyncHttpProvider.this.nextRequest(builder.setUrl(newUrl).build(), future);
                                        return null;
                                    }
                                };
                                if (response.isChunked()) {
                                    ctx.setAttachment(ac);
                                } else {
                                    ac.call();
                                }
                                return;
                            }
                        } else {
                            throw new MaxRedirectException("Maximum redirect reached: " + this.config.getMaxRedirects());
                        }
                    }
                    if (!future.getAndSetStatusReceived(true) && this.updateStatusAndInterrupt(handler, status)) {
                        this.finishUpdate(future, ctx, response.isChunked());
                        return;
                    }
                    if (this.updateHeadersAndInterrupt(handler, new ResponseHeaders(future.getURI(), response, this))) {
                        this.finishUpdate(future, ctx, response.isChunked());
                        return;
                    }
                    if (!response.isChunked()) {
                        if (response.getContent().readableBytes() != 0) {
                            this.updateBodyAndInterrupt(handler, new ResponseBodyPart(future.getURI(), response, this));
                        }
                        this.finishUpdate(future, ctx, false);
                        return;
                    }
                    if (nettyRequest.getMethod().equals(HttpMethod.HEAD)) {
                        this.updateBodyAndInterrupt(handler, new ResponseBodyPart(future.getURI(), response, this));
                        this.markAsDoneAndCacheConnection(future, ctx);
                        this.drainChannel(ctx, future, future.getKeepAlive(), future.getURI());
                        return;
                    }
                    break block51;
                }
                if (e.getMessage() instanceof HttpChunk) {
                    HttpChunk chunk = (HttpChunk)e.getMessage();
                    if (handler != null && (chunk.isLast() || this.updateBodyAndInterrupt(handler, new ResponseBodyPart(future.getURI(), null, this, chunk)))) {
                        if (chunk instanceof DefaultHttpChunkTrailer) {
                            this.updateHeadersAndInterrupt(handler, new ResponseHeaders(future.getURI(), future.getHttpResponse(), this, (HttpChunkTrailer)chunk));
                        }
                        this.finishUpdate(future, ctx, !chunk.isLast());
                    }
                }
            }
            catch (Exception t) {
                if (IOException.class.isAssignableFrom(t.getClass()) && this.config.getIOExceptionFilters().size() > 0) {
                    FilterContext fc = new FilterContext.FilterContextBuilder().asyncHandler(future.getAsyncHandler()).request(future.getRequest()).ioException((IOException)IOException.class.cast(t)).build();
                    if ((fc = this.handleIoException(fc, future)).replayRequest()) {
                        this.replayRequest(future, fc, response, ctx);
                        return;
                    }
                }
                try {
                    this.abort(future, t);
                }
                finally {
                    this.finishUpdate(future, ctx, false);
                    throw t;
                }
            }
        }
    }

    private void drainChannel(final ChannelHandlerContext ctx, NettyResponseFuture<?> future, final boolean keepAlive, final URI uri) {
        ctx.setAttachment(new AsyncCallable(future){

            public Object call() throws Exception {
                if (keepAlive && ctx.getChannel().isReadable()) {
                    if (!NettyAsyncHttpProvider.this.connectionsPool.offer(AsyncHttpProviderUtils.getBaseUrl(uri), ctx.getChannel())) {
                        NettyAsyncHttpProvider.this.finishChannel(ctx);
                    }
                } else {
                    NettyAsyncHttpProvider.this.finishChannel(ctx);
                }
                return null;
            }

            public String toString() {
                return String.format("Draining task for channel %s", ctx.getChannel());
            }
        });
    }

    private FilterContext handleIoException(FilterContext fc, NettyResponseFuture<?> future) {
        for (IOExceptionFilter asyncFilter : this.config.getIOExceptionFilters()) {
            try {
                if ((fc = asyncFilter.filter(fc)) != null) continue;
                throw new NullPointerException("FilterContext is null");
            }
            catch (FilterException efe) {
                this.abort(future, efe);
            }
        }
        return fc;
    }

    private void replayRequest(NettyResponseFuture<?> future, FilterContext fc, HttpResponse response, ChannelHandlerContext ctx) throws IOException {
        Request newRequest = fc.getRequest();
        future.setAsyncHandler(fc.getAsyncHandler());
        future.setState(NettyResponseFuture.STATE.NEW);
        future.touch();
        log.debug("\n\nReplaying Request {}\n for Future {}\n", newRequest, future);
        this.drainChannel(ctx, future, future.getKeepAlive(), future.getURI());
        this.nextRequest(newRequest, future);
    }

    private List<String> getWwwAuth(List<Map.Entry<String, String>> list) {
        ArrayList<String> l = new ArrayList<String>();
        for (Map.Entry<String, String> e : list) {
            if (!e.getKey().equalsIgnoreCase("WWW-Authenticate")) continue;
            l.add(e.getValue());
        }
        return l;
    }

    private void nextRequest(Request request, NettyResponseFuture<?> future) throws IOException {
        this.nextRequest(request, future, true);
    }

    private void nextRequest(Request request, NettyResponseFuture<?> future, boolean useCache) throws IOException {
        this.execute(request, future, useCache, true, true);
    }

    private void abort(NettyResponseFuture<?> future, Throwable t) {
        Channel channel = future.channel();
        if (channel != null && this.openChannels.contains(channel)) {
            this.closeChannel(channel.getPipeline().getContext(NettyAsyncHttpProvider.class));
            this.openChannels.remove(channel);
        }
        if (!future.isCancelled() && !future.isDone()) {
            log.debug("Aborting Future {}\n", future);
            log.debug(t.getMessage(), t);
        }
        future.abort(t);
    }

    private void upgradeProtocol(ChannelPipeline p, String scheme) throws IOException, GeneralSecurityException {
        if (p.get(HTTP_HANDLER) != null) {
            p.remove(HTTP_HANDLER);
        }
        if (scheme.startsWith(HTTPS)) {
            if (p.get(SSL_HANDLER) == null) {
                p.addFirst(HTTP_HANDLER, new HttpClientCodec());
                p.addFirst(SSL_HANDLER, new SslHandler(this.createSSLEngine()));
            } else {
                p.addAfter(SSL_HANDLER, HTTP_HANDLER, new HttpClientCodec());
            }
        } else {
            p.addFirst(HTTP_HANDLER, new HttpClientCodec());
        }
    }

    @Override
    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (this.isClose.get()) {
            return;
        }
        this.connectionsPool.removeAll(ctx.getChannel());
        try {
            super.channelClosed(ctx, e);
        }
        catch (Exception ex) {
            log.trace("super.channelClosed", ex);
        }
        log.debug("Channel Closed: {} with attachment {}", e.getChannel(), ctx.getAttachment());
        if (ctx.getAttachment() instanceof AsyncCallable) {
            AsyncCallable ac = (AsyncCallable)ctx.getAttachment();
            ctx.setAttachment(ac.future());
            ac.call();
            return;
        }
        if (ctx.getAttachment() instanceof NettyResponseFuture) {
            NettyResponseFuture future = (NettyResponseFuture)ctx.getAttachment();
            future.touch();
            if (this.config.getIOExceptionFilters().size() > 0) {
                FilterContext fc = new FilterContext.FilterContextBuilder().asyncHandler(future.getAsyncHandler()).request(future.getRequest()).ioException(new IOException("Channel Closed")).build();
                if ((fc = this.handleIoException(fc, future)).replayRequest() && !future.cannotBeReplay()) {
                    this.replayRequest(future, fc, null, ctx);
                    return;
                }
            }
            if (future != null && !future.isDone() && !future.isCancelled()) {
                if (!this.remotelyClosed(ctx.getChannel(), future)) {
                    this.abort(future, new IOException("Remotely Closed " + ctx.getChannel()));
                }
            } else {
                this.closeChannel(ctx);
            }
        }
    }

    protected boolean remotelyClosed(Channel channel, NettyResponseFuture<?> future) {
        if (this.isClose.get()) {
            return false;
        }
        this.connectionsPool.removeAll(channel);
        if (future == null && channel.getPipeline().getContext(NettyAsyncHttpProvider.class).getAttachment() != null && NettyResponseFuture.class.isAssignableFrom(channel.getPipeline().getContext(NettyAsyncHttpProvider.class).getAttachment().getClass())) {
            future = (NettyResponseFuture)channel.getPipeline().getContext(NettyAsyncHttpProvider.class).getAttachment();
        }
        if (future == null || future.cannotBeReplay()) {
            log.debug("Unable to recover future {}\n", future);
            return false;
        }
        future.setState(NettyResponseFuture.STATE.RECONNECTED);
        log.debug("Trying to recover request {}\n", future.getNettyRequest());
        try {
            this.nextRequest(future.getRequest(), future);
            return true;
        }
        catch (IOException iox) {
            future.setState(NettyResponseFuture.STATE.CLOSED);
            future.abort(iox);
            log.error("Remotely Closed, unable to recover", iox);
            return false;
        }
    }

    private void markAsDoneAndCacheConnection(NettyResponseFuture<?> future, ChannelHandlerContext ctx) throws MalformedURLException {
        try {
            future.done(null);
        }
        catch (Throwable t) {
            log.debug(t.getMessage(), t);
        }
        if (!future.getKeepAlive()) {
            this.closeChannel(ctx);
        }
    }

    private void finishUpdate(NettyResponseFuture<?> future, ChannelHandlerContext ctx, boolean isChunked) throws IOException {
        if (isChunked && future.getKeepAlive()) {
            this.drainChannel(ctx, future, future.getKeepAlive(), future.getURI());
        } else if (future.getKeepAlive() && ctx.getChannel().isReadable() && !this.connectionsPool.offer(AsyncHttpProviderUtils.getBaseUrl(future.getURI()), ctx.getChannel())) {
            this.finishChannel(ctx);
        }
        this.markAsDoneAndCacheConnection(future, ctx);
    }

    private boolean markChannelNotReadable(ChannelHandlerContext ctx) {
        ctx.setAttachment(new DiscardEvent());
        return true;
    }

    private final boolean updateStatusAndInterrupt(AsyncHandler handler, HttpResponseStatus c) throws Exception {
        return handler.onStatusReceived(c) != AsyncHandler.STATE.CONTINUE;
    }

    private final boolean updateHeadersAndInterrupt(AsyncHandler handler, HttpResponseHeaders c) throws Exception {
        return handler.onHeadersReceived(c) != AsyncHandler.STATE.CONTINUE;
    }

    private final boolean updateBodyAndInterrupt(AsyncHandler handler, HttpResponseBodyPart c) throws Exception {
        return handler.onBodyPartReceived(c) != AsyncHandler.STATE.CONTINUE;
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        NettyResponseFuture<?> future;
        Throwable cause;
        block16: {
            Channel channel = e.getChannel();
            cause = e.getCause();
            future = null;
            if (log.isDebugEnabled()) {
                log.debug("Unexpected I/O exception on channel {}", channel, (Object)cause);
            }
            try {
                if (cause != null && ClosedChannelException.class.isAssignableFrom(cause.getClass())) {
                    return;
                }
                if (ctx.getAttachment() instanceof NettyResponseFuture) {
                    future = (NettyResponseFuture<?>)ctx.getAttachment();
                    future.attachChannel(null, false);
                    future.touch();
                    if (IOException.class.isAssignableFrom(cause.getClass())) {
                        if (this.config.getIOExceptionFilters().size() > 0) {
                            FilterContext fc = new FilterContext.FilterContextBuilder().asyncHandler(future.getAsyncHandler()).request(future.getRequest()).ioException(new IOException("Channel Closed")).build();
                            if ((fc = this.handleIoException(fc, future)).replayRequest()) {
                                this.replayRequest(future, fc, null, ctx);
                                return;
                            }
                        } else {
                            try {
                                ctx.getChannel().close();
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                            return;
                        }
                    }
                    if (NettyAsyncHttpProvider.abortOnReadCloseException(cause) || NettyAsyncHttpProvider.abortOnWriteCloseException(cause)) {
                        log.debug("Trying to recover from dead Channel: {}", channel);
                        return;
                    }
                    break block16;
                }
                if (ctx.getAttachment() instanceof AsyncCallable) {
                    future = ((AsyncCallable)ctx.getAttachment()).future();
                }
            }
            catch (Throwable t) {
                cause = t;
            }
        }
        if (future != null) {
            try {
                log.debug("Was unable to recover Future: {}", future);
                this.abort(future, cause);
            }
            catch (Throwable t) {
                log.error(t.getMessage(), t);
            }
        }
        this.closeChannel(ctx);
        ctx.sendUpstream(e);
    }

    protected static boolean abortOnConnectCloseException(Throwable cause) {
        try {
            for (StackTraceElement element : cause.getStackTrace()) {
                if (!element.getClassName().equals("sun.nio.ch.SocketChannelImpl") || !element.getMethodName().equals("checkConnect")) continue;
                return true;
            }
            if (cause.getCause() != null) {
                return NettyAsyncHttpProvider.abortOnConnectCloseException(cause.getCause());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    protected static boolean abortOnDisconnectException(Throwable cause) {
        try {
            for (StackTraceElement element : cause.getStackTrace()) {
                if (!element.getClassName().equals("org.sonatype.aether.ant.org.jboss.netty.handler.ssl.SslHandler") || !element.getMethodName().equals("channelDisconnected")) continue;
                return true;
            }
            if (cause.getCause() != null) {
                return NettyAsyncHttpProvider.abortOnConnectCloseException(cause.getCause());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    protected static boolean abortOnReadCloseException(Throwable cause) {
        for (StackTraceElement element : cause.getStackTrace()) {
            if (!element.getClassName().equals("sun.nio.ch.SocketDispatcher") || !element.getMethodName().equals("read")) continue;
            return true;
        }
        if (cause.getCause() != null) {
            return NettyAsyncHttpProvider.abortOnReadCloseException(cause.getCause());
        }
        return false;
    }

    protected static boolean abortOnWriteCloseException(Throwable cause) {
        for (StackTraceElement element : cause.getStackTrace()) {
            if (!element.getClassName().equals("sun.nio.ch.SocketDispatcher") || !element.getMethodName().equals("write")) continue;
            return true;
        }
        if (cause.getCause() != null) {
            return NettyAsyncHttpProvider.abortOnReadCloseException(cause.getCause());
        }
        return false;
    }

    private static final int computeAndSetContentLength(Request request, HttpRequest r) {
        int length = (int)request.getContentLength();
        if (length == -1 && r.getHeader("Content-Length") != null) {
            length = Integer.valueOf(r.getHeader("Content-Length"));
        }
        if (length >= 0) {
            r.setHeader("Content-Length", String.valueOf(length));
        }
        return length;
    }

    public static <T> NettyResponseFuture<T> newFuture(URI uri, Request request, AsyncHandler<T> asyncHandler, HttpRequest nettyRequest, AsyncHttpClientConfig config, NettyAsyncHttpProvider provider) {
        NettyResponseFuture<T> f = new NettyResponseFuture<T>(uri, request, asyncHandler, nettyRequest, NettyAsyncHttpProvider.requestTimeout(config, request.getPerRequestConfig()), provider);
        if (request.getHeaders().getFirstValue("Expect") != null && request.getHeaders().getFirstValue("Expect").equalsIgnoreCase("100-Continue")) {
            f.getAndSetWriteBody(false);
        }
        return f;
    }

    protected AsyncHttpClientConfig getConfig() {
        return this.config;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NonConnectionsPool
    implements ConnectionsPool<String, Channel> {
        private NonConnectionsPool() {
        }

        @Override
        public boolean offer(String uri, Channel connection) {
            return false;
        }

        @Override
        public Channel poll(String uri) {
            return null;
        }

        @Override
        public boolean removeAll(Channel connection) {
            return false;
        }

        @Override
        public boolean canCacheConnection() {
            return true;
        }

        @Override
        public void destroy() {
        }
    }

    private static class NettyTransferAdapter
    extends TransferCompletionHandler.TransferAdapter {
        private final ChannelBuffer content;
        private final FileInputStream file;
        private int byteRead = 0;

        public NettyTransferAdapter(FluentCaseInsensitiveStringsMap headers, ChannelBuffer content, File file) throws IOException {
            super(headers);
            this.content = content;
            this.file = file != null ? new FileInputStream(file) : null;
        }

        public void getBytes(byte[] bytes) {
            if (this.content.writableBytes() != 0) {
                this.content.getBytes(this.byteRead, bytes);
                this.byteRead += bytes.length;
            } else if (this.file != null) {
                try {
                    this.byteRead += this.file.read(bytes);
                }
                catch (IOException e) {
                    log.error(e.getMessage(), e);
                }
            }
        }
    }

    public static class OptimizedFileRegion
    implements FileRegion {
        private final FileChannel file;
        private final RandomAccessFile raf;
        private final long position;
        private final long count;
        private long byteWritten;

        public OptimizedFileRegion(RandomAccessFile raf, long position, long count) {
            this.raf = raf;
            this.file = raf.getChannel();
            this.position = position;
            this.count = count;
        }

        public long getPosition() {
            return this.position;
        }

        public long getCount() {
            return this.count;
        }

        public long transferTo(WritableByteChannel target, long position) throws IOException {
            long count = this.count - position;
            if (count < 0L || position < 0L) {
                throw new IllegalArgumentException("position out of range: " + position + " (expected: 0 - " + (this.count - 1L) + ")");
            }
            if (count == 0L) {
                return 0L;
            }
            long bw = this.file.transferTo(this.position + position, count, target);
            this.byteWritten += bw;
            if (this.byteWritten == this.raf.length()) {
                this.releaseExternalResources();
            }
            return bw;
        }

        public void releaseExternalResources() {
            try {
                this.file.close();
            }
            catch (IOException e) {
                log.warn("Failed to close a file.", e);
            }
            try {
                this.raf.close();
            }
            catch (IOException e) {
                log.warn("Failed to close a file.", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ThreadLocalBoolean
    extends ThreadLocal<Boolean> {
        private final boolean defaultValue;

        public ThreadLocalBoolean() {
            this(false);
        }

        public ThreadLocalBoolean(boolean defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        protected Boolean initialValue() {
            return this.defaultValue ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AsyncCallable
    implements Callable<Object> {
        private final NettyResponseFuture<?> future;

        public AsyncCallable(NettyResponseFuture<?> future) {
            this.future = future;
        }

        @Override
        public abstract Object call() throws Exception;

        public NettyResponseFuture<?> future() {
            return this.future;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ReaperFuture
    implements Future,
    Runnable {
        private Future scheduledFuture;
        private Channel channel;
        private NettyResponseFuture<?> nettyResponseFuture;

        public ReaperFuture(Channel channel, NettyResponseFuture<?> nettyResponseFuture) {
            this.channel = channel;
            this.nettyResponseFuture = nettyResponseFuture;
        }

        public void setScheduledFuture(Future scheduledFuture) {
            this.scheduledFuture = scheduledFuture;
        }

        @Override
        public synchronized boolean cancel(boolean mayInterruptIfRunning) {
            this.channel = null;
            this.nettyResponseFuture = null;
            return this.scheduledFuture.cancel(mayInterruptIfRunning);
        }

        public Object get() throws InterruptedException, ExecutionException {
            return this.scheduledFuture.get();
        }

        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.scheduledFuture.get(timeout, unit);
        }

        @Override
        public boolean isCancelled() {
            return this.scheduledFuture.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.scheduledFuture.isDone();
        }

        @Override
        public synchronized void run() {
            if (NettyAsyncHttpProvider.this.isClose.get()) {
                return;
            }
            if (this.nettyResponseFuture != null && this.nettyResponseFuture.hasExpired() && !this.nettyResponseFuture.isDone() && !this.nettyResponseFuture.isCancelled()) {
                log.debug("Request Timeout expired for {}\n", this.nettyResponseFuture);
                int requestTimeout = NettyAsyncHttpProvider.this.config.getRequestTimeoutInMs();
                PerRequestConfig p = this.nettyResponseFuture.getRequest().getPerRequestConfig();
                if (p != null && p.getRequestTimeoutInMs() != -1) {
                    requestTimeout = p.getRequestTimeoutInMs();
                }
                NettyAsyncHttpProvider.this.abort(this.nettyResponseFuture, new TimeoutException(String.format("No response received after %s", requestTimeout)));
                this.nettyResponseFuture = null;
                this.channel = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProgressListener
    implements ChannelFutureProgressListener {
        private final boolean notifyHeaders;
        private final AsyncHandler asyncHandler;
        private final NettyResponseFuture<?> future;

        public ProgressListener(boolean notifyHeaders, AsyncHandler asyncHandler, NettyResponseFuture<?> future) {
            this.notifyHeaders = notifyHeaders;
            this.asyncHandler = asyncHandler;
            this.future = future;
        }

        @Override
        public void operationComplete(ChannelFuture cf) {
            boolean startPublishing;
            Throwable cause = cf.getCause();
            if (cause != null && this.future.getState() != NettyResponseFuture.STATE.NEW) {
                if (IllegalStateException.class.isAssignableFrom(cause.getClass())) {
                    log.debug(cause.getMessage(), cause);
                    try {
                        cf.getChannel().close();
                    }
                    catch (RuntimeException ex) {
                        log.debug(ex.getMessage(), ex);
                    }
                    return;
                }
                if (ClosedChannelException.class.isAssignableFrom(cause.getClass()) || NettyAsyncHttpProvider.abortOnReadCloseException(cause) || NettyAsyncHttpProvider.abortOnWriteCloseException(cause)) {
                    if (log.isDebugEnabled()) {
                        log.debug(cf.getCause() == null ? "" : cf.getCause().getMessage(), cf.getCause());
                    }
                    try {
                        cf.getChannel().close();
                    }
                    catch (RuntimeException ex) {
                        log.debug(ex.getMessage(), ex);
                    }
                    return;
                }
                this.future.abort(cause);
                return;
            }
            this.future.touch();
            Realm realm = this.future.getRequest().getRealm() != null ? this.future.getRequest().getRealm() : NettyAsyncHttpProvider.this.getConfig().getRealm();
            boolean bl = startPublishing = this.future.isInAuth() || realm == null || realm.getUsePreemptiveAuth();
            if (startPublishing && ProgressAsyncHandler.class.isAssignableFrom(this.asyncHandler.getClass())) {
                if (this.notifyHeaders) {
                    ((ProgressAsyncHandler)ProgressAsyncHandler.class.cast(this.asyncHandler)).onHeaderWriteCompleted();
                } else {
                    ((ProgressAsyncHandler)ProgressAsyncHandler.class.cast(this.asyncHandler)).onContentWriteCompleted();
                }
            }
        }

        @Override
        public void operationProgressed(ChannelFuture cf, long amount, long current, long total) {
            if (ProgressAsyncHandler.class.isAssignableFrom(this.asyncHandler.getClass())) {
                ((ProgressAsyncHandler)ProgressAsyncHandler.class.cast(this.asyncHandler)).onContentWriteProgress(amount, current, total);
            }
        }
    }

    static final class DiscardEvent {
        DiscardEvent() {
        }
    }
}

