/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.util.internal;

import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import org.jboss.netty.util.UnsafeDetectUtil;
import org.jboss.netty.util.internal.LegacyLinkedTransferQueue;
import org.jboss.netty.util.internal.LinkedTransferQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QueueFactory {
    private static final boolean useUnsafe = UnsafeDetectUtil.isUnsafeFound(QueueFactory.class.getClassLoader());

    private QueueFactory() {
    }

    public static <T> BlockingQueue<T> createQueue(Class<T> itemClass) {
        if (useUnsafe) {
            return new LinkedTransferQueue();
        }
        return new LegacyLinkedTransferQueue();
    }

    public static <T> BlockingQueue<T> createQueue(Collection<? extends T> collection, Class<T> itemClass) {
        if (useUnsafe) {
            return new LinkedTransferQueue<T>(collection);
        }
        return new LegacyLinkedTransferQueue<T>(collection);
    }
}

