/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.util;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnsafeDetectUtil {
    private static final String THE_UNSAFE = "theUnsafe";
    private static final String UNSAFE = "sun.misc.Unsafe";
    private static final boolean UNSAFE_FOUND = UnsafeDetectUtil.isUnsafeFound(AtomicInteger.class.getClassLoader());

    public static boolean isUnsafeFound(ClassLoader loader) {
        try {
            Class<?> unsafeClazz = Class.forName(UNSAFE, true, loader);
            return UnsafeDetectUtil.hasUnsafeField(unsafeClazz);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
        catch (PrivilegedActionException e) {
            return false;
        }
    }

    private static boolean hasUnsafeField(final Class<?> unsafeClass) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

            @Override
            public Boolean run() throws Exception {
                unsafeClass.getDeclaredField(UnsafeDetectUtil.THE_UNSAFE);
                return true;
            }
        });
    }

    public static boolean isUnsafeFound() {
        return UNSAFE_FOUND;
    }

    private UnsafeDetectUtil() {
    }
}

