package org.apache.catalina.valves;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;

import org.apache.catalina.valves.ValveBase;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;

import org.apache.catalina.Context;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;

public class PoxyValve
    extends ValveBase {

    public void invoke(Request request, Response response)
        throws IOException, ServletException {

        String poxy = request.getHeader("Proxy");
        
        if (poxy != null) {
            response.sendError(HttpServletResponse.SC_BAD_REQUEST);
            return;
        }

        getNext().invoke(request, response);
    }
}
