/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.collections;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.tomcat.dbcp.collections.CursorableLinkedList;

class CursorableSubList
extends CursorableLinkedList
implements List {
    protected CursorableLinkedList _list = null;
    protected CursorableLinkedList.Listable _pre = null;
    protected CursorableLinkedList.Listable _post = null;

    CursorableSubList(CursorableLinkedList cursorableLinkedList, int n, int n2) {
        if (0 > n || cursorableLinkedList.size() < n2) {
            throw new IndexOutOfBoundsException();
        }
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        this._list = cursorableLinkedList;
        if (n < cursorableLinkedList.size()) {
            this._head.setNext(this._list.getListableAt(n));
            this._pre = null == this._head.next() ? null : this._head.next().prev();
        } else {
            this._pre = this._list.getListableAt(n - 1);
        }
        if (n == n2) {
            this._head.setNext(null);
            this._head.setPrev(null);
            this._post = n2 < cursorableLinkedList.size() ? this._list.getListableAt(n2) : null;
        } else {
            this._head.setPrev(this._list.getListableAt(n2 - 1));
            this._post = this._head.prev().next();
        }
        this._size = n2 - n;
        this._modCount = this._list._modCount;
    }

    @Override
    public void clear() {
        this.checkForComod();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    @Override
    public Iterator iterator() {
        this.checkForComod();
        return super.iterator();
    }

    @Override
    public int size() {
        this.checkForComod();
        return super.size();
    }

    @Override
    public boolean isEmpty() {
        this.checkForComod();
        return super.isEmpty();
    }

    @Override
    public Object[] toArray() {
        this.checkForComod();
        return super.toArray();
    }

    @Override
    public Object[] toArray(Object[] objectArray) {
        this.checkForComod();
        return super.toArray(objectArray);
    }

    @Override
    public boolean contains(Object object) {
        this.checkForComod();
        return super.contains(object);
    }

    @Override
    public boolean remove(Object object) {
        this.checkForComod();
        return super.remove(object);
    }

    @Override
    public Object removeFirst() {
        this.checkForComod();
        return super.removeFirst();
    }

    @Override
    public Object removeLast() {
        this.checkForComod();
        return super.removeLast();
    }

    @Override
    public boolean addAll(Collection collection) {
        this.checkForComod();
        return super.addAll(collection);
    }

    @Override
    public boolean add(Object object) {
        this.checkForComod();
        return super.add(object);
    }

    @Override
    public boolean addFirst(Object object) {
        this.checkForComod();
        return super.addFirst(object);
    }

    @Override
    public boolean addLast(Object object) {
        this.checkForComod();
        return super.addLast(object);
    }

    @Override
    public boolean removeAll(Collection collection) {
        this.checkForComod();
        return super.removeAll(collection);
    }

    @Override
    public boolean containsAll(Collection collection) {
        this.checkForComod();
        return super.containsAll(collection);
    }

    @Override
    public boolean addAll(int n, Collection collection) {
        this.checkForComod();
        return super.addAll(n, collection);
    }

    @Override
    public int hashCode() {
        this.checkForComod();
        return super.hashCode();
    }

    @Override
    public boolean retainAll(Collection collection) {
        this.checkForComod();
        return super.retainAll(collection);
    }

    @Override
    public Object set(int n, Object object) {
        this.checkForComod();
        return super.set(n, object);
    }

    @Override
    public boolean equals(Object object) {
        this.checkForComod();
        return super.equals(object);
    }

    @Override
    public Object get(int n) {
        this.checkForComod();
        return super.get(n);
    }

    @Override
    public Object getFirst() {
        this.checkForComod();
        return super.getFirst();
    }

    @Override
    public Object getLast() {
        this.checkForComod();
        return super.getLast();
    }

    @Override
    public void add(int n, Object object) {
        this.checkForComod();
        super.add(n, object);
    }

    @Override
    public ListIterator listIterator(int n) {
        this.checkForComod();
        return super.listIterator(n);
    }

    @Override
    public Object remove(int n) {
        this.checkForComod();
        return super.remove(n);
    }

    @Override
    public int indexOf(Object object) {
        this.checkForComod();
        return super.indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        this.checkForComod();
        return super.lastIndexOf(object);
    }

    @Override
    public ListIterator listIterator() {
        this.checkForComod();
        return super.listIterator();
    }

    @Override
    public List subList(int n, int n2) {
        this.checkForComod();
        return super.subList(n, n2);
    }

    @Override
    protected CursorableLinkedList.Listable insertListable(CursorableLinkedList.Listable listable, CursorableLinkedList.Listable listable2, Object object) {
        ++this._modCount;
        ++this._size;
        CursorableLinkedList.Listable listable3 = this._list.insertListable(null == listable ? this._pre : listable, null == listable2 ? this._post : listable2, object);
        if (null == this._head.next()) {
            this._head.setNext(listable3);
            this._head.setPrev(listable3);
        }
        if (listable == this._head.prev()) {
            this._head.setPrev(listable3);
        }
        if (listable2 == this._head.next()) {
            this._head.setNext(listable3);
        }
        this.broadcastListableInserted(listable3);
        return listable3;
    }

    @Override
    protected void removeListable(CursorableLinkedList.Listable listable) {
        ++this._modCount;
        --this._size;
        if (this._head.next() == listable && this._head.prev() == listable) {
            this._head.setNext(null);
            this._head.setPrev(null);
        }
        if (this._head.next() == listable) {
            this._head.setNext(listable.next());
        }
        if (this._head.prev() == listable) {
            this._head.setPrev(listable.prev());
        }
        this._list.removeListable(listable);
        this.broadcastListableRemoved(listable);
    }

    protected void checkForComod() throws ConcurrentModificationException {
        if (this._modCount != this._list._modCount) {
            throw new ConcurrentModificationException();
        }
    }
}

