<?xml version="1.0" encoding="ISO-8859-1" ?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1174747:1451901 (outdated) -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="win_compiling.xml.meta">
  <parentdocument href="./">Notes sp&eacute;cifiques &agrave; certaines
  plates-formes</parentdocument>

  <title>Compiler Apache pour Microsoft Windows</title>

  <summary>

    <p>Il y a de nombreux points importants &agrave; conna&icirc;tre avant de
    compiler Apache pour Microsoft Windows. Avant de commencer, lisez le
    document <a href="windows.html">Utiliser Apache avec Microsoft
    Windows</a>.</p>

  </summary>

  <section id="requirements">

    <title>Pr&eacute;requis</title>

    <p>Pour compiler Apache, l'environnement doit satisfaire aux
    conditions suivantes :</p>

    <ul>
      <li>
        <p>Espace disque</p>

        <p>Assurez-vous de disposer d'un minimum de 200 Mo d'espace
	disque disponible. Apr&egrave;s l'installation, Apache occupe environ
	80 Mo d'espace disque, plus l'espace r&eacute;serv&eacute; aux journaux et au
	cache, la taille de ces derniers pouvant augmenter rapidement.
	Les besoins r&eacute;els en espace disque d&eacute;pendent &eacute;troitement de la
	configuration choisie et des biblioth&egrave;ques ou modules tiers
	install&eacute;s, en particulier lorsqu'OpenSSL est mis en oeuvre.
	Comme de nombreux fichiers sont au format texte et donc
	facilement compressibles, l'utilisation de la compression du
	syst&egrave;me de fichiers NTFS divise ces besoins par deux.</p>
      </li>

      <li>
        <p>Correctifs requis</p>

        <p>Le binaire httpd est compil&eacute; &agrave; l'aide de nombreux correctifs
	appliqu&eacute;s aux paquets tiers, ce qui permet de s'assurer que le
	code fourni est bien compilable et d&eacute;boguable. Ces correctifs
	sont disponibles &agrave; <a
        href="http://www.apache.org/dist/httpd/binaries/win32/patches_applied/"
        >http://www.apache.org/dist/httpd/binaries/win32/patches_applied/</a>,
	et il est recommand&eacute; de les appliquer afin d'obtenir un
	r&eacute;sultat identique aux binaires "officiels" distribu&eacute;s par
	l'ASF.</p>
      </li>

      <li>
        <p>Microsoft Visual C++ 6.0 (Visual Studio 97) ou sup&eacute;rieur.</p>

        <p>Apache peut &ecirc;tre compil&eacute; en utilisant l'outil ligne de
	commande, ou depuis l'espace de travail IDE Visual Studio. Pour
	la compilation depuis la ligne de commandes, l'environnement
	doit comporter les variables <code>PATH</code>,
	<code>INCLUDE</code>, <code>LIB</code>, ainsi que d'autres
	variables qui peuvent &ecirc;tre d&eacute;finies via le script
	<code>vcvars32.bat</code> :</p>

        <note>Vous pouvez vous procurer le paquet du Processeur Visual
	Studio pour votre ancienne version de Visual Studio, ou une
	version compl&egrave;te (et non Express) d'une &eacute;dition plus r&eacute;cente de
	Visual Studio pour l'assembleur ml.exe. Ceci vous permettra, si
	vous le souhaitez, de compiler OpenSSL en utilisant une
	impl&eacute;mentation du code d'assemblage plus efficace.</note>

        <note>Seule la cha&icirc;ne d'outils de compilation de Microsoft est
	support&eacute;e de mani&egrave;re suivie par les contributeurs actifs &agrave; httpd.
	Bien que le projet accepte r&eacute;guli&egrave;rement des correctifs pour
	s'assurer que MinGW et d'autre outils de compilation
	fonctionnent, ou m&ecirc;me pour les am&eacute;liorer, ils ne sont pas
	maintenus de mani&egrave;re suivie et sont m&ecirc;me souvent hors d'&eacute;tat
	de fonctionner &agrave; certains stades du d&eacute;veloppement normal.</note>
      </li>

      <li>
        <p>Le SDK de la plate-forme Windows mis &agrave; jour, f&eacute;vrier 2003 ou
	plus r&eacute;cent.</p>

	<p>Un SDK appropri&eacute; pour la plate-forme Windows est inclus par
	d&eacute;faut dans les versions compl&egrave;tes (et non Express/lite) de
	Visual C++ 7.1 (Visual Studio 2002) et sup&eacute;rieures ; les
	utilisateurs peuvent ignorer ces &eacute;tapes, &agrave; moins qu'ils aient
	choisi d'utiliser une version plus r&eacute;cente ou diff&eacute;rente du SDK.</p>

	<p>Pour pouvoir utiliser Visual C++ 6.0 or 7.0 (Studio 2000
	.NET), l'environnement du SDK de la plate-forme doit &ecirc;tre pr&eacute;par&eacute; en utilisant le
	script <code>setenv.bat</code> (install&eacute; par le SDK de la plate-forme) avant de
	lancer la compilation en ligne de commande ou l'interface GUI
	msdev/devenv. L'installation du SDK de la plate-forme pour les
	versions Express de Visual Studio (2003 et sup&eacute;rieures) devrait
	ajuster l'environnement par d&eacute;faut de mani&egrave;re appropri&eacute;e.</p>

        <example>
	  "c:\Program Files\Microsoft Visual Studio\VC98\Bin\VCVARS32"<br />
          "c:\Program Files\Platform SDK\setenv.bat"
        </example>


      </li>

      <li>
        <p>Perl et awk</p>

	<p>De nombreuses &eacute;tapes recommand&eacute;es ici n&eacute;cessitent un
	interpr&eacute;teur perl durant le processus de pr&eacute;paration de la
	compilation.</p>

        <p>Pour installer Apache &agrave; partir du syst&egrave;me de compilation, de
	nombreux fichiers sont modifi&eacute;s via l'utilitaire
	<code>awk.exe</code>. awk effectue la modification des fichiers
	au moment de l'installation ; il a &eacute;t&eacute; choisi car il n&eacute;cessite
	un t&eacute;l&eacute;chargement de petite taille (par rapport &agrave; Perl ou
	WSH/VB). Le site de Brian Kernighan <a
	href="http://www.cs.princeton.edu/~bwk/btl.mirror/"
        >http://www.cs.princeton.edu/~bwk/btl.mirror/</a> propose un
	binaire pr&eacute;compil&eacute; pour Win32, <a
	href="http://www.cs.princeton.edu/~bwk/btl.mirror/awk95.exe"
        >http://www.cs.princeton.edu/~bwk/btl.mirror/awk95.exe</a>, que
	vous devez enregistrer sous le nom <code>awk.exe</code> (plut&ocirc;t
	que <code>awk95.exe</code>).</p>

        <note>Si awk.exe n'est pas trouv&eacute;, la cible install du fichier
	Makefile.win n'effectuera aucune substitution dans les fichiers
	.conf install&eacute;s. Vous devrez alors modifier manuellement les fichiers
	.conf install&eacute;s afin de permettre au serveur de d&eacute;marrer.
	Recherchez et remplacez toutes les balises "@token@" par une
	valeur appropri&eacute;e.</note>

        <note>L'IDE Visual Studio ne trouvera le chemin de
	<code>awk.exe</code> que dans la variable PATH, ou dans le
	chemin des ex&eacute;cutables sp&eacute;cifi&eacute; par l'option de menu Tools -&gt;
	Options -&gt; (Projects -&gt;) Directories. Assurez-vous
	qu'awk.exe est bien dans votre chemin syst&egrave;me.</note>

        <note>Notez aussi, si vous utilisez les outils Cygwin (<a
	href="http://www.cygwin.com/">http://www.cygwin.com/</a>), que
	l'utilitaire awk se nomme <code>gawk.exe</code> et que le
	fichier <code>awk.exe</code> est en fait un lien symbolique vers
	le fichier <code>gawk.exe</code>. Le shell de commandes Windows
	ne reconna&icirc;t pas les liens symboliques, et par cons&eacute;quent la
	compilation d'InstallBin &eacute;chouera. Pour contourner le probl&egrave;me,
	vous pouvez supprimer le lien <code>awk.exe</code> de
	l'installation de Cygwin, et copier <code>gawk.exe</code> vers
	<code>awk.exe</code>. Notez aussi que les portages cygwin/mingw
	de gawk 3.0.x &eacute;taient bogu&eacute;s ; veuillez par cons&eacute;quent effectuer
	une mise &agrave; jour vers la	version 3.1.x avant l'utilisation de
	tout portage de gawk.</note>
      </li>

      <li>
        <p>[Optionnel] biblioth&egrave;que zlib (pour le module
	<module>mod_deflate</module>)</p>

        <p>Zlib doit &ecirc;tre install&eacute;e dans un sous-r&eacute;pertoire du
	r&eacute;pertoire <code>srclib</code> et nomm&eacute; <code>zlib</code>. Elle
	doit &ecirc;tre compil&eacute;e directement &agrave; cette place. Zlib est
	disponible &agrave; l'adresse <a
	href="http://www.zlib.net/">http://www.zlib.net/</a> -- le
	fonctionnement correct du module <module>mod_deflate</module> a
	&eacute;t&eacute; v&eacute;rifi&eacute; avec la version 1.2.3.</p>

        <example>
          nmake -f win32\Makefile.msc<br />
          nmake -f win32\Makefile.msc test
        </example>
      </li>

      <li>
        <p>[Optionnel] Biblioth&egrave;ques OpenSSL (pour le module
	<module>mod_ssl</module> et <code>ab.exe</code> avec le support
	ssl)</p>

	<note>La biblioth&egrave;que OpenSSL est un logiciel de chiffrement. Le
	pays dans lequel vous r&eacute;sidez peut imposer des restrictions &agrave;
	l'importation, la possession, l'utilisation, et/ou la
	r&eacute;exportation vers un autre pays des logiciels de chiffrement.
	AVANT d'utiliser tout logiciel de chiffrement, veuillez
	consulter la l&eacute;gislation de votre pays, les r&egrave;gles et politiques
	d'importation, de possession, ou d'utilisation, et de
	r&eacute;exportation des logiciels de chiffrement, afin de d&eacute;terminer
	si vous en avez le droit. Voir <a
	href="http://www.wassenaar.org/">http://www.wassenaar.org/</a>
	pour plus de d&eacute;tails.</note>

        <p>La configuration et la compilation d'OpenSSL n&eacute;cessite
	l'installation de perl.</p>

        <p>Pour compiler <module>mod_ssl</module> ou le projet
	<code>abs.exe</code>, qui n'est autre que ab.c avec le support SSL
	activ&eacute;, vous devez t&eacute;l&eacute;charger OpenSSL &agrave; l'adresse <a
	href="http://www.openssl.org/source/">http://www.openssl.org/source/</a>,
	et l'installer dans un sous-r&eacute;pertoire du r&eacute;pertoire
	<code>srclib</code> que vous nommerez <code>openssl</code>. Afin
	de pr&eacute;parer OpenSSL &agrave; la liaison avec le module Apache mod_ssl
	ou abs.exe, et d&eacute;sactiver les fonctionnalit&eacute;s d'Openssl gr&eacute;v&eacute;es
	de brevets, vous pouvez utiliser la commande de compilation
	suivante :</p>

        <example>
          perl Configure no-rc5 no-idea enable-mdc2 enable-zlib VC-WIN32
               -Ipath/to/srclib/zlib -Lpath/to/srclib/zlib<br />
          ms\do_masm.bat<br />
          nmake -f ms\ntdll.mak
        </example>

        <note>Il est d&eacute;conseill&eacute; d'utiliser zlib-dynamic, car la charge
	de la d&eacute;compression des flux SSL est alors transf&eacute;r&eacute;e &agrave; la
	premi&egrave;re requ&ecirc;te qui doit charger la dll zlib. Notez que le
	correctif propos&eacute; active le drapeau -L afin de
	fonctionner avec les compilations Windows, corrige le nom de
	zdll.lib et s'assure que les fichiers .pdb sont g&eacute;n&eacute;r&eacute;s afin de
	r&eacute;soudre les probl&egrave;mes. Si l'assembleur n'est pas
	install&eacute;, vous devez ajouter no-asm ci-dessus et utiliser le
	script ms\do_ms.bat &agrave; la place de ms\do_masm.bat.</note>
      </li>

      <li>
        <p>[Optionnel] Biblioth&egrave;ques de bases de donn&eacute;es (pour
<module>mod_dbd</module> et <module>mod_authn_dbm</module>)</p>

        <p>La biblioth&egrave;que apr-util fournit un acc&egrave;s aux fonctionnalit&eacute;s
	clients dbm (base de donn&eacute;es &agrave; base de cl&eacute;s) et dbd (base de
	donn&eacute;es &agrave; base de requ&ecirc;tes) au serveur httpd et &agrave; certains de
	ses modules, comme les modules d'authentification et
	d'autorisation. Les fournisseurs sdbm dbm et odbc dbd sont
	compil&eacute;s automatiquement.</p>

        <p>Le support dbd inclut le paquet instantclient Oracle, MySQL,
	PostgreSQL et sqlite. Par exemple, pour les compiler tous,
	d&eacute;finissez LIB de fa&ccedil;on &agrave; inclure le chemin des biblioth&egrave;ques,
	INCLUDE de fa&ccedil;on &agrave; inclure le chemin des en-t&ecirc;tes, et PATH de
	fa&ccedil;on &agrave; inclure le chemin des dll et bin de chacun des quatre
	SDK, et d&eacute;finissez la variable d'environnement DBD_LIST de fa&ccedil;on
	&agrave; indiquer au processus de compilation quels SDKs pilotes
	clients du sont correctement install&eacute;s ; par exemple :</p>

        <example>
          set DBD_LIST=sqlite3 pgsql oracle mysql
        </example>

        <p>De mani&egrave;re similaire, le support dbm peut &ecirc;tre &eacute;tendu avec
	DBM_LIST pour compiler un fournisseur Berkeley DB (db) et/ou un
	fournisseur gdbm, en configurant tout d'abord de la m&ecirc;me mani&egrave;re
	LIB, INCLUDE et PATH afin de s'assurer que les biblioth&egrave;ques et
	en-t&ecirc;tes de la biblioth&egrave;que client sont bien disponibles.</p>

        <example>
          set DBM_LIST=db gdbm
        </example>

        <note>En fonction du choix des distributions de bases de
	donn&eacute;es, il peut s'av&eacute;rer n&eacute;cessaire de modifier le nom des
	cibles de l'&eacute;dition de liens (par exemple gdbm.lib &agrave; la place de
	libgdb.lib) list&eacute;es dans les fichiers .dsp/.mak des r&eacute;pertoires
	srclib\apr-util\dbd ou ...\dbm correspondants.</note>

        <p>Voir le fichier README-win32.txt pour plus d'informations &agrave;
	propos de l'obtention des diff&eacute;rents SDKs pilotes de bases de
	donn&eacute;es.</p>
      </li>

    </ul>

  </section>

  <section id="commandbuild">

    <title>Compilation &agrave; partir de la ligne de commandes</title>

    <p><code>Makefile.win</code> est le makefile principal ou racine
    d'Apache. Pour compiler Apache sous Windows, utilisez simplement une
    des commandes suivantes pour compiler la version
    <code>release</code> ou <code>debug</code> :</p>

    <example>
      nmake /f Makefile.win _apacher<br /><br />
      nmake /f Makefile.win _apached
    </example>


    <p>Ces deux commandes effectuent la compilation d'Apache. Cependant,
    avec la deuxi&egrave;me, les fichiers r&eacute;sultants ne seront pas optimis&eacute;s,
    ce qui va faciliter l'examen pas &agrave; pas du code pour trouver des
    bogues et r&eacute;soudre les probl&egrave;mes.</p>

    <p>Vous pouvez indiquer vos choix en mati&egrave;re de fournisseurs dbd et
    dbm &agrave; l'aide des variables (d'environnement) additionnelles de make
    DBD_LIST et DBM_LIST ; voir les commentaires &agrave; propos des
    [Optionnel] Biblioth&egrave;ques de bases de donn&eacute;es ci-dessus. Consultez
    les commentaires initiaux dans Makefile.win pour plus d'options
    pouvant &ecirc;tre fournies lors de la compilation.</p>

  </section>

  <section id="workspacebuild">

    <title>Compilation depuis l'espace de travail IDE de Developer
    Studio</title>

    <p>Apache peut aussi &ecirc;tre compil&eacute; depuis l'environnement de
    d&eacute;veloppement Visual Studio de VC++. Pour simplifier ce processus,
    l'espace de travail Visual Studio <code>Apache.dsw</code> est
    fourni. Cet espace de travail expose la liste compl&egrave;te des projets
    <code>.dsp</code> actifs n&eacute;cessaires &agrave; l'installation binaire
    compl&egrave;te d'Apache. Il inclut les d&eacute;pendances entre projets afin que
    ces derniers soient compil&eacute;s selon l'ordre appropri&eacute;.</p>

    <p>Ouvrez l'espace de travail <code>Apache.dsw</code>, et
    s&eacute;lectionnez <code>InstallBin</code> (compilation
    <code>Release</code> ou <code>Debug</code>, selon vos souhaits)
    comme Active Project. <code>InstallBin</code> provoque la
    compilation de tous les projets concern&eacute;s, puis invoque
    <code>Makefile.win</code> pour installer les ex&eacute;cutables et dlls
    compil&eacute;s. Vous pouvez modifier la valeur de <code>INSTDIR=</code>
    via la configuration de <code>InstallBin</code>, onglet G&eacute;n&eacute;ral,
    entr&eacute;e ligne de commandes de compilation. La valeur par d&eacute;faut de
    <code>INSTDIR</code> est le r&eacute;pertoire <code>/Apache2</code>. Si
    vous d&eacute;sirez effectuer un test de compilation (sans installation),
    s&eacute;lectionnez le projet <code>BuildBin</code>.</p>

    <p>Les fichiers projets <code>.dsp</code> sont distribu&eacute;s au format
    Visual Studio 6.0 (98). Visual C++ 5.0 (97) les reconna&icirc;t. Les
    utilisateurs de Visual Studio 2002 (.NET) et versions sup&eacute;rieures
    doivent convertir <code>Apache.dsw</code> et les fichiers
    <code>.dsp</code> en un projet <code>Apache.sln</code>, ainsi que
    les fichiers <code>.msproj</code> ; assurez-vous de reconvertir le
    fichier <code>.msproj</code> si l'un des fichiers source
    <code>.dsp</code> est modifi&eacute; ! Cette op&eacute;ration est vraiment tr&egrave;s
    simple, il suffit de r&eacute;ouvrir <code>Apache.dsw</code> dans l'IDE
    VC++ 7.0 et de le reconvertir.</p>

    <note>Il y a un probl&egrave;me au niveau de la conversion .vcproj des fichiers
    .dsp. devenv.exe interpr&egrave;te mal le drapeau
    /D pour les drapeaux RC contenant de longues /D'efines,
    si ces derni&egrave;res contiennent elles-m&ecirc;mes des espaces. Ainsi, la
    commande :
    <example>
      perl srclib\apr\build\cvtdsp.pl -2005
    </example>
    va convertir les drapeaux /D pour les drapeaux RC afin d'utiliser
    une syntaxe alternative, interpr&eacute;table ; malheureusement, cette
    syntaxe n'est pas support&eacute;e par Visual Studio 97 ou ses fichiers
    .mak export&eacute;s. Ces drapeaux /D transmettent la longue
    description des fichiers de mod_apachemodule.so &agrave; leurs compilations
    d'identificateur de version de ressource .rc partag&eacute;e.</note>


    <p>Les utilisateurs de Visual Studio 2002 (.NET) et versions
    sup&eacute;rieures doivent aussi utiliser
    la bo&icirc;te de dialogue Configuration Manager du menu Build pour
    d&eacute;cocher les deux versions <code>Debug</code> et
    <code>Release</code> des modules <module>mod_ssl</module>
    et <module>mod_deflate</module> pour <code>abs</code>. Ces modules
    sont compil&eacute;s
    en invoquant <code>nmake</code> ou directement l'IDE avec la cible
    <code>BinBuild</code> pour compiler ces modules de mani&egrave;re
    conditionnelle si les sous-r&eacute;pertoires de <code>srclib</code>
    <code>openssl</code> et/ou <code>zlib</code> existent, et en
    fonction des d&eacute;finitions des variables d'environnement
    <code>DBD_LIST</code> et <code>DBM_LIST</code>.</p>

    </section>

  <section id="exportingmakfiles">

    <title>Export des fichiers .mak de la ligne de commandes</title>


    <p>Les fichiers <code>.mak</code> export&eacute;s posent beaucoup de probl&egrave;mes,
    mais les utilisateurs de Visual C++ 5.0 en ont besoin pour compiler
    <module>mod_ssl</module>, abs (<program>ab</program> avec support
    SSL) et/ou <module>mod_deflate</module>. Les fichiers .mak
    supportent aussi un choix plus large de distributions de cha&icirc;nes
    d'outils C++, comme Visual Studio Express.</p>

    <p>Vous devez tout d'abord compiler tous les projets afin de cr&eacute;er
    toutes les cibles dynamiques auto-g&eacute;n&eacute;r&eacute;es, de fa&ccedil;on &agrave; ce que les
    d&eacute;pendances puissent &ecirc;tre interpr&eacute;t&eacute;es correctement. Compilez
    l'ensemble du projet depuis l'IDE Visual Studio 6.0 (98), en
    utilisant la cible <code>BuildAll</code>, puis utilisez le menu de
    projet Export pour tous les makefiles (en cochant "with
    dependencies"). Utilisez la commande suivante pour transformer les
    chemins absolus en chemins relatifs de fa&ccedil;on &agrave; ce que la compilation
    puisse s'effectuer depuis n'importe quelle position dans
    l'arborescence :</p>

    <example>
      perl srclib\apr\build\fixwin32mak.pl
    </example>

    <p>Vous devez ex&eacute;cuter cette commande depuis la <em>racine</em> de
    l'arborescence des sources de httpd. Tout fichier projet
    <code>.mak</code> et <code>.dep</code> du r&eacute;pertoire courant et de
    ses sous-r&eacute;pertoires sera corrig&eacute;, et les rep&egrave;res de temps ajust&eacute;s
    en fonction des <code>.dsp</code>.</p>

    <p>V&eacute;rifiez toujours le SDK de la plate-forme ou autres chemins
    fichiers locaux, sp&eacute;cifiques &agrave; la machine dans les fichiers
    <code>.mak</code> et <code>.dep</code> g&eacute;n&eacute;r&eacute;s. Le r&eacute;pertoire
    <code>DevStudio\Common\MSDev98\bin\</code> (VC6) contient un fichier
    <code>sysincl.dat</code> qui &eacute;num&egrave;re toutes les exceptions. Mettez &agrave;
    jour ce fichier (en particulier les chemins avec slashes et
    anti-slashes, tels que <code>sys/time.h</code> et
    <code>sys\time.h</code>) de fa&ccedil;on &agrave; ignorer ces nouvelles
    d&eacute;pendances. Inclure les chemins d'installation locale dans un
    fichier <code>.mak</code> distribu&eacute; fera &eacute;chouer la
    compilation.</p>

    <p>Si vous soumettez un patch qui modifie les fichiers projet, nous
    devons valider la modification de ces fichiers projet au format
    Visual Studio 6.0. Les modifications doivent &ecirc;tres simples, avec un
    minimum de drapeaux de compilation et d'&eacute;dition de liens qui
    pourront &ecirc;tre reconnus par tous les environnements Visual
    Studio.</p>

  </section>

  <section id="installation">


    <title>Installation</title>

    <p>Une fois compil&eacute;, Apache doit &ecirc;tre install&eacute; dans le r&eacute;pertoire
    racine du serveur. La valeur par d&eacute;faut est le r&eacute;pertoire
    <code>\Apache2</code>, sur le m&ecirc;me disque.</p>

    <p>Pour compiler et installer automatiquement tous les fichiers dans
    le r&eacute;pertoire <em>rep</em> d&eacute;sir&eacute;, utilisez une des commandes
    <code>nmake</code> suivantes :</p>

    <example>
      nmake /f Makefile.win installr INSTDIR=<em>dir</em><br />
      nmake /f Makefile.win installd INSTDIR=<em>dir</em>
    </example>

    <p>L'argument <em>rep</em> de <code>INSTDIR</code> permet de
    sp&eacute;cifier le r&eacute;pertoire d'installation ; il peut &ecirc;tre omis si Apache
    doit &ecirc;tre install&eacute; dans <code>\Apache22</code> (du lecteur de disque
    courant.</p>

</section>

<section id="projectcomponents-warn">

<title>Avertissement &agrave; propos de la compilation d'Apache &agrave; partir de
l'arborescence de d&eacute;veloppement</title>



  
	<note>Notez que seuls les fichiers <code>.dsp</code> sont
	maintenus d'une distribution <code>release</code> &agrave; l'autre. Les
	fichiers <code>.mak</code> ne sont PAS r&eacute;g&eacute;n&eacute;r&eacute;s, suite &agrave;
	l'&eacute;norme perte de temps des relecteurs. Vous ne
	pouvez donc pas utiliser les commandes <code>NMAKE</code>
	ci-dessus pour compiler des fichiers de projet <code>.dsp</code>
	r&eacute;vis&eacute;s si vous n'exportez pas ensuite vous-m&ecirc;me tous les
	fichiers <code>.mak</code> du projet. Ceci n'est pas n&eacute;cessaire
	si vous effectuez la compilation depuis l'environnement
	Microsoft Developer Studio.</note>
</section>	
</manualpage>
