<?xml version="1.0"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1421892 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_log_config.xml.meta">

<name>mod_log_config</name>
<description>Journalisation des requ&ecirc;tes envoy&eacute;es au
serveur</description>
<status>Base</status>
<sourcefile>mod_log_config.c</sourcefile>
<identifier>log_config_module</identifier>

<summary>
    <p>Ce module apporte une grande souplesse dans la journalisation des
    requ&ecirc;tes des clients. Les journaux sont &eacute;crits sous un format
    personnalisable, et peuvent &ecirc;tre enregistr&eacute;s directement dans un
    fichier, ou redirig&eacute;s vers un programme externe. La journalisation
    conditionnelle est support&eacute;e, si bien que des requ&ecirc;tes individuelles
    peuvent &ecirc;tre incluses ou exclues des journaux en fonction de leurs
    caract&eacute;ristiques.</p>

    <p>Ce module fournit trois directives : <directive
    module="mod_log_config">TransferLog</directive> cr&eacute;e un fichier
    journal, <directive module="mod_log_config">LogFormat</directive>
    d&eacute;finit un format personnalis&eacute;, et <directive module="mod_log_config"
    >CustomLog</directive> d&eacute;finit un fichier journal et un format en
    une seule &eacute;tape. Pour journaliser les requ&ecirc;tes dans plusieurs
    fichiers, vous pouvez utiliser plusieurs fois les directives
    <directive>TransferLog</directive> et
    <directive>CustomLog</directive> dans chaque serveur.</p>
</summary>
<seealso><a href="../logs.html">Les fichiers journaux
d'Apache</a></seealso>

<section id="formats"><title>Formats de journaux personnalis&eacute;s</title>

    <p>L'argument format des directives <directive
    module="mod_log_config">LogFormat</directive> et <directive
    module="mod_log_config">CustomLog</directive> est une cha&icirc;ne de
    caract&egrave;res. Cette cha&icirc;ne d&eacute;finit le format de la journalisation des
    requ&ecirc;tes dans le fichier journal. Elle peut contenir des caract&egrave;res
    litt&eacute;raux qui seront reproduits dans le fichier journal, et les
    caract&egrave;res de contr&ocirc;le de style C "\n" et "\t" repr&eacute;sentant
    respectivement un saut &agrave; la ligne et une tabulation. Les guillemets
    et les anti-slashes litt&eacute;raux doivent &ecirc;tre &eacute;chapp&eacute;s &agrave; l'aide
    d'anti-slashes.</p>

    <p>Les caract&eacute;ristiques de la requ&ecirc;te en elle-m&ecirc;me sont journalis&eacute;es
    en ins&eacute;rant des directives "<code>%</code>" dans la cha&icirc;ne de
    format, celles-ci &eacute;tant remplac&eacute;es dans le fichier journal par
    certaines valeurs comme suit :</p>

    <table border="1" style="zebra">
    <columnspec><column width=".2"/><column width=".8"/></columnspec>
    <tr><th>Cha&icirc;ne&nbsp;de&nbsp;format</th>
        <th>Description</th></tr>

    <tr><td><code>%%</code></td>
        <td>Le signe "pourcentage"</td></tr>

    <tr><td><code>%a</code></td>
        <td>Le port et l'adresse IP distants</td></tr>

    <tr><td><code>%{c}a</code></td>
        <td>Port et adresse IP distants sous-jacents de la connexion (voir le module
	<module>mod_remoteip</module>)</td></tr>

    <tr><td><code>%A</code></td>
        <td>L'adresse IP locale</td></tr>

    <tr><td><code>%B</code></td>
        <td>La taille de la r&eacute;ponse en octets, en excluant les en-t&ecirc;tes
	HTTP.</td></tr>

    <tr><td><code>%b</code></td>
        <td>La taille de la r&eacute;ponse en octets, en excluant les en-t&ecirc;tes
	HTTP. Au format <code>"Common Log Format" (CLF)</code> , c'est &agrave; dire
        un '<code>-</code>' &agrave; la place d'un 0 lorsqu'aucun octet n'est renvoy&eacute;.</td></tr>

    <tr><td><code>%{<var>NOMVAR</var>}C</code></td>
        <td>Le contenu du cookie <var>NOMVAR</var> dans la requ&ecirc;te
	envoy&eacute;e au serveur. Seuls les cookies version 0 sont pleinement
	support&eacute;s.</td></tr>

    <tr><td><code>%D</code></td>
        <td>Le temps mis &agrave; servir la requ&ecirc;te, en
	microsecondes.</td></tr>

    <tr><td><code>%{<var>NOMVAR</var>}e</code></td>
        <td>Le contenu de la variable d'environnement
	<var>NOMVAR</var></td></tr>

    <tr><td><code>%f</code></td>
        <td>Nom de fichier</td></tr>

    <tr><td><code>%h</code></td>
        <td>Nom de l'h&ocirc;te distant. Contiendra son adresse IP si la directive
	<directive module="core">HostnameLookups</directive> est d&eacute;finie
	&agrave; <code>Off</code>, ce qui est sa valeur par d&eacute;faut. Si cette
	adresse IP n'est enregistr&eacute;e que pour certains h&ocirc;tes, vous
	avez probablement d&eacute;fini des directives de contr&ocirc;le d'acc&egrave;s qui
	mentionnent ces derniers par leurs noms. Voir la <a
        href="mod_authz_host.html#reqhost">documentation de Require
	host</a>.</td></tr>

    <tr><td><code>%H</code></td>
        <td>Le protocole de la requ&ecirc;te</td></tr>

    <tr><td><code>%{<var>NOMVAR</var>}i</code></td>
        <td>Le contenu des lignes d'en-t&ecirc;te
	<code><var>NOMVAR</var>:</code> dans la requ&ecirc;te envoy&eacute;e au
	serveur. Ces en-t&ecirc;tes peuvent avoir &eacute;t&eacute; modifi&eacute;s par d'autres
        modules (par exemple <module>mod_headers</module>). Si vous
        &ecirc;tes int&eacute;ress&eacute; par ce qu'&eacute;tait l'en-t&ecirc;te de la requ&ecirc;te avant
        d'&ecirc;tre modifi&eacute; par la plupart des modules, utilisez
	<module>mod_setenvif</module> pour copier l'en-t&ecirc;te dans une
	variable d'environnement interne et journaliser sa valeur via
	le champ <code>%{<var>VARNAME</var>}e</code> d&eacute;crit plus haut.

        </td></tr>

    <tr><td><code>%k</code></td>
        <td>Nombre de requ&ecirc;tes persistantes en cours pour cette
	connexion. Int&eacute;ressant si la directive <directive
	module="core">KeepAlive</directive> est utilis&eacute;e ; par exemple,
	'1' signifie la premi&egrave;re requ&ecirc;te apr&egrave;s la requ&ecirc;te initiale, '2'
	la seconde, etc... ; autrement, il s'agit toujours de 0
	(indiquant la requ&ecirc;te initiale).</td></tr>

    <tr><td><code>%l</code></td>
        <td>Le nom de connexion distant (en provenance d'identd, si
	disponible). Affiche un tiret, sauf si
	<module>mod_ident</module> est pr&eacute;sent et si <directive
        module="mod_ident">IdentityCheck</directive> est &agrave;
	<code>On</code>.</td></tr>

    <tr><td><code>%L</code></td>
        <td>L'identifiant du message de journalisation de la requ&ecirc;te
	dans le journal des erreurs (ou '-' si aucun message n'a
	&eacute;t&eacute; enregistr&eacute; dans le journal des erreurs pour cette requ&ecirc;te)</td></tr>

    <tr><td><code>%m</code></td>
        <td>La m&eacute;thode de la requ&ecirc;te</td></tr>

    <tr><td><code>%{<var>NOMVAR</var>}n</code></td>
        <td>Le contenu de la note <var>NOMVAR</var> en provenance d'un
	autre module.</td></tr>

    <tr><td><code>%{<var>NOMVAR</var>}o</code></td>
        <td>Le contenu de la ligne d'en-t&ecirc;te
	<code><var>NOMVAR</var>:</code> de la r&eacute;ponse.</td></tr>

    <tr><td><code>%p</code></td>
        <td>Le port canonique du serveur servant la requ&ecirc;te</td></tr>

    <tr><td><code>%{<var>format</var>}p</code></td>
        <td>Le port canonique du serveur servant la requ&ecirc;te ou le
	v&eacute;ritable port du serveur ou le v&eacute;ritable port du client. les
	formats valides sont <code>canonical</code>, <code>local</code>,
	ou <code>remote</code>.
        </td></tr>

    <tr><td><code>%P</code></td>
        <td>Le num&eacute;ro de processus du processus enfant qui a servi la
	requ&ecirc;te.</td></tr>

    <tr><td><code>%{<var>format</var>}P</code></td>
        <td>Le num&eacute;ro de processus ou le num&eacute;ro de thread du processus
	enfant qui a servi la requ&ecirc;te. Les formats valides sont
	<code>pid</code>, <code>tid</code>, et <code>hextid</code>.
	<code>hextid</code> n&eacute;cessite APR version 1.2.0 ou sup&eacute;rieure.
        </td></tr>

    <tr><td><code>%q</code></td>
        <td>La cha&icirc;ne d'arguments (pr&eacute;fix&eacute;e par un <code>?</code> si une
	cha&icirc;ne d'arguments existe, sinon une cha&icirc;ne vide)</td></tr>

    <tr><td><code>%r</code></td>
        <td>La premi&egrave;re ligne de la requ&ecirc;te</td></tr>

    <tr><td><code>%R</code></td>
        <td>Le gestionnaire qui g&eacute;n&egrave;re la r&eacute;ponse (s'il y en a un).</td></tr>

    <tr><td><code>%s</code></td>
        <td>Statut. Pour les requ&ecirc;tes redirig&eacute;es en interne, il s'agit
	du statut de la requ&ecirc;te *originale* --- <code>%&gt;s</code> pour
	la derni&egrave;re.</td></tr>

    <tr><td><code>%t</code></td>
        <td>Date &agrave; laquelle la requ&ecirc;te a &eacute;t&eacute; re&ccedil;ue (au format [18/Sep/2011:19:18:28 -0400])
	Le dernier nombre indique le d&eacute;calage horaire par rapport &agrave; l'heure GMT.</td></tr>

    <tr><td><code>%{<var>format</var>}t</code></td>
        <td>La date, sous la forme sp&eacute;cifi&eacute;e par format, qui devrait
	&ecirc;tre au format &eacute;tendu <code>strftime(3)</code> (possiblement
	localis&eacute;). Si le format commence par <code>begin:</code> (valeur
	par d&eacute;faut), la date est extraite au d&eacute;but du traitement de la
	requ&ecirc;te ; s'il commence par <code>end:</code>, la date
	correspond au moment o&ugrave; l'entr&eacute;e du journal est inscrite, par
	cons&eacute;quent vers la fin du traitement de la requ&ecirc;te. Hormis les
	formats support&eacute;s par <code>strftime(3)</code>, les formats
	suivants sont &eacute;galement disponibles :
        <table>
        <tr><td><code>sec</code></td><td>nombre de secondes depuis Epoch</td></tr>
        <tr><td><code>msec</code></td><td>nombre de millisecondes depuis  Epoch</td></tr>
        <tr><td><code>usec</code></td><td>nombre de microsecondes depuis Epoch</td></tr>
        <tr><td><code>msec_frac</code></td><td>fraction de milliseconde</td></tr>
        <tr><td><code>usec_frac</code></td><td>fraction de microseconde</td></tr>
        </table>
        Ces symboles ne peuvent pas &ecirc;tre combin&eacute;s entre eux ou avec un
	formatage <code>strftime(3)</code> dans la m&ecirc;me cha&icirc;ne de
	format. Vous pouvez en revanche utiliser plusieurs symboles
	<code>%{<var>format</var>}t</code>.</td></tr>

    <tr><td><code>%T</code></td>
        <td>Le temps mis pour servir la requ&ecirc;te, en secondes.</td></tr>

    <tr><td><code>%u</code></td>
        <td>Le nom d'utilisateur distant, si la requ&ecirc;te a fait l'objet d'une
        authentification par le client (ce champ peut &ecirc;tre consid&eacute;r&eacute; comme
        erron&eacute; ou sans int&eacute;r&ecirc;t si le statut de retour (<code>%s</code>) est
        401).</td></tr>

    <tr><td><code>%U</code></td>
        <td>Le chemin de la requ&ecirc;te, &agrave; l'exclusion de toute cha&icirc;ne
	d'arguments ("<code>query string</code>").</td></tr>

    <tr><td><code>%v</code></td>
        <td>Le nom canonique du serveur qui a servi la requ&ecirc;te, d&eacute;fini
	par la directive <directive
	module="core">ServerName</directive>.</td></tr>

    <tr><td><code>%V</code></td>
        <td>Le nom du serveur en tenant compte de la d&eacute;finition de la
	directive <directive module="core"
        >UseCanonicalName</directive>.</td></tr>

    <tr><td><code>%X</code></td>
        <td>Statut de la connexion lorsque la r&eacute;ponse a &eacute;t&eacute; renvoy&eacute;e :

        <table>
        <columnspec><column width=".2"/><column width=".6"/></columnspec>
        <tr><td><code>X</code> =</td>
            <td>connexion abandonn&eacute;e avant l'envoi de la r&eacute;ponse.</td></tr>
        <tr><td><code>+</code> =</td>
            <td>la connexion peut rester ouverte apr&egrave;s l'envoi de la
	    r&eacute;ponse.</td></tr>
        <tr><td><code>-</code> = </td>
            <td>la connexion sera ferm&eacute;e apr&egrave;s l'envoi de la
	    r&eacute;ponse.</td></tr>
        </table>

        </td></tr>

    <tr><td><code>%I</code></td>
        <td>Le nombre d'octets re&ccedil;us, en comptant la requ&ecirc;te et les
	en-t&ecirc;tes, ne peut &ecirc;tre nul. N&eacute;cessite l'activation de
	<module>mod_logio</module>.</td></tr>

    <tr><td><code>%O</code></td>
        <td>Le nombre d'octets envoy&eacute;s, y compris les en-t&ecirc;tes, ne peut
	&ecirc;tre nul. N&eacute;cessite l'activation de
	<module>mod_logio</module>.</td></tr>
    </table>

    <section id="modifiers"><title>Modificateurs</title>

      <p>Il est possible de restreindre l'enregistrement de certains
      &eacute;l&eacute;ments
      en fonction du code de statut de la r&eacute;ponse, en ins&eacute;rant une liste
      de codes de statut s&eacute;par&eacute;s par des virgules imm&eacute;diatement apr&egrave;s le
      caract&egrave;re "%". La liste des codes de statut peut &ecirc;tre pr&eacute;c&eacute;d&eacute;e
      d'un "<code>!</code>" pour formuler une n&eacute;gation.</p>

      <table border="1" style="zebra">
      <columnspec><column width=".2"/><column width=".8"/></columnspec>
      <tr><th>Cha&icirc;ne de caract&egrave;res de formatage</th>
      <th>Interpr&eacute;tation</th></tr>

      <tr>
      <td><code>%400,501{User-agent}i</code></td>

      <td>Enregistrera l'en-t&ecirc;te <code>User-agent</code> uniquementdans le
      cas d'une erreur 400 ou 501. Avec les autres codes de statut, c'est la
      cha&icirc;ne litt&eacute;rale <code>"-"</code> qui sera enregistr&eacute;e.
      </td></tr>

       <tr><td><code>%!200,304,302{Referer}i</code></td>
       <td>
       Enregistrera l'en-t&ecirc;te <code>Referer</code> pour toutes les requ&ecirc;tes qui
      <em>ne</em> renvoient <em>aucun</em> des trois codes sp&eacute;cifi&eacute;s.
      </td></tr>
      </table>

      <p>Les modificateurs "&lt;" et "&gt;" peuvent &ecirc;tre utilis&eacute;s pour
      les requ&ecirc;tes qui ont &eacute;t&eacute; redirig&eacute;es en interne afin de choisir si
      c'est respectivement la requ&ecirc;te originale ou finale qui doit &ecirc;tre
      consult&eacute;e. Par d&eacute;faut, les directives <code>%s, %U, %T, %D,</code>
      et <code>%r</code> consultent la requ&ecirc;te originale, alors que
      toutes les autres consultent la requ&ecirc;te finale. Ainsi, par
      exemple, on peut utiliser <code>%&gt;s</code> pour enregistrer le
      statut final de la requ&ecirc;te, et <code>%&lt;u</code> pour
      enregistrer l'utilisateur authentifi&eacute; &agrave; l'origine pour une requ&ecirc;te
      redirig&eacute;e en interne vers une ressource sans authentification.</p>

    </section>

    <section id="format-notes"><title>Quelques Notes</title>

      <p>Pour des raisons de s&eacute;curit&eacute;, &agrave; partir de la version 2.0.46,
      les caract&egrave;res non imprimables et autres caract&egrave;res sp&eacute;ciaux dans
      les directives <code>%r</code>, <code>%i</code> et <code>%o</code>
      doivent &ecirc;tre &eacute;chapp&eacute;s &agrave; l'aide des s&eacute;quences
      <code>\x<var>hh</var></code>,
      o&ugrave; <var>hh</var> est le code hexad&eacute;cimal du caract&egrave;re sp&eacute;cial.
      Comme exceptions &agrave; cette r&egrave;gle, les caract&egrave;res <code>"</code> et
      <code>\</code> doivent &ecirc;tre &eacute;chapp&eacute;s par un anti-slash, et tous
      les "blancs" doivent &ecirc;tre &eacute;crits selon leur notation de style C
      (<code>\n</code>, <code>\t</code>, etc...). Avant la version
      2.0.46, aucun &eacute;chappement n'&eacute;tait r&eacute;alis&eacute; sur ces cha&icirc;nes, et il
      fallait &ecirc;tre tr&egrave;s prudent lors de l'exploitation des journaux
      bruts.</p>

      <p>&Agrave; la diff&eacute;rence de la version 1.3, dans httpd 2.0, les cha&icirc;nes
      de format <code>%b</code> et <code>%B</code> ne repr&eacute;sentent pas
      le nombre d'octets envoy&eacute;s au client, mais simplement la taille en
      octets de la r&eacute;ponse HTTP (les deux &eacute;tant diff&eacute;rents, par exemple,
      si la connexion est abandonn&eacute;e, ou si SSL est utilis&eacute;). Le format
      <code>%O</code> fourni par <module>mod_logio</module>,
      enregistrera le nombre r&eacute;el d'octets envoy&eacute;s sur le r&eacute;seau.</p>

      <note>
      <p>Note : <module>mod_cache</module> est impl&eacute;ment&eacute; en tant que
      gestionnaire basique et non en tant que gestionnaire standard.
      C'est pourquoi la cha&icirc;ne de format <code>%R</code> ne renverra pas
      d'information &agrave; propos du gestionnaire lorsqu'une mise en cache de
      contenu entre en jeu.</p>
      </note>

    </section>

    <section id="examples"><title>Exemples</title>

      <p>Quelques cha&icirc;nes de format couramment utilis&eacute;es :</p>

      <dl>
        <dt>Format de journal courant (Common Log Format - CLF)</dt>
        <dd><code>"%h %l %u %t \"%r\" %&gt;s %b"</code></dd>

        <dt>Format de journal courant avec un serveur virtuel</dt>
        <dd><code>"%v %h %l %u %t \"%r\" %&gt;s %b"</code></dd>

        <dt>Format de journal NCSA &eacute;tendu/combin&eacute;</dt>
        <dd><code>"%h %l %u %t \"%r\" %&gt;s %b \"%{Referer}i\"
        \"%{User-agent}i\""</code></dd>

        <dt>Format de journal de la page qui contient le lien vers la
	page concern&eacute;e (Referer)</dt>
        <dd><code>"%{Referer}i -&gt; %U"</code></dd>

        <dt>Format de journal de l'agent (Navigateur)</dt>
        <dd><code>"%{User-agent}i"</code></dd>
      </dl>

      <p>Vous pouvez utiliser plusieurs fois la directive
      <code>%{format}t</code> pour construire un format de temps
      utilisant les symboles de format &eacute;tendus tels que
      <code>msec_frac</code> :</p>
      <dl>
<dt>Format de temps prenant en compte les milisecondes</dt>
<dd><code>"%{%d/%b/%Y %T}t.%{msec_frac}t %{%z}t"</code></dd>

      </dl>

    </section>
</section>

<section id="security"><title>Consid&eacute;rations concernant la
s&eacute;curit&eacute;</title>
    <p>Voir le document <a
    href="../misc/security_tips.html#serverroot">conseils &agrave; mati&egrave;re de
    s&eacute;curit&eacute;</a> pour plus de d&eacute;tails sur les raisons pour lesquelles
    votre s&eacute;curit&eacute; pourrait &ecirc;tre compromise, si le r&eacute;pertoire o&ugrave; sont
    stock&eacute;s les fichiers journaux sont inscriptibles par tout autre
    utilisateur que celui qui d&eacute;marre le serveur.</p>
</section>

<directivesynopsis>
<name>BufferedLogs</name>
<description>Enregistre les entr&eacute;es du journal dans un tampon en m&eacute;moire
avant de les &eacute;crire sur disque</description>
<syntax>BufferedLogs On|Off</syntax>
<default>BufferedLogs Off</default>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>Lorsque la directive <directive>BufferedLogs</directive> est &agrave;
    "on", <module>mod_log_config</module> conserve plusieurs entr&eacute;es
    du journal en m&eacute;moire, et les &eacute;crit d'un seul bloc sur disque,
    plut&ocirc;t que de les &eacute;crire apr&egrave;s chaque requ&ecirc;te. Sur certains
    syst&egrave;mes, ceci peut am&eacute;liorer l'efficacit&eacute; des acc&egrave;s disque, et par
    cons&eacute;quent les performances. La directive ne peut &ecirc;tre d&eacute;finie
    qu'une seule fois pour l'ensemble du serveur ; elle ne peut pas &ecirc;tre
    d&eacute;finie au niveau d'un serveur virtuel.</p>

    <note>Cette directive doit &ecirc;tre utilis&eacute;e avec
    pr&eacute;caution car un crash peut provoquer la perte de donn&eacute;es de
    journalisation.</note>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>CustomLog</name>
<description>D&eacute;finit le nom et le format du fichier
journal</description>
<syntax>CustomLog  <var>fichier</var>|<var>pipe</var>
<var>format</var>|<var>alias</var>
[env=[!]<var>variable-environnement</var>|
expr=<var>expression</var>]</syntax>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
    <p>La directive <directive>CustomLog</directive> contr&ocirc;le
    la journalisation des requ&ecirc;tes destin&eacute;es au serveur. Un format de
    journalisation est sp&eacute;cifi&eacute;, et la journalisation peut s'effectuer de
    mani&egrave;re conditionnelle en fonction des caract&eacute;ristiques de la
    requ&ecirc;te au moyen de variables d'environnement.</p>

    <p>Le premier argument, qui sp&eacute;cifie l'emplacement o&ugrave; les journaux
    seront &eacute;crits, accepte deux types de valeurs :</p>

    <dl>
      <dt><var>fichier</var></dt>
      <dd>Un nom de fichier, relatif au r&eacute;pertoire d&eacute;fini par la
      directive <directive module="core">ServerRoot</directive>.</dd>

      <dt><var>pipe</var></dt>
      <dd>Le caract&egrave;re pipe "<code>|</code>", suivi du chemin vers un
      programme qui recevra les informations de la journalisation sur
      son entr&eacute;e standard. Voir les notes &agrave; propos de la <a
      href="../logs.html#piped">journalisation redirig&eacute;e</a> pour plus
      d'informations.

      <note type="warning"><title>S&eacute;curit&eacute; :</title>
      <p>Si les journaux sont redirig&eacute;s vers un programme, ce dernier
      s'ex&eacute;cutera sous l'utilisateur qui a d&eacute;marr&eacute;
      <program>httpd</program>. Ce sera l'utilisateur root si le serveur
      a &eacute;t&eacute; d&eacute;marr&eacute; par root ; v&eacute;rifiez que le programme est
      s&eacute;curis&eacute;.</p>
      </note>
      <note type="warning"><title>Note</title>
        <p>Lors de la sp&eacute;cification d'un chemin de fichier sur les
	plate-formes non-Unix, il faut prendre soin de ne pas oublier
	que seuls les slashes directs doivent &ecirc;tre utilis&eacute;s, m&ecirc;me si la
	plate-forme autorise l'emploi d'anti-slashes. D'une mani&egrave;re
	g&eacute;n&eacute;rale, c'est une bonne id&eacute;e que de n'utiliser que des slashes
	directs dans les fichiers de configuration.</p>
      </note></dd>
    </dl>

    <p>Le second argument permet de d&eacute;finir ce qui va &ecirc;tre &eacute;crit dans le
    fichier journal. Il peut contenir soit un <var>alias</var> pr&eacute;d&eacute;fini
    par une directive <directive
    module="mod_log_config">LogFormat</directive>, soit une cha&icirc;ne de
    <var>format</var> explicite comme d&eacute;crit dans la section <a
    href="#formats">formats de journaux</a>.</p>

    <p>Par exemple, les deux blocs de directives suivants produisent le
    m&ecirc;me effet :</p>

    <highlight language="config">
# Journal personnalis&eacute; avec alias de format
LogFormat "%h %l %u %t \"%r\" %&gt;s %b" common
CustomLog logs/access_log common

# Journal personnalis&eacute; avec cha&icirc;ne de format explicite
CustomLog logs/access_log "%h %l %u %t \"%r\" %&gt;s %b"
    </highlight>

    <p>Le troisi&egrave;me argument est optionnel et permet de contr&ocirc;ler si une
    requ&ecirc;te doit &ecirc;tre ou non journalis&eacute;e. Dans le cas d'une clause
    '<code>env=!<var>nom</var></code>', la condition peut &ecirc;tre la
    pr&eacute;sence ou l'absence d'une variable particuli&egrave;re dans
    l'<a href="../env.html">environnement du serveur</a>. Dans le cas
    d'une clause 'expr=<var>expression</var>', la condition consiste
    en une <a href="../expr.html">expression</a> bool&eacute;enne
    quelconque. Si la condition n'est pas v&eacute;rifi&eacute;e, la requ&ecirc;te ne sera
    pas journalis&eacute;e. D'&eacute;ventuelles r&eacute;f&eacute;rences &agrave; des en-t&ecirc;tes HTTP dans
    l'expression rationnelle n'entra&icirc;neront pas l'ajout des noms
    d'en-t&ecirc;te correspondants &agrave; l'en-t&ecirc;te Vary.</p>

    <p>Les variables d'environnement peuvent &ecirc;tre d&eacute;finies au niveau de
    chaque requ&ecirc;te en utilisant les modules
    <module>mod_setenvif</module> et/ou <module>mod_rewrite</module>.
    Par exemple, si vous voulez enregistrer les requ&ecirc;tes pour toutes les
    images GIF sur votre serveur dans un fichier journal s&eacute;par&eacute;, et pas
    dans votre journal principal, vous pouvez utiliser :</p>

    <highlight language="config">
SetEnvIf Request_URI \.gif$ gif-image
CustomLog gif-requests.log common env=gif-image
CustomLog nongif-requests.log common env=!gif-image
    </highlight>

    <p>Ou, pour reproduire le comportement de l'ancienne directive
    RefererIgnore, vous pouvez utiliser :</p>

    <highlight language="config">
SetEnvIf Referer example\.com localreferer
CustomLog referer.log referer env=!localreferer
    </highlight>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>LogFormat</name>
<description>D&eacute;crit un format utilisable dans un fichier
journal</description>
<syntax>LogFormat <var>format</var>|<var>alias</var>
[<var>alias</var>]</syntax>
<default>LogFormat "%h %l %u %t \"%r\" %>s %b"</default>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
    <p>Cette directive permet de sp&eacute;cifier le format du fichier journal
    des acc&egrave;s.</p>

    <p>La directive <directive>LogFormat</directive> se pr&eacute;sente sous
    deux formes. Sous la premi&egrave;re forme, qui ne poss&egrave;de qu'un seul
    argument, la directive d&eacute;finit le format qui sera utilis&eacute; dans les
    journaux sp&eacute;cifi&eacute;s par les directives
    <directive>TransferLog</directive> ult&eacute;rieures. L'argument unique
    peut contenir un <var>format</var> explicite comme d&eacute;crit dans la
    section <a href="#formats">formats de journaux personnalis&eacute;s</a>
    ci-dessus. Il peut aussi contenir un <var>alias</var> faisant
    r&eacute;f&eacute;rence &agrave; un format de journal pr&eacute;d&eacute;fini par une directive
    <directive>LogFormat</directive> comme d&eacute;crit plus loin.</p>

    <p>Sous sa seconde forme, la directive
    <directive>LogFormat</directive> associe un <var>format</var>
    explicite &agrave; un <var>alias</var>. Cet <var>alias</var> peut
    ensuite s'utiliser dans les directives
    <directive>LogFormat</directive> ou <directive
    module="mod_log_config">CustomLog</directive> ult&eacute;rieures, ce qui
    &eacute;vite d'avoir &agrave; r&eacute;p&eacute;ter l'ensemble de la cha&icirc;ne de format. Une
    directive <directive>LogFormat</directive> qui d&eacute;finit un alias
    <strong>ne fait rien d'autre</strong> -- c'est &agrave; dire qu'<em>elle ne
    fait que</em> d&eacute;finir l'alias, elle n'applique pas le format et n'en
    fait pas le format par d&eacute;faut. Par cons&eacute;quent, elle n'affecte pas
    les directives <directive
    module="mod_log_config">TransferLog</directive> ult&eacute;rieures. En
    outre, la directive <directive>LogFormat</directive> ne peut pas
    utiliser un alias pour en d&eacute;finir un autre. Notez que l'alias ne
    doit pas contenir de caract&egrave;re pourcent (<code>%</code>).</p>

    <example><title>Exemple</title>
    <highlight language="config">
      LogFormat "%v %h %l %u %t \"%r\" %&gt;s %b" serveur_virtuel_commun
      </highlight>
    </example>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>TransferLog</name>
<description>Sp&eacute;cifie l'emplacement d'un fichier journal</description>
<syntax>TransferLog <var>fichier</var>|<var>pipe</var></syntax>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
    <p>Cette directive poss&egrave;de exactement les m&ecirc;mes arguments et produit
    les m&ecirc;mes effets que la directive <directive
    module="mod_log_config">CustomLog</directive>, &agrave; l'exception qu'elle
    ne permet pas de sp&eacute;cifier un format de journal explicite ou la
    journalisation conditionnelle des requ&ecirc;tes. En l'occurrence, le
    format de journal est d&eacute;termin&eacute; par la derni&egrave;re d&eacute;finition d'une
    directive <directive module="mod_log_config">LogFormat</directive>
    qui ne d&eacute;finit pas d'alias. Si aucun format particulier n'a &eacute;t&eacute;
    sp&eacute;cifi&eacute;, c'est le Common Log Format qui sera utilis&eacute;.</p>

    <example><title>Exemple</title>
      <highlight language="config">
LogFormat "%h %l %u %t \"%r\" %&gt;s %b \"%{Referer}i\" \"%{User-agent}i\""
TransferLog logs/access_log
      </highlight>
    </example>
</usage>
</directivesynopsis>

</modulesynopsis>
