<?xml version="1.0"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1328329 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_lbmethod_byrequests.xml.meta">

<name>mod_lbmethod_byrequests</name>
<description>Algorithme de planification avec r&eacute;partition de charge du
traitement des requ&ecirc;tes pour le module
<module>mod_proxy_balancer</module></description>
<status>Extension</status>
<sourcefile>mod_lbmethod_byrequests.c</sourcefile>
<identifier>lbmethod_byrequests_module</identifier>
<compatibility>Dissoci&eacute; de <module>mod_proxy_balancer</module> dans la
version 2.3</compatibility>

<summary>
<p>Ce module ne fournit pas lui-m&ecirc;me de directive de configuration. Il
n&eacute;cessite les services de <module>mod_proxy_balancer</module>, et
fournit la m&eacute;thode de r&eacute;partition de charge <code>byrequests</code>.</p>
</summary>
<seealso><module>mod_proxy</module></seealso>
<seealso><module>mod_proxy_balancer</module></seealso>

<section id="requests">
    <title>Algorithme d'attribution des requ&ecirc;tes</title>
    <p>Activ&eacute; via <code>lbmethod=byrequests</code>, ce planificateur &agrave;
    &eacute;t&eacute; con&ccedil;u dans le but de distribuer les requ&ecirc;tes &agrave; tous les
    processus worker afin qu'ils traitent tous le nombre de requ&ecirc;tes
    pour lequel ils ont &eacute;t&eacute; configur&eacute;s. Il fonctionne de la mani&egrave;re
    suivante : </p>

    <p><dfn>lbfactor</dfn> correspond &agrave; la <em>quantit&eacute; de travail que
    nous attendons de ce processus worker</em>, ou en d'autres termes
    son <em>quota de travail</em>. C'est une valeur normalis&eacute;e
    repr&eacute;sentant leur part du travail &agrave; accomplir.</p>

    <p><dfn>lbstatus</dfn> repr&eacute;sente <em>combien il est urgent que
    ce processus worker travaille pour remplir son quota de
    travail</em>.</p>

    <p>Le <dfn>worker</dfn> est un membre du dispositif de r&eacute;partition
    de charge, en g&eacute;n&eacute;ral un serveur distant traitant un des protocoles
    support&eacute;s.</p>

    <p>On distribue &agrave; chaque processus worker son quota de travail, puis
    on regarde celui qui a le plus besoin de travailler
    (le plus grand lbstatus). Ce processus est alors s&eacute;lectionn&eacute; pour
    travailler, et son lbstatus diminu&eacute; de l'ensemble des quotas de
    travail que nous avons distribu&eacute;s &agrave; tous les processus. La somme de
    tous les lbstatus n'est ainsi pas modifi&eacute;e, et nous pouvons
    distribuer les requ&ecirc;tes selon nos souhaits.</p>

    <p>Si certains processus workers sont d&eacute;sactiv&eacute;s, les autres feront
    l'objet d'une planification normale.</p>

    <example><pre><code>for each worker in workers
    worker lbstatus += worker lbfactor
    total factor    += worker lbfactor
    if worker lbstatus > candidate lbstatus
        candidate = worker

candidate lbstatus -= total factor</code></pre>
    </example>

    <p>Si un r&eacute;partiteur de charge est configur&eacute; comme suit :</p>

    <table style="data">
    <tr><th>worker</th>
        <th>a</th>
        <th>b</th>
        <th>c</th>
        <th>d</th></tr>
    <tr><th>lbfactor</th>
        <td>25</td>
        <td>25</td>
        <td>25</td>
        <td>25</td></tr>
    <tr><th>lbstatus</th>
        <td>0</td>
        <td>0</td>
        <td>0</td>
        <td>0</td></tr>
    </table>

    <p>Et si <var>b</var> est d&eacute;sactiv&eacute;, la planification suivante est
    mise en oeuvre :</p>

    <table style="data">
    <tr><th>worker</th>
        <th>a</th>
        <th>b</th>
        <th>c</th>
        <th>d</th></tr>
    <tr><th>lbstatus</th>
        <td><em>-50</em></td>
        <td>0</td>
        <td>25</td>
        <td>25</td></tr>
    <tr><th>lbstatus</th>
        <td>-25</td>
        <td>0</td>
        <td><em>-25</em></td>
        <td>50</td></tr>
    <tr><th>lbstatus</th>
        <td>0</td>
        <td>0</td>
        <td>0</td>
        <td><em>0</em></td></tr>
    <tr><td colspan="5">(repeat)</td></tr>
    </table>

    <p>C'est &agrave; dire la chronologie suivante : <var>a</var> <var>c</var>
    <var>d</var>
    <var>a</var> <var>c</var> <var>d</var> <var>a</var> <var>c</var>
    <var>d</var> ... Veuillez noter que :</p>

    <table style="data">
    <tr><th>worker</th>
        <th>a</th>
        <th>b</th>
        <th>c</th>
        <th>d</th></tr>
    <tr><th>lbfactor</th>
        <td>25</td>
        <td>25</td>
        <td>25</td>
        <td>25</td></tr>
    </table>

    <p>A le m&ecirc;me effet que :</p>

    <table style="data">
    <tr><th>worker</th>
        <th>a</th>
        <th>b</th>
        <th>c</th>
        <th>d</th></tr>
    <tr><th>lbfactor</th>
        <td>1</td>
        <td>1</td>
        <td>1</td>
        <td>1</td></tr>
    </table>

    <p>Ceci est d&ucirc; au fait que toutes les valeurs de <dfn>lbfactor</dfn>
    sont normalis&eacute;es et &eacute;valu&eacute;es en fonction des autres. Avec :</p>

    <table style="data">
    <tr><th>worker</th>
        <th>a</th>
        <th>b</th>
        <th>c</th></tr>
    <tr><th>lbfactor</th>
        <td>1</td>
        <td>4</td>
        <td>1</td></tr>
    </table>

    <p>le processus <var>b</var> va, en moyenne, se voir assigner 4 fois
    plus de requ&ecirc;tes que <var>a</var> et <var>c</var>.</p>

    <p>La configuration suivante, asym&eacute;trique, fonctionne comme on peut
    s'y attendre :</p>

    <table style="data">
    <tr><th>worker</th>
        <th>a</th>
        <th>b</th></tr>
    <tr><th>lbfactor</th>
        <td>70</td>
        <td>30</td></tr>
    <tr><td colspan="2">&nbsp;</td></tr>
    <tr><th>lbstatus</th>
        <td><em>-30</em></td>
        <td>30</td></tr>
    <tr><th>lbstatus</th>
        <td>40</td>
        <td><em>-40</em></td></tr>
    <tr><th>lbstatus</th>
        <td><em>10</em></td>
        <td>-10</td></tr>
    <tr><th>lbstatus</th>
        <td><em>-20</em></td>
        <td>20</td></tr>
    <tr><th>lbstatus</th>
        <td><em>-50</em></td>
        <td>50</td></tr>
    <tr><th>lbstatus</th>
        <td>20</td>
        <td><em>-20</em></td></tr>
    <tr><th>lbstatus</th>
        <td><em>-10</em></td>
        <td>10</td></tr>
    <tr><th>lbstatus</th>
        <td><em>-40</em></td>
        <td>40</td></tr>
    <tr><th>lbstatus</th>
        <td>30</td>
        <td><em>-30</em></td></tr>
    <tr><th>lbstatus</th>
        <td><em>0</em></td>
        <td>0</td></tr>
    <tr><td colspan="3">(repeat)</td></tr>
    </table>

    <p>Apr&egrave;s 10 distributions, la planification se r&eacute;p&egrave;te et 7
    <var>a</var> sont s&eacute;lectionn&eacute;s avec 3 <var>b</var> intercal&eacute;s.</p>
</section>

</modulesynopsis>
