<?xml version="1.0"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1346429 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_authz_host.xml.meta">

<name>mod_authz_host</name>
<description>Autorisations de groupe bas&eacute;es sur l'h&ocirc;te (nom ou adresse
IP)</description>
<status>Base</status>
<sourcefile>mod_authz_host.c</sourcefile>
<identifier>authz_host_module</identifier>
<compatibility>Disponible depuis les versions 2.3 et sup&eacute;rieures
d'Apache</compatibility>

<summary>
    <p>Les fournisseurs d'autorisation impl&eacute;ment&eacute;s par le module
    <module>mod_authz_host</module> sont enregistr&eacute;s &agrave; l'aide de
    la directive <directive module="mod_authz_core">Require</directive>. On peut
    utiliser cette directive &agrave; l'int&eacute;rieur de sections <directive
    module="core" type="section">Directory</directive>, <directive
    module="core" type="section">Files</directive>, ou <directive
    module="core" type="section">Location</directive> ou de fichiers
    <code><a href="core.html#accessfilename">.htaccess</a> </code> pour
    contr&ocirc;ler l'acc&egrave;s &agrave; certaines zones du serveur. Le contr&ocirc;le d'acc&egrave;s
    peut &ecirc;tre effectu&eacute; en fonction du nom d'h&ocirc;te ou de l'adresse IP.</p>

    <p>En g&eacute;n&eacute;ral, les directives de restriction d'acc&egrave;s s'appliquent &agrave;
    toutes les m&eacute;thodes d'acc&egrave;s (<code>GET</code>, <code>PUT</code>,
    <code>POST</code>, etc...). C'est d'ailleurs ce que l'on souhaite
    dans la plupart des cas. Il est cependant possible de ne restreindre
    l'acc&egrave;s que pour certaines m&eacute;thodes, tout en laissant les autres
    m&eacute;thodes sans protection, en pla&ccedil;ant les directives dans une section
    <directive module="core" type="section">Limit</directive>.</p>
</summary>

<seealso><a href="../howto/auth.html">Authentification, autorisation et
contr&ocirc;le d'acc&egrave;s</a></seealso>
<seealso><directive module="mod_authz_core">Require</directive></seealso>

<section id="requiredirectives"><title>Les directives Require</title>

    <p>La directive Apache <directive
    module="mod_authz_core">Require</directive> est utilis&eacute;e au cours de
    la phase d'autorisation pour v&eacute;rifier si un utilisateur se voit
    accorder ou refuser l'acc&egrave;s &agrave; une ressource. mod_authz_host fournit
    les types d'autorisation <code>ip</code>, <code>host</code>. D'autres
    types d'autorisation
    sont aussi disponibles, mais n&eacute;cessitent le chargement des modules
    d'autorisation appropri&eacute;s.</p>

    <p>Ces fournisseurs d'autorisation permettent de d&eacute;terminer quels
    h&ocirc;tes peuvent acc&eacute;der &agrave; une zone du serveur. On peut contr&ocirc;ler
    l'acc&egrave;s en fonction du nom d'h&ocirc;te, de l'adresse IP, ou d'un intervalle
    d'adresses IP.</p>

<section id="reqip"><title>Require ip</title>

    <p>Le fournisseur <code>ip</code> permet de contr&ocirc;ler l'acc&egrave;s au
    serveur en fonction de l'adresse IP du client distant. Lorsque
    <code>Require ip <var>adresse-ip</var></code> est sp&eacute;cifi&eacute;, la
    requ&ecirc;te est autoris&eacute;e si l'adresse IP du client distant correspond
    &agrave;</p>

    <p>Une adresse IP compl&egrave;te :</p>

    <highlight language="config">
Require ip 10.1.2.3
Require ip 192.168.1.104 192.168.1.205
    </highlight>

    <p>L'adresse IP d'un h&ocirc;te pour qui l'acc&egrave;s est accord&eacute;</p>

    <p>Une adresse IP partielle :</p>

    <highlight language="config">
Require ip 10.1
Require ip 10 172.20 192.168.2
    </highlight>
    <p>Les 1 &agrave; 3 premiers octets d'une adresse IP, pour une restriction
    &agrave; un sous-r&eacute;seau.</p>

    <p>Une paire r&eacute;seau/masque de sous-r&eacute;seau :</p>

    <highlight language="config">
      Require ip 10.1.0.0/255.255.0.0
    </highlight>
    <p>Un r&eacute;seau a.b.c.d, et un masque de sous-r&eacute;seau w.x.y.z. pour une
    restriction de sous-r&eacute;seau plus fine.</p>

    <p>Une sp&eacute;cification CIDR r&eacute;seau/nnn :</p>

    <highlight language="config">
      Require ip 10.1.0.0/16
    </highlight>
    <p>Identique au cas pr&eacute;c&eacute;dent, except&eacute; que le masque de sous-r&eacute;seau
    repr&eacute;sente les nnn premiers bits de poids fort.</p>

    <p>Notez que les trois derniers exemples correspondent exectement au
    m&ecirc;me ensemble d'h&ocirc;tes.</p>

    <p>On peut sp&eacute;cifier des adresses et des sous-r&eacute;seaux IPv6 comme
    suit :</p>

    <highlight language="config">
Require ip 2001:db8::a00:20ff:fea7:ccea
Require ip 2001:db8::a00:20ff:fea7:ccea/10
    </highlight>


</section>

<section id="reqhost"><title>Require host</title>

    <p>Le fournisseur <code>host</code> permet de contr&ocirc;ler l'acc&egrave;s au
    serveur en fonction du nom d'h&ocirc;te du client distant. Lorsque
    <code>Require host <var>nom-h&ocirc;te</var></code> est sp&eacute;cifi&eacute;, la
    requ&ecirc;te est autoris&eacute;e si le nom d'h&ocirc;te correspond &agrave;</p>

    <p>Un nom de domaine (&eacute;ventuellement partiel)</p>

    <highlight language="config">
Require host example.org
Require host .net example.edu
    </highlight>

    <p>Les h&ocirc;tes dont les noms correspondent ou se terminent par la
    cha&icirc;ne sp&eacute;cifi&eacute;e se voient accorder l'acc&egrave;s. Seuls les &eacute;l&eacute;ment de
    nom de domaine complets sont mis en correspondance ; ainsi,
    l'exemple ci-dessus correspondra &agrave; <code>foo.example.org</code>, mais
    ne correspondra pas &agrave; <code>fooexample.org</code>. Avec cette
    configuration, Apache va effectuer une double recherche DNS sur
    l'adresse IP du client, sans tenir compte de la d&eacute;finition de la
    directive  <directive module="core">HostnameLookups</directive>. Il
    va effectuer une recherche DNS inverse sur l'adresse IP pour trouver
    le nom d'h&ocirc;te associ&eacute;, puis une recherche DNS directe sur le nom
    d'h&ocirc;te pour v&eacute;rifier qu'il correspond bien &agrave; l'adresse IP originale.
    L'acc&egrave;s ne sera accord&eacute; que si le nom d'h&ocirc;te correspond et si les
    recherches DNS inverse et directe sont coh&eacute;rentes.</p>

</section>

<section id="reqlocal"><title>Require local</title>
    <p>Le fournisseur <code>local</code> autorise l'acc&egrave;s au serveur si
    l'une au moins de ces conditions est satisfaite :</p>

    <ul>
        <li>l'adresse IP du client correspond &agrave; 127.0.0.0/8</li>
        <li>l'adresse IP du client est ::1</li>
        <li>les adresses IP du client et du serveur sont identiques</li>
    </ul>

    <p>L'exemple suivant montre une m&eacute;thode simple pour s&eacute;lectionner les
    connexions en provenance de l'h&ocirc;te local :</p>

    <highlight language="config">
    Require local
    </highlight>

</section>

<section id="proxy"><title>Note concernant la s&eacute;curit&eacute;</title>

    <p>Si le contenu de votre serveur est mandat&eacute;, vous devez garder &agrave;
    l'esprit que l'adresse client correspondra &agrave; l'adresse de votre
    serveur mandataire et non &agrave; l'adresse du client, et l'utilisation de
    la directive <code>Require</code> dans ce contexte ne provoquera pas
    forc&eacute;ment l'effet d&eacute;sir&eacute;. Voir <module>mod_remoteip</module> pour
    une solution possible &agrave; ce probl&egrave;me.</p>
    
</section>

</section>

</modulesynopsis>
