<?xml version="1.0"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English revision : 1427185 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_auth_form.xml.meta">

<name>mod_auth_form</name>
<description>Authentification &agrave; l'aide d'un formulaire</description>
<status>Base</status>
<sourcefile>mod_auth_form.c</sourcefile>
<identifier>auth_form_module</identifier>
<compatibility>Disponible &agrave; partir d'Apache 2.3</compatibility>

<summary>
    <note type="warning"><title>Avertissement</title>
      <p>L'authentification &agrave; base de formulaire d&eacute;pend des modules
      <module>mod_session</module> qui utilisent les cookies HTTP, et en
      tant que tels s'exposent &agrave; des attaques de type Cross Site
      Scripting, ou risquent de divulguer des informations &agrave; caract&egrave;re
      priv&eacute; aux clients. Assurez-vous que ces risques ont bien &eacute;t&eacute; pris
      en compte avant d'activer les sessions sur votre serveur.</p>
    </note>

    <p>Ce module permet de restreindre les acc&egrave;s, au moyen d'un formulaire de
    connexion HTML, en recherchant les utilisateurs aupr&egrave;s des fournisseurs
    sp&eacute;cifi&eacute;s. Les formulaires HTML requi&egrave;rent
    davantage de configuration que les m&eacute;thodes d'authentification
    alternatives, mais ils peuvent s'av&eacute;rer beaucoup plus conviviaux
    pour les utilisateurs.
    </p>

    <p>L'authentification HTTP de base est fournie par le module
    <module>mod_auth_basic</module>, et l'authentification HTTP &agrave; base
    de condens&eacute; par le module <module>mod_auth_digest</module>. Le
    module <module>mod_auth_form</module> doit &ecirc;tre utilis&eacute; avec au
    moins un module d'authentification du style
    <module>mod_authn_file</module> et un module d'autorisation comme
    <module>mod_authz_user</module>.</p>

    <p>Lorsque l'utilisateur a &eacute;t&eacute; authentifi&eacute; avec succ&egrave;s, ses
    informations de connexion sont stock&eacute;s dans une session fournie par
    le module <module>mod_session</module>.
    </p>

</summary>
<seealso><module>mod_session</module></seealso>
<seealso><directive module="mod_authn_core">AuthName</directive></seealso>
<seealso><directive module="mod_authn_core">AuthType</directive></seealso>
<seealso><directive module="mod_authz_core">Require</directive></seealso>
<seealso><a href="../howto/auth.html">Mise en oeuvre de
l'authentification</a></seealso>

    <section id="basicconfig"><title>Configuration de base</title>

      <p>Pour prot&eacute;ger une URL particuli&egrave;re avec le module
      <module>mod_auth_form</module>, vous devez d&eacute;terminer l'endroit o&ugrave;
      vous allez stocker votre <var>session</var>, ainsi que la m&eacute;thode
      d'authentification. Dans cet exemple simple, les informations de
      connexion sont stock&eacute;es dans une session &agrave; l'aide du module
      <module>mod_session_cookie</module>, et l'authentification utilise
      un fichier en s'appuyant sur le module
      <module>mod_authn_file</module>. Si l'authentification &eacute;choue,
      l'utilisateur sera redirig&eacute; vers la page du formulaire de
      connexion.</p>

      <example><title>Exemple simple</title>
        <highlight language="config">
AuthFormProvider file
AuthUserFile conf/passwd
AuthType form
AuthName realm
AuthFormLoginRequiredLocation http://example.com/login.html
Session On
SessionCookieName session path=/
SessionCryptoPassphrase secret
        </highlight>
      </example>

      <p>L'authentification <module>mod_auth_form</module> est activ&eacute;e
      en affectant la valeur <var>form</var> &agrave; la directive <directive
      module="mod_authn_core">AuthType</directive>. Les directives
      <directive module="mod_auth_form">AuthFormProvider</directive> et
      <directive module="mod_authn_file">AuthUserFile</directive>
      sp&eacute;cifient que les noms d'utilisateurs et mots de passe seront
      v&eacute;rifi&eacute;s en utilisant le fichier choisi.</p>

      <p>Les directives <directive
      module="mod_session">Session</directive>, <directive
      module="mod_session_cookie">SessionCookieName</directive> et
      <directive
      module="mod_session_crypto">SessionCryptoPassphrase</directive>
      cr&eacute;ent une session chiffr&eacute;e stock&eacute;e dans un cookie HTTP au niveau
      du navigateur. Pour plus d'informations &agrave; propos des diff&eacute;rentes
      options de configuration des sessions, reportez-vous &agrave; la
      documentation du module <module>mod_session</module>.</p>

      <p>Dans l'exemple simple ci-dessus, une URL a &eacute;t&eacute; prot&eacute;g&eacute;e par
      <module>mod_auth_form</module>, mais on doit maintenant fournir
      &agrave; l'utilisateur un moyen de saisir un nom et un mot de passe. &Agrave; cet
      effet, on peut soit &eacute;crire une page de connexion ind&eacute;pendante
      d&eacute;di&eacute;e, soit inclure le formulaire de connexion dans la page
      courante.</p>
    </section>

    <section id="standalone"><title>Page de connexion d&eacute;di&eacute;e</title>

      <p>Le formulaire de connexion peut &ecirc;tre contenu dans une page
      ind&eacute;pendante, ou &ecirc;tre inclus dans la page courante. </p>

      <p>Lorsque la connexion s'effectue &agrave; partir d'une page
      ind&eacute;pendante et si la tentative d'authentification &eacute;choue,
      l'utilisateur doit &ecirc;tre redirig&eacute; vers un formulaire de connexion,
      cr&eacute;&eacute; &agrave; cet effet sur le site web, en utilisant la directive
      <directive
      module="mod_auth_form">AuthFormLoginRequiredLocation</directive>.
      En g&eacute;n&eacute;ral, la page de connexion contiendra un formulaire HTML
      demandant &agrave; l'utilisateur de fournir un nom et un mot de passe.</p>

      <example><title>Exemple de formulaire de connexion</title>
        &lt;form method="POST" action="/dologin.html"&gt;<br />
        Utilisateur : &lt;input type="text" name="httpd_username" value="" /&gt;<br />
        Mot de passe: &lt;input type="password" name="httpd_password" value="" /&gt;<br />
        &lt;input type="submit" name="login" value="Connexion" /&gt;<br />
        &lt;/form&gt;<br />
      </example>

      <p>La partie o&ugrave; s'effectue la connexion proprement dite est
      trait&eacute;e par le gestionnaire <var>form-login-handler</var>.
      L'action de ce formulaire doit pointer vers ce gestionnaire, ce
      que l'on configure dans Apache httpd comme suit :</p>

      <example><title>Exemple de configuration du gestionnaire de
      formulaire de connexion</title>
        <highlight language="config">
&lt;Location /dologin.html&gt;
    SetHandler form-login-handler
    AuthFormLoginRequiredLocation http://example.com/login.html
    AuthFormLoginSuccessLocation http://example.com/success.html
    AuthFormProvider file
    AuthUserFile conf/passwd
    AuthType form
    AuthName realm
    Session On
    SessionCookieName session path=/
    SessionCryptoPassphrase secret
&lt;/Location&gt;
        </highlight>
      </example>

      <p>L'URL sp&eacute;cifi&eacute;e par la directive <directive
      module="mod_auth_form">AuthFormLoginRequiredLocation</directive>
      r&eacute;f&eacute;rencera en g&eacute;n&eacute;ral une page expliquant &agrave; l'utilisateur que sa
      tentative de connexion a &eacute;chou&eacute;, et qu'il doit la renouveler. La
      directive <directive
      module="mod_auth_form">AuthFormLoginSuccessLocation</directive>
      sp&eacute;cifie l'URL vers laquelle l'utilisateur doit &ecirc;tre redirig&eacute; s'il
      s'est authentifi&eacute; avec succ&egrave;s.</p>

      <p>Alternativement, l'URL vers laquelle doit &ecirc;tre redirig&eacute;
      l'utilisateur s'il s'est authentifi&eacute; avec succ&egrave;s peut &ecirc;tre
      int&eacute;gr&eacute;e dans le formulaire de connexion, comme dans l'exemple
      ci-dessous. Il en d&eacute;coule que le m&ecirc;me gestionnaire
      <var>form-login-handler</var> pourra &ecirc;tre utilis&eacute; pour diff&eacute;rentes
      zones du site web.</p>

      <example><title>Exemple de formulaire de login avec page cible</title>
        &lt;form method="POST" action="/dologin.html"&gt;<br />
        <indent>
          Utilisateur  : &lt;input type="text" name="httpd_username" value="" /&gt;<br />
          Mot de passe : &lt;input type="password" name="httpd_password" value="" /&gt;<br />
          &lt;input type="submit" name="login" value="Connexion" /&gt;<br />
          &lt;input type="hidden" name="httpd_location" value="http://example.com/success.html" /&gt;<br />
        </indent>
        &lt;/form&gt;<br />
      </example>

    </section>

    <section id="inline"><title>Connexion &agrave; la vol&eacute;e</title>

      <note type="warning"><title>Avertissement</title>
        <p>Il existe un risque, dans certaines circonstances, que le
	formulaire de connexion configur&eacute; pour une connexion &agrave; la vol&eacute;e
	soit soumis plusieurs fois, r&eacute;v&eacute;lant de ce fait les param&egrave;tres
	de connexion &agrave; l'application sous-jacente. L'administrateur doit
	s'assurer que cette derni&egrave;re est correctement s&eacute;curis&eacute;e afin
	d'&eacute;viter les &eacute;ventuels abus. En cas de doute, utilisez une page
	de connexion ind&eacute;pendante d&eacute;di&eacute;e.</p>
      </note>

      <p>Comme alternative &agrave; la page de connexion d&eacute;di&eacute;e pour un site
      web, il est possible de configurer <module>mod_auth_form</module>
      pour authentifier les utilisateurs &agrave; la vol&eacute;e, sans les rediriger
      vers une autre page, ce qui permet de conserver l'&eacute;tat de la page
      courante au cours de la tentative de connexion. Ceci peut s'av&eacute;rer
      utile dans le cas d'une session limit&eacute;e dans le temps, si le d&eacute;lai
      de la session a expir&eacute; pendant la requ&ecirc;te de l'utilisateur. Ce
      dernier peut alors se r&eacute;authentifier &agrave; la m&ecirc;me place, et
      poursuivre son activit&eacute; &agrave; partir du point o&ugrave; il en &eacute;tait rest&eacute;.</p>

      <p>Si un utilisateur non authentifi&eacute; tente d'acc&eacute;der &agrave; une page
      prot&eacute;g&eacute;e par <module>mod_auth_form</module>, et si ce dernier
      n'est pas configur&eacute; avec une directive <directive
      module="mod_auth_form">AuthFormLoginRequiredLocation</directive>,
      un code de statut <var>HTTP_UNAUTHORIZED</var> est renvoy&eacute; vers le
      navigateur, indiquant &agrave; l'utilisateur qu'il n'est pas autoris&eacute; &agrave;
      acc&eacute;der &agrave; cette page.</p>

      <p>Pour configurer l'authentification &agrave; la vol&eacute;e, l'administrateur
      remplace le message d'erreur renvoy&eacute; par le code de statut
      <var>HTTP_UNAUTHORIZED</var> par un message d'erreur personnalis&eacute;
      contenant le formulaire de connexion comme suit :</p>

      <example><title>Exemple simple d'authentification &agrave; la vol&eacute;e</title>
        <highlight language="config">
AuthFormProvider file
ErrorDocument 401 /login.shtml
AuthUserFile conf/passwd
AuthType form
AuthName realm
AuthFormLoginRequiredLocation http://example.com/login.html
Session On
SessionCookieName session path=/
SessionCryptoPassphrase secret
        </highlight>
      </example>

      <p>La page du message d'erreur doit contenir un formulaire de
      connexion dont la propri&eacute;t&eacute; action est vide, comme dans l'exemple
      ci-dessous. Ceci a pour effet de soumettre le formulaire &agrave; l'URL
      prot&eacute;g&eacute;e originale, cette derni&egrave;re n'ayant pas besoin d'&ecirc;tre
      connue de la page en cours.</p>

      <example><title>Exemple de formulaire de connexion &agrave; la vol&eacute;e</title>
        &lt;form method="POST" <strong>action=""</strong>&gt;<br />
        <indent>
          Utilisateur  : &lt;input type="text" name="httpd_username" value="" /&gt;<br />
          Mot de passe : &lt;input type="password" name="httpd_password" value="" /&gt;<br />
          &lt;input type="submit" name="login" value="Connexion" /&gt;<br />
        </indent>
        &lt;/form&gt;<br />
      </example>

      <p>Lorsque l'utilisateur final a entr&eacute; ses informations de
      connexion, le formulaire effectue une requ&ecirc;te HTTP POST pour l'URL
      originale prot&eacute;g&eacute;e par mot de passe.
      <module>mod_auth_form</module> va alors intercepter cette requ&ecirc;te
      POST, et dans le cas o&ugrave; des champs HTML Utilisateur et Mot de
      passe corrects sont pr&eacute;sents, l'utilisateur sera connect&eacute;, et
      l'URL originale prot&eacute;g&eacute;e par mot de passe lui sera retourn&eacute;e en
      tant que requ&ecirc;te GET.</p>

    </section>

    <section id="inlinepreservebody"><title>Connexion &agrave; la vol&eacute;e avec
    conservation du contenu</title>

      <p>Il existe une limite &agrave; la technique de connexion &agrave; la vol&eacute;e
      d&eacute;crite ci-dessus ; si un formulaire HTML POST entra&icirc;ne une
      demande d'authentification ou de r&eacute;authentification, le contenu du
      formulaire original envoy&eacute; par le navigateur sera perdu. Cela peut
      s'av&eacute;rer plus ou moins g&ecirc;nant pour l'utilisateur final selon la
      fonction du site web.</p>

      <p>Comme solution &agrave; ce probl&egrave;me, <module>mod_auth_form</module>
      permet d'int&eacute;grer la m&eacute;thode et le contenu de la requ&ecirc;te originale
      dans le formulaire de connexion. Si l'authentification r&eacute;ussit,
      Apache httpd pourra refaire une tentative avec la m&eacute;thode et le contenu
      originaux, tout en conservant l'&eacute;tat de la requ&ecirc;te originale.</p>

      <p>Pour mettre en oeuvre la conservation du contenu, vous devez
      ajouter trois champs suppl&eacute;mentaires au formulaire de connexion
      comme dans l'exemple suivant :</p>

      <example><title>Exemple de formulaire avec conservation du
      contenu</title>
        &lt;form method="POST" action=""&gt;<br />
        <indent>
          Utilisateur  : &lt;input type="text" name="httpd_username" value="" /&gt;<br />
          Mot de passe : &lt;input type="password" name="httpd_password" value="" /&gt;<br />
          &lt;input type="submit" name="login" value="Connexion" /&gt;<br />
          <strong>&lt;input type="hidden" name="httpd_method" value="POST" /&gt;<br />
          &lt;input type="hidden" name="httpd_mimetype" value="application/x-www-form-urlencoded" /&gt;<br />
          &lt;input type="hidden" name="httpd_body" value="name1=value1&amp;name2=value2" /&gt;</strong><br />
        </indent>
        &lt;/form&gt;
      </example>

      <p>La mani&egrave;re dont la m&eacute;thode, le type MIME et le contenu de la
      requ&ecirc;te originale seront int&eacute;gr&eacute;s dans le formulaire de connexion
      vont d&eacute;pendre de la plate-forme et de la technologie utilis&eacute;es au
      sein du site web.
      </p>

      <p>Une option consiste &agrave; utiliser le module
      <module>mod_include</module> en association avec la directive
      <directive module="mod_request">KeptBodySize</directive>, ainsi
      qu'un script CGI adapt&eacute; pour int&eacute;grer les variables dans le
      formulaire.</p>

      <p>Une autre option consiste &agrave; pr&eacute;senter le formulaire de
      connexion en utilisant un script CGI ou une autre technologie
      dynamique.</p>

      <example><title>Exemple avec script CGI</title>
        <highlight language="config">
        AuthFormProvider file
        ErrorDocument 401 /cgi-bin/login.cgi
        ...
        </highlight>
      </example>

    </section>

    <section id="loggingout"><title>D&eacute;connexion</title>

      <p>Pour permettre &agrave; un utilisateur de se d&eacute;connecter d'une session
      particuli&egrave;re, vous devez configurer une page pour qu'elle soit
      trait&eacute;e par le gestionnaire <var>form-logout-handler</var>. Tout
      acc&egrave;s &agrave; cette URL va entra&icirc;ner la suppression de l'Utilisateur et
      du Mot de passe de la session courante, ce qui aura pour effet de
      d&eacute;connecter l'utilisateur.</p>

      <p>Vous pouvez sp&eacute;cifier une URL vers laquelle le navigateur sera
      redirig&eacute; en cas de d&eacute;connection r&eacute;ussie, en d&eacute;finissant la
      directive <directive
      module="mod_auth_form">AuthFormLogoutLocation</directive>. Cette
      URL devra expliquer &agrave; l'utilisateur qu'il a &eacute;t&eacute; d&eacute;connect&eacute;, et lui
      donner la possibilit&eacute; de se connecter &agrave; nouveau.</p>

      <example><title>Exemple simple de configuration de la
      d&eacute;connexion</title>
        <highlight language="config">
SetHandler form-logout-handler
AuthName realm
AuthFormLogoutLocation http://example.com/loggedout.html
Session On
SessionCookieName session path=/
SessionCryptoPassphrase secret
        </highlight>
      </example>

      <p>Notez que la d&eacute;connexion d'un utilisateur ne supprime pas la
      session ; elle supprime seulement l'Utilisateur et le mot de passe
      de la session. Si la session qui en r&eacute;sulte est vide, elle sera
      probablement supprim&eacute;e, mais ce n'est pas garanti. Si vous voulez
      &ecirc;tre s&ucirc;r que la session sera supprim&eacute;e, affectez une petite valeur
      &agrave; la directive <directive
      module="mod_session">SessionMaxAge</directive>, par exemple 1
      (affecter &agrave; cette directive la valeur z&eacute;ro signifie une session
      sans limite d'&acirc;ge).
      </p>

      <example><title>Exemple simple avec dur&eacute;e de validit&eacute; de session
      limit&eacute;e</title>
        <highlight language="config">
SetHandler form-logout-handler
AuthFormLogoutLocation http://example.com/loggedout.html
Session On
SessionMaxAge 1
SessionCookieName session path=/
SessionCryptoPassphrase secret
        </highlight>
      </example>

    </section>

    <section id="urlencoding"><title>Noms d'utilisateurs et mots de
    passe</title>
    <p>Notez que la soumission d'un formulaire implique l'encodage URL
    (URLEncoding) des donn&eacute;es du formulaire, ici le nom d'utilisateur et
    le mot de passe. Vous devez donc choisir des noms d'utilisateurs et
    mots de passe qui ne contiennent pas de caract&egrave;res susceptibles
    d'&ecirc;tre encod&eacute;s URL lors de la soumission du formulaire, sous peine
    d'obtenir des r&eacute;sultats inattendus.</p>
    </section>

<directivesynopsis>
<name>AuthFormProvider</name>
<description>D&eacute;finit le(s) fournisseur(s) d'authentification pour la
zone concern&eacute;e</description>
<syntax>AuthFormProvider <var>nom fournisseur</var>
[<var>nom fournisseur</var>] ...</syntax>
<default>AuthFormProvider file</default>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>

<usage>
    <p>La directive <directive>AuthFormProvider</directive> permet de
    d&eacute;finir quel fournisseur sera utilis&eacute; pour authentifier les
    utilisateurs pour la zone concern&eacute;e. Le fournisseur par d&eacute;faut
    <code>file</code> est impl&eacute;ment&eacute; par le module
    <module>mod_authn_file</module>. Assurez-vous que le fournisseur
    choisi soit bien pr&eacute;sent dans le serveur.</p>

    <example><title>Exemple</title>
      <highlight language="config">
&lt;Location /secure&gt;
    AuthType form
    AuthName "private area"
    AuthFormProvider  dbm
    AuthDBMType        SDBM
    AuthDBMUserFile    /www/etc/dbmpasswd
    Require            valid-user
    #...
&lt;/Location&gt;
      </highlight>
    </example>

    <p>Les diff&eacute;rents fournisseurs sont impl&eacute;ment&eacute;s par les modules
    <module>mod_authn_dbm</module>, <module>mod_authn_file</module>,
    <module>mod_authn_dbd</module> et
    <module>mod_authnz_ldap</module>.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthFormAuthoritative</name>
<description>D&eacute;termine si l'autorisation et l'authentification sont confi&eacute;s &agrave;
des modules de plus bas niveau</description>
<syntax>AuthFormAuthoritative On|Off</syntax>
<default>AuthFormAuthoritative On</default>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>

<usage>
    <p>Normalement, chacun des modules d'autorisation sp&eacute;cifi&eacute;s par la
    directive <directive
    module="mod_auth_form">AuthFormProvider</directive> va tenter de
    v&eacute;rifier l'identit&eacute; de l'utilisateur, et si ce dernier n'est trouv&eacute;
    dans aucun fournisseur, l'acc&egrave;s sera refus&eacute;. En d&eacute;finissant
    explicitement la directive
    <directive>AuthFormAuthoritative</directive> &agrave; <code>Off</code> on
    confie les processus d'authentification et d'autorisation &agrave; des
    modules ne s'appuyant pas sur des fournisseurs, si <strong>aucun
    identifiant utilisateur</strong> ou aucune <strong>r&egrave;gle</strong> ne
    correspond &agrave; l'identifiant utilisateur fourni. Ceci ne peut s'av&eacute;rer
    n&eacute;cessaire que si l'on combine <module>mod_auth_form</module> avec
    des modules tiers qui ne se configurent pas avec la directive
    <directive module="mod_auth_form">AuthFormProvider</directive>.
    Lorsqu'on utilise de tels modules, la chronologie du processus est
    d&eacute;termin&eacute;e dans leur code source, et n'est pas configurable.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthFormUsername</name>
<description>Le nom du champ de formulaire qui contient le nom de
connexion</description>
<syntax>AuthFormUsername <var>nom du champ</var></syntax>
<default>httpd_username</default>
<contextlist><context>directory</context>
</contextlist>
<compatibility>Disponible depuis la version 2.3.3 du serveur HTTP Apache</compatibility>

<usage>
    <p>La directive <directive
    module="mod_auth_form">AuthFormUsername</directive> permet de
    sp&eacute;cifier le nom du champ HTML qui, s'il existe, contiendra le nom
    d'utilisateur qui sera utilis&eacute; pour la connexion.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthFormPassword</name>
<description>Le nom du champ de formulaire qui contient le mot de passe
de connexion</description>
<syntax>AuthFormPassword <var>nom du champ</var></syntax>
<default>httpd_password</default>
<contextlist><context>directory</context>
</contextlist>
<compatibility>Disponible depuis la version 2.3.0 du serveur HTTP Apache</compatibility>

<usage>
    <p>La directive <directive
    module="mod_auth_form">AuthFormPassword</directive> permet de
    sp&eacute;cifier le nom du champ HTML qui, s'il existe, contiendra le mot
    de passe qui sera utilis&eacute; pour la connexion.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthFormLocation</name>
<description>Le nom du champ de formulaire qui contiendra l'URL vers
laquelle l'utilisateur sera redirig&eacute; en cas de connexion
r&eacute;ussie</description>
<syntax>AuthFormLocation <var>nom du champ</var></syntax>
<default>httpd_location</default>
<contextlist><context>directory</context>
</contextlist>
<compatibility>Disponible depuis la version 2.3.0 du serveur HTTP Apache</compatibility>

<usage>
    <p>La directive <directive
    module="mod_auth_form">AuthFormLocation</directive> permet de
    sp&eacute;cifier le nom du champ HTML qui, s'il existe, contiendra l'URL
    vers laquelle rediriger le navigateur en cas de connexion
    r&eacute;ussie.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthFormMethod</name>
<description>Le nom du champ de formulaire contenant la m&eacute;thode de la
requ&ecirc;te &agrave; effectuer en cas de connexion r&eacute;ussie</description>
<syntax>AuthFormMethod <var>nom du champ</var></syntax>
<default>httpd_method</default>
<contextlist><context>directory</context>
</contextlist>
<compatibility>Disponible depuis la version 2.3.0 du serveur HTTP Apache</compatibility>

<usage>
    <p>La directive <directive
    module="mod_auth_form">AuthFormMethod</directive> permet de
    sp&eacute;cifier le nom du champ HTML qui, s'il existe, contiendra le type
    MIME de la requ&ecirc;te &agrave; effectuer en cas de connexion r&eacute;ussie.</p>

    <p>En ajoutant au formulaire les champs d&eacute;crits dans <directive
    module="mod_auth_form">AuthFormMethod</directive>, <directive
    module="mod_auth_form">AuthFormMimetype</directive> et <directive
    module="mod_auth_form">AuthFormBody</directive>, un site web sera en
    mesure de relancer une requ&ecirc;te qui a &eacute;t&eacute; &eacute;ventuellement interrompue
    par l'&eacute;cran de connexion, ou par l'expiration d'un d&eacute;lai de
    session.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthFormMimetype</name>
<description>Le nom du champ de formulaire contenant le type MIME du
corps de la requ&ecirc;te &agrave; effectuer en cas de connexion
r&eacute;ussie</description>
<syntax>AuthFormMimetype <var>nom du champ</var></syntax>
<default>httpd_mimetype</default>
<contextlist><context>directory</context>
</contextlist>
<compatibility>Disponible depuis la version 2.3.0 du serveur HTTP Apache</compatibility>

<usage>
    <p>La directive <directive
    module="mod_auth_form">AuthFormMimetype</directive> permet de
    sp&eacute;cifier le nom du champ HTML qui, s'il existe, contiendra le type
    MIME de la requ&ecirc;te &agrave; effectuer en cas de connexion r&eacute;ussie.</p>

    <p>En ajoutant au formulaire les champs d&eacute;crits dans <directive
    module="mod_auth_form">AuthFormMethod</directive>, <directive
    module="mod_auth_form">AuthFormMimetype</directive> et <directive
    module="mod_auth_form">AuthFormBody</directive>, un site web sera en
    mesure de relancer une requ&ecirc;te qui a &eacute;t&eacute; &eacute;ventuellement interrompue
    par l'&eacute;cran de connexion, ou par l'expiration d'un d&eacute;lai de
    session.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthFormBody</name>
<description>Le nom du champ de formulaire contenant le corps de la
requ&ecirc;te &agrave; effectuer en cas de connexion r&eacute;ussie</description>
<syntax>AuthFormBody <var>nom du champ</var></syntax>
<default>httpd_body</default>
<contextlist><context>directory</context>
</contextlist>
<compatibility>Disponible depuis la version 2.3.0 du serveur HTTP Apache</compatibility>

<usage>
    <p>La directive <directive
    module="mod_auth_form">AuthFormBody</directive> permet de
    sp&eacute;cifier le nom du champ HTML qui, s'il existe, contiendra le corps
    de la requ&ecirc;te &agrave; effectuer en cas de connexion r&eacute;ussie.</p>

    <p>En ajoutant au formulaire les champs d&eacute;crits dans <directive
    module="mod_auth_form">AuthFormMethod</directive>, <directive
    module="mod_auth_form">AuthFormMimetype</directive> et <directive
    module="mod_auth_form">AuthFormBody</directive>, un site web sera en
    mesure de relancer une requ&ecirc;te qui a &eacute;t&eacute; &eacute;ventuellement interrompue
    par l'&eacute;cran de connexion, ou par l'expiration d'un d&eacute;lai de
    session.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthFormSize</name>
<description>La taille maximale en octets du formulaire dont seront
extraites les informations de connexion</description>
<syntax>AuthFormSize <var>taille</var></syntax>
<default>8192</default>
<contextlist><context>directory</context>
</contextlist>
<compatibility>Disponible depuis la version 2.3.0 du serveur HTTP Apache</compatibility>

<usage>
    <p>La directive <directive
    module="mod_auth_form">AuthFormSize</directive> permet de sp&eacute;cifier
    la taille maximale du corps de la requ&ecirc;te qui sera utilis&eacute;e pour
    trouver le formulaire de connexion.</p>

    <p>Si une requ&ecirc;te de connexion entrante poss&egrave;de une taille
    sup&eacute;rieure &agrave; cette valeur, elle sera rejet&eacute;e avec le code de r&eacute;ponse
    HTTP <code>HTTP_REQUEST_TOO_LARGE</code>.</p>

    <p>Si vous avez ajout&eacute; au formulaire des champs d&eacute;crits dans <directive
    module="mod_auth_form">AuthFormMethod</directive>, <directive
    module="mod_auth_form">AuthFormMimetype</directive> et <directive
    module="mod_auth_form">AuthFormBody</directive>, il est recommand&eacute;
    de d&eacute;finir cette directive &agrave; une valeur similaire &agrave; celle de la
    directive <directive module="mod_request">KeptBodySize</directive>.</p>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthFormLoginRequiredLocation</name>
<description>L'URL de la page vers laquelle on doit &ecirc;tre redirig&eacute; si une
authentification est requise</description>
<syntax>AuthFormLoginRequiredLocation <var>url</var></syntax>
<default>none</default>
<contextlist><context>directory</context>
</contextlist>
<compatibility>Disponible depuis la version 2.3.0 du serveur HTTP
Apache. L'interpr&eacute;teur d'expressions a &eacute;t&eacute; ajout&eacute; &agrave; partir de la version
2.4.4.</compatibility>

<usage>
    <p>La directive <directive
    module="mod_auth_form">AuthFormLoginRequiredLocation</directive>
    permet de sp&eacute;cifier l'URL vers laquelle l'utilisateur devra &ecirc;tre
    redirig&eacute; s'il n'est pas autoris&eacute; &agrave;
    acc&eacute;der &agrave; une page. L'argument pass&eacute; &agrave; cette directive
    est lu au moyen de l'analyseur lexical <a href="../expr.html">ap_expr</a> avant d'&ecirc;tre
    envoy&eacute; au client. Par d&eacute;faut,
    si un utilisateur n'est pas autoris&eacute; &agrave; acc&eacute;der &agrave; une page, le code
    de r&eacute;ponse HTTP <code>HTTP_UNAUTHORIZED</code> est renvoy&eacute; avec la
    page sp&eacute;cifi&eacute;e par la directive <directive
    module="core">ErrorDocument</directive>. La directive <directive
    module="mod_auth_form">AuthFormLoginRequiredLocation</directive>
    permet de remplacer cette valeur par d&eacute;faut.</p>

    <p>Vous pouvez utiliser cette directive si vous voulez pr&eacute;senter une
    page de connexion personnalis&eacute;e &agrave; vos utilisateurs.</p>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthFormLoginSuccessLocation</name>
<description>L'URL de la page vers laquelle on doit &ecirc;tre redirig&eacute; en cas
de connexion r&eacute;ussie</description>
<syntax>AuthFormLoginSuccessLocation <var>url</var></syntax>
<default>none</default>
<contextlist><context>directory</context>
</contextlist>
<compatibility>Disponible depuis la version 2.3.0 du serveur HTTP
Apache. L'interpr&eacute;teur d'expressions a &eacute;t&eacute; ajout&eacute; &agrave; partir de la version
2.4.4.</compatibility>

<usage>
    <p>La directive <directive
    module="mod_auth_form">AuthFormLoginSuccessLocation</directive>
    permet de sp&eacute;cifier l'URL vers laquelle l'utilisateur doit &ecirc;tre
    redirig&eacute; en cas de connexion r&eacute;ussie. L'argument pass&eacute; &agrave; cette directive
    est lu au moyen de l'analyseur lexical <a href="../expr.html">ap_expr</a> avant d'&ecirc;tre
    envoy&eacute; au client.  L'effet de cette directive
    peut &ecirc;tre annul&eacute; si l'on a d&eacute;fini un champ de formulaire contenant
    une autre URL &agrave; l'aide de la directive <directive
    module="mod_auth_form">AuthFormLocation</directive>.</p>

    <p>Vous pouvez utiliser cette directive si vous poss&eacute;dez une URL de
    connexion personnalis&eacute;e, et si vous n'avez pas int&eacute;gr&eacute; la page de
    destination dans le formulaire de connexion.</p>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthFormFakeBasicAuth</name>
<description>Simule un en-t&ecirc;te d'authentification de base</description>
<syntax>AuthFormFakeBasicAuth <var>On|Off</var></syntax>
<default>AuthFormFakeBasicAuth Off</default>
<contextlist><context>directory</context>
</contextlist>
<compatibility>Disponible depuis la version 2.3.0 du serveur HTTP Apache</compatibility>

<usage>
    <p>Le drapeau <directive
    module="mod_auth_form">AuthFormFakeBasicAuth</directive> permet de
    d&eacute;terminer si un en-t&ecirc;te d'<code>Authentification de base</code>
    sera ajout&eacute; aux en-t&ecirc;tes de la requ&ecirc;te. On peut utiliser cette
    m&eacute;thode pour pr&eacute;senter le nom d'utilisateur et le mot de passe &agrave;
    l'application sous-jacente, sans que cette derni&egrave;re ait besoin de
    conna&icirc;tre la mani&egrave;re dont le processus de connexion a &eacute;t&eacute; men&eacute; &agrave;
    bien.</p>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthFormLogoutLocation</name>
<description>L'URL vers laquelle un utilisateur devra &ecirc;tre redirig&eacute;
apr&egrave;s s'&ecirc;tre d&eacute;connect&eacute;</description>
<syntax>AuthFormLogoutLocation <var>uri</var></syntax>
<default>none</default>
<contextlist><context>directory</context>
</contextlist>
<compatibility>Disponible depuis la version 2.3.0 du serveur HTTP
Apache. L'interpr&eacute;teur d'expressions a &eacute;t&eacute; ajout&eacute; &agrave; partir de la version
2.4.4.</compatibility>

<usage>
    <p>La directive <directive
    module="mod_auth_form">AuthFormLogoutLocation</directive> permet de
    sp&eacute;cifier l'URL de la page du serveur vers laquelle l'utilisateur
    devra &ecirc;tre redirig&eacute; s'il se d&eacute;connecte.
    L'argument pass&eacute; &agrave; cette directive
    est lu au moyen de l'analyseur lexical <a href="../expr.html">ap_expr</a> avant d'&ecirc;tre
    envoy&eacute; au client.</p>

    <p>Lorsqu'un acc&egrave;s est tent&eacute; sur un URI trait&eacute; par le gestionnaire
    <code>form-logout-handler</code>, la page sp&eacute;cifi&eacute;e par cette
    directive sera pr&eacute;sent&eacute;e &agrave; l'utilisateur final. Par exemple :</p>

    <example><title>Exemple</title>
      <highlight language="config">
&lt;Location /logout&gt;
    SetHandler form-logout-handler
    AuthFormLogoutLocation http://example.com/loggedout.html
    Session on
    #...
&lt;/Location&gt;
      </highlight>
    </example>

    <p>Si un utilisateur tente d'acc&eacute;der &agrave; l'URI <var>/logout/</var>, il
    sera d&eacute;connect&eacute;, et la page <var>/loggedout.html</var> lui sera
    pr&eacute;sent&eacute;e. Assurez-vous que la page <var>loggedout.html</var> n'est
    pas prot&eacute;g&eacute;e par mot de passe, car dans le cas contraire, elle ne
    serait pas affich&eacute;e.</p>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthFormDisableNoStore</name>
<description>D&eacute;sactive l'en-t&ecirc;te CacheControl no-store sur la page de
connexion</description>
<syntax>AuthFormDisableNoStore <var>On|Off</var></syntax>
<default>AuthFormDisableNoStore Off</default>
<contextlist><context>directory</context>
</contextlist>
<compatibility>Disponible depuis la version 2.3.0 du serveur HTTP Apache</compatibility>

<usage>
    <p>Le drapeau <directive
    module="mod_auth_form">AuthFormDisableNoStore</directive> supprime
    l'envoi d'un en-t&ecirc;te <code>Cache-Control no-store</code> lorsqu'une
    page avec code d'erreur 401 est renvoy&eacute;e si l'utilisateur n'est pas
    encore connect&eacute;. Avec cet en-t&ecirc;te, il est plus difficile pour une
    application <code>ecmascript</code> de resoumettre un formulaire de connexion, et
    ainsi r&eacute;v&eacute;ler le nom d'utilisateur et le mot de passe &agrave;
    l'application sous-jacente. Vous devez &ecirc;tre conscient des risques
    encourus si vous le d&eacute;sactivez.</p>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthFormSitePassphrase</name>
<description>Court-circuite l'authentification pour les sites &agrave; fort
trafic</description>
<syntax>AuthFormSitePassphrase <var>secret</var></syntax>
<default>none</default>
<contextlist><context>directory</context>
</contextlist>
<compatibility>Disponible depuis la version 2.3.0 du serveur HTTP Apache</compatibility>

<usage>
    <p>La directive <directive
    module="mod_auth_form">AuthFormSitePassphrase</directive> permet de
    sp&eacute;cifier un mot de passe qui, s'il est pr&eacute;sent dans la session
    utilisateur, indique &agrave; Apache httpd de court-circuiter l'authentification
    pour l'URL consid&eacute;r&eacute;e. On peut l'utiliser dans le cas de sites web &agrave;
    fort trafic afin de r&eacute;duire la charge induite sur l'infrastructure
    d'authentification.</p>

    <p>On peut ins&eacute;rer le mot de passe dans une session utilisateur en
    ajoutant cette directive &agrave; la configuration concernant le
    gestionnaire <var>form-login-handler</var>. Le gestionnaire
    <var>form-login-handler</var>, quant &agrave; lui, effectuera toujours les
    v&eacute;rifications d'authentification, qu'un mot de passe soit sp&eacute;cifi&eacute;
    ou non.</p>

    <note type="warning"><title>Avertissement</title>
      <p>Si la session est pr&eacute;sent&eacute;e &agrave; l'utilisateur &agrave; l'aide du module
      <module>mod_session_cookie</module>, et si la session n'est pas
      prot&eacute;g&eacute;e par le module <module>mod_session_crypto</module>, le mot
      de passe peut faire l'objet d'une attaque de type dictionnaire.
      Quelle que soit la configuration de la session, assurez-vous que
      cette directive n'est pas utilis&eacute;e dans un espace d'URLs contenant
      des donn&eacute;es priv&eacute;es, ou &agrave; partir desquelles des transactions
      sensibles pourraient &ecirc;tre men&eacute;es. En tout &eacute;tat de cause, vous
      devez &ecirc;tre conscient des risques encourus avant de l'utiliser.</p>
    </note>

</usage>
</directivesynopsis>

</modulesynopsis>
