<?xml version="1.0"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1450091 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="core.xml.meta">

<name>core</name>
<description>Fonctionnalit&eacute;s de base du serveur HTTP Apache toujours
disponibles</description>
<status>Core</status>

<directivesynopsis>
<name>AcceptFilter</name>
<description>Permet d'optimiser la configuration d'une socket pour
l'&eacute;coute d'un protocole</description>
<syntax>AcceptFilter <var>protocole</var> <var>filtre
d'acceptation</var></syntax>
<contextlist><context>server config</context></contextlist>
<compatibility>Disponible depuis la version 2.3.3 sous Windows et 2.1.5
sur les autres plates-formes.</compatibility>

<usage>
    <p>Cette directive permet d'effectuer une optimisation de la socket
    d'&eacute;coute d'un type de protocole en fonction du syst&egrave;me
    d'exploitation. Le but premier est de faire en sorte que le noyau
    n'envoie pas de socket au processus du serveur jusqu'&agrave; ce que
    des donn&eacute;es soient re&ccedil;ues, ou qu'une requ&ecirc;te HTTP compl&egrave;te soit mise
    en tampon. Seuls les <a
    href="http://www.freebsd.org/cgi/man.cgi?query=accept_filter&amp;
    sektion=9">Filtres d'acceptation de FreeBSD</a>, le filtre plus
    primitif <code>TCP_DEFER_ACCEPT</code> sous Linux, et la version
    optimis&eacute;e d'AcceptEx() de Windows sont actuellement support&eacute;s.</p>

    <p>L'utilisation de l'argument <code>none</code> va d&eacute;sactiver tout
    filtre d'acceptation pour ce protocole. Ceci s'av&egrave;re utile pour les
    protocoles qui n&eacute;cessitent l'envoi de donn&eacute;es par le serveur en
    premier, comme <code>ftp:</code> ou <code>nntp</code>:</p>
    <highlight language="config">
    AcceptFilter nntp none
    </highlight>

    <p>Les noms de protocoles par d&eacute;faut sont <code>https</code> pour le
    port 443 et <code>http</code> pour tous les autres ports. Pour
    sp&eacute;cifier un autre protocole &agrave; utiliser avec un port en &eacute;coute,
    ajoutez l'argument <var>protocol</var> &agrave; la directive <directive
    module="mpm_common">Listen</directive>.</p>

    <p>Sous FreeBSD, les valeurs par d&eacute;faut sont :</p>
    <highlight language="config">
AcceptFilter http httpready
AcceptFilter https dataready
    </highlight>

    <p>Le filtre d'acceptation <code>httpready</code> met en tampon des
    requ&ecirc;tes HTTP enti&egrave;res au niveau du noyau. Quand une requ&ecirc;te
    enti&egrave;re a &eacute;t&eacute; re&ccedil;ue, le noyau l'envoie au serveur. Voir la page de
    manuel de <a
    href="http://www.freebsd.org/cgi/man.cgi?query=accf_http&amp;
    sektion=9">accf_http(9)</a> pour plus de d&eacute;tails. Comme les requ&ecirc;tes
    HTTPS sont chiffr&eacute;es, celles-ci n'autorisent que le filtre <a
    href="http://www.freebsd.org/cgi/man.cgi?query=accf_data&amp;
    sektion=9">accf_data(9)</a>.</p>

    <p>Sous Linux, les valeurs par d&eacute;faut sont :</p>
    <highlight language="config">
AcceptFilter http data
AcceptFilter https data
    </highlight>

    <p>Le filtre <code>TCP_DEFER_ACCEPT</code> de Linux ne supporte pas
    la mise en tampon des requ&ecirc;tes http. Toute valeur autre que
    <code>none</code> active le filtre <code>TCP_DEFER_ACCEPT</code>
    pour ce protocole. Pour plus de d&eacute;tails, voir la page de
    manuel Linux de <a
    href="http://homepages.cwi.nl/~aeb/linux/man2html/man7/
    tcp.7.html">tcp(7)</a>.</p>

    <p>Sous Windows, les valeurs par d&eacute;faut sont :</p>
    <highlight language="config">
AcceptFilter http data
AcceptFilter https data
    </highlight>

    <p>Le module MPM pour Windows mpm_winnt utilise la directive
    AcceptFilter comme commutateur de l'API AcceptEx(), et ne supporte
    pas la mise en tampon du protocole http. Deux valeurs utilisent
    l'API Windows AcceptEx() et vont recycler les sockets r&eacute;seau entre
    les connexions. <code>data</code> attend jusqu'&agrave; ce que les donn&eacute;es
    aient &eacute;t&eacute; transmises comme d&eacute;crit plus haut, et le tampon de donn&eacute;es
    initiales ainsi que les adresses r&eacute;seau finales sont tous extraits
    gr&acirc;ce &agrave; une seule invocation d'AcceptEx(). <code>connect</code>
    utilise l'API AcceptEx(), extrait aussi les adresses r&eacute;seau finales,
    mais &agrave; l'instar de <code>none</code>, la valeur <code>connect</code>
    n'attend pas la transmission des donn&eacute;es initiales.</p>

    <p>Sous Windows, <code>none</code> utilise accept() au lieu
    d'AcceptEx(), et ne recycle pas les sockets entre les connexions.
    Ceci s'av&egrave;re utile pour les interfaces r&eacute;seau dont le pilote est
    d&eacute;fectueux, ainsi que pour certains fournisseurs de r&eacute;seau comme les
    pilotes vpn, ou les filtres anti-spam, anti-virus ou
    anti-spyware.</p>

</usage>
<seealso><directive module="core">Protocol</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>AcceptPathInfo</name>
<description>Les ressources acceptent des informations sous forme d'un
nom de chemin en fin de requ&ecirc;te.</description>
<syntax>AcceptPathInfo On|Off|Default</syntax>
<default>AcceptPathInfo Default</default>
<contextlist><context>server config</context>
<context>virtual host</context><context>directory</context>
<context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>

    <p>Cette directive permet de d&eacute;finir si les requ&ecirc;tes contenant des
    informations sous forme d'un nom de chemin suivant le nom d'un
    fichier r&eacute;el (ou un fichier qui n'existe pas dans un r&eacute;pertoire qui
    existe) doivent &ecirc;tre accept&eacute;es ou rejet&eacute;es. Les scripts peuvent
    acc&eacute;der &agrave; cette information via la variable d'environnement
    <code>PATH_INFO</code>.</p>

    <p>Supposons par exemple que <code>/test/</code> pointe vers un
    r&eacute;pertoire qui ne contient que le fichier <code>here.html</code>.
    Les requ&ecirc;tes pour <code>/test/here.html/more</code> et
    <code>/test/nothere.html/more</code> vont affecter la valeur
    <code>/more</code> &agrave; la variable d'environnement
    <code>PATH_INFO</code>.</p>

    <p>L'argument de la directive <directive>AcceptPathInfo</directive>
    poss&egrave;de trois valeurs possibles :</p>
    <dl>
    <dt><code>Off</code></dt><dd>Une requ&ecirc;te ne sera accept&eacute;e que si
    elle correspond &agrave; un chemin qui existe. Par cons&eacute;quent, une requ&ecirc;te
    contenant une information de chemin apr&egrave;s le nom de fichier r&eacute;el
    comme <code>/test/here.html/more</code> dans l'exemple ci-dessus
    renverra une erreur "404 NOT FOUND".</dd>

    <dt><code>On</code></dt><dd>Une requ&ecirc;te sera accept&eacute;e si la partie
    principale du chemin correspond &agrave; un fichier existant. Dans
    l'exemple ci-dessus <code>/test/here.html/more</code>, la requ&ecirc;te
    sera accept&eacute;e si <code>/test/here.html</code> correspond &agrave; un nom de
    fichier valide.</dd>

    <dt><code>Default</code></dt><dd>Le traitement des requ&ecirc;tes est
    d&eacute;termin&eacute; par le <a
    href="../handler.html">gestionnaire</a> responsable de la requ&ecirc;te.
    Le gestionnaire de base pour les fichiers normaux rejette par d&eacute;faut
    les requ&ecirc;tes avec <code>PATH_INFO</code>. Les gestionnaires qui
    servent des scripts, comme<a
    href="mod_cgi.html">cgi-script</a> et <a
    href="mod_isapi.html">isapi-handler</a>, acceptent en g&eacute;n&eacute;ral par
    d&eacute;faut les requ&ecirc;tes avec <code>PATH_INFO</code>.</dd>
    </dl>

    <p>Le but premier de la directive <code>AcceptPathInfo</code> est de
    vous permettre de remplacer le choix du gestionnaire d'accepter ou
    de rejeter <code>PATH_INFO</code>. Ce remplacement est n&eacute;cessaire
    par exemple, lorsque vous utilisez un <a
    href="../filter.html">filtre</a>, comme <a
    href="mod_include.html">INCLUDES</a>, pour g&eacute;n&eacute;rer un contenu bas&eacute;
    sur <code>PATH_INFO</code>. Le gestionnaire de base va en g&eacute;n&eacute;ral
    rejeter la requ&ecirc;te, et vous pouvez utiliser la configuration
    suivante pour utiliser un tel script :</p>
<highlight language="config">
&lt;Files "mypaths.shtml"&gt;
  Options +Includes
  SetOutputFilter INCLUDES
  AcceptPathInfo On
&lt;/Files&gt;
    </highlight>
    

</usage>
</directivesynopsis>

<directivesynopsis>
<name>AccessFileName</name>
<description>Nom du fichier de configuration distribu&eacute;</description>
<syntax>AccessFileName <var>nom-du-fichier</var>
[<var>nom-du-fichier</var>] ...</syntax>
<default>AccessFileName .htaccess</default>
<contextlist><context>server config</context><context>virtual
host</context>
</contextlist>

<usage>
    <p>Au cours du traitement d'une requ&ecirc;te, le serveur recherche le
    premier fichier de configuration existant &agrave; partir de la liste
    de noms dans chaque r&eacute;pertoire composant le chemin du document, &agrave;
    partir du moment o&ugrave; les fichiers de configuration distribu&eacute;s sont <a
    href="#allowoverride">activ&eacute;s pour ce r&eacute;pertoire</a>. Par exemple
    :</p>

    <highlight language="config">AccessFileName .acl</highlight>

    <p>avant de renvoyer le document
    <code>/usr/local/web/index.html</code>, le serveur va rechercher les
    fichiers <code>/.acl</code>, <code>/usr/.acl</code>,
    <code>/usr/local/.acl</code> et <code>/usr/local/web/.acl</code>
    pour y lire d'&eacute;ventuelles directives, &agrave; moins quelles n'aient &eacute;t&eacute;
    d&eacute;sactiv&eacute;es avec</p>

    <highlight language="config">
&lt;Directory /&gt;
    AllowOverride None
&lt;/Directory&gt;
    </highlight>
</usage>
<seealso><directive module="core">AllowOverride</directive></seealso>
<seealso><a href="../configuring.html">Fichiers de configuration</a></seealso>
<seealso><a href="../howto/htaccess.html">Fichiers .htaccess</a></seealso>
</directivesynopsis>

<directivesynopsis>
<name>AddDefaultCharset</name>
<description>Param&egrave;tre jeu de caract&egrave;res par d&eacute;faut &agrave; ajouter quand le
type de contenu d'une r&eacute;ponse est <code>text/plain</code> ou
<code>text/html</code></description>
<syntax>AddDefaultCharset On|Off|<var>jeu de caract&egrave;res</var></syntax>
<default>AddDefaultCharset Off</default>
<contextlist><context>server config</context>
<context>virtual host</context><context>directory</context>
<context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>Cette directive sp&eacute;cifie une valeur par d&eacute;faut pour le param&egrave;tre
    jeu de caract&egrave;res du type de m&eacute;dia (le nom d'un codage de
    caract&egrave;res) &agrave; ajouter &agrave; une r&eacute;ponse, si et seulement si le type de
    contenu de la r&eacute;ponse est soit <code>text/plain</code>, soit
    <code>text/html</code>. Ceci va remplacer
    tout jeu de caract&egrave;res sp&eacute;cifi&eacute; dans le corps de la r&eacute;ponse via un
    &eacute;l&eacute;ment <code>META</code>, bien que cet effet d&eacute;pende en fait
    souvent de la configuration du client de l'utilisateur. La
    d&eacute;finition de <code>AddDefaultCharset Off</code> d&eacute;sactive cette
    fonctionnalit&eacute;. <code>AddDefaultCharset On</code> ajoute un jeu de
    caract&egrave;res par d&eacute;faut de <code>iso-8859-1</code>. Toute autre valeur
    peut &ecirc;tre d&eacute;finie via le param&egrave;tre <var>jeu de caract&egrave;res</var>, qui
    doit appartenir &agrave; la liste des <a
    href="http://www.iana.org/assignments/character-sets">valeurs de
    jeux de caract&egrave;res enregistr&eacute;s par l'IANA</a> &agrave; utiliser dans les
    types de m&eacute;dia Internet (types MIME).
    Par exemple :</p>

    <highlight language="config">AddDefaultCharset utf-8</highlight>

    <p>La directive <directive>AddDefaultCharset</directive> ne doit
    &ecirc;tre utilis&eacute;e que lorsque toutes les ressources textes auxquelles
    elle s'applique poss&egrave;dent le jeu de caract&egrave;re sp&eacute;cifi&eacute;, et qu'il est
    trop contraignant de d&eacute;finir leur jeu de caract&egrave;res
    individuellement. Un exemple de ce type est l'ajout du param&egrave;tre jeu
    de caract&egrave;res aux ressources comportant un contenu g&eacute;n&eacute;r&eacute;, comme les
    scripts CGI h&eacute;rit&eacute;s qui peuvent &ecirc;tre vuln&eacute;rables &agrave; des attaques de
    type cross-site scripting &agrave; cause des donn&eacute;es utilisateurs incluses
    dans leur sortie. Notez cependant qu'une meilleur solution consiste
    &agrave; corriger (ou supprimer) ces scripts, car la d&eacute;finition d'un jeu de
    caract&egrave;res par d&eacute;faut ne prot&egrave;ge pas les utilisateurs qui ont activ&eacute;
    la fonctionnalit&eacute; "D&eacute;tection automatique de l'encodage des
    caract&egrave;res" dans leur navigateur.</p>
</usage>
<seealso><directive module="mod_mime">AddCharset</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>AllowEncodedSlashes</name>
<description>D&eacute;termine si les s&eacute;parateurs de chemin encod&eacute;s sont
autoris&eacute;s &agrave; transiter dans les URLs tels quels</description>
<syntax>AllowEncodedSlashes On|Off|NoDecode</syntax>
<default>AllowEncodedSlashes Off</default>
<contextlist><context>server config</context><context>virtual
host</context>
</contextlist>
<compatibility>L'option NoDecode est disponible depuis la version
2.3.12.</compatibility>

<usage>
    <p>La directive <directive>AllowEncodedSlashes</directive> permet
    l'utilisation des URLs contenant des s&eacute;parateurs de chemin
    encod&eacute;s dans la partie chemin
    (<code>%2F</code> pour <code>/</code> et m&ecirc;me <code>%5C</code> pour
    <code>\</code> sur les syst&egrave;mes concern&eacute;s).</p>

    <p>Avec la valeur par d&eacute;faut, <code>Off</code>, de telles URLs sont
    refus&eacute;es et provoquent le renvoi d'une erreur 404 (Not found).</p>

    <p>Avec la valeur <code>On</code>, ces URLs sont accept&eacute;es, et les
    slashes encod&eacute;s sont d&eacute;cod&eacute;s comme tout autre caract&egrave;re cod&eacute;.</p>

    <p>Avec la valeur <code>NoDecode</code>, ces URLs sont accept&eacute;es,
    mais les slashes cod&eacute;s ne sont pas d&eacute;cod&eacute;s et laiss&eacute;s dans leur &eacute;tat
    cod&eacute;.</p>

    <p>D&eacute;finir <directive>AllowEncodedSlashes</directive> &agrave;
    <code>On</code> est surtout utile en association avec
    <code>PATH_INFO</code>.</p>

    <note><title>Note</title>
      <p>Si le codage des slashes dans la partie chemin est n&eacute;cessaire,
      l'utilisation de l'option <code>NoDecode</code> est fortement
      recommand&eacute;e par mesure de s&eacute;curit&eacute;. Permettre le d&eacute;codage des
      slashes pourrait &eacute;ventuellement induire l'autorisation de chemins
      non s&ucirc;rs.</p>
    </note>
</usage>
<seealso><directive module="core">AcceptPathInfo</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>AllowOverride</name>
<description>Types de directives autoris&eacute;es dans les fichiers
<code>.htaccess</code></description>
<syntax>AllowOverride All|None|<var>type directive</var>
[<var>type directive</var>] ...</syntax>
<default>AllowOverride None &agrave; partir de la version 2.3.9, AllowOverride
All pour les versions ant&eacute;rieures</default>
<contextlist><context>directory</context></contextlist>

<usage>
    <p>Lorsque le serveur trouve un fichier <code>.htaccess</code> (dont
    le nom est d&eacute;fini par la directive <directive
    module="core">AccessFileName</directive>), il doit savoir lesquelles
    des directives plac&eacute;es dans ce fichier sont autoris&eacute;es &agrave; modifier la
    configuration pr&eacute;existante.</p>

    <note><title>Valable seulement dans les sections
    &lt;Directory&gt;</title>
    La directive <directive>AllowOverride</directive> ne peut &ecirc;tre
    utilis&eacute;e que dans les sections <directive type="section"
    module="core">Directory</directive> d&eacute;finies sans expressions
    rationnelles, et non dans les sections <directive
    type="section" module="core">Location</directive>, <directive
    module="core" type="section">DirectoryMatch</directive> ou
    <directive type="section" module="core">Files</directive>.
    </note>

    <p>Lorsque cette directive et la directive <directive
    module="core">AllowOverrideList</directive> sont d&eacute;finies &agrave; <code>None</code>, les
    fichiers <a href="#accessfilename">.htaccess</a> sont totalement
    ignor&eacute;s. Dans ce cas, le serveur n'essaiera m&ecirc;me pas de lire les
    fichiers <code>.htaccess</code> du syst&egrave;me de fichiers.</p>

    <p>Lorsque cette directive est d&eacute;finie &agrave; <code>All</code>, toute
    directive valable dans le <a
    href="directive-dict.html#Context">Contexte</a> .htaccess sera
    autoris&eacute;e dans les fichiers <code>.htaccess</code>.</p>

    <p>L'argument <var>type directive</var> peut contenir les
    groupements de directives suivants :</p>

    <dl>
      <dt>AuthConfig</dt>

      <dd>

      Permet l'utilisation des directives d'autorisation (<directive
      module="mod_authz_dbm">AuthDBMGroupFile</directive>,
      <directive module="mod_authn_dbm">AuthDBMUserFile</directive>,
      <directive module="mod_authz_groupfile">AuthGroupFile</directive>,
      <directive module="mod_authn_core">AuthName</directive>,
      <directive module="mod_authn_core">AuthType</directive>, <directive
      module="mod_authn_file">AuthUserFile</directive>, <directive
      module="mod_authz_core">Require</directive>, <em>etc...</em>).</dd>

      <dt>FileInfo</dt>

      <dd>
      Permet l'utilisation des directives qui contr&ocirc;lent les types de
      documents (directives  <directive
      module="core">ErrorDocument</directive>, <directive
      module="core">ForceType</directive>, <directive
      module="mod_negotiation">LanguagePriority</directive>,
      <directive module="core">SetHandler</directive>, <directive
      module="core">SetInputFilter</directive>, <directive
      module="core">SetOutputFilter</directive>, et directives du
      module <module>mod_mime</module> Add* et Remove*), des metadonn&eacute;es
      des documents (<directive
      module="mod_headers">Header</directive>, <directive
      module="mod_headers">RequestHeader</directive>, <directive
      module="mod_setenvif">SetEnvIf</directive>, <directive
      module="mod_setenvif">SetEnvIfNoCase</directive>, <directive
      module="mod_setenvif">BrowserMatch</directive>, <directive
      module="mod_usertrack">CookieExpires</directive>, <directive
      module="mod_usertrack">CookieDomain</directive>, <directive
      module="mod_usertrack">CookieStyle</directive>, <directive
      module="mod_usertrack">CookieTracking</directive>, <directive
      module="mod_usertrack">CookieName</directive>), des directives du
      module <module>mod_rewrite</module> directives (<directive
      module="mod_rewrite">RewriteEngine</directive>, <directive
      module="mod_rewrite">RewriteOptions</directive>, <directive
      module="mod_rewrite">RewriteBase</directive>, <directive
      module="mod_rewrite">RewriteCond</directive>, <directive
      module="mod_rewrite">RewriteRule</directive>), des directives du
      module <module>mod_alias</module> directives (<directive
      module="mod_alias">Redirect</directive>, <directive
      module="mod_alias">RedirectTemp</directive>, <directive
      module="mod_alias">RedirectPermanent</directive>, <directive
      module="mod_alias">RedirectMatch</directive>), et de la directive
      <directive module="mod_actions">Action</directive> du module
      <module>mod_actions</module>.
      </dd>

      <dt>Indexes</dt>

      <dd>
      Permet l'utilisation des directives qui contr&ocirc;lent l'indexation
      des r&eacute;pertoires (<directive
      module="mod_autoindex">AddDescription</directive>,
      <directive module="mod_autoindex">AddIcon</directive>, <directive
      module="mod_autoindex">AddIconByEncoding</directive>,
      <directive module="mod_autoindex">AddIconByType</directive>,
      <directive module="mod_autoindex">DefaultIcon</directive>, <directive
      module="mod_dir">DirectoryIndex</directive>, <a
      href="mod_autoindex.html#indexoptions.fancyindexing"><code>FancyIndexing</code></a>,
      <directive
      module="mod_autoindex">HeaderName</directive>, <directive
      module="mod_autoindex">IndexIgnore</directive>, <directive
      module="mod_autoindex">IndexOptions</directive>, <directive
      module="mod_autoindex">ReadmeName</directive>,
      <em>etc...</em>).</dd>

      <dt>Limit</dt>

      <dd>
      Permet l'utilisation des directives contr&ocirc;lant l'acc&egrave;s au serveur
      (<directive
      module="mod_access_compat">Allow</directive>, <directive
      module="mod_access_compat">Deny</directive> et <directive
      module="mod_access_compat">Order</directive>).</dd>

      <dt>Nonfatal=[Override|Unknown|All]</dt>

      <dd>
      Permet d'utiliser l'option AllowOverride pour rendre les erreurs
      de syntaxe non fatales dans les fichiers .htaccess : au lieu de
      causer une Internal Server Error, les directives non autoris&eacute;es ou
      non reconnues seront ignor&eacute;es et un avertissement enregistr&eacute; dans
      le journal :
      <ul>
          <li><strong>Nonfatal=Override</strong> rend les directives
	  interdite par AllowOverride non fatales.</li>
          <li><strong>Nonfatal=Unknown</strong> rend les directives
	  inconnues non fatales. Sont concern&eacute;es les erreurs de frappe
	  et les directives impl&eacute;ment&eacute;es par un module non charg&eacute;.</li>
          <li><strong>Nonfatal=All</strong> rend toutes les directives
	  pr&eacute;c&eacute;dentes non fatales.</li>
      </ul>
      <p>Notez qu'une erreur de syntaxe dans une directive valide
      causera toujours une internal server error.</p>
      <note type="warning"><title>S&eacute;curit&eacute;</title>
          Les erreurs non fatales peuvent &ecirc;tre &agrave; l'origine de probl&egrave;mes
	  de s&eacute;curit&eacute; pour les utilisateurs de fichiers .htaccess. Par
	  exemple, si AllowOverride interdit AuthConfig, toute
	  configuration utilisateur destin&eacute;e &agrave; restreindre l'acc&egrave;s &agrave; un
	  site ne sera pas prise en compte.
      </note>
      </dd>

      <dt>Options[=<var>Option</var>,...]</dt>

      <dd>
      Permet l'utilisation des directives contr&ocirc;lant les fonctionnalit&eacute;s
      sp&eacute;cifiques d'un r&eacute;pertoire (<directive
      module="core">Options</directive> et <directive
      module="mod_include">XBitHack</directive>). "Options" doit &ecirc;tre
      suivi d'un signe "&eacute;gal", puis d'une liste d'options s&eacute;par&eacute;es par des
      virgules (pas d'espaces) ; ces options doivent &ecirc;tre d&eacute;finies &agrave;
      l'aide de la commande <directive
      module="core">Options</directive>.

      <note><title>D&eacute;sactivation implicite des options</title>
      <p>Bien que la liste des options disponibles dans les fichiers
      .htaccess puisse &ecirc;tre limit&eacute;e par cette directive, tant qu'un
      directive <directive module="core">Options</directive> est
      autoris&eacute;e, toute autre option h&eacute;rit&eacute;e peut &ecirc;tre d&eacute;sactiv&eacute;e en
      utilisant la syntaxe non-relative. En d'autres termes, ce
      m&eacute;canisme ne peut pas forcer une option sp&eacute;cifique &agrave; rester
      <em>activ&eacute;e</em> tout en permettant &agrave; toute autre option d'&ecirc;tre
      activ&eacute;e.
      </p></note>

      <example>
      AllowOverride Options=Indexes,MultiViews
      </example>
      
      </dd>
    </dl>

    <p>Exemple :</p>

    <highlight language="config">AllowOverride AuthConfig Indexes</highlight>

    <p>Dans l'exemple ci-dessus, toutes les directives qui ne font
    partie ni du groupe <code>AuthConfig</code>, ni du groupe
    <code>Indexes</code>, provoquent une erreur "internal
    server error".</p>

    <note><p>Pour des raisons de s&eacute;curit&eacute; et de performance, ne
    d&eacute;finissez pas <code>AllowOverride</code> &agrave; autre chose que
    <code>None</code> dans votre bloc <code>&lt;Directory /&gt;</code>.
    Recherchez plut&ocirc;t (ou cr&eacute;ez) le bloc <code>&lt;Directory&gt;</code>
    qui se r&eacute;f&egrave;re au r&eacute;pertoire o&ugrave; vous allez pr&eacute;cis&eacute;ment placer un
    fichier <code>.htaccess</code>.</p>
    </note>
</usage>
<seealso><directive module="core">AccessFileName</directive></seealso>
<seealso><directive module="core">AllowOverrideList</directive></seealso>
<seealso><a href="../configuring.html">Fichiers de configuration</a></seealso>
<seealso><a href="../howto/htaccess.html">Fichiers .htaccess</a></seealso>
</directivesynopsis>

<directivesynopsis>
<name>AllowOverrideList</name>
<description>Directives autoris&eacute;es dans les fichiers <code>.htaccess</code></description>
<syntax>AllowOverrideList None|<var>directive</var>
[<var>directive-type</var>] ...</syntax>
<default>AllowOverrideList None</default>
<contextlist><context>directory</context></contextlist>

<usage>
    <p>Lorsque le serveur trouve un fichier <code>.htaccess</code>
    (comme sp&eacute;cifi&eacute; par la directive <directive
    module="core">AccessFileName</directive>), il doit savoir lesquelles
    des directives d&eacute;clar&eacute;es dans ce fichier peuvent remplacer des
    directives des fichiers de configuration du serveur.</p>

    <note><title>Seulement disponible dans les sections &lt;Directory&gt;</title>
    La directive <directive>AllowOverrideList</directive> n'est
    disponible que dans les sections <directive type="section"
    module="core">Directory</directive> sp&eacute;cifi&eacute;es sans expressions
    rationnelles.
    </note>

    <p>Lorsque cette directive et la directive <directive
    module="core">AllowOverride</directive> sont d&eacute;finies &agrave;
    <code>None</code>, les fichiers <a
    href="#accessfilename">.htaccess</a> sont totalement ignor&eacute;s. Dans
    ce cas, le serveur ne cherchera m&ecirc;me pas &agrave; lire des fichiers
    <code>.htaccess</code> dans le syst&egrave;me de fichiers.</p>

    <p>Example:</p>

    <highlight language="config">
AllowOverride None
AllowOverrideList Redirect RedirectMatch
    </highlight>

    <p>Dans l'exemple ci-dessus, seules les directives
    <code>Redirect</code> et <code>RedirectMatch</code> sont autoris&eacute;es.
    Toutes les autres provoqueront une erreur interne du serveur.</p>

    <p>Example:</p>

    <highlight language="config">
AllowOverride AuthConfig
AllowOverrideList CookieTracking CookieName
    </highlight>

    <p>Dans l'exemple ci-dessus, la directive <directive
    module="core">AllowOverride</directive> autorise les directives du
    groupement <code>AuthConfig</code>, et
    <directive>AllowOverrideList</directive> n'autorise que deux
    directives du groupement <code>FileInfo</code>. Toutes les autres
    provoqueront une erreur interne du serveur.</p>
</usage>

<seealso><directive module="core">AccessFileName</directive></seealso>
<seealso><directive module="core">AllowOverride</directive></seealso>
<seealso><a href="../configuring.html">Fichiers de configuration</a></seealso>
<seealso><a href="../howto/htaccess.html">Fichiers .htaccess</a></seealso>
</directivesynopsis>

<directivesynopsis>
<name>CGIMapExtension</name>
<description>Technique permettant de localiser l'interpr&eacute;teur des
scripts CGI</description>
<syntax>CGIMapExtension <var>chemin CGI</var> <var>.extension</var></syntax>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>FileInfo</override>
<compatibility>NetWare uniquement</compatibility>

<usage>
    <p>Cette directive permet de contr&ocirc;ler la mani&egrave;re dont Apache httpd trouve
    l'interpr&eacute;teur servant &agrave; ex&eacute;cuter les scripts CGI. Par exemple, avec
    la d&eacute;finition <code>CGIMapExtension sys:\foo.nlm .foo</code>, tous
    les fichiers scripts CGI poss&eacute;dant une extension <code>.foo</code>
    seront pass&eacute;s &agrave; l'interpr&eacute;teur FOO.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>ContentDigest</name>
<description>Active la g&eacute;n&eacute;ration d'un en-t&ecirc;te <code>Content-MD5</code>
dans la r&eacute;ponse HTTP</description>
<syntax>ContentDigest On|Off</syntax>
<default>ContentDigest Off</default>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>Options</override>
<status>Exp&eacute;rimental</status>

<usage>
    <p>Cette directive active la g&eacute;n&eacute;ration d'un en-t&ecirc;te
    <code>Content-MD5</code> selon les d&eacute;finitions des RFC 1864 et
    2616.</p>

    <p>MD5 est un algorithme permettant de g&eacute;n&eacute;rer un condens&eacute; (parfois
    appel&eacute; "empreinte") &agrave; partir de donn&eacute;es d'une taille al&eacute;atoire ; le
    degr&eacute; de pr&eacute;cision est tel que la moindre alt&eacute;ration des donn&eacute;es
    d'origine entra&icirc;ne une alt&eacute;ration de l'empreinte.</p>

    <p>L'en-t&ecirc;te <code>Content-MD5</code> permet de v&eacute;rifier
    l'int&eacute;grit&eacute; de la r&eacute;ponse HTTP dans son ensemble. Un serveur mandataire
    ou un client peut utiliser cet en-t&ecirc;te pour rechercher une
    &eacute;ventuelle modification accidentelle de la r&eacute;ponse au cours de sa
    transmission. Exemple d'en-t&ecirc;te :</p>

    <example>
      Content-MD5: AuLb7Dp1rqtRtxz2m9kRpA==
    </example>

    <p>Notez que des probl&egrave;mes de performances peuvent affecter votre
    serveur, car l'empreinte est g&eacute;n&eacute;r&eacute;e pour chaque requ&ecirc;te (il n'y a
    pas de mise en cache).</p>

    <p>L'en-t&ecirc;te <code>Content-MD5</code> n'est envoy&eacute; qu'avec les
    documents servis par le module <module>core</module>, &agrave; l'exclusion
    de tout autre module. Ainsi, les documents SSI, les sorties de
    scripts CGI, et les r&eacute;ponses &agrave; des requ&ecirc;tes partielles (byte range)
    ne comportent pas cet en-t&ecirc;te.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>DefaultRuntimeDir</name>
<description>R&eacute;pertoire de base des fichiers cr&eacute;&eacute;s au cours de l'ex&eacute;cution du serveur</description>
<syntax>DefaultRuntimeDir <var>chemin-r&eacute;pertoire</var></syntax>
<default>DefaultRuntimeDir DEFAULT_REL_RUNTIMEDIR (logs/)</default>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>La directive <directive>DefaultRuntimeDir</directive> permet de
    d&eacute;finir le r&eacute;pertoire dans lequel le serveur va cr&eacute;er les diff&eacute;rents
    fichiers relatifs &agrave; son ex&eacute;cution (m&eacute;moire partag&eacute;e, verrous,
    etc...). Si le chemin sp&eacute;cifi&eacute; est relatif, le chemin absolu sera
    g&eacute;n&eacute;r&eacute; relativement &agrave; la valeur de la directive
    <directive>ServerRoot</directive></p>

    <p><strong>Example</strong></p>
   <highlight language="config">
DefaultRuntimeDir scratch/
    </highlight>

    <p>La valeur par d&eacute;faut de la directive
    <directive>DefaultRuntimeDir</directive> peut &ecirc;tre modifi&eacute;e en
    changeant la valeur de la macro <code>DEFAULT_REL_RUNTIMEDIR</code>
    d&eacute;finie &agrave; la compilation.</p>

   <p>Note: si la valeur de <directive>ServerRoot</directive> n'a pas
   &eacute;t&eacute; sp&eacute;cifi&eacute;e avant d'utiliser cette directive, c'est la valeur par
   d&eacute;faut de <directive>ServerRoot</directive> qui sera utilis&eacute;e pour
   d&eacute;finir la base du r&eacute;pertoire.</p>

</usage>
<seealso>Voir les <a
href="../misc/security_tips.html#serverroot">conseils &agrave; propos de
s&eacute;surit&eacute;</a> pour plus d'informations en vue de d&eacute;finir correctement les
permissions sur la racine du serveur <directive>ServerRoot</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>DefaultType</name>
<description>Les seuls effets de cette directive sont des &eacute;missions
d'avertissements si sa valeur est diff&eacute;rente de <code>none</code>. Dans
les versions pr&eacute;c&eacute;dentes, DefaultType permettait de sp&eacute;cifier un type de
m&eacute;dia &agrave; assigner par d&eacute;faut au contenu d'une r&eacute;ponse pour lequel aucun
autre type de m&eacute;dia n'avait &eacute;t&eacute; trouv&eacute;.
</description>
<syntax>DefaultType <var>type m&eacute;dia|none</var></syntax>
<default>DefaultType none</default>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>FileInfo</override>
<compatibility>L'argument <code>none</code> est disponible dans les
versions d'Apache httpd 2.2.7 et sup&eacute;rieures. Tous les autres choix sont
DESACTIV&Eacute;S &agrave; partir des version 2.3.x.</compatibility>

<usage>
    <p>Cette directive a &eacute;t&eacute; d&eacute;sactiv&eacute;e. Pour la compatibilit&eacute;
    ascendante avec les anciens fichiers de configuration, elle peut
    &ecirc;tre sp&eacute;cifi&eacute;e avec la valeur <code>none</code>, c'est &agrave; dire sans
    type de m&eacute;dium par d&eacute;faut. Par exemple :</p>

    <highlight language="config">DefaultType None</highlight>

    <p><code>DefaultType None</code> n'est disponible que dans les
    versions d'Apache 2.2.7 et sup&eacute;rieures.</p>

    <p>Utilisez le fichier de configuration mime.types et la directive
    <directive module="mod_mime">AddType</directive> pour configurer
    l'assignement d'un type de m&eacute;dium via les extensions de fichiers, ou
    la directive <directive module="core">ForceType</directive> pour
    attribuer un type de m&eacute;dium &agrave; des ressources sp&eacute;cifiques. Dans le
    cas contraire, le serveur enverra sa r&eacute;ponse sans champ d'en-t&ecirc;te
    Content-Type, et le destinataire devra d&eacute;terminer lui-m&ecirc;me le type
    de m&eacute;dium.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>Define</name>
<description>Permet de d&eacute;finir une variable</description>
<syntax>Define <var>nom-param&egrave;tre</var> [<var>valeur-param&egrave;tre</var>]</syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context></contextlist>

<usage>
    <p>Avec un seul param&egrave;tre, l'effet de la directive
    <directive>Define</directive> est identique &agrave; celui de l'argument
    <code>-D</code> du programme <program>httpd</program>. Il permet de
    modifier le comportement des sections <directive module="core"
    type="section">IfDefine</directive> sans avoir &agrave; ajouter d'argument
    <code>-D</code> au sein des scripts de d&eacute;marrage.</p>

    <p>De plus, le second param&egrave;tre permet d'affecter une valeur &agrave; la
    variable d&eacute;finie par le premier. Cette variable peut &ecirc;tre r&eacute;f&eacute;renc&eacute;e
    dans le fichier de configuration via la syntaxe <code>${VAR}</code>.
    La port&eacute;e de la variable est toujours globale, et n'est jamais
    limit&eacute;e &agrave; la section de configuration courante.</p>

    <highlight language="config">
&lt;IfDefine TEST&gt;
  Define servername test.example.com
&lt;/IfDefine&gt;
&lt;IfDefine !TEST&gt;
  Define servername www.example.com
  Define SSL
&lt;/IfDefine&gt;

DocumentRoot /var/www/${servername}/htdocs
    </highlight>

    <p>Le caract&egrave;re ":" est interdit dans les noms de variables afin
    d'&eacute;viter les conflits avec la syntaxe de la directive <directive
    module="mod_rewrite">RewriteMap</directive>.</p>
</usage>
</directivesynopsis>

<directivesynopsis type="section">
<name>Directory</name>
<description>Regroupe un ensemble de directives qui ne s'appliquent
qu'au r&eacute;pertoire concern&eacute; du syst&egrave;me de fichiers, &agrave; ses
sous-r&eacute;pertoires, et &agrave; leur contenu.</description>
<syntax>&lt;Directory <var>chemin r&eacute;pertoire</var>&gt;
... &lt;/Directory&gt;</syntax>
<contextlist><context>server config</context><context>virtual
host</context>
</contextlist>

<usage>
    <p>Les balises <directive type="section">Directory</directive> et
    <code>&lt;/Directory&gt;</code> permettent de regrouper un ensemble
    de directives qui ne s'appliquent qu'au r&eacute;pertoire pr&eacute;cis&eacute;,
    &agrave; ses sous-r&eacute;pertoires, et aux fichiers situ&eacute;s dans ces
    sous-r&eacute;pertoires. Toute directive
    autoris&eacute;e dans un contexte de r&eacute;pertoire peut &ecirc;tre utilis&eacute;e.
    <var>chemin r&eacute;pertoire</var> est soit le chemin absolu d'un
    r&eacute;pertoire, soit une cha&icirc;ne de caract&egrave;res avec caract&egrave;res g&eacute;n&eacute;riques
    utilisant la comparaison Unix de style shell. Dans une cha&icirc;ne de
    caract&egrave;res avec caract&egrave;res g&eacute;n&eacute;riques, <code>?</code> correspond &agrave;
    un caract&egrave;re quelconque, et <code>*</code> &agrave; toute cha&icirc;ne de
    caract&egrave;res. Les intervalles de caract&egrave;res <code>[]</code> sont aussi
    autoris&eacute;s. Aucun caract&egrave;re g&eacute;n&eacute;rique ne peut remplacer le caract&egrave;re
    `/', si bien que l'expression <code>&lt;Directory
    /*/public_html&gt;</code> ne conviendra pas pour le chemin
     * <code>/home/user/public_html</code>, alors que <code>&lt;Directory
    /home/*/public_html&gt;</code> conviendra. Exemple :</p>

    <highlight language="config">
&lt;Directory "/usr/local/httpd/htdocs"&gt;
  Options Indexes FollowSymLinks
&lt;/Directory&gt;
    </highlight>

    <note>
      <p>Soyez prudent avec l'argument <var>chemin r&eacute;pertoire</var> : il
      doit correspondre exactement au chemin du syst&egrave;me de fichier
      qu'Apache httpd utilise pour acc&eacute;der aux fichiers. Les directives
      comprises dans une section <code>&lt;Directory&gt;</code> ne
      s'appliqueront pas aux fichiers du m&ecirc;me r&eacute;pertoire auxquels on
      aura acc&eacute;d&eacute; via un chemin diff&eacute;rent, per exemple via un lien
      symbolique.</p>
    </note>

    <p> Les <glossary ref="regex">Expressions rationnelles</glossary>
    peuvent aussi &ecirc;tre utilis&eacute;es en ajoutant le caract&egrave;re
    <code>~</code>. Par exemple :</p>

    <highlight language="config">
&lt;Directory ~ "^/www/[0-9]{3}"&gt;

&lt;/Directory&gt;
</highlight>

    <p>pourra correspondre &agrave; tout r&eacute;pertoire situ&eacute; dans /www/ et dont le
    nom se compose de trois chiffres.</p>

    <p>Si plusieurs sections <directive
    type="section">Directory</directive> (sans expression rationnelle)
    correspondent au r&eacute;pertoire (ou &agrave; un de ses parents) qui contient le
    document, les directives de la section <directive
    type="section">Directory</directive> dont le chemin est le plus
    court sont appliqu&eacute;es en premier, en s'intercalant avec les
    directives des fichiers <a href="#accessfilename">.htaccess</a>. Par
    exemple, avec</p>

    <highlight language="config">
&lt;Directory /&gt;
  AllowOverride None
&lt;/Directory&gt;

&lt;Directory "/home"&gt;
  AllowOverride FileInfo
&lt;/Directory&gt;
    </highlight>

    <p>l'acc&egrave;s au document <code>/home/web/dir/doc.html</code> emprunte
    le chemin suivant :</p>

    <ul>
      <li>Aplication de la directive <code>AllowOverride None</code>
      (qui d&eacute;sactive les fichiers <code>.htaccess</code>).</li>

      <li>Application de la directive <code>AllowOverride
      FileInfo</code> (pour le r&eacute;pertoire <code>/home</code>).</li>

      <li>Application de toute directive <code>FileInfo</code> qui se
      trouverait dans d'&eacute;ventuels fichiers <code>/home/.htaccess</code>,
      <code>/home/web/.htaccess</code> ou
      <code>/home/web/dir/.htaccess</code>, dans cet ordre.</li>
    </ul>

    <p>Les directives associ&eacute;es aux r&eacute;pertoires sous forme d'expressions
    rationnelles ne sont prises en compte qu'une fois toutes les
    directives des sections sans expressions rationnelles appliqu&eacute;es.
    Alors, tous les r&eacute;pertoires avec expressions rationnelles sont
    test&eacute;s selon l'ordre dans lequel ils apparaissent dans le fichier de
    configuration. Par exemple, avec</p>

    <highlight language="config">
&lt;Directory ~ "abc$"&gt;
  # ... directives ici ...
&lt;/Directory&gt;
    </highlight>

    <p>la section avec expression rationnelle ne sera prise en compte
    qu'apr&egrave;s les sections <directive
    type="section">Directory</directive> sans expression rationnelle
    et les fichiers <code>.htaccess</code>. Alors, l'expression
    rationnelle conviendra pour <code>/home/abc/public_html/abc</code>
    et la section <directive type="section">Directory</directive>
    correspondante s'appliquera.</p>

   <p><strong>Notez que la politique d'acc&egrave;s par d&eacute;faut
   dans les sections <code>&lt;Directory /&gt;</code> consiste &agrave;
   autoriser tout acc&egrave;s sans restriction. Ceci signifie qu'Apache httpd va servir tout fichier
   correspondant &agrave; une URL. Il est recommand&eacute; de modifier cette
   situation &agrave; l'aide d'un bloc du style</strong></p>

    <highlight language="config">
&lt;Directory /&gt;
  Require all denied
&lt;/Directory&gt;
    </highlight>

    <p><strong>puis d'affiner la configuration pour les r&eacute;pertoires que vous
    voulez rendre accessibles. Voir la page <a
    href="../misc/security_tips.html">Conseils &agrave; propos de s&eacute;curit&eacute;</a>
    pour plus de d&eacute;tails.</strong></p>

    <p>Les sections <directive type="section">Directory</directive> se situent
    dans le fichier <code>httpd.conf</code>. Les directives <directive
    type="section">Directory</directive> ne peuvent pas &ecirc;tre imbriqu&eacute;es
    et ne sont pas autoris&eacute;es dans les sections <directive module="core"
    type="section">Limit</directive> ou <directive module="core"
    type="section">LimitExcept</directive>.</p>
</usage>
<seealso><a href="../sections.html">Comment fonctionnent les sections
&lt;Directory&gt;, &lt;Location&gt; et &lt;Files&gt;</a> pour des
explications &agrave; propos de la mani&egrave;re dont ces diff&eacute;rentes sections se
combinent entre elles &agrave; la r&eacute;ception d'une requ&ecirc;te</seealso>
</directivesynopsis>

<directivesynopsis type="section">
<name>DirectoryMatch</name>
<description>Regroupe des directives qui s'appliquent au contenu de r&eacute;pertoires
du syst&egrave;me de fichiers correspondant &agrave; une expression rationnelle</description>
<syntax>&lt;DirectoryMatch <var>regex</var>&gt;
... &lt;/DirectoryMatch&gt;</syntax>
<contextlist><context>server config
</context><context>virtual host</context>
</contextlist>

<usage>
    <p>Les balises <directive type="section">DirectoryMatch</directive>
    et <code>&lt;/DirectoryMatch&gt;</code> permettent de regrouper un
    ensemble de directives qui ne s'appliqueront qu'au r&eacute;pertoire
    pr&eacute;cis&eacute; (et aux fichiers qu'il contient), comme pour la section <directive
    module="core" type="section">Directory</directive>. Cependant, le
    r&eacute;pertoire est pr&eacute;cis&eacute; sous la forme d'une <glossary
    ref="regex">expression rationnelle</glossary>. Par exemple :</p>

    <highlight language="config">
&lt;DirectoryMatch "^/www/(.+/)?[0-9]{3}"&gt;
    # ...
&lt;/DirectoryMatch&gt;
</highlight>

    <p>conviendrait pour les sous-r&eacute;pertoires de <code>/www/</code> dont
    le nom se compose de trois chiffres.</p>

    <note><title>Compatibilit&eacute;</title>
      Avant la version 2.3.9, cette directive s'appliquait aussi aux
      sous-r&eacute;pertoires (comme la directive <directive module="core"
      type="section">Directory</directive>), et ne tenait pas compte du
      symbole de fin de ligne ($). Depuis la version 2.3.9, seuls les
      r&eacute;pertoires qui correspondent &agrave; l'expression sont affect&eacute;s par les
      directives contenues dans la section.
    </note>

    <note><title>slash de fin</title>
      Cette directive s'applique aux requ&ecirc;tes pour des r&eacute;pertoires avec
      ou sans slash de fin ; les expressions contenant un symbole de fin
      de ligne ($) doivent donc faire l'objet d'une attention
      particuli&egrave;re.
    </note>
</usage>
<seealso><directive type="section" module="core">Directory</directive>
pour une description de la mani&egrave;re dont les expressions rationnelles
sont trait&eacute;es en pr&eacute;sence d'autres sections <directive
type="section">Directory</directive> sans expressions rationnelles</seealso>
<seealso><a
href="../sections.html">Comment fonctionnent les sections
&lt;Directory&gt;, &lt;Location&gt; et &lt;Files&gt;</a> pour une
explication &agrave; propos de la mani&egrave;re dont ces diff&eacute;rentes sections se
combinent entre elles &agrave; la r&eacute;ception d'une requ&ecirc;te</seealso>
</directivesynopsis>

<directivesynopsis>
<name>DocumentRoot</name>
<description>Racine principale de l'arborescence des documents visible
depuis Internet</description>
<syntax>DocumentRoot <var>chemin r&eacute;pertoire</var></syntax>
<default>DocumentRoot /usr/local/apache/htdocs</default>
<contextlist><context>server config</context><context>virtual
host</context>
</contextlist>

<usage>
    <p>Cette directive permet de d&eacute;finir le r&eacute;pertoire &agrave; partir duquel
    <program>httpd</program> va servir les fichiers. S'il ne correspond
    pas &agrave; un <directive module="mod_alias">Alias</directive>, le chemin
    de l'URL sera ajout&eacute; par le serveur &agrave; la racine des documents afin
    de construire le chemin du document recherch&eacute;. Exemple :</p>

    <highlight language="config">DocumentRoot "/usr/web"</highlight>

    <p>un acc&egrave;s &agrave; <code>http://my.example.com/index.html</code> se
    r&eacute;f&egrave;re alors &agrave; <code>/usr/web/index.html</code>. Si <var>chemin
    r&eacute;pertoire</var> n'est pas un chemin absolu, il est consid&eacute;r&eacute; comme
    relatif au chemin d&eacute;fini par la directive <directive
    module="core">ServerRoot</directive>.</p>

    <p>Le r&eacute;pertoire d&eacute;fini par la directive
    <directive>DocumentRoot</directive> ne doit pas comporter de slash
    final.</p>
</usage>
<seealso><a href="../urlmapping.html#documentroot">Mise en
correspondance des URLs avec le syst&egrave;me de fichiers</a></seealso>
</directivesynopsis>

<directivesynopsis type="section">
<name>Else</name>
<description>Contient des directives qui ne s'appliquent que si la
condition correspondant &agrave; la section <directive type="section"
module="core">If</directive> ou <directive type="section"
module="core">ElseIf</directive> pr&eacute;c&eacute;dente n'est pas satisfaite par la
requ&ecirc;te &agrave; l'ex&eacute;cution</description>
<syntax>&lt;Else&gt; ... &lt;/Else&gt;</syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>All</override>

<usage>
    <p>La section <directive type="section">Else</directive> applique
    les directives qu'elle contient si et seulement si les conditions
    correspondant &agrave; la section <directive type="section">If</directive>
    ou <directive type="section">ElseIf</directive> imm&eacute;diatement
    sup&eacute;rieure et dans la m&ecirc;me port&eacute;e n'ont pas &eacute;t&eacute; satisfaites. Par
    exemple, dans :</p>

    <highlight language="config">
&lt;If "-z req('Host')"&gt;
  # ...
&lt;/If&gt;
&lt;Else&gt;
  # ...
&lt;/Else&gt;
    </highlight>

    <p>La condition de la section <directive
    type="section">If</directive> serait satisfaite pour les requ&ecirc;tes
    HTTP/1.0 sans en-t&ecirc;te <var>Host:</var>, alors que celle de la section
    <directive type="section">Else</directive> le serait pour les
    requ&ecirc;tes comportant un en-t&ecirc;te <var>Host:</var>.</p>

</usage>
<seealso><directive type="section" module="core">If</directive></seealso>
<seealso><directive type="section" module="core">ElseIf</directive></seealso>
<seealso><a href="../sections.html">Fonctionnement des sections &lt;Directory&gt;, &lt;Location&gt;,
    &lt;Files&gt;</a> pour une explication de la mani&egrave;re dont ces
    diff&eacute;rentes section se combinent entre elles lorsqu'une requ&ecirc;te est
    re&ccedil;ue. Les directives <directive type="section">If</directive>,
    <directive type="section">ElseIf</directive>, et <directive
    type="section">Else</directive> s'appliquent en dernier.</seealso>
</directivesynopsis>

<directivesynopsis type="section">
<name>ElseIf</name>
<description>Contient des directives qui ne s'appliquent que si la
condition correspondante est satisfaite par une requ&ecirc;te &agrave; l'ex&eacute;cution,
alors que la condition correspondant &agrave; la section <directive
type="section" module="core">If</directive> ou <directive
type="section">ElseIf</directive> pr&eacute;c&eacute;dente ne l'&eacute;tait pas.</description>
<syntax>&lt;ElseIf <var>expression</var>&gt; ... &lt;/ElseIf&gt;</syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>All</override>

<usage>
    <p>La section <directive type="section">ElseIf</directive> applique
    les directives qu'elle contient si et seulement si d'une part la
    condition correspondante est satisfaite, et d'autre part la condition
    correspondant &agrave; la section <directive type="section">If</directive>
    ou <directive type="section">ElseIf</directive> de la m&ecirc;me port&eacute;e ne
    l'est pas. Par exemple, dans :</p>

    <highlight language="config">
&lt;If "-R '10.1.0.0/16'"&gt;
  #...
&lt;/If&gt;
&lt;ElseIf "-R '10.0.0.0/8'"&gt;
  #...
&lt;/ElseIf&gt;
&lt;Else&gt;
  #...
&lt;/Else&gt;
    </highlight>

    <p>La condition correspondant &agrave; la section <directive
    type="section">ElseIf</directive> est satisfaite si l'adresse
    distante de la requ&ecirc;te appartient au sous-r&eacute;seau 10.0.0.0/8, mais
    pas si elle appartient au sous-r&eacute;seau 10.1.0.0/16.</p>

</usage>
<seealso><a href="../expr.html">Les expressions dans le serveur HTTP
Apache</a>, pour une r&eacute;f&eacute;rence compl&egrave;te et d'autres exemples.</seealso>
<seealso><directive type="section" module="core">If</directive></seealso>
<seealso><directive type="section" module="core">Else</directive></seealso>
<seealso><a href="../sections.html">Fonctionnement des sections &lt;Directory&gt;, &lt;Location&gt;,
    &lt;Files&gt;</a> pour une explication de la mani&egrave;re dont ces
    diff&eacute;rentes section se combinent entre elles lorsqu'une requ&ecirc;te est
    re&ccedil;ue. Les directives <directive type="section">If</directive>,
    <directive type="section">ElseIf</directive>, et <directive
    type="section">Else</directive> s'appliquent en dernier.</seealso>
</directivesynopsis>

<directivesynopsis>
<name>EnableMMAP</name>
<description>Utilise la projection en m&eacute;moire (Memory-Mapping) pour
lire les fichiers pendant qu'ils sont servis</description>
<syntax>EnableMMAP On|Off</syntax>
<default>EnableMMAP On</default>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>FileInfo</override>

<usage>
    <p>Cette directive d&eacute;finit si <program>httpd</program> peut utiliser
    la projection en m&eacute;moire (Memory-Mapping) quand il doit lire le contenu
    d'un fichier pendant qu'il est servi. Par d&eacute;faut, lorsque le
    traitement d'une requ&ecirc;te requiert l'acc&egrave;s aux donn&eacute;es contenues dans
    un fichier -- par exemple, pour servir un fichier interpr&eacute;t&eacute; par le
    serveur &agrave; l'aide de <module>mod_include</module> -- Apache httpd projette
    le fichier en m&eacute;moire si le syst&egrave;me d'exploitation le permet.</p>

    <p>Cette projection en m&eacute;moire induit parfois une am&eacute;lioration des
    performances. Sur certains syst&egrave;mes cependant, il est pr&eacute;f&eacute;rable de
    d&eacute;sactiver la projection en m&eacute;moire afin d'&eacute;viter certains probl&egrave;mes
    op&eacute;rationnels :</p>

    <ul>
    <li>Sur certains syst&egrave;mes multi-processeurs, la projection en
    m&eacute;moire peut d&eacute;grader les performances du programme
    <program>httpd</program>.</li>
    <li>S'il fait l'objet d'une projection en m&eacute;moire par
    <program>httpd</program>, la suppression ou la troncature d'un
    fichier peut provoquer un crash de <program>httpd</program> avec une
    erreur de segmentation.</li>
    </ul>

    <p>Pour les configurations de serveur sujettes &agrave; ce genre de
    probl&egrave;me, il est pr&eacute;f&eacute;rable de d&eacute;sactiver la projection en m&eacute;moire
    des fichiers servis en sp&eacute;cifiant :</p>
    
    <highlight language="config">EnableMMAP Off</highlight>

    <p>Pour les montages NFS, cette fonctionnalit&eacute; peut &ecirc;tre
    explicitement d&eacute;sactiv&eacute;e pour les fichiers concern&eacute;s en sp&eacute;cifiant
    :</p>

    <highlight language="config">
&lt;Directory "/path-to-nfs-files"&gt;
  EnableMMAP Off
&lt;/Directory&gt;
    </highlight>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>EnableSendfile</name>
<description>Utilise le support sendfile du noyau pour servir les
fichiers aux clients</description>
<syntax>EnableSendfile On|Off</syntax>
<default>EnableSendfile Off</default>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>FileInfo</override>
<compatibility>Par d&eacute;faut &agrave; Off depuis la version 2.3.9.</compatibility>

<usage>
    <p>Cette directive d&eacute;finit si le programme <program>httpd</program>
    peut utiliser le support sendfile du noyau pour transmettre le
    contenu des fichiers aux clients. Par d&eacute;faut, lorsque le traitement
    d'une requ&ecirc;te ne requiert pas l'acc&egrave;s aux donn&eacute;es contenues dans un
    fichier -- par exemple, pour la transmission d'un fichier statique
    -- Apache httpd utilise sendfile pour transmettre le contenu du fichier
    sans m&ecirc;me lire ce dernier, si le syst&egrave;me d'exploitation le
    permet.</p>

    <p>Ce m&eacute;canisme sendfile &eacute;vite la s&eacute;paration des op&eacute;rations de
    lecture et d'envoi, ainsi que les r&eacute;servations de tampons. sur
    certains syst&egrave;mes cependant, ou sous certains syst&egrave;mes de fichiers,
    il est pr&eacute;f&eacute;rable de d&eacute;sactiver cette fonctionnalit&eacute; afin d'&eacute;viter
    certains probl&egrave;mes op&eacute;rationnels :</p>

    <ul>
    <li>Certains syst&egrave;mes peuvent pr&eacute;senter un support sendfile
    d&eacute;fectueux que le syst&egrave;me de compilation n'a pas d&eacute;tect&eacute;, en
    particulier si les ex&eacute;cutables ont &eacute;t&eacute; compil&eacute;s sur une autre
    machine, puis copi&eacute;s sur la premi&egrave;re avec un support sendfile
    d&eacute;fectueux.</li>
    <li>Sous Linux, l'utilisation de sendfile induit des bogues lors de
    la r&eacute;cup&eacute;ration des paquets de v&eacute;rification TCP (TCP-checksum) avec
    certaines cartes r&eacute;seau lorsqu'on utilise IPv6.</li>
    <li>Sous Linux sur Itanium, <code>sendfile</code> peut s'av&eacute;rer incapable de
    traiter les fichiers de plus de 2 Go.</li>
    <li>Avec un montage r&eacute;seau de <directive
    module="core">DocumentRoot</directive> (par exemple NFS, SMB, CIFS,
    FUSE), le
    noyau peut s'av&eacute;rer incapable de servir un fichier de ce montage
    r&eacute;seau en passant par son propre cache.</li>
    </ul>

    <p>Pour les configurations de serveur non sujettes &agrave; ce genre de
    probl&egrave;me, vous pouvez activer cette fonctionnalit&eacute; en
    sp&eacute;cifiant :</p>

    <highlight language="config">EnableSendfile On</highlight>

    <p>Pour les montages r&eacute;seau, cette fonctionnalit&eacute; peut &ecirc;tre
    explicitement d&eacute;sactiv&eacute;e pour les fichiers concern&eacute;s en sp&eacute;cifiant
    :</p>

    <highlight language="config">
&lt;Directory "/path-to-nfs-files"&gt;
  EnableSendfile Off
&lt;/Directory&gt;
    </highlight>
    <p>Veuillez noter que la configuration de la directive
    <directive>EnableSendfile</directive> dans un contexte de r&eacute;pertoire
    ou de fichier .htaccess n'est pas support&eacute;e par
    <module>mod_cache_disk</module>. Le module ne prend en compte la
    d&eacute;finition de <directive>EnableSendfile</directive> que dans un
    contexte global.
    </p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>Error</name>
<description>Interrompt la lecture de la configuration avec un message
d'erreur personnalis&eacute;</description>
<syntax>Error <var>message</var></syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<compatibility>&agrave; partir de la version 2.3.9</compatibility>

<usage>
    <p>Si une erreur peut &ecirc;tre d&eacute;tect&eacute;e dans la configuration, souvent
    un module manquant, cette
    directive peut &ecirc;tre utilis&eacute;e pour g&eacute;n&eacute;rer un message d'erreur
    personnalis&eacute;, et interrompre la lecture de la configuration. </p>

    <highlight language="config">
# Exemple
# v&eacute;rification du chargement de mod_include
&lt;IfModule !include_module&gt;
  Error "mod_include is required by mod_foo.  Load it with LoadModule."
&lt;/IfModule&gt;

# v&eacute;rification de la d&eacute;finition de SSL ou (exclusif) NOSSL
&lt;IfDefine SSL&gt;
&lt;IfDefine NOSSL&gt;
  Error "Both SSL and NOSSL are defined.  Define only one of them."
&lt;/IfDefine&gt;
&lt;/IfDefine&gt;
&lt;IfDefine !SSL&gt;
&lt;IfDefine !NOSSL&gt;
  Error "Either SSL or NOSSL must be defined."
&lt;/IfDefine&gt;
&lt;/IfDefine&gt;
    </highlight>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>ErrorDocument</name>
<description>Document que le serveur renvoie au client en cas
d'erreur</description>
<syntax>ErrorDocument <var>code erreur</var> <var>document</var></syntax>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>FileInfo</override>

<usage>
    <p>Apache httpd peut traiter les probl&egrave;mes et les erreurs de quatre
    mani&egrave;res,</p>

    <ol>
      <li>afficher un simple message d'erreur au contenu fixe</li>

      <li>afficher un message personnalis&eacute;</li>

      <li>rediriger en interne vers un <var>chemin d'URL</var> local pour traiter
      le probl&egrave;me ou l'erreur</li>

      <li>rediriger vers une <var>URL</var> externe pour traiter
      le probl&egrave;me ou l'erreur</li>
    </ol>

    <p>La premi&egrave;re option constitue le comportement par d&eacute;faut; pour
    choisir une des trois autres options, il faut configurer Apache &agrave;
    l'aide de la directive <directive>ErrorDocument</directive>, suivie
    du code de la r&eacute;ponse HTTP et d'une URL ou d'un message. Apache
    httpd fournit parfois des informations suppl&eacute;mentaires &agrave; propos du
    probl&egrave;me ou de l'erreur.</p>

    <p>Les URLs peuvent commencer par un slash (/) pour les chemins web
    locaux (relatifs au r&eacute;pertoire d&eacute;fini par la directive <directive
    module="core">DocumentRoot</directive>), ou se pr&eacute;senter sous la
    forme d'une URL compl&egrave;te que le client pourra r&eacute;soudre.
    Alternativement, un message &agrave; afficher par le navigateur pourra &ecirc;tre
    fourni. Exemples :</p>

    <highlight language="config">
ErrorDocument 500 http://foo.example.com/cgi-bin/tester
ErrorDocument 404 /cgi-bin/bad_urls.pl
ErrorDocument 401 /subscription_info.html
ErrorDocument 403 "Sorry can't allow you access today"
ErrorDocument 403 Forbidden!
    </highlight>

    <p>De plus, on peut sp&eacute;cifier la valeur sp&eacute;ciale <code>default</code>
    pour indiquer l'utilisation d'un simple message d'Apache httpd cod&eacute; en
    dur. Bien que non n&eacute;cessaire dans des circonstances normales, la
    sp&eacute;cification de la valeur <code>default</code> va permettre de
    r&eacute;tablir l'utilisation du simple message d'Apache httpd cod&eacute; en dur pour
    les configurations qui sans cela, h&eacute;riteraient d'une directive
    <directive>ErrorDocument</directive> existante.</p>

    <highlight language="config">
ErrorDocument 404 /cgi-bin/bad_urls.pl

&lt;Directory /web/docs&gt;
  ErrorDocument 404 default
&lt;/Directory&gt;
    </highlight>

    <p>Notez que lorsque vous sp&eacute;cifiez une directive
    <directive>ErrorDocument</directive> pointant vers une URL distante
    (c'est &agrave; dire tout ce qui commence par le pr&eacute;fixe http), le serveur
    HTTP Apache va
    envoyer une redirection au client afin de lui indiquer o&ugrave; trouver le
    document, m&ecirc;me dans le cas o&ugrave; ce document se trouve sur le serveur
    local. Ceci a de nombreuses cons&eacute;quences dont la plus importante
    r&eacute;side dans le fait que le client ne recevra pas le code d'erreur
    original, mais au contraire un code de statut de redirection. Ceci
    peut en retour semer la confusion chez les robots web et divers
    clients qui tentent de d&eacute;terminer la validit&eacute; d'une URL en examinant
    le code de statut. De plus, si vous utilisez une URL distante avec
    <code>ErrorDocument 401</code>, le client ne saura pas qu'il doit
    demander un mot de passe &agrave; l'utilisateur car il ne recevra pas le
    code de statut 401. C'est pourquoi, <strong>si vous utilisez une
    directive <code>ErrorDocument 401</code>, elle devra faire r&eacute;f&eacute;rence
    &agrave; un document par le biais d'un chemin local.</strong></p>

    <p>Microsoft Internet Explorer (MSIE) ignore par d&eacute;faut les messages
    d'erreur g&eacute;n&eacute;r&eacute;s par le serveur lorsqu'ils sont trop courts et
    remplacent ses propres messages d'erreur "amicaux". Le seuil de
    taille varie en fonction du type d'erreur, mais en g&eacute;n&eacute;ral, si la
    taille de votre message d'erreur est sup&eacute;rieure &agrave; 512 octets, il y a
    peu de chances pour que MSIE l'occulte, et il sera affich&eacute; par ce
    dernier. Vous trouverez d'avantage d'informations dans l'article de
    la base de connaissances Microsoft <a
    href="http://support.microsoft.com/default.aspx?scid=kb;en-us;Q294807"
    >Q294807</a>.</p>

    <p>Bien que la plupart des messages d'erreur internes originaux
    puissent &ecirc;tre remplac&eacute;s, ceux-ci sont cependant conserv&eacute;s dans
    certaines circonstances sans tenir compte de la d&eacute;finition de la
    directive <directive module="core">ErrorDocument</directive>. En
    particulier, en cas de d&eacute;tection d'une requ&ecirc;te mal form&eacute;e, le
    processus de traitement normal des requ&ecirc;tes est imm&eacute;diatement
    interrompu, et un message d'erreur interne est renvoy&eacute;, ceci afin de
    se pr&eacute;munir contre les probl&egrave;mes de s&eacute;curit&eacute; li&eacute;s aux requ&ecirc;tes mal
    form&eacute;es.</p>

    <p>Si vous utilisez mod_proxy, il est en g&eacute;n&eacute;ral pr&eacute;f&eacute;rable
    d'activer <directive
    module="mod_proxy">ProxyErrorOverride</directive> afin d'&ecirc;tre en
    mesure de produire des messages d'erreur personnalis&eacute;s pour le
    compte de votre serveur d'origine. Si vous n'activez pas
    ProxyErrorOverride, Apache httpd ne g&eacute;n&eacute;rera pas de messages d'erreur
    personnalis&eacute;s pour le contenu mandat&eacute;.</p>

</usage>

<seealso><a href="../custom-error.html">documentation sur la
personnalisation des r&eacute;ponses</a></seealso>
</directivesynopsis>

<directivesynopsis>
<name>ErrorLog</name>
<description>D&eacute;finition du chemin du journal des erreurs</description>
<syntax> ErrorLog <var>chemin fichier</var>|syslog[:<var>facility</var>]</syntax>
<default>ErrorLog logs/error_log (Unix) ErrorLog logs/error.log (Windows and OS/2)</default>
<contextlist><context>server config</context><context>virtual
host</context>
</contextlist>

<usage>
    <p>La directive <directive>ErrorLog</directive> permet de d&eacute;finir le
    nom du fichier dans lequel le serveur va journaliser toutes les
    erreurs qu'il rencontre. Si le <var>chemin fichier</var> n'est pas
    absolu, il est consid&eacute;r&eacute; comme relatif au chemin d&eacute;fini par la
    directive <directive module="core">ServerRoot</directive>.</p>

    <highlight language="config">ErrorLog "/var/log/httpd/error_log"</highlight>

    <p>Si le <var>chemin fichier</var> commence par une barre verticale
    "<code>(|)</code>", il est consid&eacute;r&eacute; comme une commande &agrave; lancer pour traiter la
    journalisation de l'erreur.</p>

    <highlight language="config">ErrorLog "|/usr/local/bin/httpd_errors"</highlight>

    <p>Voir les notes &agrave; propos des <a href="../logs.html#piped">journaux
    redirig&eacute;s</a> pour plus d'informations.</p>

    <p>L'utilisation de <code>syslog</code> &agrave; la place d'un nom de
    fichier active la journalisation via syslogd(8) si le syst&egrave;me le
    supporte. Le dispositif syslog par d&eacute;faut est <code>local7</code>,
    mais vous pouvez le modifier &agrave; l'aide de la syntaxe
    <code>syslog:<var>facility</var></code>, o&ugrave; <var>facility</var> peut
    &ecirc;tre remplac&eacute; par un des noms habituellement document&eacute;s dans la page
    de man syslog(1). Le dispositif syslog <code>local7</code> est
    global, et si il est modifi&eacute; dans un serveur virtuel, le dispositif
    final sp&eacute;cifi&eacute; affecte l'ensemble du serveur</p>

    <highlight language="config">ErrorLog syslog:user</highlight>

    <p>SECURITE : Voir le document <a
    href="../misc/security_tips.html#serverroot">conseils &agrave; propos de
    s&eacute;curit&eacute;</a> pour des d&eacute;tails sur les raisons pour lesquelles votre
    s&eacute;curit&eacute; peut &ecirc;tre compromise si le r&eacute;pertoire contenant les
    fichiers journaux pr&eacute;sente des droits en &eacute;criture pour tout autre
    utilisateur que celui sous lequel le serveur est d&eacute;marr&eacute;.</p>
    <note type="warning"><title>Note</title>
      <p>Lors de la sp&eacute;cification d'un chemin de fichier sur les
      plates-formes non-Unix, on doit veiller &agrave; n'utiliser que des
      slashes (/), m&ecirc;me si la plate-forme autorise l'utilisation des
      anti-slashes (\). Et d'une mani&egrave;re g&eacute;n&eacute;rale, il est recommand&eacute; de
      n'utiliser que des slashes (/) dans les fichiers de
      configuration.</p>
    </note>
</usage>
<seealso><directive module="core">LogLevel</directive></seealso>
<seealso><a href="../logs.html">Fichiers journaux du serveur HTTP Apache</a></seealso>
</directivesynopsis>

<directivesynopsis>
<name>ErrorLogFormat</name>
<description>Sp&eacute;cification du format des entr&eacute;es du journal des erreurs</description>
<syntax> ErrorLogFormat [connection|request] <var>format</var></syntax>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>
<compatibility>Disponible depuis la version 2.3.9 d'Apache</compatibility>

<usage>
    <p>La directive <directive>ErrorLogFormat</directive> permet de
    sp&eacute;cifier quelles informations suppl&eacute;mentaires vont &ecirc;tre enregistr&eacute;es
    dans le journal des erreurs en plus du message habituel.</p>

    <highlight language="config">
# Exemple simple
ErrorLogFormat "[%t] [%l] [pid %P] %F: %E: [client %a] %M"
    </highlight>

    <p>La sp&eacute;cification de <code>connection</code> ou
    <code>request</code> comme premier param&egrave;tre permet de d&eacute;finir des
    formats suppl&eacute;mentaires, ce qui a pour effet de journaliser des
    informations additionnelles lorsque le premier message est
    enregistr&eacute; respectivement pour une connexion ou une requ&ecirc;te
    sp&eacute;cifique. Ces informations additionnelles ne sont enregistr&eacute;es
    qu'une seule fois par connexion/requ&ecirc;te. Si le traitement d'une
    connexion ou d'une requ&ecirc;te ne g&eacute;n&egrave;re aucun message dans le journal,
    alors aucune information additionnelle n'est enregistr&eacute;e.</p>

    <p>Il peut arriver que certains items de la cha&icirc;ne de format ne
    produisent aucune sortie. Par exemple, l'en-t&ecirc;te Referer n'est
    pr&eacute;sent que si le message du journal est associ&eacute; &agrave; une requ&ecirc;te et s'il
    est g&eacute;n&eacute;r&eacute; &agrave; un moment o&ugrave; l'en-t&ecirc;te Referer a d&eacute;j&agrave; &eacute;t&eacute; lu par le
    client. Si aucune sortie n'est g&eacute;n&eacute;r&eacute;e, le comportement par d&eacute;faut
    consiste &agrave; supprimer tout ce qui se trouve entre l'espace pr&eacute;c&eacute;dent
    et le suivant. Ceci implique que la ligne de journalisation est
    divis&eacute;e en champs ne contenant pas d'espace s&eacute;par&eacute;s par des espaces.
    Si un item de la cha&icirc;ne de format ne g&eacute;n&egrave;re aucune sortie,
    l'ensemble du champ est omis. Par exemple, si l'adresse distante
    <code>%a</code> du format <code>[%t] [%l] [%a] %M&nbsp;</code> n'est
    pas disponible, les crochets qui l'entourent ne seront eux-m&ecirc;mes pas
    enregistr&eacute;s. Il est possible d'&eacute;chapper les espaces par un anti-slash
    afin qu'ils ne soient pas consid&eacute;r&eacute;s comme s&eacute;parateurs de champs.
    La combinaison '%&nbsp;' (pourcentage espace) est un d&eacute;limiteur de
    champ de taille nulle qui ne g&eacute;n&egrave;re aucune sortie.</p>

    <p>Ce comportement peut &ecirc;tre chang&eacute; en ajoutant des modificateurs &agrave;
    l'item de la cha&icirc;ne de format. Le modificateur <code>-</code>
    (moins) provoque l'enregistrement d'un signe moins si l'item
    consid&eacute;r&eacute; ne g&eacute;n&egrave;re aucune sortie. Pour les formats &agrave; enregistrement
    unique par connexion/requ&ecirc;te, il est aussi possible d'utiliser le
    modificateur <code>+</code> (plus). Si un item ne g&eacute;n&eacute;rant aucune
    sortie poss&egrave;de le modificateur plus, la ligne dans son ensemble est
    omise.</p>

    <p>Un modificateur de type entier permet d'assigner un niveau de
    s&eacute;v&eacute;rit&eacute; &agrave; un item de format. L'item consid&eacute;r&eacute; ne
    sera journalis&eacute; que si la s&eacute;v&eacute;rit&eacute; du message n'est pas
    plus haute que le niveau de s&eacute;v&eacute;rit&eacute; sp&eacute;cifi&eacute;. Les
    valeurs possibles vont de 1 (alert) &agrave; 15 (trace8), en passant par 4
    (warn) ou 7 (debug).</p>

    <p>Par exemple, voici ce qui arriverait si vous ajoutiez des
    modificateurs &agrave; l'item <code>%{Referer}i</code> qui enregistre le
    contenu de l'en-t&ecirc;te <code>Referer</code>.</p>

    <table border="1" style="zebra">
    <columnspec><column width=".3"/><column width=".7"/></columnspec>

    <tr><th>Item modifi&eacute;</th><th>Signification</th></tr>

    <tr>
    <td><code>%-{Referer}i</code></td>
    <td>Enregistre le caract&egrave;re <code>-</code> si l'en-t&ecirc;te
    <code>Referer</code> n'est pas d&eacute;fini.</td>
    </tr>

    <tr>
    <td><code>%+{Referer}i</code></td>
    <td>N'enregistre rien si l'en-t&ecirc;te
    <code>Referer</code> n'est pas d&eacute;fini.</td>
    </tr>

    <tr>
    <td><code>%4{Referer}i</code></td>
    <td>N'enregistre le contenu de l'en-t&ecirc;te <code>Referer</code> que si
    la s&eacute;v&eacute;rit&eacute; du message de journalisation est sup&eacute;rieure &agrave; 4.</td>
    </tr>

    </table>

    <p>Certains items de format acceptent des param&egrave;tres suppl&eacute;mentaires
    entre accolades.</p>

    <table border="1" style="zebra">
    <columnspec><column width=".2"/><column width=".8"/></columnspec>

    <tr><th>Cha&icirc;ne&nbsp;de&nbsp;format</th> <th>Description</th></tr>

    <tr><td><code>%%</code></td>
        <td>Le signe pourcentage</td></tr>

    <tr><td><code>%a</code></td>
        <td>Adresse IP et port clients</td></tr>

    <tr><td><code>%{c}a</code></td>
        <td>Port et adresse IP sous-jacents du correspondant pour la
	connexion (voir le module
	<module>mod_remoteip</module>)</td></tr>

    <tr><td><code>%A</code></td>
        <td>Adresse IP et port locaux</td></tr>

    <tr><td><code>%{<em>name</em>}e</code></td>
        <td>Variable d'environnement de requ&ecirc;te <em>name</em></td></tr>

    <tr><td><code>%E</code></td>
        <td>Etat d'erreur APR/OS et cha&icirc;ne</td></tr>

    <tr><td><code>%F</code></td>
        <td>Nom du fichier source et num&eacute;ro de ligne de l'appel du
	journal</td></tr>

    <tr><td><code>%{<em>name</em>}i</code></td>
        <td>En-t&ecirc;te de requ&ecirc;te <em>name</em></td></tr>

    <tr><td><code>%k</code></td>
        <td>Nombre de requ&ecirc;tes persistantes pour cette connexion</td></tr>

    <tr><td><code>%l</code></td>
        <td>S&eacute;v&eacute;rit&eacute; du message</td></tr>

    <tr><td><code>%L</code></td>
        <td>Identifiant journal de la requ&ecirc;te</td></tr>

    <tr><td><code>%{c}L</code></td>
        <td>Identifiant journal de la connexion</td></tr>

    <tr><td><code>%{C}L</code></td>
        <td>Identifiant journal de la connexion si utilis&eacute; dans la
	port&eacute;e de la connexion, vide sinon</td></tr>

    <tr><td><code>%m</code></td>
        <td>Nom du module qui effectue la journalisation du message</td></tr>

    <tr><td><code>%M</code></td>
        <td>Le message effectif</td></tr>

    <tr><td><code>%{<em>name</em>}n</code></td>
        <td>Note de requ&ecirc;te <em>name</em></td></tr>

    <tr><td><code>%P</code></td>
        <td>Identifiant du processus courant</td></tr>

    <tr><td><code>%T</code></td>
        <td>Identifiant du thread courant</td></tr>

    <tr><td><code>%{g}T</code></td>
        <td>Identifiant unique de thread syst&egrave;me du thread courant
	(l'identifiant affich&eacute; par la commande <code>top</code> par
	exemple ; seulement sous Linux pour l'instant)</td></tr>

    <tr><td><code>%t</code></td>
        <td>L'heure courante</td></tr>

    <tr><td><code>%{u}t</code></td>
        <td>L'heure courante avec les microsecondes</td></tr>

    <tr><td><code>%{cu}t</code></td>
        <td>L'heure courante au format compact ISO 8601, avec les
	microsecondes</td></tr>

    <tr><td><code>%v</code></td>
        <td>Le nom de serveur canonique <directive
	module="core">ServerName</directive> du serveur courant.</td></tr>

    <tr><td><code>%V</code></td>
        <td>Le nom de serveur du serveur qui sert la requ&ecirc;te en accord
	avec la d&eacute;finition de la directive <directive module="core"
	>UseCanonicalName</directive>.</td></tr>

    <tr><td><code>\&nbsp;</code> (anti-slash espace)</td>
        <td>Espace non d&eacute;limiteur</td></tr>

    <tr><td><code>%&nbsp;</code> (pourcentage espace)</td>
        <td>D&eacute;limiteur de champ (aucune sortie)</td></tr>
    </table>

    <p>L'item de format identifiant journal <code>%L</code> g&eacute;n&egrave;re un
    identifiant unique pour une connexion ou une requ&ecirc;te. Il peut servir
    &agrave; d&eacute;terminer quelles lignes correspondent &agrave; la m&ecirc;me connexion ou
    requ&ecirc;te ou quelle requ&ecirc;te est associ&eacute;e &agrave; tel connexion. Un item de
    format <code>%L</code> est aussi disponible dans le module
    <module>mod_log_config</module>, mais il permet dans ce contexte de
    corr&eacute;ler les entr&eacute;es du journal des acc&egrave;s avec celles du journal des
    erreurs. Si le module <module>mod_unique_id</module> est charg&eacute;,
    c'est son identifiant unique qui sera utilis&eacute; comme identifiant de
    journal pour les requ&ecirc;tes.</p>

    <highlight language="config">
# Exemple (format par d&eacute;faut pour les MPMs thread&eacute;s)
ErrorLogFormat "[%{u}t] [%-m:%l] [pid %P:tid %T] %7F: %E: [client\ %a] %M%&nbsp;,\&nbsp;referer\&nbsp;%{Referer}i"
    </highlight>

    <p>Cet exemple renverrait un message d'erreur du style :</p>

    <example>
    [Thu May 12 08:28:57.652118 2011] [core:error] [pid 8777:tid 4326490112] [client ::1:58619] File does not exist: /usr/local/apache2/htdocs/favicon.ico
    </example>

    <p>Notez que, comme indiqu&eacute; plus haut, certains champs sont
    totalement supprim&eacute;s s'ils n'ont pas &eacute;t&eacute; d&eacute;finis.</p>

    <highlight language="config">
# Exemple (similaire au format 2.2.x)
ErrorLogFormat "[%t] [%l] %7F: %E: [client\ %a] %M%&nbsp;,\&nbsp;referer\&nbsp;%{Referer}i"
    </highlight>

    <highlight language="config">
# Exemple avanc&eacute; avec identifiants journal de requ&ecirc;te/connexion
ErrorLogFormat "[%{uc}t] [%-m:%-l] [R:%L] [C:%{C}L] %7F: %E: %M"
ErrorLogFormat request "[%{uc}t] [R:%L] Request %k on C:%{c}L pid:%P tid:%T"
ErrorLogFormat request "[%{uc}t] [R:%L] UA:'%+{User-Agent}i'"
ErrorLogFormat request "[%{uc}t] [R:%L] Referer:'%+{Referer}i'"
ErrorLogFormat connection "[%{uc}t] [C:%{c}L] local\ %a remote\ %A"
    </highlight>

</usage>
<seealso><directive module="core">ErrorLog</directive></seealso>
<seealso><directive module="core">LogLevel</directive></seealso>
<seealso><a href="../logs.html">Fichiers journaux du serveur HTTP Apache</a></seealso>
</directivesynopsis>

<directivesynopsis>
<name>ExtendedStatus</name>
<description>Extrait des informations d'&eacute;tat &eacute;tendues pour chaque
requ&ecirc;te</description>
<syntax>ExtendedStatus On|Off</syntax>
<default>ExtendedStatus Off</default>
<contextlist><context>server config</context></contextlist>

<usage>

	<p>Cette option permet d'extraire des donn&eacute;es suppl&eacute;mentaires
	concernant la requ&ecirc;te en cours de traitement pour un processus
	donn&eacute;, ainsi qu'un r&eacute;sum&eacute; d'utilisation ; vous pouvez acc&eacute;der &agrave;
	ces variables pendant l'ex&eacute;cution en configurant
	<module>mod_status</module>. Notez que d'autres modules sont
	susceptibles de s'appuyer sur ce tableau de bord.</p>

    <p>Cette directive s'applique au serveur dans son ensemble, et ne
    peut pas &ecirc;tre activ&eacute;e/d&eacute;sactiv&eacute;e pour un serveur virtuel
    particulier. Notez que l'extraction des informations d'&eacute;tat &eacute;tendues
    peut ralentir le serveur. Notez aussi que cette d&eacute;finition ne peut
    pas &ecirc;tre modifi&eacute;e au cours d'un red&eacute;marrage graceful.</p>

    <note>
    <p>Notez que le chargement de <module>mod_status</module> d&eacute;finit
    automatiquement ExtendedStatus &agrave; On, et que d'autres modules tiers
    sont susceptibles d'en faire de m&ecirc;me. De tels modules ont besoin
    d'informations d&eacute;taill&eacute;es &agrave; propos de l'&eacute;tat de tous les processus.
    Depuis la version 2.3.6, <module>mod_status</module> a d&eacute;finit la
    valeur par d&eacute;faut &agrave; On, alors qu'elle &eacute;tait &agrave; Off dans les versions
    ant&eacute;rieures.</p>
    </note>

</usage>

</directivesynopsis>

<directivesynopsis>
<name>FileETag</name>
<description>Caract&eacute;ristiques de fichier utilis&eacute;es lors de la g&eacute;n&eacute;ration
de l'en-t&ecirc;te de r&eacute;ponse HTTP ETag pour les fichiers statiques</description>
<syntax>FileETag <var>composant</var> ...</syntax>
<default>FileETag MTime Size</default>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>FileInfo</override>
<compatibility>La valeur par d&eacute;faut &eacute;tait "INode&nbsp;MTime&nbsp;Size"
dans les versions 2.3.14 et ant&eacute;rieures.</compatibility>

<usage>
    <p>
    La directive <directive>FileETag</directive> d&eacute;finit les
    caract&eacute;ristiques de fichier utilis&eacute;es lors de la g&eacute;n&eacute;ration de
    l'en-t&ecirc;te de r&eacute;ponse HTTP <code>ETag</code> (entity tag) quand le
    document est contenu dans un fichier statique(la valeur de
    <code>ETag</code>
    est utilis&eacute;e dans le cadre de la gestion du cache pour pr&eacute;server la
    bande passante r&eacute;seau). La directive
    <directive>FileETag</directive> vous permet maintenant de choisir
    quelles caract&eacute;ristiques du fichier vont &ecirc;tre utilis&eacute;es, le cas
    &eacute;ch&eacute;ant. Les mots-cl&eacute;s reconnus sont :
    </p>

    <dl>
     <dt><strong>INode</strong></dt>
     <dd>Le num&eacute;ro d'i-node du fichier sera inclus dans le processus de
     g&eacute;n&eacute;ration</dd>
     <dt><strong>MTime</strong></dt>
     <dd>La date et l'heure auxquelles le fichier a &eacute;t&eacute; modifi&eacute; la
     derni&egrave;re fois seront incluses</dd>
     <dt><strong>Size</strong></dt>
     <dd>La taille du fichier en octets sera incluse</dd>
     <dt><strong>All</strong></dt>
     <dd>Tous les champs disponibles seront utilis&eacute;s. Cette d&eacute;finition
     est &eacute;quivalente &agrave; : 
     <highlight language="config">FileETag INode MTime Size</highlight></dd>
     <dt><strong>None</strong></dt>
     <dd>Si le document se compose d'un fichier, aucun champ
     <code>ETag</code> ne sera inclus dans la r&eacute;ponse</dd>
    </dl>

    <p>Les mots-cl&eacute;s <code>INode</code>, <code>MTime</code>, et
    <code>Size</code> peuvent &ecirc;tre pr&eacute;fix&eacute;s par <code>+</code> ou
    <code>-</code>, ce qui permet de modifier les valeurs par d&eacute;faut
    h&eacute;rit&eacute;es d'un niveau de configuration plus g&eacute;n&eacute;ral. Tout mot-cl&eacute;
    apparaissant sans aucun pr&eacute;fixe annule enti&egrave;rement et imm&eacute;diatement
    les configurations h&eacute;rit&eacute;es.</p>

    <p>Si la configuration d'un r&eacute;pertoire contient
    <code>FileETag&nbsp;INode&nbsp;MTime&nbsp;Size</code>, et si un de
    ses sous-r&eacute;pertoires contient <code>FileETag&nbsp;-INode</code>, la
    configuration de ce sous-r&eacute;pertoire (qui sera propag&eacute;e vers tout
    sous-r&eacute;pertoire qui ne la supplante pas), sera &eacute;quivalente &agrave;
    <code>FileETag&nbsp;MTime&nbsp;Size</code>.</p>
    <note type="warning"><title>Avertissement</title>
    Ne modifiez pas les valeurs par d&eacute;faut pour les r&eacute;pertoires ou
    localisations o&ugrave; WebDAV est activ&eacute; et qui utilisent
    <module>mod_dav_fs</module> comme fournisseur de stockage.
    <module>mod_dav_fs</module> utilise
    <code>MTime&nbsp;Size</code> comme format fixe pour les
    comparaisons de champs <code>ETag</code> dans les requ&ecirc;tes
    conditionnelles. Ces requ&ecirc;tes conditionnelles &eacute;choueront si le
    format <code>ETag</code> est modifi&eacute; via la directive
    <directive>FileETag</directive>.
    </note>
    <note><title>Inclusions c&ocirc;t&eacute; serveur</title>
    Aucun champ ETag n'est g&eacute;n&eacute;r&eacute; pour les r&eacute;ponses interpr&eacute;t&eacute;es par
    <module>mod_include</module>, car l'entit&eacute; de la r&eacute;ponse peut
    changer sans modification de l'INode, du MTime, ou de la taille du
    fichier statique contenant les directives SSI.
    </note>


</usage>
</directivesynopsis>

<directivesynopsis type="section">
<name>Files</name>
<description>Contient des directives qui s'appliquent aux fichiers
pr&eacute;cis&eacute;s</description>
<syntax>&lt;Files <var>nom fichier</var>&gt; ... &lt;/Files&gt;</syntax>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>All</override>

<usage>
    <p>La directive <directive type="section">Files</directive> limite
    la port&eacute;e des directives qu'elle contient aux fichiers pr&eacute;cis&eacute;s.
    Elle est comparable aux directives <directive module="core"
    type="section">Directory</directive> et <directive module="core"
    type="section">Location</directive>. Elle doit se terminer par une
    balise <code>&lt;/Files&gt;</code>. Les directives contenues dans
    cette section s'appliqueront &agrave; tout objet dont le nom de base (la
    derni&egrave;re partie du nom de fichier) correspond au fichier sp&eacute;cifi&eacute;.
    Les sections <directive type="section">Files</directive> sont
    trait&eacute;es selon l'ordre dans lequel elles apparaissent dans le
    fichier de configuration, apr&egrave;s les sections <directive module="core"
    type="section">Directory</directive> et la lecture des fichiers
    <code>.htaccess</code>, mais avant les sections <directive
    type="section" module="core">Location</directive>. Notez que les
    sections <directive type="section">Files</directive> peuvent &ecirc;tre
    imbriqu&eacute;es dans les sections <directive type="section"
    module="core">Directory</directive> afin de restreindre la portion
    du syst&egrave;me de fichiers &agrave; laquelle ces derni&egrave;res vont
    s'appliquer.</p>

    <p>L'argument <var>filename</var> peut contenir un nom de fichier
    ou une cha&icirc;ne de caract&egrave;res avec caract&egrave;res g&eacute;n&eacute;riques, o&ugrave;
    <code>?</code> remplace un caract&egrave;re, et <code>*</code> toute cha&icirc;ne
    de caract&egrave;res.</p>
    <highlight language="config">
&lt;Files "cat.html"&gt;
    # Ins&eacute;rer ici des directives qui s'appliquent au fichier cat.html
&lt;/Files&gt;

&lt;Files "?at.*"&gt;
    # Les directives ins&eacute;r&eacute;es ici s'appliqueront aux fichiers
    # cat.html, bat.html, hat.php, et ainsi de suite.
&lt;/Files&gt;
</highlight>
    
    <p>On peut aussi utiliser les <glossary
    ref="regex">Expressions rationnelles</glossary> en ajoutant la
    caract&egrave;re <code>~</code>. Par exemple :</p>

    <highlight language="config">
&lt;Files ~ "\.(gif|jpe?g|png)$"&gt;
    #...
&lt;/Files&gt;
</highlight>

    <p>correspondrait &agrave; la plupart des formats graphiques de l'Internet.
    Il est cependant pr&eacute;f&eacute;rable d'utiliser la directive <directive
    module="core" type="section">FilesMatch</directive>.</p>

    <p>Notez qu'&agrave; la diff&eacute;rence des sections <directive type="section"
    module="core">Directory</directive> et <directive type="section"
    module="core">Location</directive>, les sections <directive
    type="section">Files</directive> peuvent &ecirc;tre utilis&eacute;es dans les
    fichiers <code>.htaccess</code>. Ceci permet aux utilisateurs de
    contr&ocirc;ler l'acc&egrave;s &agrave; leurs propres ressources, fichier par
    fichier.</p>

</usage>
<seealso><a href="../sections.html">Comment fonctionnent les sections
&lt;Directory&gt;, &lt;Location&gt; et &lt;Files&gt;</a> pour une
explication de la mani&egrave;re dont ces diff&eacute;rentes sections se combinent
entre elles &agrave; la r&eacute;ception d'une requ&ecirc;te</seealso>
</directivesynopsis>

<directivesynopsis type="section">
<name>FilesMatch</name>
<description>Contient des directives qui s'appliquent &agrave; des fichiers
sp&eacute;cifi&eacute;s sous la forme d'expressions rationnelles</description>
<syntax>&lt;FilesMatch <var>expression rationnelle</var>&gt; ...
&lt;/FilesMatch&gt;</syntax>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>All</override>

<usage>
    <p>La section <directive type="section">FilesMatch</directive>
    limite la port&eacute;e des directives qu'elle contient aux fichiers
    sp&eacute;cifi&eacute;s, tout comme le ferait une section <directive module="core"
    type="section">Files</directive>. Mais elle accepte aussi les
    <glossary ref="regex">expressions rationnelles</glossary>. Par
    exemple :</p>

    <highlight language="config">
&lt;FilesMatch "\.(gif|jpe?g|png)$"&gt;
    # ...
&lt;/FilesMatch&gt;
</highlight>

    <p>correspondrait &agrave; la plupart des formats graphiques de
    l'Internet.</p>
</usage>

<seealso><a href="../sections.html">Comment fonctionnent les sections
&lt;Directory&gt;, &lt;Location&gt; et &lt;Files&gt;</a> pour une
explication de la mani&egrave;re dont ces diff&eacute;rentes sections se combinent
entre elles &agrave; la r&eacute;ception d'une requ&ecirc;te</seealso>
</directivesynopsis>

<directivesynopsis>
<name>ForceType</name>
<description>Force le type de m&eacute;dium sp&eacute;cifi&eacute; dans le champ d'en-t&ecirc;te
HTTP Content-Type pour les fichiers correspondants</description>
<syntax>ForceType <var>type m&eacute;dium</var>|None</syntax>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>FileInfo</override>

<usage>
    <p>Lorsqu'elle est plac&eacute;e dans un fichier <code>.htaccess</code> ou
    une section <directive type="section"
    module="core">Directory</directive>, <directive type="section"
    module="core">Location</directive>, ou <directive type="section"
    module="core">Files</directive>, cette directive force
    l'identification du type MIME des fichiers sp&eacute;cifi&eacute;s &agrave; la valeur de
    l'argument <var>type m&eacute;dium</var>. Par exemple, si vous poss&eacute;dez un
    r&eacute;pertoire ne contenant que des fichiers GIF, et si vous ne voulez
    pas leur ajouter l'extension <code>.gif</code>, vous pouvez utiliser
    :</p>

    <highlight language="config">ForceType image/gif</highlight>

    <p>Notez que cette directive l'emporte sur d'autres associations de
    type de m&eacute;dium indirectes d&eacute;finies dans mime.types ou via la
    directive <directive module="mod_mime">AddType</directive>.</p>

    <p>Vous pouvez aussi annuler toute d&eacute;finition plus g&eacute;n&eacute;rale de
    <directive>ForceType</directive> en affectant la valeur
    <code>None</code> &agrave; l'argument <var>type m&eacute;dium</var> :</p>

    <highlight language="config">
# force le type MIME de tous les fichiers &agrave; image/gif:
&lt;Location /images&gt;
  ForceType image/gif
&lt;/Location&gt;

# mais utilise les m&eacute;thodes classiques d'attribution du type MIME
# dans le sous-r&eacute;pertoire suivant :
&lt;Location /images/mixed&gt;
  ForceType None
&lt;/Location&gt;
    </highlight>
    
    <p>A la base, cette directive &eacute;crase le type de contenu g&eacute;n&eacute;r&eacute; pour
    les fichiers statiques servis &agrave; partir du syt&egrave;me de fichiers. Pour
    les ressources autres que les fichiers statiques pour lesquels le
    g&eacute;n&eacute;rateur de r&eacute;ponse sp&eacute;cifie en g&eacute;n&eacute;ral un type de contenu, cette
    directive est ignor&eacute;e.</p>

</usage>
</directivesynopsis>
<directivesynopsis>
<name>GprofDir</name>
<description>R&eacute;pertoire dans lequel &eacute;crire les donn&eacute;es de profiling
gmon.out.</description>
<syntax>GprofDir <var>/tmp/gprof/</var>|<var>/tmp/gprof/</var>%</syntax>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
    <p>Lorsque le serveur a &eacute;t&eacute; compil&eacute; avec le support du profiling
    gprof, la directive <directive>GprofDir</directive> permet de
    sp&eacute;cifier dans quel r&eacute;pertoire les fichiers <code>gmon.out</code>
    doivent &ecirc;tre &eacute;crits lorsque le processus s'arr&ecirc;te. Si l'argument se
    termine par un caract&egrave;re pourcentage ('%'), des sous-r&eacute;pertoires
    sont cr&eacute;&eacute;s pour chaque identifiant de processus.</p>

    <p>Cette directive ne fonctionne actuellement qu'avec le MPM
    <module>prefork</module>.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>HostnameLookups</name>
<description>Active la recherche DNS sur les adresses IP des
clients</description>
<syntax>HostnameLookups On|Off|Double</syntax>
<default>HostnameLookups Off</default>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context></contextlist>

<usage>
    <p>Cette directive active la recherche DNS afin de pouvoir
    journaliser les nom d'h&ocirc;tes (et les passer aux programmes CGI et aux
    inclusions SSI via la variable <code>REMOTE_HOST</code>). La valeur
    <code>Double</code> d&eacute;clenche une double recherche DNS inverse. En
    d'autres termes, une fois la recherche inverse effectu&eacute;e, on lance
    une recherche directe sur le r&eacute;sultat de cette derni&egrave;re. Au moins
    une des adresses IP fournies par la recherche directe doit
    correspondre &agrave; l'adresse originale (ce que l'on nomme
    <code>PARANOID</code> dans la terminologie "tcpwrappers").</p>

    <p>Quelle que soit la configuration, lorsqu'on utilise
    <module>mod_authz_host</module> pour contr&ocirc;ler l'acc&egrave;s en fonction
    du nom d'h&ocirc;te, une double recherche DNS inverse est effectu&eacute;e,
    s&eacute;curit&eacute; oblige. Notez cependant que le r&eacute;sultat de cette double
    recherche n'est en g&eacute;n&eacute;ral pas accessible, &agrave; moins que vous n'ayez
    sp&eacute;cifi&eacute; <code>HostnameLookups Double</code>. Par exemple, si vous
    n'avez sp&eacute;cifi&eacute; que <code>HostnameLookups On</code>, et si une
    requ&ecirc;te concerne un objet prot&eacute;g&eacute; par des restrictions en fonction
    du nom d'h&ocirc;te, quel que soit le r&eacute;sultat de la double recherche
    inverse, les programmes CGI ne recevront que le r&eacute;sultat de la
    recherche inverse simple dans la variable
    <code>REMOTE_HOST</code>.</p>

    <p>La valeur par d&eacute;faut est <code>Off</code> afin de pr&eacute;server le
    traffic r&eacute;seau des sites pour lesquels la recherche inverse n'est
    pas vraiment n&eacute;cessaire. Cette valeur par d&eacute;faut est aussi b&eacute;n&eacute;fique
    pour les utilisateurs finaux car il n'ont ainsi pas &agrave; subir de temps
    d'attente suppl&eacute;mentaires dus aux recherches DNS. Les sites
    fortement charg&eacute;s devraient laisser cette directive &agrave;
    <code>Off</code>, car les recherches DNS peuvent prendre des temps
    tr&egrave;s longs. Vous pouvez &eacute;ventuellement utiliser hors ligne
    l'utilitaire <program>logresolve</program>, compil&eacute; par d&eacute;faut dans
    le sous-r&eacute;pertoire <code>bin</code> de votre r&eacute;pertoire
    d'installation, afin de d&eacute;terminer les noms d'h&ocirc;tes associ&eacute;s aux
    adresses IP journalis&eacute;es.</p>

    <p>Enfin, si vous avez des <a
    href="mod_authz_host.html#reqhost">directives Require &agrave; base de
    nom</a>, une recherche de nom d'h&ocirc;te sera effectu&eacute;e quelle que soit
    la d&eacute;finition de la directive <code>HostnameLookups</code>.</p>
</usage>
</directivesynopsis>

<directivesynopsis type="section">
<name>If</name>
<description>Contient des directives qui ne s'appliquent que si une
condition est satisfaite au cours du traitement d'une
requ&ecirc;te</description>
<syntax>&lt;If <var>expression</var>&gt; ... &lt;/If&gt;</syntax>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>All</override>

<usage>
    <p>La directive <directive type="section">If</directive> &eacute;value une
    expression &agrave; la vol&eacute;e, et applique les directives qu'elle contient
    si et seulement si l'expression renvoie la valeur "vrai". Par
    exemple :</p>

    <highlight language="config">&lt;If "-z req('Host')"&gt;</highlight>

    <p>serait satisfaite pour les requ&ecirc;tes HTTP/1.0 sans en-t&ecirc;te
    <var>Host:</var>. Les expressions peuvent contenir diff&eacute;rents
    op&eacute;rateurs de type shell pour la comparaison de cha&icirc;nes
    (<code>=</code>, <code>!=</code>, <code>&lt;</code>, ...), la
    comparaison d'entiers (<code>-eq</code>, <code>-ne</code>, ...), ou
    &agrave; usages divers (<code>-n</code>, <code>-z</code>, <code>-f</code>,
    ...). Les expressions rationnelles sont aussi support&eacute;es,</p>

    <highlight language="config">&lt;If "%{QUERY_STRING} =~ /(delete|commit)=.*?elem/"&gt;</highlight>

    <p>ainsi que les comparaison de mod&egrave;les de type shell et de
    nombreuses autres op&eacute;rations. Ces op&eacute;rations peuvent &ecirc;tre effectu&eacute;es
    sur les en-t&ecirc;tes de requ&ecirc;tes (<code>req</code>), les variables
    d'environnement (<code>env</code>), et un grand nombre d'autres
    propri&eacute;t&eacute;s. La documentation compl&egrave;te est disponible dans <a
    href="../expr.html">Les expressions dans le serveur HTTP Apache</a>.</p>

</usage>

<seealso><a href="../expr.html">Les expressions dans le serveur HTTP
Apache</a>, pour une r&eacute;f&eacute;rence compl&egrave;te et d'autres exemples.</seealso>
<seealso><directive type="section" module="core">ElseIf</directive></seealso>
<seealso><directive type="section" module="core">Else</directive></seealso>
<seealso><a href="../sections.html">Comment fonctionnent les sections
&lt;Directory&gt;, &lt;Location&gt; et &lt;Files&gt;</a> pour une
explication de la mani&egrave;re dont ces diff&eacute;rentes sections se combinent
entre elles &agrave; la r&eacute;ception d'une requ&ecirc;te. Les
directives <directive type="section">If</directive>, <directive
type="section">ElseIf</directive>, et <directive
type="section">Else</directive> s'appliquent en dernier.</seealso>
</directivesynopsis>

<directivesynopsis type="section">
<name>IfDefine</name>
<description>Contient des directives qui ne s'appliqueront que si un
test retourne "vrai" au d&eacute;marrage du serveur</description>
<syntax>&lt;IfDefine [!]<var>param&egrave;tre</var>&gt; ...
    &lt;/IfDefine&gt;</syntax>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>All</override>

<usage>
    <p>La section <code>&lt;IfDefine
    <var>test</var>&gt;...&lt;/IfDefine&gt;</code> permet de
    conf&eacute;rer un caract&egrave;re conditionnel &agrave; un ensemble de directives. Les
    directives situ&eacute;es &agrave; l'int&eacute;rieur d'une section <directive
    type="section">IfDefine</directive> ne s'appliquent que si
    <var>test</var> est vrai. Si <var>test</var> est faux, tout ce qui
    se trouve entre les balises de d&eacute;but et de fin est ignor&eacute;.</p>

    <p><var>test</var> peut se pr&eacute;senter sous deux formes :</p>

    <ul>
      <li><var>nom param&egrave;tre</var></li>

      <li><code>!</code><var>nom param&egrave;tre</var></li>
    </ul>

    <p>Dans le premier cas, les directives situ&eacute;es entre les balises de
    d&eacute;but et de fin ne s'appliqueront que si le param&egrave;tre nomm&eacute; <var>nom
    param&egrave;tre</var> est d&eacute;fini. Le second format inverse le test, et
    dans ce cas, les directives ne s'appliqueront que si <var>nom
    param&egrave;tre</var> n'est <strong>pas</strong> d&eacute;fini.</p>

    <p>L'argument <var>nom param&egrave;tre</var> est une d&eacute;finition qui peut
    &ecirc;tre effectu&eacute;e par la ligne de commande
    <program>httpd</program> via le param&egrave;tre
    <code>-D<var>param&egrave;tre</var></code> au d&eacute;marrage du serveur, ou via la
    directive <directive module="core">Define</directive>.</p>

    <p>Les sections <directive type="section">IfDefine</directive>
    peuvent &ecirc;tre imbriqu&eacute;es, ce qui permet d'impl&eacute;menter un test
    multi-param&egrave;tres simple. Exemple :</p>

    <example>httpd -DReverseProxy -DUseCache -DMemCache ...</example>
    <highlight language="config">
&lt;IfDefine ReverseProxy&gt;
  LoadModule proxy_module   modules/mod_proxy.so
  LoadModule proxy_http_module   modules/mod_proxy_http.so
  &lt;IfDefine UseCache&gt;
    LoadModule cache_module   modules/mod_cache.so
    &lt;IfDefine MemCache&gt;
      LoadModule mem_cache_module   modules/mod_mem_cache.so
    &lt;/IfDefine&gt;
    &lt;IfDefine !MemCache&gt;
      LoadModule cache_disk_module   modules/mod_cache_disk.so
    &lt;/IfDefine&gt;
  &lt;/IfDefine&gt;
&lt;/IfDefine&gt;
    </highlight>
</usage>
</directivesynopsis>

<directivesynopsis type="section">
<name>IfModule</name>
<description>Contient des directives qui ne s'appliquent qu'en fonction
de la pr&eacute;sence ou de l'absence d'un module sp&eacute;cifique</description>
<syntax>&lt;IfModule [!]<var>fichier module</var>|<var>identificateur
module</var>&gt; ... &lt;/IfModule&gt;</syntax>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>All</override>
<compatibility>Les identificateurs de modules sont disponibles dans les
versions 2.1 et sup&eacute;rieures.</compatibility>

<usage>
    <p>La section <code>&lt;IfModule
    <var>test</var>&gt;...&lt;/IfModule&gt;</code> permet de conf&eacute;rer &agrave;
    des directives un caract&egrave;re conditionnel bas&eacute; sur la pr&eacute;sence d'un
    module sp&eacute;cifique. Les directives situ&eacute;es dans une section
    <directive type="section">IfModule</directive> ne s'appliquent que
    si <var>test</var> est vrai. Si <var>test</var> est faux, tout ce
    qui se trouve entre les balises de d&eacute;but et de fin est ignor&eacute;.</p>

    <p><var>test</var> peut se pr&eacute;senter sous deux formes :</p>

    <ul>
      <li><var>module</var></li>

      <li>!<var>module</var></li>
    </ul>

    <p>Dans le premier cas, les directives situ&eacute;es entre les balises de
    d&eacute;but et de fin ne s'appliquent que si le module <var>module</var>
    est pr&eacute;sent -- soit compil&eacute; avec le binaire Apache httpd, soit charg&eacute;
    dynamiquement via la directive <directive module="mod_so"
    >LoadModule</directive>. Le second format inverse le test, et dans
    ce cas, les directives ne s'appliquent que si <var>module</var>
    n'est <strong>pas</strong> pr&eacute;sent.</p>

    <p>L'argument <var>module</var> peut contenir soit l'identificateur
    du module, soit le nom du fichier source du module. Par exemple,
    <code>rewrite_module</code> est un identificateur et
    <code>mod_rewrite.c</code> le nom du fichier source
    correspondant. Si un module comporte plusieurs fichiers sources,
    utilisez le nom du fichier qui contient la cha&icirc;ne de caract&egrave;res
    <code>STANDARD20_MODULE_STUFF</code>.</p>

    <p>Les sections <directive type="section">IfModule</directive>
    peuvent &ecirc;tre imbriqu&eacute;es, ce qui permet d'impl&eacute;menter des tests
    multi-modules simples.</p>

    <note>Cette section ne doit &ecirc;tre utilis&eacute;e que si votre fichier de
    configuration ne fonctionne qu'en fonction de la pr&eacute;sence ou de
    l'absence d'un module sp&eacute;cifique. D'une mani&egrave;re g&eacute;n&eacute;rale, il n'est
    pas n&eacute;cessaire de placer les directives &agrave; l'int&eacute;rieur de sections
    <directive type="section">IfModule</directive>.</note>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>Include</name>
<description>Inclut d'autres fichiers de configuration dans un des
fichiers de configuration du serveur</description>
<syntax>Include <var>chemin-fichier</var>|<var>chemin-r&eacute;pertoire</var>|<var>wildcard</var></syntax>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context>
</contextlist>
<compatibility>Utilisation des caract&egrave;res g&eacute;n&eacute;riques dans la partie chemin depuis la
version 2.3.6</compatibility>

<usage>
    <p>Cette directive permet l'inclusion d'autres fichiers de
    configuration dans un des fichiers de configuration du serveur.</p>

    <p>On peut utiliser des caract&egrave;res g&eacute;n&eacute;riques de style Shell
    (<code>fnmatch()</code>) aussi bien dans la partie nom de fichier du
    chemin que dans la partie r&eacute;pertoires pour inclure plusieurs
    fichiers en une
    seule fois, selon leur ordre alphab&eacute;tique. De plus, si la directive
    <directive>Include</directive> pointe vers un r&eacute;pertoire, Apache
    httpd inclura tous les fichiers de ce r&eacute;pertoire et de tous ces
    sous-r&eacute;pertoires. L'inclusion de r&eacute;pertoires entiers est cependant
    d&eacute;conseill&eacute;e, car il est fr&eacute;quent d'oublier des fichiers
    temporaires dans un r&eacute;pertoire, ce qui causerait une erreur
    <program>httpd</program> en cas d'inclusion. Pour inclure des
    fichiers qui correspondent &agrave; un certain mod&egrave;le, comme *.conf par
    exemple, nous vous recommandons d'utiliser plut&ocirc;t la syntaxe avec
    caract&egrave;res g&eacute;n&eacute;riques comme ci-dessous.</p>

    <p>La directive <directive module="core">Include</directive>
    <strong>&eacute;chouera avec un code d'erreur</strong> si une expression
   contenant des caract&egrave;res g&eacute;n&eacute;riques ne correspond &agrave; aucun fichier.
   Pour ignorer les expressions contenant des caract&egrave;res g&eacute;n&eacute;riques ne
   correspondant &agrave; aucun fichier, utilisez la directive <directive
   module="core">IncludeOptional</directive>.</p>

    <p>Le chemin fichier sp&eacute;cifi&eacute; peut &ecirc;tre soit un chemin absolu, soit
    un chemin relatif au r&eacute;pertoire d&eacute;fini par la directive <directive
    module="core">ServerRoot</directive>.</p>

    <p>Exemples :</p>

    <highlight language="config">
Include /usr/local/apache2/conf/ssl.conf
Include /usr/local/apache2/conf/vhosts/*.conf
    </highlight>

    <p>ou encore, avec des chemins relatifs au r&eacute;pertoire d&eacute;fini par la
    directive <directive module="core">ServerRoot</directive> :</p>

    <highlight language="config">
Include conf/ssl.conf
Include conf/vhosts/*.conf
    </highlight>

    <p>On peut aussi ins&eacute;rer des caract&egrave;res g&eacute;n&eacute;riques dans la partie
    r&eacute;pertoires du chemin. Dans l'exemple suivant, la directive
    &eacute;chouera si aucun sous-r&eacute;pertoire de conf/vhosts ne contient au
    moins un fichier *.conf :</p>
  
    <highlight language="config">Include conf/vhosts/*/*.conf</highlight>

    <p>Par contre, dans l'exemple suivant, la directive sera simplement
    ignor&eacute;e si aucun sous-r&eacute;pertoire de conf/vhosts ne contient au
    moins un fichier *.conf :</p>

    <highlight language="config">IncludeOptional conf/vhosts/*/*.conf</highlight>
  
</usage>    

<seealso><directive module="core">IncludeOptional</directive></seealso>
<seealso><program>apachectl</program></seealso>
</directivesynopsis>

<directivesynopsis>
<name>IncludeOptional</name>
<description>Inclusion de fichiers dans le fichier de configuration</description>
<syntax>IncludeOptional
<var>chemin-fichier</var>|<var>chemin-r&eacute;pertoire</var>|<var>wildcard</var></syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context>
</contextlist>
<compatibility>Disponible &agrave; partir de la version 2.3.6 du serveur HTTP
Apache</compatibility>
 
<usage>
    <p>Cette directive permet d'inclure des fichiers dans les fichiers
    de configuration du serveur. Elle fonctionne de mani&egrave;re identique &agrave;
    la directive <directive module="core">Include</directive>, &agrave;
    l'exception du fait que si l'expression avec caract&egrave;res g&eacute;n&eacute;riques
    wilcard ne correspond &agrave; aucun fichier ou r&eacute;pertoire, elle sera
    ignor&eacute;e silencieusement au lieu de causer une erreur.</p>    
    
</usage>

<seealso><directive module="core">Include</directive></seealso>
<seealso><program>apachectl</program></seealso>
</directivesynopsis>

<directivesynopsis>
<name>KeepAlive</name>
<description>Active les connexions HTTP persistantes</description>
<syntax>KeepAlive On|Off</syntax>
<default>KeepAlive On</default>
<contextlist><context>server config</context><context>virtual
host</context>
</contextlist>

<usage>
    <p>L'extension Keep-Alive de HTTP/1.0 et l'impl&eacute;mentation des
    connexions persistantes dans HTTP/1.1 ont rendu possibles des
    sessions HTTP de longue dur&eacute;e, ce qui permet de transmettre
    plusieurs requ&ecirc;tes via la m&ecirc;me connexion TCP. Dans certains cas, le
    gain en rapidit&eacute; pour des documents comportant de nombreuses images
    peut atteindre 50%. Pour activer les connexions persistantes,
    d&eacute;finissez <code>KeepAlive On</code>.</p>

    <p>Pour les clients HTTP/1.0, les connexions persistantes ne seront
    mises en oeuvre que si elles ont &eacute;t&eacute; sp&eacute;cialement demand&eacute;es par un
    client. De plus, une connexion persistante avec un client HTTP/1.0
    ne peut &ecirc;tre utilis&eacute;e que si la taille du contenu est connue
    d'avance. Ceci implique que les contenus dynamiques comme les
    sorties CGI, les pages SSI, et les listings de r&eacute;pertoires g&eacute;n&eacute;r&eacute;s
    par le serveur n'utiliseront en g&eacute;n&eacute;ral pas les connexions
    persistantes avec les clients HTTP/1.0. Avec les clients HTTP/1.1,
    les connexions persistantes sont utilis&eacute;es par d&eacute;faut, sauf
    instructions contraires. Si le client le demande, le transfert par
    tron&ccedil;ons de taille fixe (chunked encoding) sera utilis&eacute; afin de
    transmettre un contenu de longueur inconnue via une connexion
    persistante.</p>

    <p>Lorsqu'un client utilise une connexion persistante, elle comptera
    pour une seule requ&ecirc;te pour la directive <directive
    module="mpm_common">MaxConnectionsPerChild</directive>, quel
    que soit le nombre de requ&ecirc;tes transmises via cette connexion.</p>
</usage>

<seealso><directive module="core">MaxKeepAliveRequests</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>KeepAliveTimeout</name>
<description>Dur&eacute;e pendant laquelle le serveur va attendre une requ&ecirc;te
avant de fermer une connexion persistante</description>
<syntax>KeepAliveTimeout <var>nombre</var>[ms]</syntax>
<default>KeepAliveTimeout 5</default>
<contextlist><context>server config</context><context>virtual
host</context>
</contextlist>
<compatibility>La sp&eacute;cification d'une valeur en millisecondes est
possible depuis les versions 2.3.2 et sup&eacute;rieures d'Apache httpd</compatibility>

<usage>
    <p>Le nombre de secondes pendant lesquelles Apache httpd va attendre une
    requ&ecirc;te avant de fermer la connexion. Le d&eacute;lai peut &ecirc;tre d&eacute;fini en
    millisecondes en suffixant sa valeur par ms. La valeur du d&eacute;lai
    sp&eacute;cifi&eacute;e par la directive <directive
    module="core">Timeout</directive> s'applique d&egrave;s qu'une requ&ecirc;te a
    &eacute;t&eacute; re&ccedil;ue.</p>

    <p>Donner une valeur trop &eacute;l&eacute;v&eacute;e &agrave;
    <directive>KeepAliveTimeout</directive> peut induire des probl&egrave;mes
    de performances sur les serveurs fortement charg&eacute;s. Plus le d&eacute;lai
    est &eacute;l&eacute;v&eacute;, plus nombreux seront les processus serveur en attente de
    requ&ecirc;tes de la part de clients inactifs.</p>

    <p>Dans un contexte de serveur virtuel &agrave; base de nom, c'est
    la valeur de la paire adresse IP/port du serveur virtuel qui
    correspond le mieux qui sera utilis&eacute;e.</p>
</usage>
</directivesynopsis>

<directivesynopsis type="section">
<name>Limit</name>
<description>Limite les contr&ocirc;les d'acc&egrave;s que la section contient &agrave;
certaines m&eacute;thodes HTTP</description>
<syntax>&lt;Limit <var>m&eacute;thode</var> [<var>m&eacute;thode</var>] ... &gt; ...
    &lt;/Limit&gt;</syntax>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig, Limit</override>

<usage>
    <p>Les contr&ocirc;les d'acc&egrave;s s'appliquent normalement &agrave;
    <strong>toutes</strong> les m&eacute;thodes d'acc&egrave;s, et c'est en g&eacute;n&eacute;ral le
    comportement souhait&eacute;. <strong>Dans le cas g&eacute;n&eacute;ral, les directives
    de contr&ocirc;le d'acc&egrave;s n'ont pas &agrave; &ecirc;tre plac&eacute;es dans une section
    <directive type="section">Limit</directive>.</strong></p>

    <p>La directive <directive type="section">Limit</directive> a pour
    but de limiter les effets des contr&ocirc;les d'acc&egrave;s aux m&eacute;thodes HTTP
    sp&eacute;cifi&eacute;es. Pour toutes les autres m&eacute;thodes, les restrictions
    d'acc&egrave;s contenues dans la section <directive
    type="section">Limit</directive> <strong>n'auront aucun
    effet</strong>. L'exemple suivant n'applique les contr&ocirc;les d'acc&egrave;s
    qu'aux m&eacute;thodes <code>POST</code>, <code>PUT</code>, et
    <code>DELETE</code>, en laissant les autres m&eacute;thodes sans protection
    :</p>

    <highlight language="config">
&lt;Limit POST PUT DELETE&gt;
  Require valid-user
&lt;/Limit&gt;
    </highlight>

    <p>La liste des noms de m&eacute;thodes peut contenir une ou plusieurs
    valeurs parmi les suivantes : <code>GET</code>, <code>POST</code>,
    <code>PUT</code>, <code>DELETE</code>, <code>CONNECT</code>,
    <code>OPTIONS</code>, <code>PATCH</code>, <code>PROPFIND</code>,
    <code>PROPPATCH</code>, <code>MKCOL</code>, <code>COPY</code>,
    <code>MOVE</code>, <code>LOCK</code>, et <code>UNLOCK</code>.
    <strong>Le nom de m&eacute;thode est sensible &agrave; la casse.</strong> Si la
    valeur <code>GET</code> est pr&eacute;sente, les requ&ecirc;tes <code>HEAD</code>
    seront aussi concern&eacute;es. La m&eacute;thode <code>TRACE</code> ne peut pas
    &ecirc;tre limit&eacute;e (voir la directive <directive
    module="core">TraceEnable</directive>).</p>

    <note type="warning">Une section <directive
    type="section">LimitExcept</directive> doit toujours &ecirc;tre pr&eacute;f&eacute;r&eacute;e &agrave;
    une section <directive type="section">Limit</directive> pour la
    restriction d'acc&egrave;s, car une section <directive type="section"
    module="core">LimitExcept</directive> fournit une protection contre
    les m&eacute;thodes arbitraires.</note>

    <p>Les directives <directive type="section">Limit</directive> et
    <directive type="section" module="core">LimitExcept</directive>
    peuvent &ecirc;tre imbriqu&eacute;es. Dans ce cas, pour chaque niveau des
    directives <directive type="section">Limit</directive> ou  <directive
    type="section" module="core">LimitExcept</directive>, ces derni&egrave;res
    doivent restreindre l'acc&egrave;s pour les m&eacute;thodes auxquelles les
    contr&ocirc;les d'acc&egrave;s s'appliquent.</p>

    <note type="warning">Lorsqu'on utilise les directives <directive
    type="section">Limit</directive> ou <directive
    type="section">LimitExcept</directive> avec la directive <directive
    module="mod_authz_core">Require</directive>, la premi&egrave;re directive
    <directive module="mod_authz_core">Require</directive> dont la
    condition est satisfaite autorise la requ&ecirc;te, sans tenir compte de
    la pr&eacute;sence d'autres directives <directive
    module="mod_authz_core">Require</directive>.</note>

    <p>Par exemple, avec la configuration suivante, tous les
    utilisateurs seront autoris&eacute;s &agrave; effectuer des requ&ecirc;tes
    <code>POST</code>, et la directive <code>Require group
    editors</code> sera ignor&eacute;e dans tous les cas :</p>

    <highlight language="config">
&lt;LimitExcept GET&gt;
  Require valid-user
&lt;/LimitExcept&gt;
&lt;Limit POST&gt;
  Require group editors
&lt;/Limit&gt;
    </highlight>
</usage>
</directivesynopsis>

<directivesynopsis type="section">
<name>LimitExcept</name>
<description>Applique les contr&ocirc;les d'acc&egrave;s &agrave; toutes les m&eacute;thodes HTTP,
sauf celles qui sont sp&eacute;cifi&eacute;es</description>
<syntax>&lt;LimitExcept <var>m&eacute;thode</var> [<var>m&eacute;thode</var>] ... &gt; ...
    &lt;/LimitExcept&gt;</syntax>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig, Limit</override>

<usage>
    <p><directive type="section">LimitExcept</directive> et
    <code>&lt;/LimitExcept&gt;</code> permettent de regrouper des
    directives de contr&ocirc;le d'acc&egrave;s qui s'appliqueront &agrave; toutes les
    m&eacute;thodes d'acc&egrave;s HTTP qui ne font <strong>pas</strong> partie de la
    liste des arguments ; en d'autres termes, elles ont un comportement
    oppos&eacute; &agrave; celui de la section <directive type="section"
    module="core">Limit</directive>, et on peut les utiliser pour
    contr&ocirc;ler aussi bien les m&eacute;thodes standards que les m&eacute;thodes non
    standards ou non reconnues. Voir la documentation de la section
    <directive module="core" type="section">Limit</directive> pour plus
    de d&eacute;tails.</p>

    <p>Par exemple :</p>

    <highlight language="config">
&lt;LimitExcept POST GET&gt;
  Require valid-user
&lt;/LimitExcept&gt;
    </highlight>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>LimitInternalRecursion</name>
<description>D&eacute;termine le nombre maximal de redirections internes et de
sous-requ&ecirc;tes imbriqu&eacute;es</description>
<syntax>LimitInternalRecursion <var>nombre</var> [<var>nombre</var>]</syntax>
<default>LimitInternalRecursion 10</default>
<contextlist><context>server config</context><context>virtual
host</context>
</contextlist>

<usage>
    <p>Une redirection interne survient, par exemple, quand on utilise
    la directive <directive module="mod_actions">Action</directive> qui
    redirige en interne la requ&ecirc;te d'origine vers un script CGI. Une
    sous-requ&ecirc;te est le m&eacute;canisme qu'utilise Apache httpd pour d&eacute;terminer ce
    qui se passerait pour un URI s'il faisait l'objet d'une requ&ecirc;te. Par
    exemple, <module>mod_dir</module> utilise les sous-requ&ecirc;tes pour
    rechercher les fichiers list&eacute;s dans la directive <directive
    module="mod_dir">DirectoryIndex</directive>.</p>

    <p>La directive <directive>LimitInternalRecursion</directive> permet
    d'&eacute;viter un crash du serveur d&ucirc; &agrave; un bouclage infini de redirections
    internes ou de sous-requ&ecirc;tes. De tels bouclages sont dus en g&eacute;n&eacute;ral
    &agrave; des erreurs de configuration.</p>

    <p>La directive accepte, comme arguments, deux limites qui sont
    &eacute;valu&eacute;es &agrave; chaque requ&ecirc;te. Le premier <var>nombre</var> est le
    nombre maximum de redirections internes qui peuvent se succ&eacute;der. Le
    second <var>nombre</var> d&eacute;termine la profondeur d'imbrication
    maximum des sous-requ&ecirc;tes. Si vous ne sp&eacute;cifiez qu'un seul
    <var>nombre</var>, il sera affect&eacute; aux deux limites.</p>

    <highlight language="config">LimitInternalRecursion 5</highlight>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>LimitRequestBody</name>
<description>limite la taille maximale du corps de la requ&ecirc;te HTTP
envoy&eacute;e par le client</description>
<syntax>LimitRequestBody <var>octets</var></syntax>
<default>LimitRequestBody 0</default>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>All</override>

<usage>
    <p>Cette directive sp&eacute;cifie la taille maximale autoris&eacute;e pour le
    corps d'une requ&ecirc;te ; la valeur de l'argument <var>octets</var> va
    de 0 (pour une taille illimit&eacute;e), &agrave; 2147483647 (2Go). Voir la note
    ci-dessous pour la limite d'applicabilit&eacute; aux requ&ecirc;tes mandat&eacute;es.</p>

    <p>La directive <directive>LimitRequestBody</directive> permet de
    d&eacute;finir une limite pour la taille maximale autoris&eacute;e du corps d'une
    requ&ecirc;te HTTP en tenant compte du contexte dans lequel la directive
    a &eacute;t&eacute; plac&eacute;e (c'est &agrave; dire au niveau du serveur, d'un r&eacute;pertoire,
    d'un fichier ou d'une localisation). Si la requ&ecirc;te du client d&eacute;passe
    cette limite, le serveur r&eacute;pondra par un message d'erreur et ne
    traitera pas la requ&ecirc;te. La taille du corps d'une requ&ecirc;te normale va
    varier de mani&egrave;re importante en fonction de la nature de la
    ressource et des m&eacute;thodes autoris&eacute;es pour cette derni&egrave;re. Les
    scripts CGI utilisent souvent le corps du message pour extraire les
    informations d'un formulaire. Les impl&eacute;mentations de la m&eacute;thode
    <code>PUT</code> n&eacute;cessitent une valeur au moins aussi &eacute;lev&eacute;e que la
    taille maximale des repr&eacute;sentations que le serveur d&eacute;sire accepter
    pour cette ressource.</p>

    <p>L'administrateur du serveur peut utiliser cette directive pour
    contr&ocirc;ler plus efficacement les comportements anormaux des requ&ecirc;tes
    des clients, ce qui lui permettra de pr&eacute;venir certaines formes
    d'attaques par d&eacute;ni de service.</p>

    <p>Si par exemple, vous autorisez le chargement de fichiers vers une
    localisation particuli&egrave;re, et souhaitez limiter la taille des
    fichiers charg&eacute;s &agrave; 100Ko, vous pouvez utiliser la directive suivante
    :</p>

    <highlight language="config">LimitRequestBody 102400</highlight>

    <note><p>Pour une description d&eacute;taill&eacute;e de la mani&egrave;re dont cette
    directive est interpr&eacute;t&eacute;e par les requ&ecirc;tes mandat&eacute;es, voir la
    documentation du module <module>mod_proxy</module>.</p>
    </note>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>LimitRequestFields</name>
<description>Limite le nombre de champs d'en-t&ecirc;te autoris&eacute;s dans une
requ&ecirc;te HTTP</description>
<syntax>LimitRequestFields <var>nombre</var></syntax>
<default>LimitRequestFields 100</default>
<contextlist><context>server config</context><context>virtual host</context></contextlist>

<usage>
    <p><var>nombre</var> est un entier de 0 (nombre de champs illimit&eacute;)
    &agrave; 32767. La valeur par d&eacute;faut est d&eacute;finie &agrave; la compilation par la
    constante <code>DEFAULT_LIMIT_REQUEST_FIELDS</code> (100 selon la
    distribution).</p>

    <p>La directive <directive>LimitRequestFields</directive> permet &agrave;
    l'administrateur du serveur de modifier le nombre maximum de champs
    d'en-t&ecirc;te autoris&eacute;s dans une requ&ecirc;te HTTP. Pour un serveur, cette
    valeur doit &ecirc;tre sup&eacute;rieure au nombre de champs qu'une requ&ecirc;te
    client normale peut contenir. Le nombre de champs d'en-t&ecirc;te d'une
    requ&ecirc;te qu'un client utilise d&eacute;passe rarement 20, mais ce nombre
    peut varier selon les impl&eacute;mentations des clients, et souvent en
    fonction des extensions que les utilisateurs configurent dans leurs
    navigateurs pour supporter la n&eacute;gociation de contenu d&eacute;taill&eacute;e. Les
    extensions HTTP optionnelles utilisent souvent les
    champs d'en-t&ecirc;te des requ&ecirc;tes.</p>

    <p>L'administrateur du serveur peut utiliser cette directive pour
    contr&ocirc;ler plus efficacement les comportements anormaux des requ&ecirc;tes
    des clients, ce qui lui permettra de pr&eacute;venir certaines formes
    d'attaques par d&eacute;ni de service. La valeur sp&eacute;cifi&eacute;e doit &ecirc;tre
    augment&eacute;e si les clients standards re&ccedil;oivent une erreur du serveur
    indiquant que la requ&ecirc;te comportait un nombre d'en-t&ecirc;tes trop
    important.</p>

    <p>Par exemple :</p>

    <highlight language="config">LimitRequestFields 50</highlight>

    <note type="warning"><title>Avertissement</title>
     <p>Dans le cas des serveurs virtuels &agrave; base de noms, la valeur de
     cette directive est extraite du serveur virtuel par d&eacute;faut (le
     premier de la liste) pour la paire adresse IP/port.</p>
    </note>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>LimitRequestFieldSize</name>
<description>D&eacute;dinit la taille maximale autoris&eacute;e d'un en-t&ecirc;te de
requ&ecirc;te HTTP</description>
<syntax>LimitRequestFieldSize <var>octets</var></syntax>
<default>LimitRequestFieldSize 8190</default>
<contextlist><context>server config</context><context>virtual host</context></contextlist>

<usage>
    <p>Cette directive permet de d&eacute;finir le nombre maximum
    d'<var>octets</var> autoris&eacute;s dans un en-t&ecirc;te de requ&ecirc;te HTTP.</p>

    <p>La directive <directive>LimitRequestFieldSize</directive> permet
    &agrave; l'administrateur du serveur de d&eacute;finir la taille
    maximale autoris&eacute;e d'un en-t&ecirc;te de requ&ecirc;te HTTP. Pour un serveur,
    cette valeur doit &ecirc;tre suffisamment grande pour contenir tout
    en-t&ecirc;te d'une requ&ecirc;te client normale. La taille d'un champ d'en-t&ecirc;te
    de requ&ecirc;te normal va varier selon les impl&eacute;mentations des clients,
    et en fonction des extensions que les utilisateurs
    configurent dans leurs navigateurs pour supporter la n&eacute;gociation de
    contenu d&eacute;taill&eacute;e. Les en-t&ecirc;tes d'authentification SPNEGO peuvent
    atteindre une taille de 12392 octets.</p>

    <p>>L'administrateur du serveur peut utiliser cette directive pour
    contr&ocirc;ler plus efficacement les comportements anormaux des requ&ecirc;tes
    des clients, ce qui lui permettra de pr&eacute;venir certaines formes
    d'attaques par d&eacute;ni de service.</p>

    <p>Par exemple ::</p>

    <highlight language="config">LimitRequestFieldSize 4094</highlight>

    <note>Dans des conditions normales, la valeur par d&eacute;faut de cette
    directive ne doit pas &ecirc;tre modifi&eacute;e.</note>

    <note type="warning"><title>Avertissement</title>
     <p>Dans le cas des serveurs virtuels &agrave; base de noms, la valeur de
     cette directive est extraite du serveur virtuel par d&eacute;faut (le
     premier de la liste) pour lequel la paire adresse IP/port
     correspond le mieux.</p>
    </note>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>LimitRequestLine</name>
<description>D&eacute;finit la taille maximale d'une ligne de requ&ecirc;te
HTTP</description>
<syntax>LimitRequestLine <var>octets</var></syntax>
<default>LimitRequestLine 8190</default>
<contextlist><context>server config</context><context>virtual host</context></contextlist>

<usage>
    <p>Cette directive permet de d&eacute;finir la taille maximale autoris&eacute;e
    pour une ligne de requ&ecirc;te HTTP en <var>octets</var>.</p>

    <p>La directive <directive>LimitRequestLine</directive> permet &agrave;
    l'administrateur du serveur de d&eacute;finir la taille
    maximale autoris&eacute;e d'une ligne de requ&ecirc;te HTTP client. Comme une
    requ&ecirc;te comporte une m&eacute;thode HTTP, un URI, et une version de
    protocole, la directive <directive>LimitRequestLine</directive>
    impose une restriction sur la longueur maximale autoris&eacute;e pour un
    URI dans une requ&ecirc;te au niveau du serveur. Pour un serveur, cette
    valeur doit &ecirc;tre suffisamment grande pour r&eacute;f&eacute;rencer les noms de
    toutes ses ressources, y compris toutes informations pouvant &ecirc;tre
    ajout&eacute;es dans la partie requ&ecirc;te d'une m&eacute;thode <code>GET</code>.</p>

    <p>L'administrateur du serveur peut utiliser cette directive pour
    contr&ocirc;ler plus efficacement les comportements anormaux des requ&ecirc;tes
    des clients, ce qui lui permettra de pr&eacute;venir certaines formes
    d'attaques par d&eacute;ni de service.</p>

    <p>Par exemple :</p>

    <highlight language="config">LimitRequestLine 4094</highlight>

    <note>Dans des conditions normales, la valeur par d&eacute;faut de cette
    directive ne doit pas &ecirc;tre modifi&eacute;e. En outre, vous ne
    pouvez pas sp&eacute;cifier une valeur sup&eacute;rieure &agrave; 8190 sans modifier le
    code source et recompiler.</note>

    <note type="warning"><title>Avertissement</title>
     <p>Dans le cas des serveurs virtuels &agrave; base de noms, la valeur de
     cette directive est extraite du serveur virtuel par d&eacute;faut (le
     premier de la liste) pour lequel la paire adresse IP/port
     correspond le mieux.</p>
    </note>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>LimitXMLRequestBody</name>
<description>D&eacute;finit la taille maximale du corps d'une requ&ecirc;te au format
XML</description>
<syntax>LimitXMLRequestBody <var>octets</var></syntax>
<default>LimitXMLRequestBody 1000000</default>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>All</override>

<usage>
    <p>Taille maximale (en octets) du corps d'une requ&ecirc;te au format XML.
    Une valeur de <code>0</code> signifie qu'aucune limite n'est
    impos&eacute;e.</p>

    <p>Exemple :</p>

    <highlight language="config">LimitXMLRequestBody 0</highlight>

</usage>
</directivesynopsis>

<directivesynopsis type="section">
<name>Location</name>
<description>N'applique les directives contenues qu'aux URLs
sp&eacute;cifi&eacute;es</description>
<syntax>&lt;Location
    <var>chemin URL</var>|<var>URL</var>&gt; ... &lt;/Location&gt;</syntax>
<contextlist><context>server config</context><context>virtual
host</context>
</contextlist>

<usage>
    <p>La directive <directive type="section">Location</directive>
    limite la port&eacute;e des directives contenues aux URLs d&eacute;finies par
    l'argument URL. Elle est similaire &agrave; la directive <directive
    type="section" module="core">Directory</directive>, et marque le
    d&eacute;but d'une section qui se termine par une directive
    <code>&lt;/Location&gt;</code>. Les sections <directive
    type="section">Location</directive> sont trait&eacute;es selon l'ordre dans
    lequel elles apparaissent dans le fichier de configuration, mais
    apr&egrave;s les sections <directive
    type="section" module="core">Directory</directive> et la lecture des
    fichiers <code>.htaccess</code>, et apr&egrave;s les sections <directive
    type="section" module="core">Files</directive>.</p>

    <p>Les sections <directive type="section">Location</directive>
    agissent compl&egrave;tement en dehors du syst&egrave;me de fichiers. Ceci a de
    nombreuses cons&eacute;quences. Parmi les plus importantes, on ne doit pas
    utiliser les sections <directive type="section">Location</directive>
    pour contr&ocirc;ler l'acc&egrave;s aux r&eacute;pertoires du syst&egrave;me de fichiers. Comme
    plusieurs URLs peuvent correspondre au m&ecirc;me r&eacute;pertoire du syst&egrave;me de
    fichiers, un tel contr&ocirc;le d'acc&egrave;s pourrait &ecirc;tre contourn&eacute;.</p>

    <p>Les directives que contient cette section seront appliqu&eacute;es aux
    requ&ecirc;tes si la partie chemin de l'URL satisfait &agrave; l'un au moins de
    ces crit&egrave;res :
    </p>
    <ul>
      <li>Le chemin sp&eacute;cifi&eacute; correspond exactement &agrave; la partie chemin de
      l'URL.
      </li>
      <li>Le chemin sp&eacute;cifi&eacute;, qui se termine par un slash, est un
      pr&eacute;fixe de la partie chemin de l'URL (trait&eacute; comme une racine du
      contexte).
      </li>
      <li>Le chemin sp&eacute;cifi&eacute;, si on lui ajoute un slash de fin, est un
      pr&eacute;fixe de la partie chemin de l'URL (aussi trait&eacute; comme une racine du
      contexte).
      </li>
    </ul>
    <p>
    Dans l'exemple ci-dessous, o&ugrave; aucun slash de fin n'est utilis&eacute;, les
    directives contenues dans la section s'appliqueront &agrave; /private1,
    /private1/ et /private1/file.txt, mais pas &agrave; /private1other. 
    </p>
    <highlight language="config">
&lt;Location /private1&gt;
    #  ...
&lt;/Location&gt;
    </highlight>
    <p>
    De m&ecirc;me, dans l'exemple ci-dessous, o&ugrave; l'on utilise un slash de fin, les
    directives contenues dans la section s'appliqueront &agrave; /private2/ et
    &agrave; /private2/file.txt, mais pas &agrave; /private2other.
    </p>
    <highlight language="config">
&lt;Location /private2<em>/</em>&gt;
    # ...
&lt;/Location&gt;
    </highlight>
    
    <note><title>Quand utiliser la section <directive
    type="section">Location</directive></title>

    <p>Vous pouvez utiliser une section <directive
    type="section">Location</directive> pour appliquer des directives &agrave;
    des contenus situ&eacute;s en dehors du syst&egrave;me de fichiers. Pour les
    contenus situ&eacute;s &agrave; l'int&eacute;rieur du syst&egrave;me de fichiers, utilisez
    plut&ocirc;t les sections <directive
    type="section" module="core">Directory</directive> et <directive
    type="section" module="core">Files</directive>. <code>&lt;Location
    /&gt;</code> constitue une exception et permet d'appliquer ais&eacute;ment
    une configuration &agrave; l'ensemble du serveur.</p>
    </note>

    <p>Pour toutes les requ&ecirc;tes originales (non mandat&eacute;es), l'argument
    URL est un chemin d'URL de la forme
    <code>/chemin/</code>. <em>Aucun protocole, nom d'h&ocirc;te, port, ou cha&icirc;ne
    de requ&ecirc;te ne doivent appara&icirc;tre.</em> Pour les requ&ecirc;tes mandat&eacute;es, l'URL
    sp&eacute;cifi&eacute;e doit &ecirc;tre de la forme
    <code>protocole://nom_serveur/chemin</code>, et vous devez inclure
    le pr&eacute;fixe.</p>

    <p>L'URL peut contenir des caract&egrave;res g&eacute;n&eacute;riques. Dans une cha&icirc;ne
    avec caract&egrave;res g&eacute;n&eacute;riques, <code>?</code> correspond &agrave; un caract&egrave;re
    quelconque, et <code>*</code> &agrave; toute cha&icirc;ne de caract&egrave;res. Les
    caract&egrave;res g&eacute;n&eacute;riques ne peuvent pas remplacer un / dans le chemin
    URL.</p>

    <p>On peut aussi utiliser les <glossary ref="regex">Expressions
    rationnelles</glossary>, moyennant l'addition d'un caract&egrave;re
    <code>~</code>. Par exemple :</p>

    <highlight language="config">
&lt;Location ~ "/(extra|special)/data"&gt;
    #...
&lt;/Location&gt;
</highlight>

    <p>concernerait les URLs contenant les sous-cha&icirc;ne
    <code>/extra/data</code> ou <code>/special/data</code>. La directive
    <directive type="section" module="core">LocationMatch</directive>
    pr&eacute;sente un comportement identique &agrave; la version avec expressions
    rationnelles de la directive <directive
    type="section">Location</directive>, et son utilisation est
    pr&eacute;f&eacute;rable &agrave; l'utilisation de cette derni&egrave;re pour la simple raison
    qu'il est difficile de distinguer <code>~</code> de <code>-</code>
    dans la plupart des fontes.</p>

    <p>La directive <directive type="section">Location</directive>
    s'utilise principalement avec la directive <directive
    module="core">SetHandler</directive>. Par exemple, pour activer les
    requ&ecirc;tes d'&eacute;tat, mais ne les autoriser que depuis des navigateurs
    appartenant au domaine <code>example.com</code>, vous pouvez
    utiliser :</p>

    <highlight language="config">
&lt;Location /status&gt;
  SetHandler server-status
  Require host example.com
&lt;/Location&gt;
    </highlight>

    <note><title>Note &agrave; propos du slash (/)</title>
      <p>La signification du caract&egrave;re slash d&eacute;pend de l'endroit o&ugrave; il
      se trouve dans l'URL. Les utilisateurs peuvent &ecirc;tre habitu&eacute;s &agrave;
      son comportement dans le syst&egrave;me de fichiers o&ugrave; plusieurs slashes
      successifs sont souvent r&eacute;duits &agrave; un slash unique (en d'autres
      termes, <code>/home///foo</code> est identique &agrave;
      <code>/home/foo</code>). Dans l'espace de nommage des URLs, ce
      n'est cependant pas toujours le cas. Pour la directive <directive
      type="section" module="core">LocationMatch</directive> et la
      version avec expressions rationnelles de la directive <directive
      type="section">Location</directive>, vous devez sp&eacute;cifier
      explicitement les slashes multiples si telle est votre
      intention.</p>

      <p>Par exemple, <code>&lt;LocationMatch ^/abc&gt;</code> va
      correspondre &agrave; l'URL <code>/abc</code> mais pas &agrave; l'URL <code>
      //abc</code>. La directive <directive type="section"
      >Location</directive> sans expression rationnelle se comporte de
      la m&ecirc;me mani&egrave;re lorsqu'elle est utilis&eacute;e pour des requ&ecirc;tes
      mandat&eacute;es. Par contre, lorsque la directive <directive
      type="section">Location</directive> sans expression rationnelle
      est utilis&eacute;e pour des requ&ecirc;tes non mandat&eacute;es, elle fera
      correspondre implicitement les slashes multiples &agrave; des slashes
      uniques. Par exemple, si vous sp&eacute;cifiez <code>&lt;Location
      /abc/def&gt;</code>, une requ&ecirc;te de la forme
      <code>/abc//def</code> correspondra.</p>
    </note>
</usage>
<seealso><a href="../sections.html">Comment fonctionnent les sections
&lt;Directory&gt;, &lt;Location&gt; et &lt;Files&gt;</a> pour une
explication de la mani&egrave;re dont ces diff&eacute;rentes sections se combinent
entre elles &agrave; la r&eacute;ception d'une requ&ecirc;te.</seealso>
</directivesynopsis>

<directivesynopsis type="section">
<name>LocationMatch</name>
<description>N'applique les directives contenues qu'aux URLs
correspondant &agrave; une expression rationnelle</description>
<syntax>&lt;LocationMatch
    <var>regex</var>&gt; ... &lt;/LocationMatch&gt;</syntax>
<contextlist><context>server config</context><context>virtual
host</context>
</contextlist>

<usage>
    <p>La directive <directive type="section">LocationMatch</directive>
    limite la port&eacute;e des directives contenues &agrave; l'URL sp&eacute;cifi&eacute;e, de
    mani&egrave;re identique &agrave; la directive <directive module="core"
    type="section">Location</directive>. Mais son argument permettant de
    sp&eacute;cifier les URLs concern&eacute;es est une <glossary
    ref="regex">expression rationnelle</glossary> au lieu d'une simple
    cha&icirc;ne de caract&egrave;res. Par exemple :</p>

    <highlight language="config">
&lt;LocationMatch "/(extra|special)/data"&gt;
    # ...
&lt;/LocationMatch&gt;
</highlight>

    <p>correspondrait &agrave; toute URL contenant les sous-cha&icirc;nes
    <code>/extra/data</code> ou <code>/special/data</code>.</p>
</usage>
<seealso><a href="../sections.html">Comment fonctionnent les sections
&lt;Directory&gt;, &lt;Location&gt; et &lt;Files&gt;</a> pour une
explication de la mani&egrave;re dont ces diff&eacute;rentes sections se combinent
entre elles &agrave; la r&eacute;ception d'une requ&ecirc;te.</seealso>
</directivesynopsis>

<directivesynopsis>
<name>LogLevel</name>
<description>Contr&ocirc;le la verbosit&eacute; du journal des erreurs</description>
<syntax>LogLevel [<var>module</var>:]<var>niveau</var>
    [<var>module</var>:<var>niveau</var>] ...
</syntax>
<default>LogLevel warn</default>
<contextlist><context>server config</context><context>virtual
host</context><context>directory</context>
</contextlist>
<compatibility>La configuration du niveau de journalisation par module
et par r&eacute;pertoire est disponible depuis la version 2.3.6 du serveur HTTP
Apache</compatibility>
<usage>
    <p>La directive <directive>LogLevel</directive> permet d'ajuster la
    verbosit&eacute; des messages enregistr&eacute;s dans les journaux d'erreur (voir
    la directive <directive module="core">ErrorLog</directive>
    directive). Les <var>niveau</var>x disponibles sont pr&eacute;sent&eacute;s
    ci-apr&egrave;s, par ordre de criticit&eacute; d&eacute;croissante :</p>

    <table border="1">
    <columnspec><column width=".2"/><column width=".3"/><column width=".5"/>
    </columnspec>
      <tr>
        <th><strong>Niveau</strong> </th>

        <th><strong>Description</strong> </th>

        <th><strong>Exemple</strong> </th>
      </tr>

      <tr>
        <td><code>emerg</code> </td>

        <td>Urgences - le syst&egrave;me est inutilisable.</td>

        <td>"Child cannot open lock file. Exiting"</td>
      </tr>

      <tr>
        <td><code>alert</code> </td>

        <td>Des mesures doivent &ecirc;tre prises imm&eacute;diatement.</td>

        <td>"getpwuid: couldn't determine user name from uid"</td>
      </tr>

      <tr>
        <td><code>crit</code> </td>

        <td>Conditions critiques.</td>

        <td>"socket: Failed to get a socket, exiting child"</td>
      </tr>

      <tr>
        <td><code>error</code> </td>

        <td>Erreurs.</td>

        <td>"Premature end of script headers"</td>
      </tr>

      <tr>
        <td><code>warn</code> </td>

        <td>Avertissements.</td>

        <td>"child process 1234 did not exit, sending another
        SIGHUP"</td>
      </tr>

      <tr>
        <td><code>notice</code> </td>

        <td>Ev&egrave;nement important mais normal.</td>

        <td>"httpd: caught SIGBUS, attempting to dump core in
        ..."</td>
      </tr>

      <tr>
        <td><code>info</code> </td>

        <td>Informations.</td>

        <td>"Server seems busy, (you may need to increase
        StartServers, or Min/MaxSpareServers)..."</td>
      </tr>

      <tr>
        <td><code>debug</code> </td>

        <td>Messages de d&eacute;bogage.</td>

        <td>"Opening config file ..."</td>
      </tr>
      <tr>
        <td><code>trace1</code> </td>

        <td>Messages de traces</td>

        <td>"proxy: FTP: control connection complete"</td>
      </tr>
      <tr>
        <td><code>trace2</code> </td>

        <td>Messages de traces</td>

        <td>"proxy: CONNECT: sending the CONNECT request to the remote proxy"</td>
      </tr>
      <tr>
        <td><code>trace3</code> </td>

        <td>Messages de traces</td>

        <td>"openssl: Handshake: start"</td>
      </tr>
      <tr>
        <td><code>trace4</code> </td>

        <td>Messages de traces</td>

        <td>"read from buffered SSL brigade, mode 0, 17 bytes"</td>
      </tr>
      <tr>
        <td><code>trace5</code> </td>

        <td>Messages de traces</td>

        <td>"map lookup FAILED: map=rewritemap key=keyname"</td>
      </tr>
      <tr>
        <td><code>trace6</code> </td>

        <td>Messages de traces</td>

        <td>"cache lookup FAILED, forcing new map lookup"</td>
      </tr>
      <tr>
        <td><code>trace7</code> </td>

        <td>Messages de traces, enregistrement d'une grande quantit&eacute; de
	donn&eacute;es</td>

        <td>"| 0000: 02 23 44 30 13 40 ac 34 df 3d bf 9a 19 49 39 15 |"</td>
      </tr>
      <tr>
        <td><code>trace8</code> </td>

        <td>Messages de traces, enregistrement d'une grande quantit&eacute; de
	donn&eacute;es</td>

        <td>"| 0000: 02 23 44 30 13 40 ac 34 df 3d bf 9a 19 49 39 15 |"</td>
      </tr>
    </table>

    <p>Lorsqu'un niveau particulier est sp&eacute;cifi&eacute;, les messages de tous
    les autres niveaux de criticit&eacute; sup&eacute;rieure seront aussi enregistr&eacute;s.
    <em>Par exemple</em>, si <code>LogLevel info</code> est sp&eacute;cifi&eacute;,
    les messages de niveaux <code>notice</code> et <code>warn</code>
    seront aussi &eacute;mis.</p>

    <p>Il est recommand&eacute; d'utiliser un niveau <code>crit</code> ou
    inf&eacute;rieur.</p>

    <p>Par exemple :</p>

    <highlight language="config">LogLevel notice</highlight>

    <note><title>Note</title>
      <p>Si la journalisation s'effectue directement dans un fichier,
      les messages de niveau <code>notice</code> ne peuvent pas &ecirc;tre
      supprim&eacute;s et sont donc toujours journalis&eacute;s. Cependant, ceci ne
      s'applique pas lorsque la journalisation s'effectue vers
      <code>syslog</code>.</p>
    </note>
    
    <p>Sp&eacute;cifier un niveau sans nom de module va attribuer ce niveau &agrave;
    tous les modules. Sp&eacute;cifier un niveau avec nom de module va
    attribuer ce niveau &agrave; ce module seulement. Il est possible de
    sp&eacute;cifier un module par le nom de son fichier source ou par son
    identificateur, avec ou sans le suffixe <code>_module</code>. Les
    trois sp&eacute;cifications suivantes sont donc &eacute;quivalentes :</p>

    <highlight language="config">
LogLevel info ssl:warn
LogLevel info mod_ssl.c:warn
LogLevel info ssl_module:warn
    </highlight>

    <p>Il est aussi possible d'attribuer un niveau de journalisation par
    r&eacute;pertoire :</p>

    <highlight language="config">
LogLevel info
&lt;Directory "/usr/local/apache/htdocs/app"&gt;
  LogLevel debug
&lt;/Directory&gt;
    </highlight>

    <note>
        La configuration du niveau de journalisation par r&eacute;pertoire
	n'affecte que les messages journalis&eacute;s apr&egrave;s l'interpr&eacute;tation de
	la requ&ecirc;te et qui sont associ&eacute;s &agrave; cette derni&egrave;re. Les messages
	de journalisation associ&eacute;s &agrave; la connexion ou au serveur ne sont
	pas affect&eacute;s.
    </note>
</usage>
<seealso><directive module="core">ErrorLog</directive></seealso>
<seealso><directive module="core">ErrorLogFormat</directive></seealso>
<seealso><a href="../logs.html">Journaux du serveur HTTP Apache</a></seealso>
</directivesynopsis>

<directivesynopsis>
<name>MaxKeepAliveRequests</name>
<description>Nombre de requ&ecirc;tes permises pour une connexion
persistante</description>
<syntax>MaxKeepAliveRequests <var>nombre</var></syntax>
<default>MaxKeepAliveRequests 100</default>
<contextlist><context>server config</context><context>virtual
host</context>
</contextlist>

<usage>
    <p>La directive <directive>MaxKeepAliveRequests</directive> permet
    de limiter le nombre de requ&ecirc;tes autoris&eacute;es par connexion lorsque
    <directive module="core" >KeepAlive</directive> est &agrave; "on". Si sa
    valeur est <code>0</code>, le nombre de requ&ecirc;tes autoris&eacute;es est
    illimit&eacute;. Il est recommand&eacute; de d&eacute;finir une valeur assez haute pour
    des performances du serveur maximales.</p>

    <p>Par exemple :</p>

    <highlight language="config">MaxKeepAliveRequests 500</highlight>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>MaxRanges</name>
<description>Nombre de segments de donn&eacute;es autoris&eacute; avant le renvoi de
l'int&eacute;gralit&eacute; de la ressource</description>
<syntax>MaxRanges default | unlimited | none | <var>nombre de segments</var></syntax>
<default>MaxRanges 200</default>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context>
</contextlist>
<compatibility>Disponible depuis la version 2.3.15 du serveur HTTP
Apache</compatibility>

<usage>
    <p>La directive <directive>MaxRanges</directive> permet de limiter
    le nombre de segments de donn&eacute;es que le serveur va renvoyer au
    client. Si un nombre de segments plus important est demand&eacute;, la
    ressource sera renvoy&eacute;e dans son int&eacute;gralit&eacute;.</p>

    <dl>  
      <dt><strong>default</strong></dt>
      <dd>Limite le nombre de segments de donn&eacute;es &agrave; 200 (valeur par
      d&eacute;faut d&eacute;finie &agrave; la compilation).</dd>
   
      <dt><strong>none</strong></dt>
      <dd>Les en-t&ecirc;tes Range sont ignor&eacute;s.</dd>
          
      <dt><strong>unlimited</strong></dt>
      <dd>Le nombre de segments de donn&eacute;es est illimit&eacute;.</dd>

      <dt><var>nombre de segments</var></dt>
      <dd>Un nombre positif repr&eacute;sentera la nombre de segments de
      donn&eacute;es maximal que le serveur renverra au client.</dd>
    </dl>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>MaxRangeOverlaps</name>
    <description>Nombre de chevauchements de segments de donn&eacute;es autoris&eacute;
    (par exemple <code>100-200,150-300</code>) avant le renvoi de la
    ressource compl&egrave;te</description>
    <syntax>MaxRangeOverlaps default | unlimited | none | <var>nombre de
    chevauchements</var></syntax>
    <default>MaxRangeOverlaps 20</default>
    <contextlist><context>server config</context><context>virtual host</context>
        <context>directory</context>
    </contextlist>
    <compatibility>Disponible depuis la version 2.3.15 du serveur HTTP
    Apache</compatibility>

    <usage>
        <p>La directive <directive>MaxRangeOverlaps</directive> permet
	de limiter le nombre de chevauchements de segments de donn&eacute;es HTTP
	autoris&eacute; par le serveur. Si le nombre de
	chevauchements de segments demand&eacute; est sup&eacute;rieur au nombre maximal
	autoris&eacute;, la ressource sera renvoy&eacute;e dans son int&eacute;gralit&eacute;.</p>

        <dl>
            <dt><strong>default</strong></dt>
            <dd>Limite le nombre de chevauchements de segments &agrave; la valeur
	    par d&eacute;faut 20 d&eacute;finie &agrave; la compilation.</dd>

            <dt><strong>none</strong></dt>
            <dd>Aucun chevauchement de segment n'est autoris&eacute;.</dd>

            <dt><strong>unlimited</strong></dt>
            <dd>Le nombre de chevauchements de segments est illimit&eacute;.</dd>

            <dt><var>number-of-ranges</var></dt>
            <dd>Un nombre positif repr&eacute;sente le nombre maximal de
	    chevauchements de segments autoris&eacute; par le serveur.</dd>
        </dl>
    </usage>
</directivesynopsis>

<directivesynopsis>
    <name>MaxRangeReversals</name>
    <description>Nombre d'inversions d'ordre autoris&eacute; dans la sp&eacute;cification des
    segments de donn&eacute;es (par exemple <code>100-200,50-70</code>) avant le renvoi de la
    ressource compl&egrave;te</description>
    <syntax>MaxRangeReversals default | unlimited | none | <var>nombre
    d'inversions</var></syntax>
    <default>MaxRangeReversals 20</default>
    <contextlist><context>server config</context><context>virtual host</context>
        <context>directory</context>
    </contextlist>
    <compatibility>Disponible depuis la version 2.3.15 du serveur HTTP
    Apache</compatibility>

    <usage>
        <p>La directive <directive>MaxRangeReversals</directive> permet
	de limiter le nombre d'inversions d'ordre dans la sp&eacute;cification
	des segments de donn&eacute;es HTTP
	autoris&eacute; par le serveur. Si le nombre
	d'inversions demand&eacute; est sup&eacute;rieur au nombre maximal
	autoris&eacute;, la ressource sera renvoy&eacute;e dans son int&eacute;gralit&eacute;.</p>

        <dl>
            <dt><strong>default</strong></dt>
            <dd>Limite le nombre d'inversions &agrave; la valeur
	    par d&eacute;faut 20 d&eacute;finie &agrave; la compilation.</dd>

            <dt><strong>none</strong></dt>
            <dd>Aucune inversion n'est autoris&eacute;e.</dd>

            <dt><strong>unlimited</strong></dt>
            <dd>Le nombre d'inversions est illimit&eacute;.</dd>

            <dt><var>number-of-ranges</var></dt>
            <dd>Un nombre positif repr&eacute;sente le nombre maximal
	    d'inversions autoris&eacute; par le serveur.</dd>
        </dl>
    </usage>
</directivesynopsis>

<directivesynopsis>
<name>Mutex</name>
<description>D&eacute;finit les m&eacute;canismes de mutex et le repertoire du fichier
verrou pour tous les mutex ou seulement les mutex sp&eacute;cifi&eacute;s</description>
<syntax>Mutex <var>m&eacute;canisme</var> [default|<var>nom-mutex</var>] ... [OmitPID]</syntax>
<default>Mutex default</default>
<contextlist><context>server config</context></contextlist>
<compatibility>Disponible depuis la version 2.3.4 du serveur HTTP Apache</compatibility>

<usage>
    <p>La directive <directive>Mutex</directive> permet de d&eacute;finir le
    m&eacute;canisme de mutex, et &eacute;ventuellement le r&eacute;pertoire du fichier
    verrou que les modules et httpd utilisent pour s&eacute;rialiser l'acc&egrave;s aux
    ressources. Sp&eacute;cifiez <code>default</code> comme premier argument
    pour modifier la configuration de tous les mutex ; sp&eacute;cifiez un nom
    de mutex (voir la table ci-dessous) comme premier argument pour
    ne modifier que la configuration de ce mutex.</p>

    <p>La directive <directive>Mutex</directive> est typiquement
    utilis&eacute;e dans les situations exceptionnelles suivantes :</p>

    <ul>
        <li>choix d'un autre m&eacute;canisme de mutex lorsque le m&eacute;canisme par
	d&eacute;faut s&eacute;lectionn&eacute; par <glossary>APR</glossary> pr&eacute;sente un
	probl&egrave;me de fonctionnement ou de performances.</li>

        <li>choix d'un autre r&eacute;pertoire utilis&eacute; par les mutex &agrave; base de
	fichier lorsque le r&eacute;pertoire par d&eacute;faut ne supporte pas le
	verrouillage</li>
    </ul>

    <note><title>Modules support&eacute;s</title>
    <p>Cette directive ne configure que les mutex qui ont &eacute;t&eacute;
    enregistr&eacute;s avec le serveur de base via l'API
    <code>ap_mutex_register()</code>. Tous les modules fournis avec
    httpd supportent la directive <directive>Mutex</directive>, mais il
    n'en sera pas forc&eacute;ment de m&ecirc;me pour les modules tiers.
    Reportez-vous &agrave; la documentation du module tiers consid&eacute;r&eacute; afin de
    d&eacute;terminer le(s) nom(s) de mutex qui pourront &ecirc;tre d&eacute;finis si la
    directive est support&eacute;e.</p>
    </note>

    

    <p>Les <em>m&eacute;canismes</em> de mutex disponibles sont les suivants :</p>
    <ul>
        <li><code>default | yes</code>
        <p>C'est l'impl&eacute;mentation du verrouillage par d&eacute;faut, telle
	qu'elle est d&eacute;finie par <glossary>APR</glossary>. On peut
	afficher l'impl&eacute;mentation du verrouillage par d&eacute;faut via la
	commande <program>httpd</program> avec l'option <code>-V</code>.</p></li>

        <li><code>none | no</code>
        <p>Le mutex est d&eacute;sactiv&eacute;, et cette valeur n'est permise pour un
	mutex que si le module indique qu'il s'agit d'un choix valide.
	Consultez la documentation du module pour plus d'informations.</p></li>

        <li><code>posixsem</code>
        <p>Une variante de mutex bas&eacute;e sur un s&eacute;maphore Posix.</p>

        <note type="warning"><title>Avertissement</title>
        <p>La propri&eacute;t&eacute; du s&eacute;maphore n'est pas restitu&eacute;e si un thread du
	processus g&eacute;rant le mutex provoque une erreur de segmentation,
	ce qui provoquera un blocage du serveur web.</p>
        </note>
        </li>

        <li><code>sysvsem</code>
        <p>Une variante de mutex bas&eacute;e sur un s&eacute;maphore IPC SystemV.</p>

        <note type="warning"><title>Avertissement</title>
        <p>Il peut arriver que les s&eacute;maphores SysV soient conserv&eacute;s si le
	processus se crashe avant que le s&eacute;maphore ne soit supprim&eacute;.</p>
	</note>

        <note type="warning"><title>S&eacute;curit&eacute;</title>
        <p>L'API des s&eacute;maphores permet les attaques par d&eacute;ni de service
	par tout programme CGI s'ex&eacute;cutant sous le m&ecirc;me uid que le
	serveur web (autrement dit tous les programmes CGI, &agrave; moins que
	vous n'utilisiez un programme du style <program>suexec</program>
	ou <code>cgiwrapper</code>).</p>
	</note>
        </li>

        <li><code>sem</code>
        <p>S&eacute;lection de la "meilleure" impl&eacute;mentation des s&eacute;maphores
	disponible ; le choix s'effectue entre les s&eacute;maphores posix et
	IPC SystemV, dans cet ordre.</p></li>

        <li><code>pthread</code>
        <p>Une variante de mutex &agrave; base de mutex de thread Posix
	inter-processus.</p>

        <note type="warning"><title>Avertissement</title>
        <p>Sur la plupart des syst&egrave;mes, si un processus enfant se
	termine anormalement alors qu'il d&eacute;tenait un mutex qui utilise
	cette impl&eacute;mentation, le serveur va se bloquer et cesser de
	r&eacute;pondre aux requ&ecirc;tes. Dans ce cas, un red&eacute;marrage manuel est
	n&eacute;cessaire pour r&eacute;cup&eacute;rer le mutex.</p>
        <p>Solaris constitue une exception notable, en ceci qu'il fournit
	un m&eacute;canisme qui permet en g&eacute;n&eacute;ral de r&eacute;cup&eacute;rer le mutex apr&egrave;s
	l'arr&ecirc;t anormal d'un processus enfant qui d&eacute;tenait le mutex.</p>
        <p>Si votre syst&egrave;me impl&eacute;mente la fonction
	<code>pthread_mutexattr_setrobust_np()</code>, vous devriez
	pouvoir utiliser l'option <code>pthread</code> sans probl&egrave;me.</p>
        </note>
        </li>

        <li><code>fcntl:/chemin/vers/mutex</code>
        <p>Une variante de mutex utilisant un fichier verrou physique et
	la fonction <code>fcntl()</code>.</p>

        <note type="warning"><title>Avertissement</title>
        <p>Lorsqu'on utilise plusieurs mutex bas&eacute;s sur ce m&eacute;canisme dans
	un environnement multi-processus, multi-thread, des erreurs de
	blocage (EDEADLK) peuvent &ecirc;tre rapport&eacute;es pour des op&eacute;rations de
	mutex valides si la fonction <code>fcntl()</code> ne g&egrave;re pas
	les threads, comme sous Solaris.</p>
	</note>
        </li>

        <li><code>flock:/chemin/vers/mutex</code>
        <p>M&eacute;thode similaire &agrave; <code>fcntl:/chemin/vers/mutex</code>,
	mais c'est la fonction <code>flock()</code> qui est utilis&eacute;e
	pour g&eacute;rer le verrouillage par fichier.</p></li>

        <li><code>file:/chemin/vers/mutex</code>
        <p>S&eacute;lection de la "meilleure" impl&eacute;mentation de verrouillage
	par fichier disponible ; le choix s'effectue entre
	<code>fcntl</code> et <code>flock</code>, dans cet ordre.</p></li>
    </ul>

    <p>La plupart des m&eacute;canismes ne sont disponibles que sur les
    plate-formes o&ugrave; ces derni&egrave;res et <glossary>APR</glossary> les
    supportent. Les m&eacute;canismes qui ne sont pas disponibles sur toutes
    les plate-formes sont <em>posixsem</em>,
    <em>sysvsem</em>, <em>sem</em>, <em>pthread</em>, <em>fcntl</em>, 
    <em>flock</em>, et <em>file</em>.</p>

    <p>Avec les m&eacute;canismes &agrave; base de fichier <em>fcntl</em> et
    <em>flock</em>, le chemin, s'il est fourni, est un r&eacute;pertoire dans
    lequel le fichier verrou sera cr&eacute;&eacute;. Le r&eacute;pertoire par
    d&eacute;faut est le r&eacute;pertoire d'ex&eacute;cution de httpd relatif &agrave; la
    directive <directive module="core">ServerRoot</directive>.
    Utilisez toujours un syst&egrave;me
    de fichiers local sur disque pour <code>/chemin/vers/mutex</code> et
    jamais un r&eacute;pertoire se trouvant dans un syst&egrave;me de fichiers NFS ou
    AFS. Le nom de base du fichier se composera du type de mutex, d'une
    cha&icirc;ne optionnelle correspondant &agrave; l'instance et fournie par le
    module ; et, sauf si le mot-cl&eacute; <code>OmitPID</code> a &eacute;t&eacute; sp&eacute;cifi&eacute;,
    l'identificateur du processus parent httpd sera ajout&eacute; afin de
    rendre le nom du fichier unique, &eacute;vitant ainsi tout conflit lorsque
    plusieurs instances d'httpd partagent le m&ecirc;me r&eacute;pertoire de
    verrouillage. Par exemple, si le nom de mutex est
    <code>mpm-accept</code>, et si le r&eacute;pertoire de verrouillage est
    <code>/var/httpd/locks</code>, le nom du fichier verrou pour
    l'instance httpd dont le processus parent a pour identifiant 12345
    sera <code>/var/httpd/locks/mpm-accept.12345</code>.</p>

    <note type="warning"><title>S&eacute;curit&eacute;</title>
    <p>Il est conseill&eacute; d'<em>&eacute;viter</em> de placer les fichiers mutex
    dans un r&eacute;pertoire o&ugrave; tout le monde peut &eacute;crire comme
    <code>/var/tmp</code>, car quelqu'un pourrait initier une attaque
    par d&eacute;ni de service et emp&ecirc;cher le serveur de d&eacute;marrer en cr&eacute;ant un
    fichier verrou poss&eacute;dant un nom identique &agrave; celui que le serveur va
    tenter de cr&eacute;er.</p>
    </note>

    <p>La table suivante d&eacute;crit les noms de mutex utilis&eacute;s par httpd et
    ses modules associ&eacute;s.</p>

    <table border="1" style="zebra">
        <tr>
            <th>Nom mutex</th>
            <th>Module(s)</th>
            <th>Ressource prot&eacute;g&eacute;e</th>
	</tr>
        <tr>
            <td><code>mpm-accept</code></td>
            <td>modules MPM <module>prefork</module> et <module>worker</module></td>
            <td>connexions entrantes, afin d'&eacute;viter le probl&egrave;me de
	    l'afflux de requ&ecirc;tes ; pour plus d'informations, voir la
	    documentation <a
	    href="../misc/perf-tuning.html">Am&eacute;lioration des
	    performances</a></td>
	</tr>
	<tr>
            <td><code>authdigest-client</code></td>
            <td><module>mod_auth_digest</module></td>
            <td>liste de clients en m&eacute;moire partag&eacute;e</td>
	</tr>
        <tr>
            <td><code>authdigest-opaque</code></td>
            <td><module>mod_auth_digest</module></td>
            <td>compteur en m&eacute;moire partag&eacute;e</td>
	</tr>
        <tr>
            <td><code>ldap-cache</code></td>
            <td><module>mod_ldap</module></td>
            <td>cache de r&eacute;sultat de recherche LDAP</td>
	</tr>
        <tr>
            <td><code>rewrite-map</code></td>
            <td><module>mod_rewrite</module></td>
            <td>communication avec des programmes externes
	    d'associations de valeurs, afin d'&eacute;viter les interf&eacute;rences
	    d'entr&eacute;es/sorties entre plusieurs requ&ecirc;tes</td>
	</tr>
        <tr>
            <td><code>ssl-cache</code></td>
            <td><module>mod_ssl</module></td>
            <td>cache de session SSL</td>
	</tr>
        <tr>
            <td><code>ssl-stapling</code></td>
            <td><module>mod_ssl</module></td>
            <td>cache de l'&eacute;tiquetage OCSP ("OCSP stapling")</td>
	</tr>
        <tr>
            <td><code>watchdog-callback</code></td>
            <td><module>mod_watchdog</module></td>
            <td>fonction de rappel d'un module client particulier</td>
	</tr>
    </table>

    <p>Le mot-cl&eacute; <code>OmitPID</code> permet d'emp&ecirc;cher l'addition de
    l'identifiant du processus httpd parent au nom du fichier verrou.</p>


    <p>Dans l'exemple suivant, le m&eacute;canisme de mutex pour le mutex
    mpm-accept est modifi&eacute; pour passer du m&eacute;canisme par d&eacute;faut au
    m&eacute;canisme <code>fcntl</code>, avec le fichier verrou associ&eacute; cr&eacute;&eacute;
    dans le r&eacute;pertoire <code>/var/httpd/locks</code>. Le m&eacute;canisme de
    mutex par d&eacute;faut pour tous les autres mutex deviendra
    <code>sysvsem</code>.</p>

    <highlight language="config">
Mutex sysvsem default
Mutex fcntl:/var/httpd/locks mpm-accept
    </highlight>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>NameVirtualHost</name>
<description>OBSOLETE : D&eacute;finit une adresse IP pour les serveurs virtuels &agrave; base de
nom</description>
<syntax>NameVirtualHost <var>adresse</var>[:<var>port</var>]</syntax>
<contextlist><context>server config</context></contextlist>

<usage>

    <p>Avant la version 2.3.11, il &eacute;tait n&eacute;cessaire de d&eacute;finir une
    directive <directive>NameVirtualHost</directive> pour indiquer au
    serveur qu'une paire adresse IP/port particuli&egrave;re pouvait &ecirc;tre
    utilis&eacute;e comme serveur virtuel &agrave; base de nom. Depuis la version
    2.3.11, chaque fois qu'une paire adresse IP/port est utilis&eacute;e dans
    plusieurs serveurs virtuels, l'h&eacute;bergement virtuel &agrave; base de nom est
    automatiquement activ&eacute; pour cette adresse.</p>
    
    <p>Cette directive n'a actuellement plus aucun effet.</p>
</usage>

<seealso><a href="../vhosts/">Documentation sur les serveurs
virtuels</a></seealso>

</directivesynopsis>

<directivesynopsis>
<name>Options</name>
<description>D&eacute;finit les fonctionnalit&eacute;s disponibles pour un r&eacute;pertoire
particulier</description>
<syntax>Options
    [+|-]<var>option</var> [[+|-]<var>option</var>] ...</syntax>
<default>Options FollowSymlinks</default>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>Options</override>
<compatibility>Avec la version 2.3.11, la valeur par d&eacute;faut passe de All
&agrave; FollowSymlinks</compatibility>

<usage>
    <p>La directive <directive>Options</directive> permet de d&eacute;finir
    les fonctionnalit&eacute;s de serveur disponibles pour un r&eacute;pertoire
    particulier.</p>

    <p><var>option</var> peut &ecirc;tre d&eacute;fini &agrave; <code>None</code>, auquel
    cas aucune fonctionnalit&eacute; sp&eacute;cifique n'est activ&eacute;e, ou comprendre
    une ou plusieurs des options suivantes :</p>

    <dl>
      <dt><code>All</code></dt>

      <dd>Toutes les options except&eacute; <code>MultiViews</code>.</dd>

      <dt><code>ExecCGI</code></dt>

      <dd>L'ex&eacute;cution de scripts CGI &agrave; l'aide du module
      <module>mod_cgi</module> est permise.</dd>

      <dt><code>FollowSymLinks</code></dt>

      <dd>

      Le serveur va suivre les liens symboliques dans le r&eacute;pertoire
      concern&eacute;. Il s'agit de la valeur par d&eacute;faut.
      <note>
      <p>Bien que le serveur suive les liens symboliques, il ne modifie
      <em>pas</em> le nom de chemin concern&eacute; d&eacute;fini par la section
      <directive type="section"
      module="core">Directory</directive>.</p>
      
      <p>Les options <code>FollowSymLinks</code> et
      <code>SymLinksIfOwnerMatch</code> ne fonctionnent que dans les
      sections <directive type="section"
      module="core">Directory</directive> ou les fichiers
      <code>.htaccess</code>.</p>

      <p>Le fait d'omettre cette option ne doit pas &ecirc;tre consid&eacute;r&eacute; comme
      une mesure de s&eacute;curit&eacute; efficace, car il existe toujours une
      situation de comp&eacute;tition (race condition) entre l'instant o&ugrave; l'on
      v&eacute;rifie qu'un chemin n'est pas un lien symbolique, et l'instant o&ugrave;
      l'on utilise effectivement ce chemin.</p>
      </note></dd>

      <dt><code>Includes</code></dt>

      <dd>
      Les inclusions c&ocirc;t&eacute; serveur (SSI) &agrave; l'aide du module
      <module>mod_include</module> sont autoris&eacute;es.</dd>

      <dt><code>IncludesNOEXEC</code></dt>

      <dd>

      Les inclusions c&ocirc;t&eacute; serveur (SSI) sont permises, mais <code>#exec
      cmd</code> et <code>#exec cgi</code> sont d&eacute;sactiv&eacute;s.
      L'utilisation de <code>#include virtual</code> pour les scripts
      CGI est cependant toujours possible depuis des r&eacute;pertoires
      d&eacute;finis par <directive
      module="mod_alias">ScriptAlias</directive>.</dd>

      <dt><code>Indexes</code></dt>

      <dd>
      Si une URL requise correspond au r&eacute;pertoire concern&eacute;, et si aucun
      <directive module="mod_dir">DirectoryIndex</directive> (<em>par
      exemple</em> <code>index.html</code>) n'est d&eacute;fini pour ce
      r&eacute;pertoire, le module <module>mod_autoindex</module> va renvoyer
      un listing format&eacute; du r&eacute;pertoire.</dd>

      <dt><code>MultiViews</code></dt>

      <dd>
      Les vues multiples ("multiviews") &agrave; <a
      href="../content-negotiation.html">contenu n&eacute;goci&eacute;</a> &agrave; l'aide du
      module <module>mod_negotiation</module> sont autoris&eacute;es.
      <note><title>Note</title> <p>Cette option est ignor&eacute;e si elle est
      d&eacute;finie en tout autre endroit qu'une section <directive
      module="core" type="section">Directory</directive>, car
      <module>mod_negotiation</module> a besoin de ressources r&eacute;elles
      pour effectuer ses comparaisons et ses &eacute;valuations.</p></note>
      
      </dd>

      <dt><code>SymLinksIfOwnerMatch</code></dt>

      <dd>Le serveur ne suivra que les liens symboliques qui renvoient
      vers un fichier ou un r&eacute;pertoire dont le propri&eacute;taire est le m&ecirc;me
      que celui du lien.

      <note><title>Note</title>
      <p>Les options <code>FollowSymLinks</code> et
      <code>SymLinksIfOwnerMatch</code> ne fonctionnent que dans les
      sections <directive type="section"
      module="core">Directory</directive> ou les fichiers
      <code>.htaccess</code>.</p>

      <p>Le fait d'omettre cette option ne doit pas &ecirc;tre consid&eacute;r&eacute; comme
      une mesure de s&eacute;curit&eacute; efficace, car il existe toujours une
      situation de comp&eacute;tition (race condition) entre l'instant o&ugrave; l'on
      v&eacute;rifie qu'un chemin n'est pas un lien symbolique, et l'instant o&ugrave;
      l'on utilise effectivement ce chemin.</p>
      </note> </dd>
    </dl>

    <p>Normalement, si plusieurs directives
    <directive>Options</directive> peuvent s'appliquer &agrave; un r&eacute;pertoire,
    c'est la plus sp&eacute;cifique qui est utilis&eacute;e et les autres sont
    ignor&eacute;es ; les options ne sont pas fusionn&eacute;es (voir <a
    href="../sections.html#mergin">comment les sections sont
    fusionn&eacute;es</a>). Elles le sont cependant si <em>toutes</em> les
    options de la directive <directive>Options</directive> sont
    pr&eacute;c&eacute;d&eacute;es d'un symbole <code>+</code> ou <code>-</code>. Toute
    option pr&eacute;c&eacute;d&eacute;e d'un <code>+</code> est ajout&eacute;e &agrave; la liste des
    options courantes de mani&egrave;re forc&eacute;e et toute option pr&eacute;c&eacute;d&eacute;e d'un
    <code>-</code> est supprim&eacute;e de la liste des options courantes de la
    m&ecirc;me mani&egrave;re.</p>

    <note><title>Note</title>
    <p>M&eacute;langer des <directive>Options</directive> avec <code>+</code>
    ou <code>-</code> avec des <directive>Options</directive> sans
    <code>+</code> ou <code>-</code> constitue une erreur de syntaxe, et
    la v&eacute;rification de la syntaxe au cours du d&eacute;marrage du serveur fera
    &eacute;chouer ce dernier.</p>
    </note>

    <p>Par exemple, sans aucun symbole <code>+</code> et <code>-</code>
    :</p>

    <highlight language="config">
&lt;Directory "/web/docs"&gt;
  Options Indexes FollowSymLinks
&lt;/Directory&gt;

&lt;Directory "/web/docs/spec"&gt;
  Options Includes
&lt;/Directory&gt;
    </highlight>

    <p>ici, seule l'option <code>Includes</code> sera prise en compte
    pour le r&eacute;pertoire <code>/web/docs/spec</code>. Par contre, si la
    seconde directive <directive>Options</directive> utilise les
    symboles <code>+</code> et <code>-</code> :</p>

    <highlight language="config">
&lt;Directory "/web/docs"&gt;
  Options Indexes FollowSymLinks
&lt;/Directory&gt;

&lt;Directory "/web/docs/spec"&gt;
  Options +Includes -Indexes
&lt;/Directory&gt;
    </highlight>

    <p>alors, les options <code>FollowSymLinks</code> et
    <code>Includes</code> seront prises en compte pour le r&eacute;pertoire
    <code>/web/docs/spec</code>.</p>

    <note><title>Note</title>
      <p>L'utilisation de <code>-IncludesNOEXEC</code> ou
      <code>-Includes</code> d&eacute;sactive compl&egrave;tement les inclusions c&ocirc;t&eacute;
      serveur sans tenir compte des d&eacute;finitions pr&eacute;c&eacute;dentes.</p>
    </note>

    <p>En l'absence de toute d&eacute;finition d'options, la valeur par d&eacute;faut
    est <code>FollowSymlinks</code>.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>Protocol</name>
<description>Protocole pour une socket d'&eacute;coute</description>
<syntax>Protocol <var>protocole</var></syntax>
<contextlist><context>server config</context><context>virtual host</context></contextlist>
<compatibility>Disponible depuis la version 2.1.5 d'Apache, mais
seulement depuis la version 2.3.3 sous Windows.</compatibility>

<usage>
    <p>Cette directive permet de sp&eacute;cifier le protocole utilis&eacute; pour une
    socket d'&eacute;coute particuli&egrave;re. Le protocole sert &agrave; d&eacute;terminer quel
    module doit traiter une requ&ecirc;te, et d'appliquer les optimisations
    sp&eacute;cifiques au protocole via la directive
    <directive>AcceptFilter</directive>.</p>

    <p>Vous ne devez d&eacute;finir le protocole que si vous travaillez avec
    des ports non standards ; dans le cas g&eacute;n&eacute;ral, le protocole
    <code>http</code> est associ&eacute; au port 80 et le protocole
    <code>https</code> au port 443.</p>

    <p>Par exemple, si vous travaillez avec le protocole
    <code>https</code> sur un port non standard, sp&eacute;cifiez le protocole
    de mani&egrave;re explicite :</p>

    <highlight language="config">Protocol https</highlight>

    <p>Vous pouvez aussi sp&eacute;cifier le protocole via la directive
    <directive module="mpm_common">Listen</directive>.</p>
</usage>
<seealso><directive module="core">AcceptFilter</directive></seealso>
<seealso><directive module="mpm_common">Listen</directive></seealso>
</directivesynopsis>


<directivesynopsis>
<name>RLimitCPU</name>
<description>Limite le temps CPU allou&eacute; aux processus initi&eacute;s par les
processus enfants d'Apache httpd</description>
<syntax>RLimitCPU <var>secondes</var>|max [<var>secondes</var>|max]</syntax>
<default>Non d&eacute;fini ; utilise les valeurs par d&eacute;faut du syst&egrave;me
d'exploitation</default>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>All</override>

<usage>
    <p>Prend 1 ou 2 param&egrave;tres. Le premier definit la limite de
    consommation de ressources pour tous les processus, et le second la
    consommation de ressources maximale. Les deux param&egrave;tres peuvent
    contenir soit un nombre, soit <code>max</code> pour indiquer au
    serveur que la limite de consommation correspond &agrave; la valeur
    maximale autoris&eacute;e par la configuration du syst&egrave;me d'exploitation.
    Pour augmenter la consommation maximale de ressources, le serveur
    doit s'ex&eacute;cuter en tant que <code>root</code>, ou se trouver dans sa
    phase de d&eacute;marrage.</p>

    <p>Cette directive s'applique aux processus initi&eacute;s par les
    processus enfants d'Apache httpd qui traitent les requ&ecirc;tes, et non aux
    processus enfants eux-m&ecirc;mes. Sont concern&eacute;s les scripts CGI et les
    commandes exec des SSI, mais en aucun cas les processus initi&eacute;s par
    le processus parent d'Apache httpd comme les journalisations redirig&eacute;es
    vers un programme.</p>

    <p>Les limites de ressources CPU sont exprim&eacute;es en secondes par
    processus.</p>
</usage>
<seealso><directive module="core">RLimitMEM</directive></seealso>
<seealso><directive module="core">RLimitNPROC</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>RLimitMEM</name>
<description>Limite la m&eacute;moire allou&eacute;e aux processus initi&eacute;s par les
processus enfants d'Apache httpd</description>
<syntax>RLimitMEM <var>octets</var>|max [<var>octets</var>|max]</syntax>
<default>Non d&eacute;fini ; utilise les valeurs par d&eacute;faut du syst&egrave;me
d'exploitation</default>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>All</override>

<usage>
    <p>Prend 1 ou 2 param&egrave;tres. Le premier definit la limite de
    consommation de ressources pour tous les processus, et le second la
    consommation de ressources maximale. Les deux param&egrave;tres peuvent
    contenir soit un nombre, soit <code>max</code> pour indiquer au
    serveur que la limite de consommation correspond &agrave; la valeur
    maximale autoris&eacute;e par la configuration du syst&egrave;me d'exploitation.
    Pour augmenter la consommation maximale de ressources, le serveur
    doit s'ex&eacute;cuter en tant que <code>root</code>, ou se trouver dans sa
    phase de d&eacute;marrage.</p>

    <p>Cette directive s'applique aux processus initi&eacute;s par les
    processus enfants d'Apache httpd qui traitent les requ&ecirc;tes, et non aux
    processus enfants eux-m&ecirc;mes. Sont concern&eacute;s les scripts CGI et les
    commandes exec des SSI, mais en aucun cas les processus initi&eacute;s par
    le processus parent d'Apache httpd comme les journalisations redirig&eacute;es
    vers un programme.</p>

    <p>Les limites de ressources m&eacute;moire sont exprim&eacute;es en octets par
    processus.</p>
</usage>
<seealso><directive module="core">RLimitCPU</directive></seealso>
<seealso><directive module="core">RLimitNPROC</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>RLimitNPROC</name>
<description>Limite le nombre de processus qui peuvent &ecirc;tre initi&eacute;s par
les processus initi&eacute;s par les processus enfants d'Apache httpd</description>
<syntax>RLimitNPROC <var>nombre</var>|max [<var>nombre</var>|max]</syntax>
<default>Unset; uses operating system defaults</default>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>All</override>

<usage>
    <p>Prend 1 ou 2 param&egrave;tres. Le premier definit la limite de
    consommation de ressources pour tous les processus, et le second la
    consommation de ressources maximale. Les deux param&egrave;tres peuvent
    contenir soit un nombre, soit <code>max</code> pour indiquer au
    serveur que la limite de consommation correspond &agrave; la valeur
    maximale autoris&eacute;e par la configuration du syst&egrave;me d'exploitation.
    Pour augmenter la consommation maximale de ressources, le serveur
    doit s'ex&eacute;cuter en tant que <code>root</code>, ou se trouver dans sa
    phase de d&eacute;marrage.</p>

    <p>Cette directive s'applique aux processus initi&eacute;s par les
    processus enfants d'Apache httpd qui traitent les requ&ecirc;tes, et non aux
    processus enfants eux-m&ecirc;mes. Sont concern&eacute;s les scripts CGI et les
    commandes exec des SSI, mais en aucun cas les processus initi&eacute;s par
    le processus parent d'Apache httpd comme les journalisations redirig&eacute;es
    vers un programme.</p>

    <p>Les limites des processus contr&ocirc;lent le nombre de processus par
    utilisateur.</p>

    <note><title>Note</title>
      <p>Si les processus CGI s'ex&eacute;cutent sous le m&ecirc;me
      utilisateur que celui du serveur web, cette
      directive va limiter le nombre de processus que le serveur
      pourra lui-m&ecirc;me cr&eacute;er. La pr&eacute;sence de messages
      <strong><code>cannot fork</code></strong> dans le journal des
      erreurs indiquera que la limite est atteinte.</p>
    </note>
</usage>
<seealso><directive module="core">RLimitMEM</directive></seealso>
<seealso><directive module="core">RLimitCPU</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>ScriptInterpreterSource</name>
<description>Permet de localiser l'interpr&eacute;teur des scripts
CGI</description>
<syntax>ScriptInterpreterSource Registry|Registry-Strict|Script</syntax>
<default>ScriptInterpreterSource Script</default>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>FileInfo</override>
<compatibility>Win32 seulement.</compatibility>

<usage>
    <p>Cette directive permet de contr&ocirc;ler la m&eacute;thode qu'utilise Apache
    httpd pour trouver l'interpr&eacute;teur destin&eacute; &agrave; ex&eacute;cuter les scripts CGI. La
    d&eacute;finition par d&eacute;faut est <code>Script</code> : ceci indique &agrave;
    Apache httpd qu'il doit utiliser l'interpr&eacute;teur pr&eacute;cis&eacute; dans la ligne
    shebang du script (la premi&egrave;re ligne, commen&ccedil;ant par
    <code>#!</code>). Sur les syst&egrave;mes Win32, cette ligne ressemble
    souvent &agrave; ceci :</p>

    <highlight language="perl">#!C:/Perl/bin/perl.exe</highlight>

    <p>ou simplement, dans le cas o&ugrave; <code>perl</code> est dans le
    <code>PATH</code> :</p>

    <highlight language="perl">#!perl</highlight>

    <p>Avec <code>ScriptInterpreterSource Registry</code>, Windows va
    effectuer une recherche dans l'arborescence
    <code>HKEY_CLASSES_ROOT</code> de la base de registre avec comme
    mot-cl&eacute; l'extension du fichier contenant le script (par exemple
    <code>.pl</code>). C'est la commande d&eacute;finie par la sous-cl&eacute; de
    registre <code>Shell\ExecCGI\Command</code> ou, si elle n'existe
    pas, la sous-cl&eacute; <code>Shell\Open\Command</code> qui est utilis&eacute;e
    pour ouvrir le fichier du script. Si ces cl&eacute;s de registre ne sont
    pas trouv&eacute;es, Apache httpd utilise la m&eacute;thode de l'option
    <code>Script</code>.</p>

    <note type="warning"><title>S&eacute;curit&eacute;</title>
    <p>Soyez prudent si vous utilisez <code>ScriptInterpreterSource
    Registry</code> avec des r&eacute;pertoires faisant l'objet d'un <directive
    module="mod_alias">ScriptAlias</directive>, car Apache httpd va essayer
    d'ex&eacute;cuter <strong>tous</strong> les fichiers contenus dans
    celui-ci. L'option <code>Registry</code> peut causer des appels de
    programmes non voulus sur des fichiers non destin&eacute;s &agrave; &ecirc;tre ex&eacute;cut&eacute;s.
    Par exemple, la commande par d&eacute;faut open sur les fichiers
    <code>.htm</code> sur la plupart des syst&egrave;mes Windows va lancer
    Microsoft Internet Explorer ; ainsi, toute requ&ecirc;te HTTP pour un
    fichier <code>.htm</code> situ&eacute; dans le r&eacute;pertoire des scripts
    va lancer le navigateur en arri&egrave;re-plan sur le serveur, ce qui a
    toutes les chances de crasher votre syst&egrave;me dans les minutes qui
    suivent.</p>
    </note>

    <p>L'option <code>Registry-Strict</code>, apparue avec la version
    2.0 du serveur HTTP Apache,
    agit de mani&egrave;re identique &agrave; <code>Registry</code>, mais n'utilise
    que la sous-cl&eacute; <code>Shell\ExecCGI\Command</code>. La pr&eacute;sence de
    la cl&eacute; <code>ExecCGI</code> n'&eacute;tant pas syst&eacute;matique, Elle doit &ecirc;tre
    d&eacute;finie manuellement dans le registre Windows et &eacute;vite ainsi tout
    appel de programme accidentel sur votre syst&egrave;me.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SeeRequestTail</name>
<description>D&eacute;termine si mod_status affiche les 63 premiers caract&egrave;res
d'une requ&ecirc;te ou les 63 derniers, en supposant que la requ&ecirc;te
elle-m&ecirc;me poss&egrave;de plus de 63 caract&egrave;res.</description>
<syntax>SeeRequestTail On|Off</syntax>
<default>SeeRequestTail Off</default>
<contextlist><context>server config</context></contextlist>
<compatibility>Disponible depuis la version 2.2.7
d'Apache httpd.</compatibility>

<usage>
    <p>Avec <code>ExtendedStatus On</code>, mod_status affiche la
    v&eacute;ritable requ&ecirc;te en cours de traitement. Pour des raisons
    historiques, seuls 63 caract&egrave;res de la requ&ecirc;te sont r&eacute;ellement
    stock&eacute;s &agrave; des fins d'affichage. Cette directive permet de d&eacute;terminer
    si ce sont les 63 premiers caract&egrave;res qui seront stock&eacute;s (c'est le
    comportement par d&eacute;faut),
    ou si ce sont les 63 derniers. Ceci ne s'applique bien entendu que
    si la taille de la requ&ecirc;te est de 64 caract&egrave;res ou plus.</p>

    <p>Si Apache httpd traite la requ&ecirc;te <code
    >GET&nbsp;/disque1/stockage/apache/htdocs/images/rep-images1/nourriture/pommes.jpg&nbsp;HTTP/1.1</code>
    , l'affichage de la requ&ecirc;te par mod_status se pr&eacute;sentera comme suit :
    </p>

    <table border="1">
      <tr>
        <th>Off (d&eacute;faut)</th>
        <td>GET&nbsp;/disque1/stockage/apache/htdocs/images/rep-images1/nourritu</td>
      </tr>
      <tr>
        <th>On</th>
        <td>apache/htdocs/images/rep-images1/nourriture/pommes.jpg&nbsp;HTTP/1.1</td>
      </tr>
    </table>

</usage>

</directivesynopsis>

<directivesynopsis>
<name>ServerAdmin</name>
<description>L'adresse &eacute;lectronique que le serveur inclut dans les
messages d'erreur envoy&eacute;s au client</description>
<syntax>ServerAdmin <var>adresse &eacute;lectronique</var>|<var>URL</var></syntax>
<contextlist><context>server config</context><context>virtual
host</context>
</contextlist>

<usage>
    <p>La directive <directive>ServerAdmin</directive> permet de d&eacute;finir
    l'adresse de contact que le serveur va inclure dans tout message
    d'erreur qu'il envoie au client. Si le programme <code>httpd</code>
    ne reconnait pas l'argument fourni comme une URL, il suppose que
    c'est une <var>adresse &eacute;lectronique</var>, et lui ajoute le pr&eacute;fixe
    <code>mailto:</code> dans les cibles des hyperliens. Il est
    cependant recommand&eacute; d'utiliser exclusivement une adresse
    &eacute;lectronique, car de nombreux scripts CGI consid&egrave;rent ceci comme
    implicite. Si vous utilisez une URL, elle doit pointer vers un autre
    serveur que vous contr&ocirc;lez. Dans le cas contraire, les utilisateurs
    seraient dans l'impossibilit&eacute; de vous contacter en cas de probl&egrave;me.</p>

    <p>Il peut s'av&eacute;rer utile de d&eacute;finir une adresse d&eacute;di&eacute;e &agrave;
    l'administration du serveur, par exemple :</p>

    <highlight language="config">ServerAdmin www-admin@foo.example.com</highlight>
    <p>car les utilisateurs ne mentionnent pas syst&eacute;matiquement le
    serveur dont ils parlent !</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>ServerAlias</name>
<description>Autres noms d'un serveur utilisables pour atteindre des
serveurs virtuels &agrave; base de nom</description>
<syntax>ServerAlias <var>nom serveur</var> [<var>nom serveur</var>]
...</syntax>
<contextlist><context>virtual host</context></contextlist>

<usage>
    <p>La directive <directive>ServerAlias</directive> permet de d&eacute;finir
    les noms alternatifs d'un serveur utilisables pour atteindre des <a
    href="../vhosts/name-based.html">serveurs virtuels &agrave; base de
    nom</a>. La directive <directive>ServerAlias</directive> peut
    contenir des caract&egrave;res g&eacute;n&eacute;riques, si n&eacute;cessaire.</p>

    <highlight language="config">
&lt;VirtualHost *:80&gt;
  ServerName server.example.com
  ServerAlias server server2.example.com server2
  ServerAlias *.example.com
  UseCanonicalName Off
  # ...
&lt;/VirtualHost&gt;
    </highlight>
    <p>La recherche du serveur virtuel &agrave; base de nom correspondant au
    plus pr&egrave;s &agrave; la requ&ecirc;te s'effectue selon l'ordre d'apparition des
    directives <directive type="section"
    module="core">virtualhost</directive> dans le fichier de
    configuration. Le premier serveur virtuel dont le <directive
    module="core">ServerName</directive> ou le <directive
    module="core">ServerAlias</directive> correspond est choisi, sans
    priorit&eacute; particuli&egrave;re si le nom contient des caract&egrave;res g&eacute;n&eacute;riques
    (que ce soit pour ServerName ou ServerAlias).</p>

    <p>Tous les noms sp&eacute;cifi&eacute;s au sein d'une section
    <directive>VirtualHost</directive> sont trait&eacute;s comme un
    <directive>ServerAlias</directive> (sans caract&egrave;res g&eacute;n&eacute;riques).</p>

</usage>
<seealso><directive module="core">UseCanonicalName</directive></seealso>
<seealso><a href="../vhosts/">Documentation sur les serveurs virtuels
du serveur HTTP Apache</a></seealso>
</directivesynopsis>

<directivesynopsis>
<name>ServerName</name>
<description>Nom d'h&ocirc;te et port que le serveur utilise pour
s'authentifier lui-m&ecirc;me</description>
<syntax>ServerName [<var>protocole</var>://]<var>nom de domaine
enti&egrave;rement qualifi&eacute;</var>[:<var>port</var>]</syntax>
<contextlist><context>server config</context><context>virtual
host</context>
</contextlist>

<usage>
    <p>La directive <directive>ServerName</directive> permet de d&eacute;finir
    les protocole, nom d'h&ocirc;te et port d'une requ&ecirc;te que le serveur
    utilise pour s'authentifier lui-m&ecirc;me. Ceci est utile lors de la
    cr&eacute;ation de redirections d'URLs.</p>

    <p>La directive <directive>ServerName</directive> permet aussi
    (&eacute;ventuellement en conjonction avec la directive
    <directive>ServerAlias</directive>) d'identifier de mani&egrave;re unique
    un serveur virtuel, lorsqu'elle est utilis&eacute;e dans un contexte de <a
    href="../vhosts/name-based.html">serveurs virtuels &agrave; base de
    noms</a>.</p>
    
    <p>Par exemple, si le nom de la
    machine h&eacute;bergeant le serveur web est
    <code>simple.example.com</code>, la machine poss&egrave;de l'alias
    DNS <code>www.example.com</code>, et si vous voulez que le serveur
    web s'identifie avec cet alias, vous devez utilisez la d&eacute;finition
    suivante :</p>

    <highlight language="config">ServerName www.example.com</highlight>

    <p>La directive <directive>ServerName</directive> peut appara&icirc;tre &agrave;
    toutes les &eacute;tapes de la d&eacute;finition du serveur. Toute occurrence
    annule cependant la pr&eacute;c&eacute;dente (pour ce serveur).</p>

    <p>Si la directive <directive>ServerName</directive> n'est pas
    d&eacute;finie, le serveur tente de d&eacute;terminer le nom d'h&ocirc;te en effectuant
    une recherche DNS inverse sur son adresse IP. Si la directive
    <directive>ServerName</directive> ne pr&eacute;cise pas de port, le serveur
    utilisera celui de la requ&ecirc;te entrante. Il est recommand&eacute; de
    sp&eacute;cifier un nom d'h&ocirc;te et un port sp&eacute;cifiques &agrave; l'aide de la
    directive <directive>ServerName</directive> pour une fiabilit&eacute;
    optimale et &agrave; titre pr&eacute;ventif.</p>

    <p>Si vous d&eacute;finissez des <a
    href="../vhosts/name-based.html">serveurs virtuels &agrave; base de
    nom</a>, une directive <directive>ServerName</directive> situ&eacute;e &agrave;
    l'int&eacute;rieur d'une section <directive type="section"
    module="core">VirtualHost</directive> sp&eacute;cifiera quel nom d'h&ocirc;te
    doit appara&icirc;tre dans l'en-t&ecirc;te de requ&ecirc;te <code>Host:</code> pour
    pouvoir atteindre ce serveur virtuel.</p>


    <p>Parfois, le serveur s'ex&eacute;cute en amont d'un dispositif qui
    impl&eacute;mente SSL, comme un mandataire inverse, un r&eacute;partiteur de
    charge ou un bo&icirc;tier d&eacute;di&eacute; SSL. Dans ce cas, sp&eacute;cifiez le protocole
    <code>https://</code> et le port auquel les clients se connectent
    dans la directive <directive>ServerName</directive>, afin de
    s'assurer que le serveur g&eacute;n&egrave;re correctement ses URLs
    d'auto-identification.
    </p>

    <p>Voir la description des directives <directive
    module="core">UseCanonicalName</directive> et <directive
    module="core">UseCanonicalPhysicalPort</directive> pour les
    d&eacute;finitions qui permettent de d&eacute;terminer si les URLs
    auto-identifiantes (par exemple via le module
    <module>mod_dir</module>) vont faire r&eacute;f&eacute;rence au port sp&eacute;cifi&eacute;, ou
    au port indiqu&eacute; dans la requ&ecirc;te du client.
    </p>

    <note type="warning">
    <p>Si la valeur de la directive <directive>ServerName</directive> ne
    peut pas &ecirc;tre r&eacute;solue en adresse IP, le d&eacute;marrage du serveur
    provoquera un avertissement. <code>httpd</code> va alors utiliser le
    r&eacute;sultat de la commande syst&egrave;me <code>hostname</code> pour
    d&eacute;terminer le nom du serveur, ce qui ne correspondra pratiquement
    jamais au nom de serveur que vous souhaitez r&eacute;ellement.</p>
    <example>
    httpd: Could not reliably determine the server's fully qualified domain name, using rocinante.local for ServerName
    </example>
    </note>

</usage>

<seealso><a href="../dns-caveats.html">Probl&egrave;mes concernant le DNS et
le serveur HTTP Apache</a></seealso>
<seealso><a href="../vhosts/">Documentation sur les serveurs virtuels
du serveur HTTP Apache</a></seealso>
<seealso><directive module="core">UseCanonicalName</directive></seealso>
<seealso><directive module="core">UseCanonicalPhysicalPort</directive></seealso>
<seealso><directive module="core">ServerAlias</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>ServerPath</name>
<description>Nom de chemin d'URL h&eacute;rit&eacute; pour un serveur virtuel &agrave; base
de nom acc&eacute;d&eacute; par un navigateur incompatible</description>
<syntax>ServerPath <var>chemin d'URL</var></syntax>
<contextlist><context>virtual host</context></contextlist>

<usage>
    <p>La directive <directive>ServerPath</directive> permet de d&eacute;finir
    le nom de chemin d'URL h&eacute;rit&eacute; d'un h&ocirc;te, &agrave; utiliser avec les <a
    href="../vhosts/">serveurs virtuels &agrave; base de nom</a>.</p>
</usage>
<seealso><a href="../vhosts/">Documentation sur les serveurs virtuels
du serveur HTTP Apache</a></seealso>
</directivesynopsis>

<directivesynopsis>
<name>ServerRoot</name>
<description>Racine du r&eacute;pertoire d'installation du
serveur</description>
<syntax>ServerRoot <var>chemin de r&eacute;pertoire</var></syntax>
<default>ServerRoot /usr/local/apache</default>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>La directive <directive>ServerRoot</directive> permet de d&eacute;finir
    le r&eacute;pertoire dans lequel le serveur est install&eacute;. En particulier,
    il contiendra les sous-r&eacute;pertoires <code>conf/</code> et
    <code>logs/</code>. Les chemins relatifs indiqu&eacute;s dans les autres
    directives (comme <directive
    module="core">Include</directive> ou <directive
    module="mod_so">LoadModule</directive>) seront d&eacute;finis par
    rapport &agrave; ce r&eacute;pertoire.</p>

    <highlight language="config">ServerRoot "/home/httpd"</highlight>

    <p>La valeur par d&eacute;faut de <directive>ServerRoot</directive> peut
    &ecirc;tre modifi&eacute;e via l'argument <code>--prefix</code> de la commande <a
    href="../programs/configure.html"><code>configure</code></a>, et de
    nombreuses distributions tierces du serveur proposent une valeur
    diff&eacute;rente de celles list&eacute;es ci-dessus.</p>

</usage>
<seealso><a href="../invoking.html">the <code>-d</code>
    options de <code>httpd</code></a></seealso>
<seealso><a href="../misc/security_tips.html#serverroot">les conseils &agrave;
propos de s&eacute;curit&eacute;</a> pour des informations sur la mani&egrave;re de d&eacute;finir
correctement les permissions sur le r&eacute;pertoire indiqu&eacute; par la directive
<directive>ServerRoot</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>ServerSignature</name>
<description>D&eacute;finit un pied de page pour les documents g&eacute;n&eacute;r&eacute;s par le
serveur</description>
<syntax>ServerSignature On|Off|EMail</syntax>
<default>ServerSignature Off</default>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>All</override>

<usage>
    <p>La directive <directive>ServerSignature</directive> permet de
    d&eacute;finir une ligne de pied de page fixe pour les documents g&eacute;n&eacute;r&eacute;s
    par le serveur (messages d'erreur, listings de r&eacute;pertoires ftp de
    <module>mod_proxy</module>, sorties de <module>mod_info</module>,
    etc...). Dans le cas d'une cha&icirc;ne de mandataires, l'utilisateur n'a
    souvent aucun moyen de d&eacute;terminer lequel des mandataires cha&icirc;n&eacute;s a
    g&eacute;n&eacute;r&eacute; un message d'erreur, et c'est une des raisons pour lesquelles
    on peut &ecirc;tre amen&eacute; &agrave; ajouter un tel pied de page.</p>

    <p>La valeur par d&eacute;faut <code>Off</code> supprime la ligne de pied
    de page (et est ainsi compatible avec le comportement des
    versions 1.2 et ant&eacute;rieures d'Apache). la valeur <code>On</code>
    ajoute simplement une ligne contenant le num&eacute;ro de version du
    serveur ainsi que le nom du serveur virtuel issu de la directive
    <directive module="core">ServerName</directive>, alors que la valeur
    <code>EMail</code> ajoute en plus une r&eacute;f&eacute;rence "mailto:" &agrave;
    l'administrateur du document r&eacute;f&eacute;renc&eacute; issu la directive
    <directive module="core">ServerAdmin</directive>.</p>

    <p>Apr&egrave;s la version 2.0.44, les d&eacute;tails &agrave; propos du num&eacute;ro de
    version du serveur sont contr&ocirc;l&eacute;s &agrave; l'aide de la directive
    <directive module="core">ServerTokens</directive>.</p>
</usage>
<seealso><directive module="core">ServerTokens</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>ServerTokens</name>
<description>Configure l'en-t&ecirc;te <code>Server</code> de la r&eacute;ponse
HTTP</description>
<syntax>ServerTokens Major|Minor|Min[imal]|Prod[uctOnly]|OS|Full</syntax>
<default>ServerTokens Full</default>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>Cette directive permet de contr&ocirc;ler le contenu de l'en-t&ecirc;te
    <code>Server</code> inclus dans la r&eacute;ponse envoy&eacute;e au client : cet
    en-t&ecirc;te peut contenir le type de syst&egrave;me d'exploitation du serveur,
    ainsi que des informations &agrave; propos des modules compil&eacute;s avec le
    serveur.</p>

    <dl>
	<dt><code>ServerTokens Full</code> (ou non sp&eacute;cifi&eacute;)</dt>

	<dd>Le serveur envoie par exemple : <code>Server: Apache/2.4.2
	(Unix) PHP/4.2.2 MyMod/1.2</code></dd>

    	<dt><code>ServerTokens Prod[uctOnly]</code></dt>

      <dd>Le serveur renvoie (<em>par exemple</em>): <code>Server:
      Apache</code></dd>

      <dt><code>ServerTokens Major</code></dt>

      <dd>Le serveur renvoie (<em>par exemple</em>): <code>Server:
      Apache/2</code></dd>

      <dt><code>ServerTokens Minor</code></dt>

      <dd>Le serveur renvoie (<em>par exemple</em>): <code>Server:
      Apache/2.4</code></dd>

      <dt><code>ServerTokens Min[imal]</code></dt>

      <dd>Le serveur renvoie (<em>par exemple</em>): <code>Server:
      Apache/2.4.2</code></dd>

      <dt><code>ServerTokens OS</code></dt>

      <dd>Le serveur renvoie (<em>par exemple</em>): <code>Server:
      Apache/2.4.2 (Unix)</code></dd>

      
      
    </dl>

    <p>Cette d&eacute;finition s'applique &agrave; l'ensemble du serveur et ne peut
    &ecirc;tre activ&eacute;e ou d&eacute;sactiv&eacute;e pour tel ou tel serveur virtuel.</p>

    <p>Dans les versions post&eacute;rieures &agrave; 2.0.44, cette directive contr&ocirc;le
    aussi les informations fournies par la directive <directive
    module="core">ServerSignature</directive>.</p>

    <note>D&eacute;finir <directive>ServerTokens</directive> &agrave; une
    valeur inf&eacute;rieure &agrave; <code>minimal</code> n'est pas
    recommand&eacute; car le d&eacute;bogage des probl&egrave;mes
    interop&eacute;rationnels n'en sera alors que plus difficile. Notez
    aussi que la d&eacute;sactivation de l'en-t&ecirc;te Server:
    n'am&eacute;liore en rien la s&eacute;curit&eacute; de votre
    serveur ; le concept de "s&eacute;curit&eacute; par
    l'obscurit&eacute;" est un mythe et conduit &agrave;
    une mauvaise perception de ce qu'est la s&eacute;curit&eacute;.</note>


</usage>
<seealso><directive module="core">ServerSignature</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>SetHandler</name>
<description>Force le traitement des fichiers sp&eacute;cifi&eacute;s par un
gestionnaire particulier</description>
<syntax>SetHandler <var>nom gestionnaire</var>|None</syntax>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>FileInfo</override>

<usage>
    <p>Lorsqu'elle se situe &agrave; l'int&eacute;rieur d'un fichier
    <code>.htaccess</code>, ou d'une section <directive type="section"
    module="core">Directory</directive> ou <directive type="section"
    module="core">Location</directive>, cette directive force le
    traitement de tous les fichiers sp&eacute;cifi&eacute;s par le <a
    href="../handler.html">gestionnaire</a> d&eacute;fini par l'argument
    <var>nom gestionnaire</var>. Par exemple, dans le cas d'un
    r&eacute;pertoire dont vous voulez interpr&eacute;ter le contenu comme des
    fichiers de r&egrave;gles d'images cliquables, sans tenir compte des
    extensions, vous pouvez ajouter la ligne suivante dans un fichier
    <code>.htaccess</code> de ce r&eacute;pertoire :</p>

    <highlight language="config">SetHandler imap-file</highlight>

    <p>Autre exemple : si vous voulez que le serveur affiche un
    compte-rendu d'&eacute;tat chaque fois qu'une URL du type <code>http://nom
    serveur/status</code> est appel&eacute;e, vous pouvez ajouter ceci dans
    <code>httpd.conf</code> :</p>

    <highlight language="config">
&lt;Location "/status"&gt;
  SetHandler server-status
&lt;/Location&gt;
    </highlight>

    <p>Vous pouvez aussi utiliser cette directive pour associer un
    gestionnaire &agrave; des fichiers poss&egrave;dant une extension de nom de
    fichier particuli&egrave;re. Par exemple :</p>

    <highlight language="config">
&lt;FilesMatch \.php$&gt;
    SetHandler application/x-httpd-php
&lt;/FilesMatch&gt;
    </highlight>

    <p>Vous pouvez &eacute;craser la d&eacute;finition ant&eacute;rieure d'une directive
    <directive>SetHandler</directive> en utilisant la valeur
    <code>None</code>.</p>

    <note><title>Note</title>
    <p>Comme <directive>SetHandler</directive> l'emporte sur la
    d&eacute;finition des gestionnaires par d&eacute;faut, le comportement habituel
    consistant &agrave; traiter les URLs se terminant par un slash (/) comme
    des r&eacute;pertoires ou des fichiers index est d&eacute;sactiv&eacute;.</p></note>
</usage>

<seealso><directive module="mod_mime">AddHandler</directive></seealso>

</directivesynopsis>

<directivesynopsis>
<name>SetInputFilter</name>
<description>D&eacute;finit les filtres par lesquels vont passer les requ&ecirc;tes
client et les donn&eacute;es POST</description>
<syntax>SetInputFilter <var>filtre</var>[;<var>filtre</var>...]</syntax>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>SetInputFilter</directive> permet de
    d&eacute;finir le ou les filtres par lesquels vont passer les requ&ecirc;tes
    client et les donn&eacute;es POST au moment o&ugrave; le serveur les re&ccedil;oit. Cette
    d&eacute;finition vient en ajout &agrave; tout autre filtre d&eacute;fini en
    quelqu'endroit que ce soit, y compris via la directive <directive
    module="mod_mime">AddInputFilter</directive>.</p>

    <p>Si la directive comporte plusieurs filtres, ils doivent &ecirc;tre
    s&eacute;par&eacute;s par des points-virgules, et sp&eacute;cifi&eacute;s selon l'ordre dans
    lequel vous souhaitez les voir agir sur les contenus.</p>
</usage>
<seealso>documentation des <a
href="../filter.html">Filtres</a></seealso>
</directivesynopsis>

<directivesynopsis>
<name>SetOutputFilter</name>
<description>D&eacute;finit les filtres par lesquels vont passer les r&eacute;ponses
du serveur</description>
<syntax>SetOutputFilter <var>filtre</var>[;<var>filtre</var>...]</syntax>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context><context>.htaccess</context>
</contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>SetOutputFilter</directive> permet de
    d&eacute;finir les filtres par lesquels vont passer les r&eacute;ponses du serveur
    avant d'&ecirc;tre envoy&eacute;es au client. Cette d&eacute;finition vient en ajout &agrave;
    tout autre filtre d&eacute;fini en quelqu'endroit que ce soit, y compris
    via la directive <directive
    module="mod_mime">AddOutputFilter</directive>.</p>

    <p>Par exemple, la configuration suivante va traiter tous les
    fichiers du r&eacute;pertoire <code>/www/data/</code> comme des inclusions
    c&ocirc;t&eacute; serveur (SSI) :</p>

    <highlight language="config">
&lt;Directory "/www/data/"&gt;
  SetOutputFilter INCLUDES
&lt;/Directory&gt;
    </highlight>

    <p>Si la directive comporte plusieurs filtres, ils doivent &ecirc;tre
    s&eacute;par&eacute;s par des points-virgules, et sp&eacute;cifi&eacute;s selon l'ordre dans
    lequel vous souhaitez les voir agir sur les contenus.</p>
</usage>
<seealso><a href="../filter.html">Filters</a> documentation</seealso>
</directivesynopsis>

<directivesynopsis>
<name>TimeOut</name>
<description>Temps pendant lequel le serveur va attendre certains
&eacute;v&egrave;nements avant de consid&eacute;rer qu'une requ&ecirc;te a &eacute;chou&eacute;</description>
<syntax>TimeOut <var>secondes</var></syntax>
<default>TimeOut 60</default>
<contextlist><context>server config</context><context>virtual
host</context></contextlist>

<usage>
    <p>La directive <directive>TimeOut</directive> permet de d&eacute;finir le
    temps maximum pendant lequel Apache httpd va attendre des entr&eacute;es/sorties
    selon les circonstances :</p>

    <ol>
      <li>Lors de la lecture de donn&eacute;es en provenance du client, le
      temps maximum jusqu'&agrave; l'arriv&eacute;e d'un paquet TCP si le tampon est
      vide.</li>

      <li>Lors de l'&eacute;criture de donn&eacute;es destin&eacute;es au client, le temps
      maximum jusqu'&agrave; l'arriv&eacute;e de l'accus&eacute;-r&eacute;ception d'un paquet si le
      tampon d'envoi est plein.</li>

      <li>Avec <module>mod_cgi</module>, le temps d'attente maximum des
      sorties d'un script CGI.</li>

      <li>Avec <module>mod_ext_filter</module>, le temps d'attente
      maximum des sorties d'un processus de filtrage.</li>

      <li>Avec <module>mod_proxy</module>, la valeur du d&eacute;lai par d&eacute;faut
      si <directive module="mod_proxy">ProxyTimeout</directive> n'est
      pas d&eacute;fini.</li>
    </ol>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>TraceEnable</name>
<description>D&eacute;termine le comportement des requ&ecirc;tes
<code>TRACE</code></description>
<syntax>TraceEnable <var>[on|off|extended]</var></syntax>
<default>TraceEnable on</default>
<contextlist><context>server config</context><context>virtual host</context></contextlist>

<usage>
    <p>Cette directive l'emporte sur le comportement de
    <code>TRACE</code> pour le noyau du serveur et
    <module>mod_proxy</module>. La d&eacute;finition par d&eacute;faut
    <code>TraceEnable on</code> permet des requ&ecirc;tes <code>TRACE</code>
    selon la RFC 2616, qui interdit d'ajouter tout corps &agrave; la requ&ecirc;te.
    La d&eacute;finition <code>TraceEnable off</code> indique au noyau du
    serveur et &agrave; <module>mod_proxy</module> de retourner un code
    d'erreur <code>405</code> (M&eacute;thode non autoris&eacute;e) au client.</p>

    <p>En fait, et &agrave; des fins de test et de diagnostic seulement, on
    peut autoriser l'ajout d'un corps de requ&ecirc;te &agrave; l'aide de la
    d&eacute;finition non standard <code>TraceEnable extended</code>. Le noyau
    du serveur (dans le cas d'un serveur d'origine) va limiter la taille
    du corps de requ&ecirc;te &agrave; 64k (plus 8k pour les en-t&ecirc;tes de
    fractionnement si <code>Transfer-Encoding: chunked</code> est
    utilis&eacute;). Le noyau du serveur va reproduire l'ensemble des en-t&ecirc;tes,
    y compris les en-t&ecirc;tes de fractionnement avec le corps de la
    r&eacute;ponse. Dans le cas d'un serveur mandataire, la taille du corps de
    requ&ecirc;te n'est pas limit&eacute;e &agrave; 64k.</p>

    <note><title>Note</title>
    <p>Bien que certains pr&eacute;tendent le contraire, <code>TRACE</code> ne
    constitue pas une vuln&eacute;rabilit&eacute; en mati&egrave;re de s&eacute;curit&eacute;, et il n'y a
    aucune raison suffisante pour le d&eacute;sactiver, ce qui rendrait
    votre serveur non conforme.</p>
    </note>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>UnDefine</name>
<description>Invalide la d&eacute;finition d'une variable</description>
<syntax>UnDefine <var>nom-variable</var></syntax>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>Annule l'effet d'une directive <directive
    module="core">Define</directive> ou d'un argument <code>-D</code> de
    <program>httpd</program> en invalidant l'existence de la variable
    correspondante.</p>
    <p>On peut utiliser cette directive pour inverser l'effet d'une
    section <directive module="core" type="section">IfDefine</directive>
    sans avoir &agrave; modifier les arguments <code>-D</code> dans les scripts
    de d&eacute;marrage.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>UseCanonicalName</name>
<description>D&eacute;finit la mani&egrave;re dont le serveur d&eacute;termine son propre nom
et son port</description>
<syntax>UseCanonicalName On|Off|DNS</syntax>
<default>UseCanonicalName Off</default>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context></contextlist>

<usage>
    <p>Dans de nombreuses situations, Apache httpd doit construire une URL
    <em>auto-identifiante</em> -- c'est &agrave; dire une URL qui fait
    r&eacute;f&eacute;rence au serveur lui-m&ecirc;me. Avec <code>UseCanonicalName
    On</code>, Apache httpd va utiliser le nom d'h&ocirc;te et le port sp&eacute;cifi&eacute;s par
    la directive <directive module="core">ServerName</directive> pour
    construire le nom canonique du serveur. Ce nom est utilis&eacute; dans
    toutes les URLs auto-identifiantes, et affect&eacute; aux variables
    <code>SERVER_NAME</code> et <code>SERVER_PORT</code> dans les
    programmes CGI.</p>

    <p>Avec <code>UseCanonicalName Off</code>, Apache httpd va construire ses
    URLs auto-identifiantes &agrave; l'aide du nom d'h&ocirc;te et du port fournis
    par le client, si ce dernier en a fourni un (dans la n&eacute;gative,
    Apache utilisera le nom canonique, de la m&ecirc;me mani&egrave;re que
    ci-dessus). Ces valeurs sont les m&ecirc;mes que celles qui sont utilis&eacute;es
    pour impl&eacute;menter les <a
    href="../vhosts/name-based.html">serveurs virtuels &agrave; base de
    nom</a>, et sont disponibles avec les m&ecirc;mes clients. De m&ecirc;me, les
    variables CGI <code>SERVER_NAME</code> et <code>SERVER_PORT</code>
    seront affect&eacute;es des valeurs fournies par le client.</p>

    <p>Cette directive peut s'av&eacute;rer utile, par exemple, sur un serveur
    intranet auquel les utilisateurs se connectent en utilisant des noms
    courts tels que <code>www</code>. Si les utilisateurs tapent un nom
    court suivi d'une URL qui fait r&eacute;f&eacute;rence &agrave; un r&eacute;pertoire, comme
    <code>http://www/splat</code>, <em>sans le slash terminal</em>, vous
    remarquerez qu'Apache httpd va les rediriger vers
    <code>http://www.example.com/splat/</code>. Si vous avez activ&eacute;
    l'authentification, ceci va obliger l'utilisateur &agrave; s'authentifier
    deux fois (une premi&egrave;re fois pour <code>www</code> et une seconde
    fois pour <code>www.example.com</code> -- voir <a
    href="http://wiki.apache.org/httpd/FAQ#Why_does_Apache_ask_for_my_password_twice_before_serving_a_file.3F">la
    foire aux questions sur ce sujet pour plus d'informations</a>).
    Par contre, si <directive>UseCanonicalName</directive> est d&eacute;finie &agrave;
    <code>Off</code>, Apache httpd redirigera l'utilisateur vers
    <code>http://www/splat/</code>.</p>

    <p>Pour l'h&eacute;bergement virtuel en masse &agrave; base d'adresse IP, on
    utilise une troisi&egrave;me option, <code>UseCanonicalName
    DNS</code>, pour supporter les clients anciens qui ne
    fournissent pas d'en-t&ecirc;te <code>Host:</code>. Apache httpd effectue alors
    une recherche DNS inverse sur l'adresse IP du serveur auquel le
    client s'est connect&eacute; afin de construire ses URLs
    auto-identifiantes.</p>

    <note type="warning"><title>Avertissement</title>
    <p>Les programmes CGI risquent d'&ecirc;tre perturb&eacute;s par cette option
    s'ils tiennent compte de la variable <code>SERVER_NAME</code>. Le
    client est pratiquement libre de fournir la valeur qu'il veut comme
    nom d'h&ocirc;te. Mais si le programme CGI n'utilise
    <code>SERVER_NAME</code> que pour construire des URLs
    auto-identifiantes, il ne devrait pas y avoir de probl&egrave;me.</p>
    </note>
</usage>
<seealso><directive module="core">UseCanonicalPhysicalPort</directive></seealso>
<seealso><directive module="core">ServerName</directive></seealso>
<seealso><directive module="mpm_common">Listen</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>UseCanonicalPhysicalPort</name>
<description>D&eacute;finit la mani&egrave;re dont le serveur
d&eacute;termine son propre port</description>
<syntax>UseCanonicalPhysicalPort On|Off</syntax>
<default>UseCanonicalPhysicalPort Off</default>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context></contextlist>

<usage>
    <p>Dans de nombreuses situations, Apache httpd doit construire une URL
    <em>auto-identifiante</em> -- c'est &agrave; dire une URL qui fait
    r&eacute;f&eacute;rence au serveur lui-m&ecirc;me. Avec <code>UseCanonicalPhysicalPort
    On</code>, Apache httpd va fournir le num&eacute;ro de port physique r&eacute;el utilis&eacute;
    par la requ&ecirc;te en tant que port potentiel, pour construire le port
    canonique afin que le serveur puisse alimenter la directive
    <directive module="core">UseCanonicalName</directive>. Avec
    <code>UseCanonicalPhysicalPort Off</code>, Apache httpd n'utilisera pas le
    num&eacute;ro de port physique r&eacute;el, mais au contraire se r&eacute;f&eacute;rera aux
    informations de configuration pour construire un num&eacute;ro de port
    valide.</p>

    <note><title>Note</title>
    <p>L'ordre dans lequel s'effectue la recherche quand on utilise le
    port physique est le suivant :</p>
     <dl>
     <dt><code>UseCanonicalName On</code></dt>
     <dd>
     <ol>
      <li>Port indiqu&eacute; dans <directive module="core">Servername</directive></li>
      <li>Port physique</li>
      <li>Port par d&eacute;faut</li>
     </ol>
     </dd>
     <dt><code>UseCanonicalName Off | DNS</code></dt>
     <dd>
     <ol>
      <li>Port sp&eacute;cifi&eacute; dans l'en-t&ecirc;te <code>Host:</code></li>
      <li>Port physique</li>
      <li>Port sp&eacute;cifi&eacute; par <directive module="core">Servername</directive></li>
      <li>Port par d&eacute;faut</li>
     </ol>
     </dd>
     </dl>

    <p>Avec <code>UseCanonicalPhysicalPort Off</code>, on reprend
    l'ordre ci-dessus en supprimant "Port physique".</p>
    </note>

</usage>
<seealso><directive module="core">UseCanonicalName</directive></seealso>
<seealso><directive module="core">ServerName</directive></seealso>
<seealso><directive module="mpm_common">Listen</directive></seealso>
</directivesynopsis>

<directivesynopsis type="section">
<name>VirtualHost</name>
<description>Contient des directives qui ne s'appliquent qu'&agrave; un nom
d'h&ocirc;te sp&eacute;cifique ou &agrave; une adresse IP</description>
<syntax>&lt;VirtualHost
    <var>adresse IP</var>[:<var>port</var>] [<var>adresse
    IP</var>[:<var>port</var>]] ...&gt; ...
    &lt;/VirtualHost&gt;</syntax>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>Les balises <directive type="section">VirtualHost</directive> et
    <code>&lt;/VirtualHost&gt;</code> permettent de rassembler un groupe
    de directives qui ne s'appliquent qu'&agrave; un serveur virtuel
    particulier. Toute directive autoris&eacute;e dans un contexte de serveur
    virtuel peut &ecirc;tre utilis&eacute;e. Lorsque le serveur re&ccedil;oit un requ&ecirc;te
    pour un document h&eacute;berg&eacute; par un serveur virtuel particulier, il
    applique les directives de configuration rassembl&eacute;es dans la section
    <directive type="section">VirtualHost</directive>. <var>adresse
    IP</var> peut &ecirc;tre une des entit&eacute;s suivantes, &eacute;ventuellement suivies
    d'un caract&egrave;re ':' et d'un num&eacute;ro de port (ou *) :</p>

    <ul>
      <li>L'adresse IP du serveur virtuel ;</li>

      <li>Un nom de domaine enti&egrave;rement qualifi&eacute; correspondant &agrave;
      l'adresse IP du serveur virtuel (non recommand&eacute;) ;</li>

      <li>Le caract&egrave;re <code>*</code>, qui agit comme un
      caract&egrave;re g&eacute;n&eacute;rique, et correspond &agrave; toute adresse IP.</li>

      <li>La cha&icirc;ne <code>_default_</code>, dont la signification est
      identique &agrave; celle du caract&egrave;re <code>*</code></li>

    </ul>

    <highlight language="config">
&lt;VirtualHost 10.1.2.3:80&gt;
  ServerAdmin webmaster@host.example.com
  DocumentRoot /www/docs/host.example.com
  ServerName host.example.com
  ErrorLog logs/host.example.com-error_log
  TransferLog logs/host.example.com-access_log
&lt;/VirtualHost&gt;
    </highlight>


    <p>Les adresses IPv6 doivent &ecirc;tre entour&eacute;es de crochets car dans le
    cas contraire, un &eacute;ventuel port optionnel ne pourrait pas &ecirc;tre
    d&eacute;termin&eacute;. Voici un exemple de serveur virtuel avec adresse IPv6
    :</p>

    <highlight language="config">
&lt;VirtualHost [2001:db8::a00:20ff:fea7:ccea]:80&gt;
  ServerAdmin webmaster@host.example.com
  DocumentRoot /www/docs/host.example.com
  ServerName host.example.com
  ErrorLog logs/host.example.com-error_log
  TransferLog logs/host.example.com-access_log
&lt;/VirtualHost&gt;
    </highlight>

    <p>Chaque serveur virtuel doit correspondre &agrave; une adresse IP, un
    port ou un nom d'h&ocirc;te sp&eacute;cifique ; dans le premier cas, le serveur
    doit &ecirc;tre configur&eacute; pour recevoir les paquets IP de plusieurs
    adresses (si le serveur n'a qu'une interface r&eacute;seau, on peut
    utiliser &agrave; cet effet la commande <code>ifconfig alias</code> -- si
    votre syst&egrave;me d'exploitation le permet).</p>

    <note><title>Note</title>
    <p>L'utilisation de la directive <directive
    type="section">VirtualHost</directive> n'affecte en rien les
    adresses IP sur lesquelles Apache httpd est en &eacute;coute. Vous devez vous
    assurer que les adresses des serveurs virtuels sont bien incluses
    dans la liste des adresses pr&eacute;cis&eacute;es par la directive <directive
    module="mpm_common">Listen</directive>.</p>
    </note>
    
    <p>Tout bloc <directive
    type="section">VirtualHost</directive> doit comporter une directive
    <directive module="core">ServerName</directive>. Dans le cas
    contraire, le serveur virtuel h&eacute;ritera de la valeur de la directive
    <directive module="core">ServerName</directive> issue de la
    configuration du serveur principal.</p>

    <p>A l'arriv&eacute;e d'une requ&ecirc;te, le serveur tente de la
    faire prendre en compte par la section <directive
    type="section">VirtualHost</directive> qui correspond le mieux en ne
    se basant que sur la paire adresse IP/port. Les cha&icirc;nes sans
    caract&egrave;res g&eacute;n&eacute;riques l'emportent sur celles qui en contiennent. Si
    aucune correspondance du point de vue de l'adresse IP/port n'est
    trouv&eacute;e, c'est la configuration du serveur "principal" qui sera
    utilis&eacute;e.</p>
    
    <p>Si plusieurs serveurs virtuels correspondent du point de vue de
    l'adresse IP/port, le serveur s&eacute;lectionne celui qui correspond le
    mieux du point de vue du nom d'h&ocirc;te de la requ&ecirc;te. Si aucune
    correspondance du point de vue du nom d'h&ocirc;te n'est trouv&eacute;e, c'est le
    premier serveur virtuel dont l'adresse IP/port correspond qui sera
    utilis&eacute;. Par voie de cons&eacute;quence, le premier serveur virtuel
    comportant une certaine paire adresse IP/port est le serveur virtuel
    par d&eacute;faut pour cette paire adresse IP/port.</p>

    <note type="warning"><title>S&eacute;curit&eacute;</title>
    <p>Voir le document sur les <a
    href="../misc/security_tips.html">conseils &agrave; propos de s&eacute;curit&eacute;</a>
    pour une description d&eacute;taill&eacute;e des raisons pour lesquelles la
    s&eacute;curit&eacute; de votre serveur pourrait &ecirc;tre compromise, si le r&eacute;pertoire
    contenant les fichiers journaux est inscriptible par tout autre
    utilisateur que celui qui d&eacute;marre le serveur.</p>
    </note>
</usage>
<seealso><a href="../vhosts/">Documentation des serveurs virtuels
du serveur HTTP Apache</a></seealso>
<seealso><a href="../dns-caveats.html">Probl&egrave;mes concernant le DNS et
le serveur HTTP Apache</a></seealso>
<seealso><a href="../bind.html">D&eacute;finition des adresses et ports
qu'utilise le serveur HTTP Apache</a></seealso>
<seealso><a href="../sections.html">Comment fonctionnent les sections
&lt;Directory&gt;, &lt;Location&gt; et &lt;Files&gt;</a> pour une
explication de la mani&egrave;re dont ces diff&eacute;rentes sections se combinent
entre elles &agrave; la r&eacute;ception d'une requ&ecirc;te</seealso>
</directivesynopsis>

</modulesynopsis>
