%define with()          %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()       %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
%define bcond_with()    %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}

#no jars in this native build, so skip signing
%define _jarsign_opts --nocopy

# jbhomedir is /usr/share/jbossas  (files must be immutable)
%define jbhomedir %{_datadir}/jbossas
%define jbosswebnativedir modules/system/layers/base/org/jboss/as/web/main/lib

%define repodir %{_javadir}/repository.jboss.com/apache-tomcat-connector-native/%{version}-brew
%define repodirsrc %{repodir}/src

%define _with_zips 1
# If you want to build the zips,
# give rpmbuild option '--with zips'

%define with_zips %{?_with_zips:1}%{!?_with_zips:0}
%define without_zips %{!?_with_zips:1}%{?_with_zips:0}

Name:           tomcat-native
Version:        1.1.34
Release:        1%{?dist}
Summary:        Tomcat native library

Group:          System Environment/Libraries
License:        ASL 2.0
URL:            http://tomcat.apache.org/tomcat-6.0-doc/apr.html
Source0:        http://archive.apache.org/dist/tomcat/tomcat-connectors/native/%{version}/source/%{name}-%{version}-src.tar.gz
Source2:        %{name}-component-info.xml
Source3:        %{name}-upload.sh
%if "%{?rhel}" == "5"
#patch to build with apr 1.2.7 on RHEL 5
Patch1:         tomcat-native-apr-1.2.x.patch
%endif
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
%if "%{?rhel}" == "7"
#64 bit only natives on RHEL 7
ExcludeArch:   i686 i386
%endif

BuildRequires:  java-devel
BuildRequires:  jpackage-utils
BuildRequires:  apr, apr-devel >= 1.2.1
BuildRequires:  jbcs-httpd24-openssl, jbcs-httpd24-openssl-devel, jbcs-httpd24-openssl-libs
BuildRequires:  zip
# Upstream compatibility:
Provides:       tcnative = %{version}-%{release}

#win-buildrequires: xbuild
#win-buildrequires: openssl
#win-buildrequires: httpd
#sun-buildrequires: openssl
#unx-buildrequires: httpd

%description
Tomcat can use the Apache Portable Runtime to provide superior
scalability, performance, and better integration with native server
technologies.  The Apache Portable Runtime is a highly portable library
that is at the heart of Apache HTTP Server 2.x.  APR has many uses,
including access to advanced IO functionality (such as sendfile, epoll
and OpenSSL), OS level functionality (random number generation, system
status, etc), and native process handling (shared memory, NT pipes and
Unix sockets).  This package contains the Tomcat native library which
provides support for using APR in Tomcat.

%package -n jbossas-jbossweb-native
Summary:     JBossWeb native library for JBoss EAP 6.
Group:       Development
Requires:    apr, jbcs-httpd24-openssl 

%description -n jbossas-jbossweb-native
JBossWeb native library for JBoss EAP 6.

%if %{with_zips}
%package src-zip
Summary:     Container for the sources of the Tomcat native library.
Group:       Development

%description src-zip
Container for the sources of the Tomcat native library
%endif

%if %with repolib
%package repolib
Summary:        Artifacts to be uploaded to a repository library
Group:          Development/Libraries/Java

%description repolib
Artifacts to be uploaded to a repository library.
This package is not meant to be installed but so its contents
can be extracted through rpm2cpio.
%endif

%prep
%setup -q -n %{name}-%{version}-src
%if "%{?rhel}" == "5"
%patch1 -p1
%endif

%if %{with_zips}
zip -q -r ../%{name}-%{version}-src.zip *
%endif

%build
cd jni/native
%configure \
    --with-apr=%{_bindir}/apr-1-config \
    --with-java-home=%{java_home} \
    --with-java-platform=2
make %{?_smp_mflags} CFLAGS=-fno-strict-aliasing


%install
rm -rf $RPM_BUILD_ROOT
make -C jni/native install DESTDIR=$RPM_BUILD_ROOT
# Perhaps a devel package sometime?  Not for now; no headers are installed.
rm -f $RPM_BUILD_ROOT%{_libdir}/libtcnative*.*a
rm -rf $RPM_BUILD_ROOT%{_libdir}/pkgconfig

%ifarch i386 i686
archdir=linux-i686
%endif
%ifarch ppc64
archdir=linux-ppc64
%endif
%ifarch x86_64
archdir=linux-x86_64
%endif
mkdir -p $RPM_BUILD_ROOT/%{jbhomedir}/%{jbosswebnativedir}/$archdir
cp -L $RPM_BUILD_ROOT%{_libdir}/libtcnative-1.so $RPM_BUILD_ROOT/%{jbhomedir}/%{jbosswebnativedir}/$archdir/
(cd $RPM_BUILD_ROOT/%{jbhomedir}/%{jbosswebnativedir}/$archdir && for i in `ls %{_libdir}/libapr-1.so.0`; do ln -s $i libapr-1.so; done)
%if "%{?rhel}" == "5"
(cd $RPM_BUILD_ROOT/%{jbhomedir}/%{jbosswebnativedir}/$archdir && for i in `ls /%{_lib}/libssl.so.6`; do ln -s $i libssl.so; done)
(cd $RPM_BUILD_ROOT/%{jbhomedir}/%{jbosswebnativedir}/$archdir && for i in `ls /%{_lib}/libcrypto.so.6`; do ln -s $i libcrypto.so; done)
%else
# these symlinks are the same for RHEL 6 and 7
(cd $RPM_BUILD_ROOT/%{jbhomedir}/%{jbosswebnativedir}/$archdir && for i in `ls %{_libdir}/libssl.so.10`; do ln -s $i libssl.so; done)
(cd $RPM_BUILD_ROOT/%{jbhomedir}/%{jbosswebnativedir}/$archdir && for i in `ls %{_libdir}/libcrypto.so.10`; do ln -s $i libcrypto.so; done)
%endif

%if %{with_zips}
%{__mkdir_p} ${RPM_BUILD_ROOT}%{_javadir}/jbossas-fordev
%{__install} ../%{name}-%{version}-src.zip ${RPM_BUILD_ROOT}%{_javadir}/jbossas-fordev/
%endif

# repolib
%if %with repolib
        tag=`echo %{version}-brew`
        sed -i "s/@VERSION@/$tag/g" %{SOURCE2}
        tag=`echo %{name}-%{version}-%{release} | sed 's|\.|_|g'`
        sed -i "s/@TAG@/$tag/g" %{SOURCE2}
        install -d -m 755 $RPM_BUILD_ROOT%{repodir}
        install -d -m 755 $RPM_BUILD_ROOT%{repodirsrc}
        install -p -m 0644 %{SOURCE2} $RPM_BUILD_ROOT%{repodir}/component-info.xml
        install -m 755 %{SOURCE0} $RPM_BUILD_ROOT%{repodirsrc}
        install -p -m 755 %{SOURCE3} $RPM_BUILD_ROOT%{repodir}/upload.sh
        pushd $RPM_BUILD_ROOT%{repodir}
        install -d -m 755 $RPM_BUILD_ROOT/usr/share/java/repository.jboss.com/maven2-brew/apache-tomcat-connector-native/%{version}
        ./upload.sh $RPM_BUILD_ROOT/usr/share/java/repository.jboss.com/maven2-brew/
        popd
%endif

%clean
rm -rf $RPM_BUILD_ROOT


%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig


%files
%defattr(-,root,root,-)
%doc CHANGELOG.txt LICENSE NOTICE
# Note: unversioned *.so needed here due to how Tomcat loads the lib :(
%{_libdir}/libtcnative*.so*

%files -n jbossas-jbossweb-native
%defattr(0644,jboss,jboss,0755)
%dir %{_datadir}/jbossas
%dir %{_datadir}/jbossas/modules
%dir %{_datadir}/jbossas/modules/system
%dir %{_datadir}/jbossas/modules/system/layers
%dir %{_datadir}/jbossas/modules/system/layers/base
%dir %{_datadir}/jbossas/modules/system/layers/base/org
%dir %{_datadir}/jbossas/modules/system/layers/base/org/jboss/as
%dir %{_datadir}/jbossas/modules/system/layers/base/org/jboss/as/web
%dir %{_datadir}/jbossas/modules/system/layers/base/org/jboss/as/web/main
%dir %{jbhomedir}/%{jbosswebnativedir}
%dir %{jbhomedir}/%{jbosswebnativedir}/*/
%{jbhomedir}/%{jbosswebnativedir}/*

%if %{with_zips}
%files src-zip
%defattr(0644,root,root,0755)
%{_javadir}/jbossas-fordev/%{name}-%{version}-src.zip
%endif

%if %with repolib
%files repolib
%defattr(0644,root,root,0755)
%{_javadir}/repository.jboss.com
%endif

%changelog
* Thu Jun 02 2016 Coty Sutherland <csutherl@redhat.com> - 1.1.34-1
- Update openssl requirements to build with openssl 1.0.2

* Tue Mar 15 2016 Honza Fnukal <hfnukal@redhat.com> - 1.1.32-3
- Update release for one off patch for EAP native

* Fri Oct 31 2014 Vaclav Tunka <vtunka@redhat.com> - 1.1.32-1
- Upgrade to 1.1.32
- Remove BZ56396 patch that's already incorporated in new tag

* Tue Apr 29 2014 Vaclav Tunka <vtunka@redhat.com> - 1.1.30-1
- Upgrade to 1.1.30

* Tue Aug  6 2013 Mladen Turk <mturk@redhat.com> - 1.1.27-2
- Rebuild with patched APR.

* Tue Feb 19 2013 Vaclav Tunka <vtunka@redhat.com> - 1.1.27-1
- Rebase to 1.1.27

* Wed Sep  5 2012 Mladen Turk <mturk@redhat.com> - 1.1.24-2
- Rebuild.

* Tue Jun 19 2012 Mladen Turk <mturk@redhat.com> - 1.1.24-1
- Rebase to 1.1.24.

* Mon Mar  5 2012 Mladen Turk <mturk@redhat.com> - 1.1.23-1
- Rebase to 1.1.23.

* Wed Feb  1 2012 Mladen Turk <mturk@redhat.com> - 1.1.22-2
- Rebuild using git repository.

* Thu Dec 22 2011 Mladen Turk <pcheung@redhat.com>  - 1.1.22-1
- Upgrade to 1.1.22

* Thu Dec  8 2011 Vaclav Tunka <vtunka@redhat.com> - 1.1.20-2.4
- Build for EAP 6 / EWS 2

* Wed Oct 26 2011 Vaclav Tunka <vtunka@redhat.com> - 1.1.20-2.3
- Rebuild

* Fri Oct 21 2011 Vaclav Tunka <vtunka@redhat.com> - 1.1.20-2.2
- Makefile include for general xbuild Makefile
- Moving to generated .ini file
- Add win build requires for xbuild, openssl and httpd

* Wed Oct 12 2011 Mladen Turk <pcheung@redhat.com>  - 1.1.20-2.1
- Add winspec files

* Thu Jan 06 2011 Permaine Cheung <pcheung@redhat.com>  - 1.1.20-2.0
- Build with no-strict-aliasing as suggested by rpmdiff

* Thu Nov 25 2010 Permaine Cheung <pcheung@redhat.com> - 1.1.20-1.0
- Upgrade to 1.1.20
- Remove patch that has already been incorporated in the new version

* Fri May 28 2010 Permaine Cheung <pcheung@redhat.com> - 1.1.19-4.0
- Add repolib for sources

* Fri May 07 2010 Martha Benitez <mbenitez@redhat.com> - 1.1.19-3.0.1
- rebuilt

* Tue Apr 06 2010 Hui Wang <huwang@redhat.com> - 1.1.19-3.0
- Rebuild

* Mon Feb 08 2010 Permaine Cheung <pcheung@redhat.com> - 1.1.19-2.0
- Add patch for BZ48584 (From mturk@redhat.com)

* Fri Jan 15 2010 Permaine Cheung <pcheung@redhat.com> - 1.1.19-1.0
- Upgrade to 1.1.19

* Mon Dec 14 2009 Permaine Cheung <pcheung@redhat.com> - 1.1.18-1.0
- Upgrade to 1.1.18
- Remove patch for CVE-2009-3555 as it is fixed in 1.1.18

* Mon Nov 16 2009 Permaine Cheung <pcheung@redhat.com> - 1.1.16-1.2
- Add fix for CVE-2009-3555

* Wed Jul 22 2009 Permaine Cheung <pcheung@redhat.com> - 1.1.16-1.1
- Add src-zip

* Thu Nov 20 2008 Ville Skyttä <ville.skytta at iki.fi> - 1.1.16-1
- 1.1.16.

* Thu Sep 11 2008 Ville Skyttä <ville.skytta at iki.fi> - 1.1.15-1
- 1.1.15.

* Sat Jul  5 2008 Ville Skyttä <ville.skytta at iki.fi> - 1.1.14-1
- 1.1.14.

* Sat Feb 16 2008 Ville Skyttä <ville.skytta at iki.fi> - 1.1.13-1
- 1.1.13.

* Tue Feb 12 2008 Ville Skyttä <ville.skytta at iki.fi> - 1.1.12-2
- Apply upstream fix to silence (seemingly harmless?) configure error spewage.

* Sat Dec 22 2007 Ville Skyttä <ville.skytta at iki.fi> - 1.1.12-1
- 1.1.12.

* Wed Dec 05 2007 Release Engineering <rel-eng at fedoraproject dot org> - 1.1.10-3
 - Rebuild for deps

* Wed Dec  5 2007 Ville Skyttä <ville.skytta at iki.fi> - 1.1.10-2
- Rebuild.

* Thu Sep  6 2007 Ville Skyttä <ville.skytta at iki.fi> - 1.1.10-1
- First Fedora build.

* Mon Aug 20 2007 Ville Skyttä <ville.skytta at iki.fi> - 1.1.10-0.2
- License: ASL 2.0.

* Mon Apr 16 2007 Ville Skyttä <ville.skytta at iki.fi> - 1.1.10-0.1
- 1.1.10.

* Tue Apr  3 2007 Ville Skyttä <ville.skytta at iki.fi> - 1.1.9-0.1
- 1.1.9.

* Sat Jan  6 2007 Ville Skyttä <ville.skytta at iki.fi> - 1.1.8-0.1
- 1.1.8.

* Tue Dec 12 2006 Ville Skyttä <ville.skytta at iki.fi> - 1.1.7-0.1
- 1.1.7.

* Mon Nov 13 2006 Ville Skyttä <ville.skytta at iki.fi> - 1.1.6-0.1
- 1.1.6.

* Sat Sep 30 2006 Ville Skyttä <ville.skytta at iki.fi> - 1.1.4-0.1
- 1.1.4, specfile cleanup.

* Wed Jun 14 2006 Ville Skyttä <ville.skytta at iki.fi> - 1.1.3-0.1
- First build.
