/*
 * The definitions file for COVALENT-APACHE-LOGGING-MIB.
 */
#ifndef __APACHE_LOGGING_MIB_H__
#define __APACHE_LOGGING_MIB_H__

#define COVALENT_SNMP_LOGGING_VERSION 0.0

typedef struct {
    unsigned long counter;
    apr_time_t lasttime;
    unsigned char lastmsg[ MAX_SNMPADMINSTRING ];
} loglevel_entry;

typedef struct {
    unsigned long www_service;
    unsigned long level;
    apr_time_t time;
    unsigned char msg[ MAX_SNMPADMINSTRING ];
} last_n_log_entry;

typedef struct {
    loglevel_entry loglevel_info[ 8 ];
    char *file;
    unsigned int enable;
    unsigned int level;
    unsigned int lastNSize;
    unsigned int lastNIndex;
#define DEFAULT_LASTN_LOG_MSG	10
#define MAX_LASTN_LOG_MSG	10
    last_n_log_entry lastNTable[ MAX_LASTN_LOG_MSG ];
} apache_logging_info;

#define APPLICATION	1 /* Equals OID of Notifications. */
#define WWW_SERVICE	2 /* Equals OID of Notifications. */

#ifdef COVALENT_APACHE_LOGGING_APPLICATION_GROUP
void init_apache_logging_mib_appl(apr_pool_t *p, server_rec *s);
void update_apache_logging_mib_appl(int www_service,
                       int log_level, char *log_message);
#else /* COVALENT_APACHE_LOGGING_APPLICATION_GROUP */
#define init_apache_logging_mib_appl(p, s)
#define update_apache_logging_mib_appl(www_service, log_level, log_message)
#endif /* COVALENT_APACHE_LOGGING_APPLICATION_GROUP */

#ifdef COVALENT_APACHE_LOGGING_WWW_SERVICE_GROUP
void init_apache_logging_mib_www_service(apr_pool_t *p, server_rec *s);
void update_apache_logging_mib_www_service(int www_service,
                       int log_level, char *log_message);
#else /* COVALENT_APACHE_LOGGING_WWW_SERVICE_GROUP */
#define init_apache_logging_mib_www_service(p, s)
#define update_apache_logging_mib_www_service(www_service, log_level, log_message)
#endif /* COVALENT_APACHE_LOGGING_WWW_SERVICE_GROUP */

void update_apache_logging_mib(int type, apache_logging_info *info,
                       unsigned int www_service, unsigned int log_level,
                       char *log_message);
void generate_notification(int type, long www_service,
                       long log_level, apr_time_t log_time, char *log_message);
char *snmp_error_logging_open(int init_state);
int snmp_error_logging_get_socket(void);
int snmp_error_logging_recv(int socket);
void snmp_error_logging_send(const char *file, int line, int level,
                apr_status_t status, const server_rec *s,
                const request_rec *r, apr_pool_t *pool,
                const char *errstr);


#endif /* __APACHE_LOGGING_MIB_H__ */
