/* $Date: 2008-01-18 07:11:17 +0800 (Fri, 18 Jan 2008) $ $Id: covalent-snmp.h 8676 2008-01-17 23:11:17Z ispringer $ harrie@covalent.net
 */
#ifndef __COVALENT_SNMP_H__
#define __COVALENT_SNMP_H__

#ifndef BUCKETTYPE_IS_SDBM
#define BUCKETTYPE_IS_SDBM
#endif
#ifdef HAVE_DB_H
#undef HAVE_DB_H
#endif
#ifdef HAVE_DB_185_H
#undef HAVE_DB_185_H
#endif
#ifdef HAVE_NDBM_H
#undef HAVE_NDBM_H
#endif


#ifdef EVAL_VERSION
#define EVAL_STRING	"(eval)"
#else
#define EVAL_STRING	""
#endif

#ifndef COVALENT_SNMP_VERSION
#define COVALENT_SNMP_VERSION	PACKAGE "/" VERSION EVAL_STRING
#endif

/* SNMP configuration idirectory for the snmpd.conf file */
#ifndef COVALENT_SNMP_CONFIGURATION_DIR
#define COVALENT_SNMP_CONFIGURATION_DIR     "conf"
#endif

/* SNMP configuration directory for persistent information */
#ifndef COVALENT_SNMP_PERSISTENT_DIR
#define COVALENT_SNMP_PERSISTENT_DIR "var"
#endif

#ifndef DEFAULT_WWWDOCLASTNSIZE
#define DEFAULT_WWWDOCLASTNSIZE			25
#endif

#ifndef MAX_WWWDOCLASTNSIZE
#define MAX_WWWDOCLASTNSIZE			DEFAULT_WWWDOCLASTNSIZE
#endif

#ifndef DEFAULT_WWWDOCBUCKETTIMEINTERVAL
#define DEFAULT_WWWDOCBUCKETTIMEINTERVAL	900 /* in seconds */
#endif

#ifndef DEFAULT_WWWDOCBUCKETS
#define DEFAULT_WWWDOCBUCKETS			2
#endif

#ifndef MAX_WWWDOCBUCKETS
#define MAX_WWWDOCBUCKETS			DEFAULT_WWWDOCBUCKETS
#endif

#ifndef DEFAULT_WWWDOCTOPNSIZE
#define DEFAULT_WWWDOCTOPNSIZE        25
#endif

#ifndef MAX_WWWDOCTOPNSIZE
#define MAX_WWWDOCTOPNSIZE            DEFAULT_WWWDOCTOPNSIZE
#endif

/* HTTP request response types. The variables are
 * generated by remake_status in status_code.h */
extern int responseTypes[];
extern char *requestTypes[];
extern int derived_hard_server_limit;

/* Specific type definitions for the HTTP protocol specific tables. */
typedef struct {
    unsigned long requests;
    unsigned long bytes;
    unsigned long lastTime;
} wwwRequestIn_t;

typedef struct {
    unsigned long requests;
    unsigned long bytes; 
    unsigned long lastTime;
} wwwRequestOut_t;

typedef struct {
    unsigned long responses;
    unsigned long bytes; 
    unsigned long lastTime;
} wwwResponseIn_t;

typedef struct {
    unsigned long responses;
    unsigned long bytes; 
    unsigned long lastTime;
} wwwResponseOut_t;

typedef struct {
    char name[ MAX_WWWDOCNAME ];
    time_t timestamp;
    int requestType;
    int responseType;
#ifndef NO_WWW_DOCUMENTS_GROUP
    char statusMsg[ MAX_WWWDOCLASTNSTATUSMSG ];
    unsigned long bytes;
#endif /* NO_WWW_DOCUMENTS_GROUP */
} wwwDocLastN_t;

typedef struct {
    char  name[ MAX_WWWDOCNAME ];
    unsigned long  accesses;
    unsigned long  bytes;
    int lastResponseType;
} wwwDocTopN_t;

typedef struct {
    time_t timestamp;
    unsigned long accesses;
    unsigned long documents;
    unsigned long bytes;
    wwwDocTopN_t accessTopNTable[ MAX_WWWDOCTOPNSIZE ];
    wwwDocTopN_t bytesTopNTable[ MAX_WWWDOCTOPNSIZE ];
} wwwDocBucket_t;

/* Here we define for the various systems the DBM-system to be used. */
#ifdef HAVE_DB_185_H
#include <db_185.h>
#define DB_TYPE         DB*
#define RECORD_INSERT   0
#define RECORD_REPLACE  0
#define FIRST_RECORD    R_FIRST
#define NEXT_RECORD     R_NEXT
#elif HAVE_DB_H
#include <db.h>
#define DB_TYPE         DB*
#define RECORD_INSERT   0
#define RECORD_REPLACE  0
#define FIRST_RECORD    R_FIRST
#define NEXT_RECORD     R_NEXT
#elif HAVE_NDBM_H
#include <ndbm.h>
#define USE_NDBM_BUCKET
#define DB_TYPE		DBM*
#define RECORD_INSERT	DBM_INSERT
#define RECORD_REPLACE	DBM_REPLACE
#define FIRST_RECORD	0
#define NEXT_RECORD	1
#elif BUCKETTYPE_IS_SDBM
#include <covalent_sdbm.h>
#define USE_NDBM_BUCKET
#define DB_TYPE		DBM*
#define RECORD_INSERT	0
#define RECORD_REPLACE	1
#define FIRST_RECORD	0
#define NEXT_RECORD	1
#endif

typedef struct {
    unsigned long	wwwSummaryInRequests;
    unsigned long	wwwSummaryOutRequests;
    unsigned long	wwwSummaryInResponses;
    unsigned long	wwwSummaryOutResponses;
    unsigned long	wwwSummaryInLowBytes;
    unsigned long	wwwSummaryOutLowBytes;
#ifndef NO_WWW_REQUEST_IN_GROUP
    wwwRequestIn_t	wwwRequestIn[ METHODS - 1 ];
#endif
#ifndef NO_WWW_REQUEST_OUT_GROUP
    wwwRequestOut_t	wwwRequestOut[ METHODS ];
#endif
#ifndef NO_WWW_RESPONSE_IN_GROUP
    wwwResponseIn_t	wwwResponseIn[ RESPONSE_CODES ];
#endif
#ifndef NO_WWW_RESPONSE_OUT_GROUP
    wwwResponseOut_t	wwwResponseOut[ RESPONSE_CODES ];
#endif
#ifndef NO_WWW_DOCUMENTS_GROUP
    unsigned long	wwwDocCtrlLastNSize;
    unsigned long	temp_wwwDocCtrlLastNSize;
    unsigned long	wwwDocCtrlLastNLock;
    unsigned long	temp_wwwDocCtrlLastNLock;
    unsigned long	wwwDocCtrlBuckets;
    unsigned long	temp_wwwDocCtrlBuckets;
    unsigned long	wwwDocCtrlBucketTimeInterval;
    unsigned long	temp_wwwDocCtrlBucketTimeInterval;
    unsigned long	wwwDocCtrlTopNSize;
    unsigned long	temp_wwwDocCtrlTopNSize;
    /* wwwDocLastNtable */
    wwwDocLastN_t	wwwDocLastNTable[ MAX_WWWDOCLASTNSIZE ];
    unsigned long	wwwDocLastNIndex;
    /* wwwDocBucketTables */
    wwwDocBucket_t	wwwDocBucketTable[ MAX_WWWDOCBUCKETS ];
    unsigned long	wwwDocBucketIndex;
    DB_TYPE		wwwDocBucket;
    char		*wwwDocBucketName;
#endif
} wwwStatistics_t;

int covalent_snmp_update_www_statistics(int socket);
void covalent_snmp_main(server_rec *s, pool *p);
int get_server_index(int unique_token);

/* Module specific funtions */
int covalent_snmp_logger(request_rec *r);
void covalent_snmp_module_init(server_rec *s, pool *p);
void covalent_snmp_child_init(server_rec *s, pool *p);

/* Configuration command specific directives */
const char *set_snmp_config_dir(cmd_parms *cmd, void *dummy, char *arg);
const char *set_snmp_persistent_dir(cmd_parms *cmd, void *dummy, char *arg);
const char *set_snmp_user(cmd_parms *cmd, void *dummy, char *arg);
const char *set_snmp_max_clients_limit(cmd_parms *cmd, void *dummy, char *arg);
const char *set_snmp_request_types(cmd_parms *cmd, void *dummy, char *arg);
const char *set_snmp_response_types(cmd_parms *cmd, void *dummy, char *arg);

DB_TYPE		covalent_snmp_wwwDocBucket_open(char *name);
void		covalent_snmp_wwwDocBucket_close(DB_TYPE wwwdocbucket);
int		covalent_snmp_wwwDocBucket_store(DB_TYPE wwwdocbucket, char *keystr, wwwDocTopN_t *record, int action);
wwwDocTopN_t	*covalent_snmp_wwwDocBucket_fetch(DB_TYPE wwwdocbucket, char *keystr);
wwwDocTopN_t	*covalent_snmp_wwwDocBucket_seqfetch(DB_TYPE wwwdocbucket, int action);
const char      *covalent_snmp_wwwDocBucket_strerror(void);


#ifndef EVAL_MAX_SYSUPTIME
#define EVAL_MAX_SYSUPTIME 86400000 /* 10 days in milliseconds */
#endif

#endif /* __COVALENT_SNMP_H__ */
