%define contentdir /var/www
%define suexec_caller apache
%define mmn 20051115
%define vstring Red Hat
%define distro Red Hat Enterprise Web Server
# Minimum version of OpenSSL having support for the secure TLS reneg API
%define opensslver 0.9.8e-12.el5_4.4

%define _with_zips 1
%define _with_src_zips 1
# If you want to build the zips,
# give rpmbuild option '--with zips'

%define with_zips %{?_with_zips:1}%{!?_with_zips:0}
%define without_zips %{!?_with_zips:1}%{?_with_zips:0}
%define with_src_zips %{?_with_src_zips:1}%{!?_with_src_zips:0}
%define without_src_zips %{!?_without_src_zips:1}%{?_without_src_zips:0}

%define ews_release EWS_2.1.1.CR1

Summary: Apache HTTP Server
Name: httpd
Version: 2.2.26
Release: 25%{?dist}
URL: http://httpd.apache.org/
Source0: http://www.apache.org/dist/httpd/httpd-%{version}.tar.gz
Source1: index.html
Source3: httpd.logrotate
Source4: httpd.init
Source5: httpd.sysconf
Source10: httpd.conf
Source11: ssl.conf
Source12: welcome.conf
Source13: manual.conf
Source14: proxy_ajp.conf
# Documentation
Source33: README.confd
# Multiplatform file
Source40: httpd.conf.windows
Source41: ssl.conf.windows
# build/scripts patches
Patch1: httpd-2.2.22-apctl.patch
Patch2: httpd-2.2.17-apxs.patch
#Patch3: httpd-2.2.9-deplibs.patch
#Patch4: httpd-2.1.10-disablemods.patch
#Patch5: httpd-2.1.10-layout.patch
# Features/functional changes
#Patch20: httpd-2.2.14-release.patch
#Patch21: httpd-2.2.11-xfsz.patch
#Patch22: httpd-2.1.10-pod.patch
#Patch23: httpd-2.0.45-export.patch
#Patch24: httpd-2.2.11-corelimit.patch
#Patch25: httpd-2.2.11-selinux.patch
#Patch26: httpd-2.2.14-sslocsp.patch
# Multiplatform patches
Patch40: httpd-2.2.10-sol-apr-xpg4.patch
Patch41: httpd-2.2.10-win-defs.patch
Patch42: httpd-2.2.14-win-apr.patch
Patch43: httpd-2.2.17-force-expat1.patch
Patch44: httpd-2.2.10-apmon.patch
Patch45: httpd-2.2.15-nmakefiles.patch
Patch46: httpd-2.2.26-aprcfg.patch
Patch47: httpd-2.2.26-win-substitute.patch

# Bug fixes
#Patch60: httpd-2.0.52-logresline.patch
#Patch61: httpd-2.2.3-defpidlog.patch
#Patch62: httpd-2.2.3-extfiltereos.patch
#Patch63: httpd-2.2.3-graceful-ebadf.patch
#Patch64: httpd-2.2.3-noxpad.patch
#Patch65: httpd-2.2.3-pngmagic.patch
#Patch68: httpd-2.2.15-proxyconn.patch
#Patch70: httpd-2.2.15-ssloidval.patch
#Patch71: httpd-2.2.15-davputfail.patch

#Patch75: httpd-2.2.17-bz48735.patch
#Patch76: httpd-2.2.21-JBPAPP-9087.patch
#Patch77: httpd-JBPAPP-3614.patch

#Patch79: httpd-2.2.15-CVE-2011-3368.patch
#Patch81: httpd-2.2.22-r815719.patch
#Patch83: httpd-2.2.22-bz894955.patch
#Patch84: httpd-2.2.3-r693108.patch
#Patch85: httpd-2.2.15-CVE-2012-3499.patch
#Patch86: httpd-2.2.15-CVE-2012-4558.patch
#Patch87: httpd-ocsp-entrust.patch
#Patch88: httpd-2.2.22-ocsptrust.patch
#Patch89: httpd-2.2.15-CVE-2013-6438.patch
#Patch90: httpd-2.2.15-CVE-2014-0098.patch
#Patch91: CVE-2014-0026.patch
#Patch92: CVE-2014-0118.patch
#Patch93: CVE-2014-0231.patch
#Patch94: httpd-CVE-2013-5704.patch
#Patch95: httpd-2.2.26-CVE-2009-3560-revised.patch
#Patch96: httpd-2.2.26-CVE-2009-3720.patch
#Patch97: httpd-2.2.26-CVE-2012-0876.patch
#Patch98: httpd-2.2.26-CVE-2012-1148.patch
#Patch99: httpd-2.2.26-r1542327.patch
#Patch100: httpd-2.2.26-CVE-2015-3183.patch
#Patch101: httpd-2.2.26-r1282726.patch


License: ASL 2.0
Group: System Environment/Daemons
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
BuildRequires: zip
BuildRequires: autoconf, perl, pkgconfig, findutils, ed
BuildRequires: db4-devel, expat, expat-devel, zlib-devel, libselinux-devel
BuildRequires: apr-devel >= 1.2.0, apr-util-devel >= 1.2.0, pcre-devel >= 5.0
Requires: initscripts >= 8.36, /etc/mime.types
Obsoletes: httpd-suexec
Requires(pre): /usr/sbin/useradd
Requires(post): chkconfig
Provides: webserver
Provides: httpd-mmn = %{mmn}
Obsoletes: apache, secureweb, mod_dav, mod_gzip, stronghold-apache, stronghold-htdocs
Obsoletes: mod_put, mod_roaming
Conflicts: pcre < 4.0

#win-buildrequires: xbuild
#win-buildrequires: zlib
#win-buildrequires: libiconv
#win-buildrequires: db4
#win-buildrequires: openssl

#sun-buildrequires: zlib
#sun-buildrequires: db4
#sun-buildrequires: openssl
#sun-buildrequires: cyrus-sasl
#sun-buildrequires: openldap

%description
The Apache HTTP Server is a powerful, efficient, and extensible
web server.
%if %{with_zips}
%package zip
Summary:     Container for the zipped distribution of the Apache HTTP server.
Group:       Development

%description zip
Container for the zipped distribution of the Apache HTTP server.
%endif

%if %{with_src_zips}
%package src-zip
Summary:     Container for the zipped source code of the Apache HTTP server.
Group:       Development

%description src-zip
Container for the source code of the Apache HTTP server.
%endif

%package devel
Group: Development/Libraries
Summary: Development tools for the Apache HTTP server.
Obsoletes: secureweb-devel, apache-devel, stronghold-apache-devel
Requires: apr-devel, apr-util-devel, pkgconfig
Requires: httpd = %{version}-%{release}

%description devel
The httpd-devel package contains the APXS binary and other files
that you need to build Dynamic Shared Objects (DSOs) for the
Apache HTTP Server.

If you are installing the Apache HTTP server and you want to be
able to compile or develop additional modules for Apache, you need
to install this package.

%package manual
Group: Documentation
Summary: Documentation for the Apache HTTP server.
Requires: httpd = %{version}-%{release}
Obsoletes: secureweb-manual, apache-manual

%description manual
The httpd-manual package contains the complete manual and
reference guide for the Apache HTTP server. The information can
also be found at http://httpd.apache.org/docs/2.2/.

%package tools
Group: System Environment/Daemons
Summary: Tools for use with the Apache HTTP Server

%description tools
The httpd-tools package contains tools which can be used with
the Apache HTTP Server.

%package -n mod_ssl
Group: System Environment/Daemons
Summary: SSL/TLS module for the Apache HTTP server
Epoch: 1
BuildRequires: jbcs-httpd-openssl-devel
Requires(post): jbcs-httpd-openssl, /bin/cat
Requires: httpd = 0:%{version}-%{release}, httpd-mmn = %{mmn}
Requires: jbcs-httpd-openssl
Obsoletes: stronghold-mod_ssl

%description -n mod_ssl
The mod_ssl module provides strong cryptography for the Apache Web
server via the Secure Sockets Layer (SSL) and Transport Layer
Security (TLS) protocols.

%prep
%setup -q -n httpd-%{ews_release}
%patch1 -p1 -b .apctl
%patch2 -p1 -b .apxs
#%patch3 -p1 -b .deplibs
#%patch4 -p1 -b .disablemods
#%patch5 -p1 -b .layout

#%patch21 -p1 -b .xfsz
#%patch22 -p1 -b .pod
#%patch23 -p1 -b .export
#%patch24 -p1 -b .corelimit
#%patch26 -p1 -b .sslocsp

%patch40 -p1 -b .xpg4
%patch41 -p1 -b .windefs
%patch42 -p1 -b .winapr
%patch43 -p1 -b .expat1
%patch44 -p1 -b .apmonitor
%patch45 -p1 -b .windefs
%patch46 -p1 -b .aprcfg
%patch47 -p1 -b .winsubstitute

#%patch60 -p1 -b .logresline
#%patch61 -p1 -b .defpidlog
#%patch62 -p1 -b .extfiltereos
#%patch63 -p1 -b .graceful-ebadf
#%patch64 -p1 -b .noxpad
#%patch65 -p1 -b .pngmagic
#%patch68 -p1 -b .proxyconn
#%patch70 -p1 -b .ssloidval
#%patch71 -p1 -b .davputfail
#
#%patch75 -p1 -b .bz48735
#%patch77 -p1 -b .jbpapp3614
#
#%patch79 -p1 -b .cve3368
#%patch81 -p1 -b .r815719

cp -p $RPM_SOURCE_DIR/httpd.init httpd.init
#%patch84 -p1 -b .r693108
#%patch87 -p1 -b .ocspentrust
#%patch88 -p1 -b .ocsptrust
#%patch89 -p1 -b .cve6438
#%patch90 -p1 -b .cve0089
#%patch91 -p0
#%patch92 -p0
#%patch93 -p0
#%patch94 -p1
#%patch95 -p1 -b .cve3560
#%patch96 -p1 -b .cve3720
#%patch97 -p1 -b .cve0876
#%patch98 -p1 -b .cve1148
#%patch99 -p1 -b .r1542327
#%patch100 -p1 -b .cve3183
#%patch101 -p1 -b .r1282726

# Patch in vendor/release string
sed "s/@VENDOR@/%{distro}/;s/@RELEASE@/%{version}-%{release}/" < %{PATCH20} | patch -p1 -b -z .release

# Safety check: prevent build if defined MMN does not equal upstream MMN.
vmmn=`echo MODULE_MAGIC_NUMBER_MAJOR | cpp -include include/ap_mmn.h | sed -n '/^2/p'`
if test "x${vmmn}" != "x%{mmn}"; then
   : Error: Upstream MMN is now ${vmmn}, packaged MMN is %{mmn}.
   : Update the mmn macro and rebuild.
   exit 1
fi

: Building for '%{distro}' with MMN %{mmn} and vendor string '%{vstring}'

# Fix for JBPAPP-3740
sed -i -e '/  Installation$/{N;N;N;N;N;d;}' README

%if %{with_src_zips}
pushd $RPM_BUILD_DIR
tar czf $RPM_BUILD_DIR/httpd-%{version}-src.tar.gz httpd-%{version}
popd
%endif

%build
# forcibly prevent use of bundled apr, apr-util, pcre
rm -rf srclib/{apr,apr-util,pcre}

# regenerate configure scripts
autoheader && autoconf || exit 1

# Before configure; fix location of build dir in generated apxs
%{__perl} -pi -e "s:\@exp_installbuilddir\@:%{_libdir}/httpd/build:g" \
	support/apxs.in

CFLAGS="$RPM_OPT_FLAGS -Wformat-security -fno-strict-aliasing"
SH_LDFLAGS="-Wl,-z,relro"
export CFLAGS SH_LDFLAGS

# Hard-code path to links to avoid unnecessary builddep
export LYNX_PATH=/usr/bin/links

function mpmbuild()
{
mpm=$1; shift
mkdir $mpm; pushd $mpm
../configure \
 	--prefix=%{_sysconfdir}/httpd \
 	--exec-prefix=%{_prefix} \
 	--bindir=%{_bindir} \
 	--sbindir=%{_sbindir} \
 	--mandir=%{_mandir} \
	--libdir=%{_libdir} \
	--sysconfdir=%{_sysconfdir}/httpd/conf \
	--includedir=%{_includedir}/httpd \
	--libexecdir=%{_libdir}/httpd/modules \
	--datadir=%{contentdir} \
        --with-installbuilddir=%{_libdir}/httpd/build \
	--with-mpm=$mpm \
        --with-apr=%{_prefix} --with-apr-util=%{_prefix} \
	--enable-suexec --with-suexec \
	--with-suexec-caller=%{suexec_caller} \
	--with-suexec-docroot=%{contentdir} \
	--with-suexec-logfile=%{_localstatedir}/log/httpd/suexec.log \
	--with-suexec-bin=%{_sbindir}/suexec \
	--with-suexec-uidmin=500 --with-suexec-gidmin=100 \
        --enable-pie \
        --with-pcre \
	$*

make %{?_smp_mflags} EXTRA_CFLAGS="-Werror-implicit-function-declaration"
popd
}

# Build everything and the kitchen sink with the prefork build
mpmbuild prefork \
        --enable-mods-shared=all \
	--enable-ssl --with-ssl \
	--enable-proxy \
        --enable-cache \
        --enable-disk-cache \
        --enable-ldap --enable-authnz-ldap \
        --enable-cgid \
        --enable-authn-anon --enable-authn-alias \
        --disable-imagemap


# For the other MPMs, just build httpd and no optional modules
mpmbuild worker --enable-modules=none
mpmbuild event --enable-modules=none

%install
rm -rf $RPM_BUILD_ROOT

pushd prefork
make DESTDIR=$RPM_BUILD_ROOT install
popd

# install alternative MPMs
install -m 755 worker/httpd $RPM_BUILD_ROOT%{_sbindir}/httpd.worker
install -m 755 event/httpd $RPM_BUILD_ROOT%{_sbindir}/httpd.event

# install var directory
mkdir $RPM_BUILD_ROOT%{_sysconfdir}/httpd/var

# install conf file/directory
mkdir $RPM_BUILD_ROOT%{_sysconfdir}/httpd/conf.d
install -m 644 $RPM_SOURCE_DIR/README.confd \
    $RPM_BUILD_ROOT%{_sysconfdir}/httpd/conf.d/README
for f in ssl.conf welcome.conf manual.conf proxy_ajp.conf; do
  install -m 644 $RPM_SOURCE_DIR/$f $RPM_BUILD_ROOT%{_sysconfdir}/httpd/conf.d/$f
done

rm $RPM_BUILD_ROOT%{_sysconfdir}/httpd/conf/*.conf
install -m 644 $RPM_SOURCE_DIR/httpd.conf \
   $RPM_BUILD_ROOT%{_sysconfdir}/httpd/conf/httpd.conf

#JBPAPP-9446
sed -i -e "s:LoadModule proxy_balancer_module:#LoadModule proxy_balancer_module:" $RPM_BUILD_ROOT%{_sysconfdir}/httpd/conf/httpd.conf

mkdir $RPM_BUILD_ROOT%{_sysconfdir}/sysconfig
install -m 644 $RPM_SOURCE_DIR/httpd.sysconf \
   $RPM_BUILD_ROOT%{_sysconfdir}/sysconfig/httpd

# https://issues.jboss.org/browse/JBPAPP-10212
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/run/httpd

# for holding mod_dav lock database
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/lib/dav

# create a prototype session cache
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/cache/mod_ssl
touch $RPM_BUILD_ROOT%{_localstatedir}/cache/mod_ssl/scache.{dir,pag,sem}

# create cache root
mkdir $RPM_BUILD_ROOT%{_localstatedir}/cache/mod_proxy

%if %{with_zips}
mkdir -p httpd/{include,lib/build,sbin,cache/mod_ssl,conf,conf.d,logs,run,var,modules,www/html,www/error}
cp -r $RPM_SOURCE_DIR/index.html httpd/www/error/noindex.html
cp -r $RPM_BUILD_ROOT%{_sysconfdir}/httpd/conf.d/* httpd/conf.d/
cp -r $RPM_BUILD_ROOT%{_sysconfdir}/httpd/conf/{httpd.conf,magic} httpd/conf/
cp -r $RPM_BUILD_ROOT%{_localstatedir}/www/{cgi-bin,error,icons} httpd/www
cp -r $RPM_BUILD_ROOT%{_localstatedir}/cache/* httpd/cache/
cp -r $RPM_BUILD_ROOT%{_sbindir}/* httpd/sbin/
sed -e "s|/usr/sbin/httpd|./httpd|" -e "s|/etc/sysconfig/httpd|../conf/httpd.conf|" \
 $RPM_BUILD_ROOT%{_sbindir}/apachectl > httpd/sbin/apachectl
cp -r $RPM_BUILD_ROOT%{_libdir}/httpd/modules/* httpd/modules/
cp -r $RPM_BUILD_ROOT%{_libdir}/httpd/build/* httpd/lib/build/
cp -r $RPM_BUILD_ROOT%{_libdir}/* httpd/lib/
rm -fr httpd/lib/httpd
cp -r $RPM_BUILD_ROOT%{_includedir}/httpd/* httpd/include/


#JBPAPP-3635
rm httpd/sbin/{checkgid,envvars,envvars-std,dbmmanage}
zip -q -r httpd-%{version}.zip httpd
%endif

# move utilities to /usr/bin
mv $RPM_BUILD_ROOT%{_sbindir}/{ab,htdbm,logresolve,htpasswd,htdigest} \
   $RPM_BUILD_ROOT%{_bindir}

# Make the MMN accessible to module packages
echo %{mmn} > $RPM_BUILD_ROOT%{_includedir}/httpd/.mmn

# docroot
mkdir $RPM_BUILD_ROOT%{contentdir}/html
install -m 644 $RPM_SOURCE_DIR/index.html \
	$RPM_BUILD_ROOT%{contentdir}/error/noindex.html
%{__perl} -pi -e "s:\@installroot\@::g" \
   $RPM_BUILD_ROOT%{contentdir}/error/noindex.html

# remove manual sources
find $RPM_BUILD_ROOT%{contentdir}/manual \( \
    -name \*.xml -o -name \*.xml.* -o -name \*.ent -o -name \*.xsl -o -name \*.dtd \
    \) -print0 | xargs -0 rm -f

# Strip the manual down just to English and replace the typemaps with flat files:
set +x
for f in `find $RPM_BUILD_ROOT%{contentdir}/manual -name \*.html -type f`; do
   if test -f ${f}.en; then
      cp ${f}.en ${f}
      rm ${f}.*
   fi
done
set -x

# logs
rmdir $RPM_BUILD_ROOT%{_sysconfdir}/httpd/logs
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/log/httpd

# symlinks for /etc/httpd
ln -s ../..%{_localstatedir}/log/httpd $RPM_BUILD_ROOT/etc/httpd/logs
ln -s ../..%{_localstatedir}/run/httpd $RPM_BUILD_ROOT/etc/httpd/run
ln -s ../..%{_libdir}/httpd/modules $RPM_BUILD_ROOT/etc/httpd/modules

# install SYSV init stuff
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d
install -m755 httpd.init \
	$RPM_BUILD_ROOT/etc/rc.d/init.d/httpd
%{__perl} -pi -e "s:\@docdir\@:%{_docdir}/%{name}-%{version}:g" \
	$RPM_BUILD_ROOT/etc/rc.d/init.d/httpd

# install log rotation stuff
mkdir -p $RPM_BUILD_ROOT/etc/logrotate.d
install -m644 $RPM_SOURCE_DIR/httpd.logrotate \
	$RPM_BUILD_ROOT/etc/logrotate.d/httpd

# fix man page paths
sed -e "s|/usr/local/apache2/conf/httpd.conf|/etc/httpd/conf/httpd.conf|" \
    -e "s|/usr/local/apache2/conf/mime.types|/etc/mime.types|" \
    -e "s|/usr/local/apache2/conf/magic|/etc/httpd/conf/magic|" \
    -e "s|/usr/local/apache2/logs/error_log|/var/log/httpd/error_log|" \
    -e "s|/usr/local/apache2/logs/access_log|/var/log/httpd/access_log|" \
    -e "s|/usr/local/apache2/logs/httpd.pid|/var/run/httpd.pid|" \
    -e "s|/usr/local/apache2|/etc/httpd|" < docs/man/httpd.8 \
  > $RPM_BUILD_ROOT%{_mandir}/man8/httpd.8

# Make ap_config_layout.h libdir-agnostic
sed -i '/.*DEFAULT_..._LIBEXECDIR/d;/DEFAULT_..._INSTALLBUILDDIR/d' \
    $RPM_BUILD_ROOT%{_includedir}/httpd/ap_config_layout.h

# Fix path to instdso in special.mk
sed -i '/instdso/s,top_srcdir,top_builddir,' \
    $RPM_BUILD_ROOT%{_libdir}/httpd/build/special.mk

# Remove unpackaged files
rm -f $RPM_BUILD_ROOT%{_libdir}/*.exp \
      $RPM_BUILD_ROOT/etc/httpd/conf/mime.types \
      $RPM_BUILD_ROOT%{_libdir}/httpd/modules/*.exp \
      $RPM_BUILD_ROOT%{_libdir}/httpd/build/config.nice \
      $RPM_BUILD_ROOT%{_bindir}/ap?-config \
      $RPM_BUILD_ROOT%{_sbindir}/{checkgid,dbmmanage,envvars*} \
      $RPM_BUILD_ROOT%{contentdir}/htdocs/* \
      $RPM_BUILD_ROOT%{_mandir}/man1/dbmmanage.* \
      $RPM_BUILD_ROOT%{contentdir}/cgi-bin/*

rm -rf $RPM_BUILD_ROOT/etc/httpd/conf/{original,extra}

# Make suexec a+rw so it can be stripped.  %%files lists real permissions
chmod 755 $RPM_BUILD_ROOT%{_sbindir}/suexec

%pre
# Add the "apache" user
/usr/sbin/useradd -c "Apache" -u 48 \
	-s /sbin/nologin -r -d %{contentdir} apache 2> /dev/null || :

%post
# Register the httpd service
/sbin/chkconfig --add httpd

%preun
if [ $1 = 0 ]; then
	/sbin/service httpd stop > /dev/null 2>&1
	/sbin/chkconfig --del httpd
fi

%define sslcert %{_sysconfdir}/pki/tls/certs/localhost.crt
%define sslkey %{_sysconfdir}/pki/tls/private/localhost.key

%post -n mod_ssl
umask 077

if [ ! -f %{sslkey} ] ; then
%{_bindir}/openssl genrsa -rand /proc/apm:/proc/cpuinfo:/proc/dma:/proc/filesystems:/proc/interrupts:/proc/ioports:/proc/pci:/proc/rtc:/proc/uptime 1024 > %{sslkey} 2> /dev/null
fi

FQDN=`hostname`
if [ "x${FQDN}" = "x" ]; then
   FQDN=localhost.localdomain
fi

if [ ! -f %{sslcert} ] ; then
cat << EOF | %{_bindir}/openssl req -new -key %{sslkey} \
         -x509 -days 365 -set_serial $RANDOM \
         -out %{sslcert} 2>/dev/null
--
SomeState
SomeCity
SomeOrganization
SomeOrganizationalUnit
${FQDN}
root@${FQDN}
EOF
fi

%check
# Check the built modules are all PIC
if readelf -d $RPM_BUILD_ROOT%{_libdir}/httpd/modules/*.so | grep TEXTREL; then
   : modules contain non-relocatable code
   exit 1
fi

# Verify that the same modules were built into the httpd binaries
./prefork/httpd -l | grep -v prefork > prefork.mods
for mpm in worker; do
  ./${mpm}/httpd -l | grep -v ${mpm} > ${mpm}.mods
  if ! diff -u prefork.mods ${mpm}.mods; then
    : Different modules built into httpd binaries, will not proceed
    exit 1
  fi
done

%if %{with_zips}
install -dm 755 $RPM_BUILD_ROOT/%{_javadir}/jbossas-fordev
# Copy over zip for the zip subpackage
install -m 644 httpd-%{version}.zip $RPM_BUILD_ROOT/%{_javadir}/jbossas-fordev/httpd-%{version}.zip
%endif

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)

%doc ABOUT_APACHE README CHANGES LICENSE VERSIONING NOTICE

%dir %{_sysconfdir}/httpd
%{_sysconfdir}/httpd/modules
%{_sysconfdir}/httpd/logs
%{_sysconfdir}/httpd/run
%dir %{_sysconfdir}/httpd/conf
%config %{_sysconfdir}/httpd/conf/httpd.conf
%config(noreplace) %{_sysconfdir}/httpd/conf.d/welcome.conf
%config(noreplace) %{_sysconfdir}/httpd/conf.d/proxy_ajp.conf
%config(noreplace) %{_sysconfdir}/httpd/conf/magic

%config(noreplace) %{_sysconfdir}/logrotate.d/httpd
%{_sysconfdir}/rc.d/init.d/httpd

%dir %{_sysconfdir}/httpd/conf.d
%{_sysconfdir}/httpd/conf.d/README

%config(noreplace) %{_sysconfdir}/sysconfig/httpd

%{_bindir}/*
%{_sbindir}/ht*
%{_sbindir}/apachectl
%{_sbindir}/rotatelogs
%attr(4510,root,%{suexec_caller}) %{_sbindir}/suexec

%dir %{_libdir}/httpd
%dir %{_libdir}/httpd/modules
%{_libdir}/httpd/modules/mod*.so
%exclude %{_libdir}/httpd/modules/mod_ssl.so

%dir %{contentdir}
%dir %{contentdir}/cgi-bin
%dir %{contentdir}/html
%dir %{contentdir}/icons
%dir %{contentdir}/error
%dir %{contentdir}/error/include
%{contentdir}/icons/*
%{contentdir}/error/README
%{contentdir}/error/noindex.html
%config %{contentdir}/error/*.var
%config %{contentdir}/error/include/*.html

%attr(0700,root,root) %dir %{_localstatedir}/log/httpd
%attr(0700,apache,apache) %dir %{_localstatedir}/lib/dav
%attr(0700,apache,apache) %dir %{_localstatedir}/cache/mod_proxy
%attr(0710,root,apache) %dir %{_localstatedir}/run/httpd

%{_mandir}/man8/*

%files tools
%defattr(-,root,root)
%{_bindir}/*
%{_mandir}/man1/*
%doc LICENSE

%files manual
%defattr(-,root,root)
%{contentdir}/manual
%config %{_sysconfdir}/httpd/conf.d/manual.conf

%files -n mod_ssl
%defattr(-,root,root)
%{_libdir}/httpd/modules/mod_ssl.so
%config(noreplace) %{_sysconfdir}/httpd/conf.d/ssl.conf
%attr(0700,apache,root) %dir %{_localstatedir}/cache/mod_ssl
%attr(0600,apache,root) %ghost %{_localstatedir}/cache/mod_ssl/scache.dir
%attr(0600,apache,root) %ghost %{_localstatedir}/cache/mod_ssl/scache.pag
%attr(0600,apache,root) %ghost %{_localstatedir}/cache/mod_ssl/scache.sem

%files devel
%defattr(-,root,root)
%{_includedir}/httpd
%{_sbindir}/apxs

%dir %{_libdir}/httpd/build
%{_libdir}/httpd/build/*.mk
%{_libdir}/httpd/build/*.sh

%if %{with_zips}
%files zip
%defattr(0644,root,root,0755)
%{_javadir}/jbossas-fordev/httpd-%{version}.zip
%endif

%if %{with_src_zips}
%files src-zip
%defattr(0644,root,root,0755)
%{_javadir}/jbossas-fordev/httpd-%{version}-src.tar.gz
%endif

%changelog
* Thu Jul 21 2016 Coty Sutherland <csutherl@redhat.com> - 2.2.26-25
- Update ews_release to reflect the correct source tarball name

* Thu Jul 21 2016 Honza Fnukal <hfnukal@redhat.com> - 2.2.26-24
- EAP natives 2.1.1.CR1 with updated sources

* Thu Jul 21 2016 Honza Fnukal <hfnukal@redhat.com> - 2.2.26-23
- EAP natives 2.1.1.CR1

* Wed Jun 29 2016 Honza Fnukal <hfnukal@redhat.com> - 2.2.26-22
- EAP natives 2.1.1.DR3

* Fri Jun 24 2016 Honza Fnukal <hfnukal@redhat.com> - 2.2.26-21
- EAP natives 2.1.1.DR2

* Tue Jun  7 2016 Honza Fnukal <hfnukal@redhat.com> - 2.2.26-20
Rebuild for EAP natives
* Mon Jun 06 2016 George Zaronikas <gzaronik@redhat.com> - 2.2.26-19
- Updating dependencies in order to build with openssl 1.0.2h
* Fri Jun 03 2016 Honza Fnukal <hfnukal@redhat.com> - 2.2.26-18
- Release for EWS 2.1.1.DR1

* Tue Mar 15 2016 Honza Fnukal <hfnukal@redhat.com> - 2.2.26-16
- Oneoff release

* Thu Nov 26 2015 Mladen Turk <mturk@redhat.com> - 2.2.26-15
- Fix bz1282726

* Thu Oct 29 2015 Mladen Turk <mturk@redhat.com> - 2.2.26-14
- CVE-2015-3183.patch.

* Thu Aug  6 2015 Mladen Turk <mturk@redhat.com> - 2.2.26-13
- Fix JWS-194.

* Wed Jul 22 2015 Mladen Turk <mturk@redhat.com> - 2.2.26-12
- Multiple patches to improve ephemeral key handling.

* Tue Apr 21 2015 Maxime Beck <maxbeck@redhat.com> - 2.2.26-11
- CVE-2009-3560-revised.patch
- CVE-2009-3720.patch
- CVE-2012-0876.patch
- CVE-2012-1148.patch

* Tue Apr 21 2015 Maxime Beck <maxbeck@redhat.com> - 2.2.26-10
- Update expat version to 1.95.8

* Mon Feb 02 2015 Lukas Kubik <lkubik@redhat.com> - 2.2.26-9
- [BZ-1167158] Apply patch for CVE-2013-5704

* Wed Sep  3 2014 Vaclav Tunka <vtunka@redhat.com> - 2.2.26-8
- Enable mod_substitute in Windows build for bz1131387

* Mon Jul 21 2014 Vaclav Tunka <vtunka@redhat.com> - 2.2.26-6
- CVE-2014-0026
- CVE-2014-0118
- CVE-2014-0231

* Tue Jul  1 2014 Mladen Turk <mturk@redhat.com> - 2.2.26-5
- Disable balancer module because it collides with mod_cluster

* Tue May 13 2014 Mladen Turk <mturk@redhat.com> - 2.2.26-4
- Fix bz1095373

* Tue May  6 2014 Mladen Turk <mturk@redhat.com> - 2.2.26-2
- Fix configuration files.
- CVE-2013-6438
- CVE-2014-0098

* Mon Apr 28 2014 Vaclav Tunka <vtunka@redhat.com> - 2.2.26-1
- Upgrade to httpd 2.2.26

* Mon Oct 28 2013 Mladen Turk <mturk@redhat.com> - 2.2.22-33
- Fix typo in patch for bz962819

* Fri Oct 25 2013 Mladen Turk <mturk@redhat.com> - 2.2.22-32
- Update fixed patch for bz962819

* Fri Oct 25 2013 Mladen Turk <mturk@redhat.com> - 2.2.22-31
- Update patch for bz962819

* Wed Oct 16 2013 Mladen Turk <mturk@redhat.com> - 2.2.22-30
- Add patch for bz962819

* Fri Sep 20 2013 Mladen Turk <mturk@redhat.com> - 2.2.22-29
- Fix bz1009987 by applying missing patch

* Mon Aug  5 2013 Mladen Turk <mturk@redhat.com> - 2.2.22-28
- bz990982

* Thu Jul 25 2013 Mladen Turk <mturk@redhat.com> - 2.2.22-27
- CVE-2013-1862
- CVE-2013-1896

* Thu Jun 20 2013 Mladen Turk <mturk@redhat.com> - 2.2.22-26
- Rebuild

* Mon Jun 17 2013 Weinan Li <weli@redhat.com> - 2.2.22-23
- bz973189

* Tue Jun  4 2013 Joe Orton <jorton@redhat.com> - 2.2.22-22
- mod_ssl: add "SSLOCSPResponderCertificateFile" config option
- fix init script handling in spec file
- Add patch for one-off: support the Tumbleweed OCSP responder

* Tue May 28 2013 Weinan Li <weli@redhat.com> - 2.2.22-20
- CVE2012-3499
- CVE2012-4558

* Tue May 14 2013 Permaine Cheung <pcheung@redhat.com> 2.2.22-19
- Add Obsoletes: in -devel to avoid running into BZ 892922 (yum trying to
  install httpd-devel.i386 from base without the requiried httpd)

* Wed May 08 2013 Weinan Li <weli@redhat.com> - 2.2.22-18
- relax checks for status-line validity #853128

* Thu May 02 2013 Weinan Li <weli@redhat.com> - 2.2.22-17
- generate src zip correctly

* Mon Apr 08 2013 Weinan Li <weli@redhat.com> - 2.2.22-16
- move httpd.init to correct position during build process

* Mon Apr 08 2013 Weinan Li <weli@redhat.com> - 2.2.22-15
- bz894955
- bz947391

* Wed Oct 17 2012 Weinan Li <weli@redhat.com> - 2.2.22-14
- More fix on JBPAPP-10212

* Tue Oct 16 2012 Weinan Li <weli@redhat.com> - 2.2.22-13
- JBPAPP-10212

* Fri Sep 21 2012 Weinan Li <weli@redhat.com> - 2.2.22-12
- JBPAPP-9446,9578

* Tue Sep 04 2012 Weinan Li <weli@redhat.com> - 2.2.22-11
- httpd-2.2.22-CVE-2012-2687.patch

* Thu Jul 12 2012 Joe Orton <jorton@redhat.com> - 2.2.22-10.1
- mod_ssl: pull latest upstream OCSP code (r815719+)
  Thanks to Joe Orton for providing the patch

* Mon Jul 09 2012 Weinan Li <weli@redhat.com> - 2.2.22-10
- Remove R apr-util-ldap because it's RHEL6 only

* Wed Jun 20 2012 Weinan Li <weli@redhat.com> - 2.2.22-9
- Fix incorrect src-zip

* Tue Jun 19 2012 Weinan Li <weli@redhat.com> - 2.2.22-8
- Bundle patched sources instead of the pristine one

* Wed May 23 2012 Weinan Li <weli@redhat.com> - 2.2.22-7
- JBPAPP-7633

* Tue May 01 2012 Weinan Li <weli@redhat.com> - 2.2.22-6
- Add var directory for zip

* Mon Apr 30 2012 Weinan Li <weli@redhat.com> - 2.2.22-5
- Add var directory

* Fri Apr 27 2012 Weinan Li <weli@redhat.com> - 2.2.22-4
- Fix src-zip package name

* Thu Apr 26 2012 Weinan Li <weli@redhat.com> - 2.2.22-3
- Add src-zip

* Mon Apr 23 2012 Weinan Li <weli@redhat.com> - 2.2.22-2
- Rebuild 2.2.22

* Wed Apr 04 2012 Weinan Li <weli@redhat.com> - 2.2.22-1
- Upgrade to 2.2.22
