/*
 * Copyright 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.webauthn4j.util;

import org.junit.jupiter.api.Test;

import static org.assertj.core.api.Assertions.assertThat;

class Base64UtilTest {

    @Test
    void encode_test() {
        byte[] data = new byte[]{0x01, 0x23, 0x45};
        byte[] expected = new byte[]{0x41, 0x53, 0x4E, 0x46};
        byte[] result = Base64Util.encode(data);
        assertThat(result).isEqualTo(expected);
    }

    @Test
    void encodeToString_test() {
        byte[] data = new byte[]{0x01, 0x23, 0x45};
        String expected = "ASNF";
        String result = Base64Util.encodeToString(data);
        assertThat(result).isEqualTo(expected);
    }

    @Test
    void decode_test() {
        byte[] data = new byte[]{0x41, 0x53, 0x4E, 0x46};
        byte[] expected = new byte[]{0x01, 0x23, 0x45};
        byte[] result = Base64Util.decode(data);
        assertThat(result).isEqualTo(expected);
    }
}
