## Overview

This is a multi-module umbrella project for [Jackson](../../../jackson)
standard binary dataformat backends.

Currently included are:

* [Avro](avro/)
* [CBOR](cbor/)
* [Ion](ion/)
* [Protobuf](protobuf/)
* [Smile](smile/)

## License

All modules are licensed under [Apache License 2.0](http://www.apache.org/licenses/LICENSE-2.0.txt).

## Status

[![Build Status](https://travis-ci.org/FasterXML/jackson-dataformats-binary.svg)](https://travis-ci.org/FasterXML/jackson-dataformats-binary)

## Other Jackson binary backends

In addition to binary format backends hosted by FasterXML in this repo, there are other
known Jackson backends for binary data formats.
For example:

* [bson4jackson](https://github.com/michel-kraemer/bson4jackson) for [BSON](http://en.wikipedia.org/wiki/BSON)
* [EXIficient](https://github.com/EXIficient/exificient-for-json) for [Efficient XML Interchange](https://en.wikipedia.org/wiki/Efficient_XML_Interchange)
* [jackson-dataformat-msgpack](https://github.com/msgpack/msgpack-java/tree/develop/msgpack-jackson) for [MessagePack](http://en.wikipedia.org/wiki/MessagePack) (aka `MsgPack`) format

## More

See [Wiki](../../wiki) for more information (javadocs).
