/*
 * Decompiled with CFR 0.152.
 */
package com.informix.asf;

import com.informix.asf.IfxASFException;
import com.informix.asf.IfxDataInputStream;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.Interval;
import com.informix.util.IfxErrMsg;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;

public class IfxDebugDataInputStream
extends IfxDataInputStream {
    private InputStream is;
    private final int one = 1;
    private final short DEF_PREC = 0;
    private byte[] smint_buf = new byte[2];
    private byte[] int_buf = new byte[4];
    private byte[] lgint_buf = new byte[10];
    private byte[] long_buf = new byte[8];
    private String ClientLocale = null;
    private IfxToJavaType ifxtojava = new IfxToJavaType();
    private ByteArrayOutputStream trace = new ByteArrayOutputStream();

    public IfxDebugDataInputStream(InputStream inputStream) {
        super(inputStream);
        this.is = inputStream;
    }

    public final int read() throws IOException {
        int n = this.is.read();
        this.trace.write((byte)n);
        return n;
    }

    public final int read(byte[] byArray) throws IOException {
        int n = this.is.read(byArray);
        this.trace.write(byArray);
        return n;
    }

    public final byte readByte() throws IOException {
        int n = this.is.read();
        this.trace.write((byte)n);
        return (byte)n;
    }

    public final int readFully(byte[] byArray) throws IOException {
        return this.readFully(byArray, 0, byArray.length);
    }

    public final int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.is.read(byArray, n, n2);
        this.trace.write(byArray, n, n3);
        return n3;
    }

    public final int readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < n2; n3 += n4) {
            n4 = this.is.read(byArray, n + n3, n2 - n3);
            if (n4 >= 0) continue;
            throw new IOException();
        }
        this.trace.write(byArray, n, n2);
        this.checkPadding();
        return n3;
    }

    public final int readPadded(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        n3 = this.readFully(byArray, n, n2);
        if ((n2 & 1) >= 1) {
            this.is.read();
        }
        return n3;
    }

    public final int readPadded(byte[] byArray) throws IOException {
        int n = this.readFully(byArray, 0, byArray.length);
        if ((byArray.length & 1) >= 1) {
            this.is.read();
        }
        return n;
    }

    public final int skipBytes(int n) throws IOException {
        int n2 = 0;
        while ((n2 += (int)this.is.skip(n - n2)) < n) {
        }
        return n;
    }

    public final int readInt() throws IOException {
        this.readFully(this.int_buf, 0, this.int_buf.length);
        return IfxToJavaType.IfxToJavaInt(this.int_buf);
    }

    public final String readChar() throws IOException, IfxASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short s = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf);
        if (s < 0) {
            throw IfxErrMsg.getLocIfxASFException(-408, this.ClientLocale);
        }
        byte[] byArray = new byte[s];
        int n = 0;
        int n2 = 0;
        int n3 = byArray.length;
        n = this.readFully(byArray, n2, n3);
        n3 -= n;
        n2 += n;
        if ((byArray.length & 1) >= 1) {
            this.is.read();
        }
        return this.ifxtojava.IfxToJavaChar(byArray);
    }

    public final String readChar(String string) throws IOException, IfxASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short s = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf);
        if (s < 0) {
            throw IfxErrMsg.getLocIfxASFException(-408, this.ClientLocale);
        }
        byte[] byArray = new byte[s];
        int n = 0;
        int n2 = 0;
        int n3 = byArray.length;
        n = this.readFully(byArray, n2, n3);
        n3 -= n;
        n2 += n;
        if ((byArray.length & 1) >= 1) {
            this.is.read();
        }
        return this.ifxtojava.IfxToJavaChar(byArray, string);
    }

    public final Date readDate() throws IOException, IfxASFException {
        this.readFully(this.int_buf, 0, this.int_buf.length);
        return IfxToJavaType.IfxToJavaDate(this.int_buf);
    }

    public final Timestamp readDateTime(short s) throws IOException, IfxASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short s2 = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf);
        if (s2 < 0) {
            throw IfxErrMsg.getLocIfxASFException(-408, this.ClientLocale);
        }
        byte[] byArray = new byte[s2];
        this.readFully(byArray, 0, byArray.length);
        if ((s2 & 1) >= 1) {
            this.is.read();
        }
        return IfxToJavaType.IfxToJavaDateTime(byArray, s);
    }

    public final byte[] readRawDateTime(short s) throws IOException, IfxASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short s2 = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf);
        if (s2 < 0) {
            throw IfxErrMsg.getLocIfxASFException(-408, this.ClientLocale);
        }
        byte[] byArray = new byte[s2];
        this.readFully(byArray, 0, byArray.length);
        if ((s2 & 1) >= 1) {
            this.is.read();
        }
        return byArray;
    }

    public final Interval readInterval(short s) throws IOException, IfxASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short s2 = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf);
        if (s2 < 0) {
            throw IfxErrMsg.getLocIfxASFException(-408, this.ClientLocale);
        }
        byte[] byArray = new byte[s2];
        this.readFully(byArray, 0, byArray.length);
        if ((s2 & 1) >= 1) {
            this.is.read();
        }
        return IfxToJavaType.IfxToJavaInterval(byArray, s);
    }

    public final BigDecimal readDecimal(short s) throws IOException, IfxASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short s2 = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf);
        if (s2 < 0) {
            throw IfxErrMsg.getLocIfxASFException(-408, this.ClientLocale);
        }
        byte[] byArray = new byte[s2];
        this.readFully(byArray, 0, byArray.length);
        if ((s2 & 1) >= 1) {
            this.is.read();
        }
        return IfxToJavaType.IfxToJavaDecimal(byArray, s);
    }

    public final double readDouble(short s) throws IOException, IfxASFException {
        this.readFully(this.long_buf, 0, this.long_buf.length);
        return IfxToJavaType.IfxToJavaDouble(this.long_buf);
    }

    public final float readReal(short s) throws IOException, IfxASFException {
        this.readFully(this.int_buf, 0, this.int_buf.length);
        return IfxToJavaType.IfxToJavaReal(this.int_buf);
    }

    public final short readSmallInt() throws IOException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        return IfxToJavaType.IfxToJavaSmallInt(this.smint_buf);
    }

    public final short readShort() throws IOException {
        return this.readSmallInt();
    }

    public final long readLongInt() throws IOException {
        this.readFully(this.lgint_buf, 0, this.lgint_buf.length);
        return IfxToJavaType.IfxToJavaLongInt(this.lgint_buf);
    }

    public final long readLong() throws IOException {
        return this.readLongInt();
    }

    public void setClientLocale(String string) {
        this.ClientLocale = string;
    }

    public String getClientLocale() {
        return this.ClientLocale;
    }

    private void checkPadding() {
        if (this.trace.size() % 2 != 0) {
            this.trace.write(-1);
        }
    }

    protected void dumpTrace(OutputStream outputStream) {
        try {
            this.trace.writeTo(outputStream);
            this.trace.reset();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected int getTraceLength() {
        return this.trace.size();
    }
}

