/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util;

import com.sap.dbtech.util.NullPrinter;
import com.sap.dbtech.util.StringUtil;
import com.sap.dbtech.util.Traceable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Properties;

public abstract class Tracer {
    public static final boolean traceAny_C = true;
    public static final int noTrace_C = 0;
    public static final int mediumTrace_C = 0;
    public static final int fullTrace_C = 10;
    private static long maxLinesInTrace = Long.MAX_VALUE;
    private static long curLinesInTrace = 0L;
    private static String filename = null;
    private static int traceVerbosity = 0;
    private static PrintStream nullPrinter;
    private static PrintStream log;
    public static int maxTraceBuf;
    private static Thread lastThread;

    private Tracer() {
    }

    private static void checkThreadChange() {
        Thread thread = Thread.currentThread();
        if (thread != lastThread) {
            lastThread = thread;
            log.println("");
            log.println("---- Thread " + Integer.toHexString(thread.hashCode()) + " " + thread.getName() + " Timestamp: " + new Timestamp(System.currentTimeMillis()));
        }
    }

    private static void checkTracefile() {
        if (curLinesInTrace >= maxLinesInTrace) {
            try {
                Tracer.close();
                File file = new File(filename + ".old");
                File file2 = new File(filename);
                try {
                    file.delete();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                file2.renameTo(file);
                log = new PrintStream(new FileOutputStream(filename, false));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            curLinesInTrace = 0L;
        }
        ++curLinesInTrace;
    }

    public static void close() {
        if (log != null) {
            log.close();
            log = null;
        }
    }

    public static void entry(int n, Object object, String string) {
        if (n <= traceVerbosity && log != null) {
            Tracer.entry(n, object, string, null);
        }
    }

    public static void entry(int n, Object object, String string, Object[] objectArray) {
        if (n <= traceVerbosity && log != null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (object instanceof String) {
                stringBuffer.append(object);
            } else {
                String string2 = object.getClass().toString();
                stringBuffer.append(string2.substring(string2.lastIndexOf(46)));
                stringBuffer.append("@");
                stringBuffer.append(Integer.toHexString(object.hashCode()));
                stringBuffer.append("::");
            }
            String string3 = objectArray == null ? string : StringUtil.sprintfs(string, objectArray);
            stringBuffer.append(string3);
            Tracer.println(stringBuffer.toString());
        }
    }

    public static void entry(int n, Object object, String string, int n2) {
        if (n <= traceVerbosity && log != null) {
            Tracer.entry(n, object, string, new Object[]{new Integer(n2)});
        }
    }

    public static void entry(int n, Object object, String string, int n2, int n3) {
        if (n <= traceVerbosity && log != null) {
            Tracer.entry(n, object, string, new Object[]{new Integer(n2), new Integer(n3)});
        }
    }

    public static void entry(int n, Object object, String string, Object object2) {
        if (n <= traceVerbosity && log != null) {
            Tracer.entry(n, object, string, new Object[]{object2});
        }
    }

    public static void entry(int n, Object object, String string, Object object2, Object object3) {
        if (n <= traceVerbosity && log != null) {
            Tracer.entry(n, object, string, new Object[]{object2, object3});
        }
    }

    public static void entry(int n, Object object, String string, Object object2, Object object3, Object object4) {
        if (n <= traceVerbosity && log != null) {
            Tracer.entry(n, object, string, new Object[]{object2, object3, object4});
        }
    }

    public static void entry(int n, Object object, String string, Object object2, Object object3, Object object4, Object object5) {
        if (n <= traceVerbosity && log != null) {
            Tracer.entry(n, object, string, new Object[]{object2, object3, object4, object5});
        }
    }

    public static void flush() {
        log.flush();
    }

    public static void forceLine(String string) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter("c:/temp/va.prt", true));
            printWriter.println(string);
            printWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void forceNewLog(String string) throws IOException {
        Tracer.forceNewLog(string, true);
    }

    public static void forceNewLog(String string, boolean bl) throws IOException {
        Tracer.forceNewLog(string, bl, Long.MAX_VALUE);
    }

    public static void forceNewLog(String string, boolean bl, long l) throws IOException {
        log = new PrintStream(new FileOutputStream(string, bl));
        maxLinesInTrace = l;
        filename = string;
    }

    public static PrintStream getLog() {
        return log;
    }

    public static boolean isOn(int n) {
        return n <= traceVerbosity;
    }

    public static void openLog(String string) throws IOException {
        if (log == nullPrinter || log == null || log == System.out) {
            Tracer.forceNewLog(string);
        }
    }

    public static synchronized void println(String string) {
        Tracer.checkTracefile();
        Tracer.checkThreadChange();
        log.println(string);
    }

    public static synchronized void print(String string) {
        Tracer.checkTracefile();
        Tracer.checkThreadChange();
        log.print(string);
    }

    public static synchronized void print(String string, Properties properties) {
        Tracer.checkTracefile();
        Tracer.checkThreadChange();
        log.println(string);
        if (properties == null) {
            return;
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = string2.equals("password") ? "***" : properties.getProperty(string2);
            if (string3 != null && string3.length() > 40) {
                string3 = string3.substring(0, 37) + "...";
            }
            log.println(string2 + "=" + string3);
        }
    }

    public static void setLog(PrintStream printStream) {
        log = printStream;
    }

    public static int setVerbosity(int n) {
        int n2 = traceVerbosity;
        traceVerbosity = n;
        return n2;
    }

    public static synchronized void trace(String string) {
        if (log != null) {
            Tracer.checkThreadChange();
            log.println(string);
        }
    }

    public static synchronized void traceException(Throwable throwable) {
        if (log != null) {
            Tracer.checkThreadChange();
            log.println("Timestamp: " + new Timestamp(System.currentTimeMillis()));
            throwable.printStackTrace(log);
        }
    }

    public static void tracef(String string, Object[] objectArray) {
        if (log != null) {
            StringUtil.fprintfs(log, string, objectArray);
        }
    }

    public static void traceObject(String string, Traceable traceable) {
        Tracer.traceObject(string, traceable, traceVerbosity);
    }

    public static synchronized void traceObject(String string, Traceable traceable, int n) {
        if (log != null) {
            Tracer.checkThreadChange();
            if (string != null) {
                Tracer.trace(string);
            }
            if (n <= traceVerbosity) {
                traceable.traceOn(log);
            } else {
                traceable.traceOn(log, maxTraceBuf);
            }
        }
    }

    public static void whereAmI() {
        if (log != null) {
            Tracer.checkThreadChange();
            Tracer.println("whereAmI");
            Throwable throwable = new Throwable();
            throwable.printStackTrace(log);
        }
    }

    public static synchronized void dumpLocks(Connection connection) throws SQLException {
        log.println(Tracer.dumpLockAsString(connection));
    }

    public static synchronized String dumpLockAsString(Connection connection) throws SQLException {
        Tracer.checkTracefile();
        Tracer.checkThreadChange();
        StringBuffer stringBuffer = new StringBuffer(200);
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT SESSION, TABLENAME, ROWID, ROWIDHEX, REQMODE, REQSTATE, LOCKMODE, LOCKSTATE FROM lockstatistics");
        stringBuffer.append("DUMP LOCKSTATISTICS\n");
        if (resultSet.next()) {
            stringBuffer.append("SESSION;TABLENAME;ROWID;ROWIDHEX;REQMODE;REQSTATE;LOCKMODE;LOCKSTATE\n");
            do {
                stringBuffer.append(resultSet.getString("SESSION") + ";" + resultSet.getString("TABLENAME") + ";" + resultSet.getString("ROWID") + ";" + Tracer.Hex2String(resultSet.getBytes("ROWIDHEX")) + ";" + resultSet.getString("REQMODE") + ";" + resultSet.getString("REQSTATE") + ";" + resultSet.getString("LOCKMODE") + ";" + resultSet.getString("LOCKSTATE") + "\n");
            } while (resultSet.next());
        } else {
            stringBuffer.append("=>no locks found\n");
        }
        resultSet.close();
        return stringBuffer.toString();
    }

    public static String Hex2String(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            if ((byArray[i] & 0xFF) < 16) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Integer.toString(byArray[i] & 0xFF, 16));
        }
        return stringBuffer.toString();
    }

    public static byte[] String2Hex(String string) {
        if (string == null || string.length() % 2 != 0) {
            return new byte[0];
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            String string2 = string.substring(2 * i, 2 * i + 2);
            byArray[i] = (byte)Integer.parseInt(string2, 16);
        }
        return byArray;
    }

    static {
        log = nullPrinter = new NullPrinter();
        maxTraceBuf = 400;
        lastThread = null;
    }
}

