/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.tools.objects.refactoring;

import com.intersys.classes.Dictionary.ClassDefinition;
import com.intersys.classes.Dictionary.ParameterDefinition;
import com.intersys.classes.Dictionary.StorageDefinition;
import com.intersys.objects.CacheException;
import com.intersys.objects.Database;
import com.intersys.objects.Id;
import com.jalapeno.tools.objects.refactoring.ClassRefactoring;
import com.jalapeno.tools.objects.refactoring.Property;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;

public class ExtractSuperclass
extends ClassRefactoring {
    private final String mSuperClassName;
    private boolean mPushSecondarySupers = false;

    public ExtractSuperclass(Database database, String string, String string2) throws CacheException {
        super(database, string);
        this.mSuperClassName = string2;
    }

    public ExtractSuperclass(Database database, String string, String string2, boolean bl) throws CacheException {
        super(database, string);
        this.mSuperClassName = string2;
        this.mPushSecondarySupers = bl;
    }

    public void setPushSecondarySupers(boolean bl) {
        this.mPushSecondarySupers = bl;
    }

    public void doPhase1() throws Exception {
        if (this.mDB.transactionLevel() > 0) {
            throw new IllegalStateException("Phase 1 of Extract Superclass can not be done inside transaction");
        }
        String string = this.mCDef.getSuper();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        String string2 = stringTokenizer.nextToken();
        String string3 = this.mSuperClassName;
        if (this.mPushSecondarySupers) {
            this.createClass(this.mDB, this.mSuperClassName, string);
        } else {
            this.createClass(this.mDB, this.mSuperClassName, string2);
            while (stringTokenizer.hasMoreTokens()) {
                string3 = string3 + "," + stringTokenizer.nextToken();
            }
        }
        if (string2 == null || string2.equals("%Library.Persistent")) {
            this.setSubClass();
        } else {
            this.addSubClass();
        }
        this.mCDef.setSuper(string3);
        this.mDB.utilities().compileCacheClass(this.mSuperClassName, "");
    }

    public String doPhase2() throws Exception {
        ClassDefinition classDefinition = (ClassDefinition)ClassDefinition.open(this.mDB, new Id(this.mSuperClassName));
        StorageDefinition storageDefinition = ExtractSuperclass.findStorage(classDefinition);
        StorageDefinition storageDefinition2 = ExtractSuperclass.findStorage(this.mCDef);
        ExtractSuperclass.moveStorage(storageDefinition2, storageDefinition);
        ParameterDefinition parameterDefinition = this.getVersionParameter();
        if (parameterDefinition != null) {
            String string = parameterDefinition.getDefault();
            Property.pullVersionProperty(this.mCDef, this.mSuperClassName, string);
            ExtractSuperclass.pushParameter(parameterDefinition, classDefinition);
        }
        classDefinition.save();
        this.mCDef.save();
        return this.mSuperClassName + "," + this.mCDef.getName();
    }

    private static void pushParameter(ParameterDefinition parameterDefinition, ClassDefinition classDefinition) throws Exception {
        ParameterDefinition parameterDefinition2 = (ParameterDefinition)parameterDefinition.constructClone();
        parameterDefinition2.setparent(classDefinition);
    }

    private void setSubClass() throws CacheException, SQLException {
        Statement statement = this.mDB.createStatement();
        String string = this.getFullSqlTableName();
        String string2 = this.mCDef.getName();
        String string3 = "update " + string + " set x__classname='~" + string2 + "' || x__classname where x__classname is not null and " + "not x__classname [ '~" + string2 + "~'";
        statement.executeUpdate(string3);
        string3 = "update " + string + " set x__classname='~" + string2 + "~' where x__classname is null";
        statement.executeUpdate(string3);
    }

    private void addSubClass() throws CacheException, SQLException {
        Statement statement = this.mDB.createStatement();
        String string = this.getFullSqlTableName();
        String string2 = "update " + string + " set x__classname='~" + this.mSuperClassName + "' || x__classname";
        statement.executeUpdate(string2);
    }
}

