/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.tools.objects.refactoring;

import com.intersys.cache.CacheClassBuilder;
import com.intersys.cache.ClassGenerationConstants;
import com.intersys.classes.Dictionary.ClassDefinition;
import com.intersys.classes.Dictionary.CompiledClass;
import com.intersys.classes.Dictionary.ParameterDefinition;
import com.intersys.classes.Dictionary.StorageDataDefinition;
import com.intersys.classes.Dictionary.StorageDefinition;
import com.intersys.classes.RelationshipObject;
import com.intersys.objects.CacheDatabase;
import com.intersys.objects.CacheException;
import com.intersys.objects.Database;
import com.intersys.objects.Id;
import com.intersys.objects.reflect.CacheClass;
import com.jalapeno.tools.objects.refactoring.ExtractSuperclass;
import java.util.Iterator;
import java.util.StringTokenizer;

public class ClassRefactoring
implements ClassGenerationConstants {
    protected Database mDB;
    protected ClassDefinition mCDef;
    private String mJavaShortClassName = null;
    private String mJavaPackage = null;
    private String mSQLTableName = null;

    public ClassRefactoring(Database database, String string) throws CacheException {
        this.mDB = database;
        this.init(string);
    }

    private void init(String string) throws CacheException {
        this.mCDef = (ClassDefinition)ClassDefinition.open(this.mDB, new Id(string));
    }

    protected String getVersionProperty() throws CacheException {
        ParameterDefinition parameterDefinition = this.getVersionParameter();
        if (parameterDefinition == null) {
            return null;
        }
        return parameterDefinition.getDefault();
    }

    protected ParameterDefinition getVersionParameter() throws CacheException {
        return this.getParameter("VERSIONPROPERTY", true);
    }

    protected ParameterDefinition getParameter(String string, boolean bl) throws CacheException {
        RelationshipObject relationshipObject = this.mCDef.getParameters();
        Iterator iterator = relationshipObject.iterator();
        while (iterator.hasNext()) {
            ParameterDefinition parameterDefinition = (ParameterDefinition)iterator.next();
            if (!string.equals(parameterDefinition.getName())) continue;
            if (bl) {
                iterator.remove();
            }
            return parameterDefinition;
        }
        return null;
    }

    protected static CompiledClass getPrimarySuper(CompiledClass compiledClass) throws CacheException {
        String string = compiledClass.getSuper();
        if (string == null || string.length() == 0 || string.equals("%Library.Persistent")) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        string = stringTokenizer.nextToken();
        return (CompiledClass)CompiledClass._open(compiledClass.getDatabase(), new Id(string));
    }

    protected static StorageDefinition findStorage(ClassDefinition classDefinition) throws CacheException {
        CompiledClass compiledClass = (CompiledClass)CompiledClass._open(classDefinition.getDatabase(), classDefinition.getId());
        return ClassRefactoring.findStorage(classDefinition, compiledClass.getStorageStrategy());
    }

    protected static StorageDefinition findStorage(ClassDefinition classDefinition, String string) throws CacheException {
        StorageDefinition storageDefinition = null;
        Iterator iterator = classDefinition.getStorages().iterator();
        while (iterator.hasNext()) {
            storageDefinition = (StorageDefinition)iterator.next();
            if (!storageDefinition.getName().equals(string)) continue;
            return storageDefinition;
        }
        throw new IllegalStateException("Illegal state of class: " + classDefinition.getName() + ". No storage defintion with strategy " + string);
    }

    protected static void moveStorage(StorageDefinition storageDefinition, StorageDefinition storageDefinition2) throws CacheException {
        storageDefinition2.setIdLocation(storageDefinition.getIdLocation());
        storageDefinition2.setDataLocation(storageDefinition.getDataLocation());
        storageDefinition2.getData().clear();
        RelationshipObject relationshipObject = storageDefinition.getData();
        Iterator iterator = relationshipObject.iterator();
        while (iterator.hasNext()) {
            StorageDataDefinition storageDataDefinition = (StorageDataDefinition)iterator.next();
            StorageDataDefinition storageDataDefinition2 = (StorageDataDefinition)storageDataDefinition.constructClone();
            storageDataDefinition2.setparent(storageDefinition2);
            iterator.remove();
        }
    }

    protected void createClass(Database database, String string, String string2) throws Exception {
        CacheClassBuilder.InternalAPI internalAPI = (CacheClassBuilder.InternalAPI)CacheClassBuilder.createDirectClassBuilder(database);
        internalAPI.createEmptyClass(string);
        internalAPI.define(4608);
        String string3 = string2 == null ? "%Library.Persistent" : string2;
        internalAPI.define(51, string3);
        if (this.mSQLTableName != null) {
            internalAPI.define(15, this.mSQLTableName);
        }
        if (this.mJavaShortClassName != null) {
            internalAPI.define(11, this.mJavaShortClassName);
        }
        if (this.mJavaPackage != null) {
            internalAPI.define(101, this.mJavaPackage);
        }
        internalAPI.define(999);
    }

    public static void main(String[] stringArray) throws Exception {
        ClassRefactoring.test(stringArray, "jdbc:Cache://localhost:1972/USER");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void test(String[] stringArray, String string) throws Exception {
        boolean bl = false;
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        String string4 = stringArray[2];
        if (stringArray.length > 3) {
            bl = Boolean.valueOf(stringArray[3]);
        }
        Database database = CacheDatabase.getDatabase(string);
        try {
            if (!"extract".equals(string2)) {
                throw new Exception("Unknown Action: " + string2);
            }
            ExtractSuperclass extractSuperclass = new ExtractSuperclass(database, string3, string4, bl);
            extractSuperclass.doPhase1();
            database.transactionStart();
            String string5 = extractSuperclass.doPhase2();
            database.utilities().compileCacheClass(string5, "+db");
            database.transactionCommit();
        }
        catch (CacheException cacheException) {
            cacheException.printStackTrace();
            try {
                ClassDefinition.delete(database, new Id(string4));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            finally {
                database.transactionRollback();
            }
            throw cacheException;
        }
    }

    public String getJavaPackage() {
        return this.mJavaPackage;
    }

    public void setJavaPackage(String string) {
        this.mJavaPackage = string;
    }

    public String getJavaShortClassName() {
        return this.mJavaShortClassName;
    }

    public void setJavaShortClassName(String string) {
        this.mJavaShortClassName = string;
    }

    public String getSQLTableName() {
        return this.mSQLTableName;
    }

    public void setSQLTableName(String string) {
        this.mSQLTableName = string;
    }

    protected String getFullSqlTableName() throws CacheException {
        CacheClass cacheClass = this.mDB.getCacheClass(this.mCDef.getName());
        return cacheClass.getFullSQLTableName();
    }
}

