/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.objects;

import com.intersys.objects.Logger;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;

public class CacheException
extends Exception
implements Serializable {
    protected int m_code = 0;
    protected Throwable mCause;

    public CacheException(Throwable throwable) {
        if (Logger.debugOn()) {
            Logger.out.println("ERROR: Exception occured: " + throwable.getMessage());
        }
        this.mCause = throwable;
    }

    public CacheException(Throwable throwable, String string) {
        super(string);
        if (Logger.debugOn()) {
            Logger.out.println("ERROR: Exception occured: " + string);
        }
        this.mCause = throwable;
    }

    public CacheException() {
        if (Logger.debugOn()) {
            Logger.out.println("ERROR: Exception occured. No information available ");
        }
        this.m_code = 0;
    }

    public CacheException(String string, boolean bl) {
        super(string);
        if (!bl && Logger.debugOn()) {
            Logger.out.println("ERROR: Exception occured: " + string);
        }
        this.m_code = 0;
    }

    public CacheException(String string) {
        super(string);
        if (Logger.debugOn()) {
            Logger.out.println("ERROR: Exception occured: " + string);
        }
        this.m_code = 0;
    }

    public CacheException(String string, int n) {
        super(string);
        if (Logger.debugOn()) {
            Logger.out.println("ERROR: Exception occured: " + string);
        }
        this.m_code = n;
    }

    public CacheException(String string, int n, Throwable throwable) {
        super(string);
        if (Logger.debugOn()) {
            Logger.out.println("ERROR: Exception occured: " + string);
        }
        this.m_code = n;
        this.mCause = throwable;
    }

    public int getCode() {
        if (this.m_code != 0) {
            return this.m_code;
        }
        if (this.mCause != null && this.mCause instanceof CacheException) {
            this.m_code = ((CacheException)this.mCause).getCode();
        }
        return this.m_code;
    }

    public String getMessage() {
        String string = super.getMessage();
        if (this.mCause != null) {
            string = string + " caused by: " + this.mCause.toString();
        }
        return string;
    }

    public void printFullTrace(OutputStream outputStream) {
        this.printFullTrace(new PrintWriter(outputStream, true));
    }

    public void printFullTrace(Writer writer) {
        PrintWriter printWriter;
        PrintWriter printWriter2 = printWriter = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer, true);
        if (this.mCause instanceof CacheException) {
            ((CacheException)this.mCause).printFullTrace(printWriter);
        } else if (this.mCause != null) {
            this.mCause.printStackTrace(printWriter);
        }
        this.printStackTrace(printWriter);
    }
}

