/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.CacheConnectionPoolDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class CachePooledConnection
implements PooledConnection {
    private ConnectionEventListener listener = null;
    private CacheConnectionPoolDataSource myDataSource;
    private CacheConnection physicalConnection;
    String url;
    String user;
    String password;
    private boolean closed = false;

    CachePooledConnection(CacheConnectionPoolDataSource cacheConnectionPoolDataSource, String string, String string2) throws SQLException {
        this.myDataSource = cacheConnectionPoolDataSource;
        this.url = this.myDataSource.url;
        this.user = string;
        this.password = string2;
        this.physicalConnection = new CacheConnection(cacheConnectionPoolDataSource.url, cacheConnectionPoolDataSource.server, cacheConnectionPoolDataSource.port, cacheConnectionPoolDataSource.database, this.user, this.password, cacheConnectionPoolDataSource.eventClass, cacheConnectionPoolDataSource.logStream, cacheConnectionPoolDataSource.loginTimeout, cacheConnectionPoolDataSource.nodelay, this, cacheConnectionPoolDataSource.securityLevel, cacheConnectionPoolDataSource.principalName, cacheConnectionPoolDataSource.isolationLevel);
    }

    public Connection getConnection() throws SQLException {
        if (this.closed) {
            throw new SQLException("Unable to get connection: PooledConnection object is closed");
        }
        return this.physicalConnection;
    }

    public synchronized void close() throws SQLException {
        if (this.closed) {
            return;
        }
        this.physicalConnection.pooled = null;
        this.physicalConnection.close();
        this.closed = true;
        this.listener = null;
        if (this.myDataSource.pool.contains(this)) {
            this.myDataSource.pool.remove(this);
        } else {
            --this.myDataSource.activeConnections;
        }
        this.myDataSource = null;
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (!this.closed) {
            this.listener = connectionEventListener;
        }
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listener = null;
    }

    protected synchronized void release() {
        this.listener.connectionClosed(new ConnectionEvent(this));
    }

    protected synchronized void returnToPool() {
        if (!this.myDataSource.pool.contains(this)) {
            this.myDataSource.pool.add(this);
        }
        --this.myDataSource.activeConnections;
    }

    boolean checkConnectionParameters(String string, String string2, String string3) {
        return this.url.equals(string) && this.user.equals(string2) && this.password.equals(string3);
    }
}

