/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.gateway;

import com.intersys.gateway.GatewayException;
import com.intersys.gateway.JavaGateway;
import com.intersys.jdbc.LogFileStream;
import com.intersys.jdbc.SysListProxy;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import javax.jms.BytesMessage;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;

public class JMSGateway
extends JavaGateway
implements MessageListener {
    private Message jmsMessage = null;

    protected JMSGateway(Socket socket, int n, LogFileStream logFileStream) throws Exception {
        super(socket, n, logFileStream);
    }

    public static void main(String[] stringArray) throws Exception {
        LogFileStream logFileStream = null;
        if (stringArray.length == 0) {
            throw new GatewayException("Port number must be supplied as the first command line argument");
        }
        int n = Integer.parseInt(stringArray[0]);
        if (stringArray.length > 1 && stringArray.length == 2) {
            logFileStream = new LogFileStream(stringArray[1]);
        }
        try {
            ServerSocket serverSocket = new ServerSocket(n);
            while (true) {
                Socket socket = serverSocket.accept();
                socket.setTcpNoDelay(true);
                socket.setReuseAddress(true);
                new JMSGateway(socket, n, logFileStream).start();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new GatewayException("[JMS Gateway] Communication link failure: " + exception.getMessage());
        }
    }

    public void onMessage(Message message) {
        try {
            this.jmsMessage = message;
            this.alertJMSMessage();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void alertJMSMessage() throws Exception {
        try {
            if (this.logFile != null) {
                this.logFile.logApi(" >> JMS_MESSAGE_ALERT");
            }
            String string = "javax.jms.Message";
            if (this.jmsMessage instanceof TextMessage) {
                string = "javax.jms.TextMessage";
            } else if (this.jmsMessage instanceof BytesMessage) {
                string = "javax.jms.BytesMessage";
            } else if (this.jmsMessage instanceof MapMessage) {
                string = "javax.jms.MapMessage";
            } else if (this.jmsMessage instanceof ObjectMessage) {
                string = "javax.jms.ObjectMessage";
            } else if (this.jmsMessage instanceof StreamMessage) {
                string = "javax.jms.StreamMessage";
            }
            SysListProxy.writeHeader(this.outMessage.wire, MESSAGE_JMS_MESSAGE_ALERT);
            SysListProxy.setString(this.outMessage.wire, string);
            this.outMessage.send(0);
            if (this.logFile != null) {
                this.logFile.logApi(" << JMS_MESSAGE_ALERT");
            }
        }
        catch (Exception exception) {
            this.processException(exception);
        }
    }

    protected void getJMSMessage() throws Exception {
        try {
            if (this.logFile != null) {
                this.logFile.logApi(" >> JMS_GET_MESSAGE: " + this.jmsMessage);
            }
            String string = SysListProxy.getString(this.inMessage.wire);
            String string2 = SysListProxy.getString(this.inMessage.wire);
            this.orefRegistry.put(string2, this.jmsMessage);
            this.orefToClassMap.put(string2, string);
            SysListProxy.writeHeader(this.outMessage.wire, MESSAGE_JMS_GET_MESSAGE);
            this.outMessage.send(0);
            if (this.logFile != null) {
                this.logFile.logApi(" << JMS_GET_MESSAGE");
            }
        }
        catch (Exception exception) {
            this.processException(exception);
        }
    }

    protected void executeInstanceMethod(Method method, String string, String string2) throws Throwable {
        Object v = this.orefRegistry.get(string2);
        if (v instanceof MessageConsumer && string.equals("setMessageListener")) {
            ((MessageConsumer)v).setMessageListener((MessageListener)this);
            SysListProxy.writeHeader(this.outMessage.wire, MESSAGE_EXECUTE_METHOD);
            SysListProxy.setUndefined(this.outMessage.wire);
            SysListProxy.setUndefined(this.outMessage.wire);
            return;
        }
        super.executeInstanceMethod(method, string, string2);
    }
}

