/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.classes;

import com.intersys.cache.Dataholder;
import com.intersys.classes.ItemOfObjects;
import com.intersys.classes.ItemOfObjectsWithClassName;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import com.intersys.objects.Database;
import com.intersys.objects.Id;
import com.intersys.objects.Oid;
import com.intersys.objects.SystemError;
import com.intersys.objects.reflect.CacheClass;
import java.sql.SQLException;

class DataConverter {
    DataConverter() {
    }

    static String byteArray2string(byte[] byArray) {
        char[] cArray = new char[byArray.length * 2];
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            cArray[n++] = (char)(48 + (byArray[i] >> 4));
            cArray[n++] = (char)(48 + (byArray[i] & 0xF));
        }
        return new String(cArray);
    }

    static byte[] string2byteArray(String string) {
        int n = string.length();
        byte[] byArray = new byte[(n + 1) / 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byArray[n3] = (byte)(string.charAt(n2++) - 48 << 4);
            if (n2 < n) {
                int n4 = n3;
                byArray[n4] = (byte)(byArray[n4] | (byte)(string.charAt(n2++) - 48));
            }
            ++n3;
        }
        return byArray;
    }

    static Object string2object(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() <= 0) {
            return null;
        }
        return string;
    }

    static ItemOfObjects oid2itemOfObjects(Oid oid) {
        if (oid == null) {
            return null;
        }
        if (oid.getData() == null) {
            return null;
        }
        if (oid.getData().length <= 0) {
            return null;
        }
        try {
            return new ItemOfObjects(new Id(oid.getId().toString()));
        }
        catch (CacheException cacheException) {
            return null;
        }
    }

    static ItemOfObjectsWithClassName oid2itemOfObjectsWithClassName(Oid oid) {
        if (oid == null) {
            return null;
        }
        if (oid.getData() == null) {
            return null;
        }
        if (oid.getData().length <= 0) {
            return null;
        }
        return new ItemOfObjectsWithClassName(oid);
    }

    static Object datatype2string(Object object) throws CacheException {
        if (object instanceof String) {
            return object;
        }
        try {
            Dataholder dataholder = Dataholder.create(object);
            Object object2 = SysListProxy.createSysList(Dataholder.DEFAULT_CONNECTION_INFO);
            dataholder.stuff(object2);
            SysListProxy.rewind(object2);
            return SysListProxy.getString(object2);
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to convert object " + object + " to String");
        }
    }

    static Object string2datatype(Object object, String string) throws CacheException {
        if ("String".equalsIgnoreCase(string)) {
            return object;
        }
        Object object2 = SysListProxy.createSysList(Dataholder.DEFAULT_CONNECTION_INFO);
        try {
            SysListProxy.setString(object2, (String)object);
            SysListProxy.rewind(object2);
        }
        catch (SQLException sQLException) {
            throw new SystemError(sQLException, "Failed to set " + object + " in list");
        }
        Dataholder dataholder = new Dataholder(4096, object2);
        return dataholder.getObject(string);
    }

    static String convertClassName(String string, Database database) throws CacheException {
        try {
            CacheClass cacheClass = database.getCacheClass(string);
            String string2 = cacheClass.getJavaClassName();
            return string2;
        }
        catch (CacheException cacheException) {
            return string;
        }
    }
}

