/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

public class BackgroundStreamReceiver
extends Thread {
    private volatile BufferedReader mIr;
    private volatile OutputStream mOut;
    private StringBuffer mBuf;
    private Exception mEx = null;
    boolean done = false;

    public BackgroundStreamReceiver(InputStream inputStream, OutputStream outputStream, String string, int n, boolean bl) {
        super(string);
        this.setPriority(n);
        this.mIr = new BufferedReader(new InputStreamReader(inputStream));
        if (!bl) {
            this.mBuf = new StringBuffer();
        }
        this.mOut = outputStream;
    }

    public String getResult() {
        return this.mBuf.toString();
    }

    public void run() {
        try {
            while (true) {
                int n;
                if (!this.mIr.ready()) {
                    BackgroundStreamReceiver.yield();
                }
                if ((n = this.mIr.read()) < 0) break;
                if (this.mBuf != null) {
                    this.mBuf.append((char)n);
                }
                if (this.mOut == null) continue;
                this.mOut.write(n);
                if (n != 10) continue;
                this.mOut.flush();
            }
            if (this.mOut != null) {
                this.mOut.flush();
            }
        }
        catch (Exception exception) {
            this.mEx = exception;
        }
        this.done = true;
    }

    public boolean isDone() {
        return this.done;
    }

    public void checkException() throws Exception {
        if (this.mEx != null) {
            throw this.mEx;
        }
    }
}

