/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.quick;

import com.intersys.cache.jdbcutil.RDBMSAdapter;
import com.intersys.cache.quick.DBAdapter;
import com.intersys.cache.quick.QuickCacheObject;
import com.intersys.cache.quick.TableBasedClass;
import com.intersys.cache.quick.ThirdPartyDatabase;
import com.intersys.cache.util.ConnectionAnalyzer;
import com.intersys.classes.Persistent;
import com.intersys.jdbc.ConnectionInfo;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheServerException;
import com.intersys.objects.CandidateKey;
import com.intersys.objects.SystemError;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheField;
import com.intersys.objects.reflect.CandidateKeyInfo;
import com.intersys.objects.reflect.SQLColumn;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ThirdPartyDBAdapter
extends RDBMSAdapter
implements DBAdapter {
    private static final ConnectionInfo DEFAULT_CONNECTION_INFO = new ConnectionInfo(true, true, null);
    private int mProductType;
    private ThirdPartyDatabase mDB;
    private Map mLoadStatements;
    private Map mCreateStatements;
    private Map mBulkCreateStatements;
    private Map mStoreStatements;
    private Map mDeleteChildStatements;
    private Map mInsertChildStatements;
    private Map mLoadChildStatements;
    private static Blob oracleEmptyBlob = null;
    private static Method createOracleTempBlob = null;
    private static Integer ORACLE_DURATION = null;

    public ThirdPartyDBAdapter(ThirdPartyDatabase thirdPartyDatabase, Connection connection) throws SQLException, CacheException {
        super(connection);
        this.mDB = thirdPartyDatabase;
        this.mProductType = ConnectionAnalyzer.getProductType(this.getConnection());
        this.mLoadStatements = new HashMap();
        this.mCreateStatements = new HashMap();
        this.mStoreStatements = new HashMap();
        if (this.useSequnce()) {
            this.mBulkCreateStatements = new HashMap();
        }
        this.mDeleteChildStatements = new HashMap();
        this.mInsertChildStatements = new HashMap();
        this.mLoadChildStatements = new HashMap();
    }

    public Object load(String string, String string2, Object object, int n, TableBasedClass tableBasedClass) throws CacheException {
        return this.load(string, string2, object, tableBasedClass, null);
    }

    private Object load(String string, String string2, Object object, TableBasedClass tableBasedClass, String string3) throws CacheException {
        String string4 = string + "." + string2;
        try {
            String string5 = string4;
            string5 = string3 != null ? string5 + "_" + string3 : string5 + "_IDKey";
            PreparedStatement preparedStatement = (PreparedStatement)this.mLoadStatements.get(string5);
            SQLColumn[] sQLColumnArray = tableBasedClass.getSQLTableMetadata().getColumns();
            if (preparedStatement == null) {
                preparedStatement = string3 != null ? this.prepareLoadStatementByKey(string4, string3, tableBasedClass, sQLColumnArray) : this.prepareLoadStatementById(string4, tableBasedClass, sQLColumnArray);
            }
            if (string3 != null) {
                ((CandidateKey)object).toStatement(preparedStatement, 1);
            } else {
                preparedStatement.setObject(1, object);
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                throw new CacheServerException("Object to load not found: " + string + "." + string2 + " by " + object.toString(), 5809);
            }
            Object object2 = this.getRow(resultSet, sQLColumnArray);
            return object2;
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to open object " + string + "." + string2 + " by " + object);
        }
    }

    public Object loadByKey(String string, String string2, CandidateKey candidateKey, int n, TableBasedClass tableBasedClass) throws CacheException {
        return this.load(string, string2, (Object)candidateKey, tableBasedClass, candidateKey.getSQLName());
    }

    public void clearStreamHandler(QuickCacheObject quickCacheObject) throws CacheException {
    }

    public boolean deleteByKey(String string, String string2, CandidateKey candidateKey, int n, TableBasedClass tableBasedClass) throws CacheException {
        throw new UnsupportedOperationException("Method deleteByKey() is not implemented in class com.intersys.cache.quick.ThirdPartyDBAdapter");
    }

    public Object existsForKey(String string, String string2, CandidateKey candidateKey) throws CacheException {
        throw new UnsupportedOperationException("Method existsForKey() is not implemented in class com.intersys.cache.quick.ThirdPartyDBAdapter");
    }

    protected Object getRow(ResultSet resultSet, SQLColumn[] sQLColumnArray) throws SQLException {
        Object object = SysListProxy.createSysList(DEFAULT_CONNECTION_INFO);
        for (int i = 0; i < sQLColumnArray.length; ++i) {
            Object object2;
            SQLColumn sQLColumn = sQLColumnArray[i];
            if (sQLColumn.isCollection()) {
                object2 = this.getBytes(resultSet, sQLColumn.getNumber());
                SysListProxy.setByte(object, (byte[])object2);
                continue;
            }
            object2 = resultSet.getObject(sQLColumn.getNumber());
            SysListProxy.setObject(object, object2);
        }
        return object;
    }

    private byte[] getBytes(ResultSet resultSet, int n) throws SQLException {
        if (this.mProductType != 3) {
            return resultSet.getBytes(n);
        }
        Blob blob = resultSet.getBlob(n);
        if (blob == null) {
            return null;
        }
        int n2 = (int)blob.length();
        return blob.getBytes(1L, n2);
    }

    private void setBytes(PreparedStatement preparedStatement, int n, byte[] byArray) throws SQLException, CacheException {
        if (this.mProductType != 3) {
            preparedStatement.setBytes(n, byArray);
            return;
        }
        if (byArray == null) {
            preparedStatement.setBlob(n, ThirdPartyDBAdapter.getEmptyOracleBlob());
            return;
        }
        Blob blob = this.getTempOracleBlob();
        blob.setBytes(1L, byArray);
        preparedStatement.setBlob(n, blob);
    }

    private PreparedStatement prepareLoadStatementById(String string, TableBasedClass tableBasedClass, SQLColumn[] sQLColumnArray) throws SQLException, CacheException {
        String string2 = tableBasedClass.getIdField().getSQLColumn().getName();
        String string3 = string2 + " = ?";
        String string4 = string + "_IDKey";
        return this.prepareLoadStatement(string, sQLColumnArray, string3, string4);
    }

    private PreparedStatement prepareLoadStatementByKey(String string, String string2, TableBasedClass tableBasedClass, SQLColumn[] sQLColumnArray) throws SQLException, CacheException {
        CandidateKeyInfo candidateKeyInfo = tableBasedClass.getSQLTableMetadata().getCandidateKey(string2);
        if (candidateKeyInfo == null) {
            throw new CacheException("No Primary Key is available for class " + tableBasedClass.getName());
        }
        SQLColumn[] sQLColumnArray2 = candidateKeyInfo.getColumns();
        String string3 = "";
        for (int i = 0; i < sQLColumnArray2.length; ++i) {
            string3 = i == 0 ? string3 + sQLColumnArray2[i].getName() + " = ? " : string3 + "AND " + sQLColumnArray2[i].getName() + " = ? ";
        }
        String string4 = string + "_" + candidateKeyInfo.getSQLName();
        return this.prepareLoadStatement(string, sQLColumnArray, string3, string4);
    }

    private PreparedStatement prepareLoadStatement(String string, SQLColumn[] sQLColumnArray, String string2, String string3) throws SQLException, CacheException {
        String string4 = this.createColumnList(sQLColumnArray, false, false);
        String string5 = "select " + string4 + " from " + string + " where " + string2;
        PreparedStatement preparedStatement = this.getConnection().prepareStatement(string5);
        this.mLoadStatements.put(string3, preparedStatement);
        return preparedStatement;
    }

    private PreparedStatement prepareCreateStatement(String string, TableBasedClass tableBasedClass, SQLColumn[] sQLColumnArray, boolean bl) throws SQLException, CacheException {
        String string2;
        String string3 = "insert into ";
        string3 = this.supportsUpdatebleViews() ? string3 + string + " (" + this.createColumnList(sQLColumnArray, false, true) + ") " : string3 + this.mDB.getBaseTable(string) + " (" + this.createColumnList(sQLColumnArray, true, true) + ") ";
        string3 = string3 + " values (";
        int n = 0;
        for (int i = 0; i < sQLColumnArray.length; ++i) {
            if (sQLColumnArray[i].isRowIdColumn()) {
                if (this.skipIdFromInsert()) continue;
                if (this.useSequnce()) {
                    string2 = this.mDB.getSequence(tableBasedClass.getName());
                    if (string2 != null) {
                        string3 = string3 + string2 + ".NEXTVAL, ";
                        continue;
                    }
                    throw new CacheException("Sequence name for class " + tableBasedClass.getName() + " not found");
                }
            }
            string3 = n == 0 ? string3 + "?" : string3 + ", ?";
            ++n;
        }
        string3 = string3 + ")";
        string2 = tableBasedClass.getIdField().getSQLColumn().getName();
        PreparedStatement preparedStatement = this.mProductType == 3 ? this.prepareInsertForOracle(string3, ++n, string2, bl) : (this.mProductType == 4 ? this.prepareInsertForMSSql(string3) : this.getConnection().prepareStatement(string3, 1));
        this.putCreateStatement(string, preparedStatement, new Integer(n), bl);
        return preparedStatement;
    }

    private PreparedStatement prepareInsertForOracle(String string, int n, String string2, boolean bl) throws SQLException {
        String string3 = bl ? string : "begin " + string + " returning " + string2 + " INTO ?; end;";
        CallableStatement callableStatement = this.getConnection().prepareCall(string3);
        if (!bl) {
            callableStatement.registerOutParameter(n, 4);
        }
        return callableStatement;
    }

    private PreparedStatement prepareInsertForMSSql(String string) throws SQLException {
        String string2 = string + ";SELECT @@IDENTITY as ID";
        PreparedStatement preparedStatement = this.getConnection().prepareStatement(string2);
        return preparedStatement;
    }

    private PreparedStatement prepareStoreStatement(TableBasedClass tableBasedClass, String string) throws SQLException {
        String string2 = "update ";
        String string3 = tableBasedClass.getFullSQLTableName();
        string2 = this.supportsUpdatebleViews() ? string2 + string3 : string2 + this.mDB.getBaseTable(string3);
        string2 = string2 + string;
        String string4 = tableBasedClass.getIdField().getSQLColumn().getName();
        PreparedStatement preparedStatement = (PreparedStatement)this.mStoreStatements.get(string2 = string2 + " where " + string4 + " = ? ");
        if (preparedStatement == null) {
            preparedStatement = this.getConnection().prepareStatement(string2);
            this.mStoreStatements.put(string2, preparedStatement);
        }
        return preparedStatement;
    }

    public Object create(String string, String string2, int n, Object object, int n2, TableBasedClass tableBasedClass) throws CacheException {
        try {
            boolean bl;
            StatementInfo statementInfo = this.setCreateParameters(string, string2, object, tableBasedClass, false);
            PreparedStatement preparedStatement = (PreparedStatement)statementInfo.statement;
            int n3 = this.mProductType == 4 ? ((bl = preparedStatement.execute()) ? 0 : preparedStatement.getUpdateCount()) : preparedStatement.executeUpdate();
            if (n3 != 1) {
                throw new CacheException("Failed to create an object in table " + string + "." + string2);
            }
            if (this.mProductType == 3) {
                return ThirdPartyDBAdapter.getAutoGeneratedIdForOracle(preparedStatement, statementInfo.whatever);
            }
            if (this.mProductType == 4) {
                return ThirdPartyDBAdapter.getAutoGeneratedIdForMSSql(preparedStatement);
            }
            return ThirdPartyDBAdapter.getAutoGeneratedId(preparedStatement);
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to create an object in table " + string + "." + string2);
        }
    }

    public void addToCreateBatch(String string, String string2, Object object, TableBasedClass tableBasedClass) throws CacheException {
        try {
            StatementInfo statementInfo = this.setCreateParameters(string, string2, object, tableBasedClass, true);
            PreparedStatement preparedStatement = (PreparedStatement)statementInfo.statement;
            preparedStatement.addBatch();
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to create an object in table " + string + "." + string2);
        }
    }

    public void executeBatchCreate(String string, String string2) throws CacheException {
        String string3 = string + "." + string2;
        Map map = this.useSequnce() ? this.mBulkCreateStatements : this.mCreateStatements;
        StatementInfo statementInfo = (StatementInfo)map.get(string3);
        try {
            ((PreparedStatement)statementInfo.statement).executeBatch();
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to create multiple objects in table " + string + "." + string2);
        }
    }

    private StatementInfo setCreateParameters(String string, String string2, Object object, TableBasedClass tableBasedClass, boolean bl) throws SQLException, CacheException {
        String string3 = string + "." + string2;
        SQLColumn[] sQLColumnArray = tableBasedClass.getSQLTableMetadata().getColumns();
        StatementInfo statementInfo = bl && this.useSequnce() ? (StatementInfo)this.mBulkCreateStatements.get(string3) : (StatementInfo)this.mCreateStatements.get(string3);
        if (statementInfo == null) {
            this.prepareCreateStatement(string3, tableBasedClass, sQLColumnArray, bl);
            statementInfo = bl && this.useSequnce() ? (StatementInfo)this.mBulkCreateStatements.get(string3) : (StatementInfo)this.mCreateStatements.get(string3);
        }
        PreparedStatement preparedStatement = (PreparedStatement)statementInfo.statement;
        SysListProxy.rewind(object);
        int n = 1;
        int n2 = 0;
        if (!this.skipIdFromInsert() && !this.useSequnce()) {
            preparedStatement.setInt(n++, n2);
        }
        int n3 = SysListProxy.getInteger(object);
        for (int i = 1; !SysListProxy.atEnd(object) && i <= n3; ++i) {
            if (sQLColumnArray[i].isXClassName()) {
                String string4 = SysListProxy.getString(object);
                if (string4 == null) {
                    string4 = "~" + tableBasedClass.getName() + "~";
                }
                preparedStatement.setString(n++, string4);
                continue;
            }
            this.setParameter(sQLColumnArray[i], object, preparedStatement, n++);
        }
        return statementInfo;
    }

    private static Object getAutoGeneratedId(PreparedStatement preparedStatement) throws SQLException, CacheException {
        ResultSet resultSet = preparedStatement.getGeneratedKeys();
        if (!resultSet.next()) {
            throw new SystemError("No id was assigned.");
        }
        Object object = resultSet.getObject(1);
        return object;
    }

    private static Object getAutoGeneratedIdForOracle(PreparedStatement preparedStatement, Object object) throws SQLException {
        CallableStatement callableStatement = (CallableStatement)preparedStatement;
        int n = (Integer)object;
        int n2 = callableStatement.getInt(n);
        return new Integer(n2);
    }

    private static Object getAutoGeneratedIdForMSSql(PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.getMoreResults();
        ResultSet resultSet = preparedStatement.getResultSet();
        resultSet.next();
        int n = resultSet.getInt("ID");
        return new Integer(n);
    }

    public void store(String string, String string2, Object object, Object object2, int n, TableBasedClass tableBasedClass) throws CacheException {
        try {
            Object object3;
            SQLColumn[] sQLColumnArray = tableBasedClass.getSQLTableMetadata().getColumns();
            String string3 = " set ";
            SysListProxy.rewind(object2);
            int n2 = 0;
            int n3 = SysListProxy.getInteger(object2);
            boolean[] blArray = new boolean[sQLColumnArray.length];
            for (int i = 1; !SysListProxy.atEnd(object2) && i <= n3; ++i) {
                String string4;
                SQLColumn sQLColumn = sQLColumnArray[i];
                if (SysListProxy.isUndefined(object2)) {
                    SysListProxy.skip(object2, 1);
                    blArray[i] = false;
                    continue;
                }
                object3 = SysListProxy.getObject(object2);
                if (n2++ != 0) {
                    string3 = string3 + ", ";
                }
                String string5 = string4 = this.supportsUpdatebleViews() ? sQLColumn.getName() : this.columnName(sQLColumn);
                if (sQLColumn.isVersionColumn()) {
                    string4 = "_Version";
                    object3 = new Long(((Number)object3).longValue() + 1L);
                }
                string3 = string3 + string4 + " = ? ";
                blArray[i] = true;
            }
            PreparedStatement preparedStatement = this.prepareStoreStatement(tableBasedClass, string3);
            SysListProxy.rewind(object2);
            n2 = 1;
            n3 = SysListProxy.getInteger(object2);
            int n4 = 1;
            while (!SysListProxy.atEnd(object2)) {
                object3 = sQLColumnArray[n4];
                if (blArray[n4]) {
                    if (object3.isVersionColumn()) {
                        long l = SysListProxy.getLong(object2);
                        preparedStatement.setLong(n2++, l + 1L);
                    } else {
                        this.setParameter((SQLColumn)object3, object2, preparedStatement, n2++);
                    }
                } else {
                    SysListProxy.getObject(object2);
                }
                ++n4;
            }
            preparedStatement.setString(n2, object.toString());
            if (preparedStatement.executeUpdate() != 1) {
                throw new CacheException("Failed to update an object in table " + string + "." + string2 + " with id = " + object);
            }
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to update an object in table " + string + "." + string2 + " with id = " + object);
        }
    }

    private void setParameter(SQLColumn sQLColumn, Object object, PreparedStatement preparedStatement, int n) throws SQLException, CacheException {
        if (sQLColumn.isForEmbeddedObject()) {
            SysListProxy.getObject(object);
            preparedStatement.setNull(n++, -2);
        } else if (sQLColumn.getTypeName().endsWith("Date")) {
            Date date = SysListProxy.getSQLDate(object);
            preparedStatement.setDate(n++, date);
        } else if (sQLColumn.getTypeName().endsWith("Time")) {
            Time time = SysListProxy.getSQLTime(object);
            preparedStatement.setTime(n++, time);
        } else if (sQLColumn.getTypeName().endsWith("Timestamp")) {
            Timestamp timestamp = SysListProxy.getSQLTimestamp(object);
            preparedStatement.setTimestamp(n++, timestamp);
        } else if (sQLColumn.getTypeName().endsWith("Integer")) {
            Object object2;
            boolean bl = true;
            CacheField cacheField = sQLColumn.getField();
            if (cacheField != null) {
                object2 = cacheField.getJavaTypeName();
                bl = Long.class.getName().equals(object2) || Long.TYPE.getName().equals(object2);
            }
            if (bl) {
                object2 = SysListProxy.getLongWrapper(object);
                if (object2 == null) {
                    preparedStatement.setNull(n++, 4);
                } else {
                    preparedStatement.setLong(n++, (Long)object2);
                }
            } else {
                object2 = SysListProxy.getIntegerWrapper(object);
                if (object2 == null) {
                    preparedStatement.setNull(n++, 4);
                } else {
                    preparedStatement.setInt(n++, (Integer)object2);
                }
            }
        } else if (sQLColumn.isCollection()) {
            byte[] byArray = SysListProxy.getByte(object);
            if (byArray == null) {
                preparedStatement.setNull(n++, -2);
            } else {
                this.setBytes(preparedStatement, n++, byArray);
            }
        } else {
            String string = SysListProxy.getString(object);
            if (string == null) {
                preparedStatement.setNull(n++, 12);
            } else {
                preparedStatement.setString(n++, string);
            }
        }
    }

    private String createColumnList(SQLColumn[] sQLColumnArray, boolean bl, boolean bl2) throws CacheException {
        String string = null;
        boolean bl3 = bl2 ? this.skipIdFromInsert() : false;
        for (int i = 0; i < sQLColumnArray.length; ++i) {
            String string2;
            SQLColumn sQLColumn = sQLColumnArray[i];
            if (bl3 && sQLColumn.isRowIdColumn()) continue;
            String string3 = string2 = bl ? this.columnName(sQLColumn) : sQLColumn.getName();
            if ("%Version".equals(string2)) {
                string2 = "_Version";
            }
            string = string == null ? string2 : string + ", " + string2;
        }
        return string;
    }

    private String columnName(SQLColumn sQLColumn) throws CacheException {
        CacheClass cacheClass;
        String string = sQLColumn.getName();
        if (sQLColumn.isRowIdColumn() || sQLColumn.isHidden()) {
            return string;
        }
        if (sQLColumn.isDefinedInSuper()) {
            return string;
        }
        CacheClass cacheClass2 = sQLColumn.getContainingClass();
        CacheClass cacheClass3 = cacheClass2.getSuperclass();
        if (cacheClass3 != null && (cacheClass = cacheClass2.getSuperclass()) != null && cacheClass.isPersistent() && !Persistent.getCacheClassName().equals(cacheClass.getName())) {
            return cacheClass2.getSQLTableName() + "_" + string;
        }
        return string;
    }

    private static final Blob getEmptyOracleBlob() throws CacheException {
        if (oracleEmptyBlob == null) {
            try {
                Class<?> clazz = Class.forName("oracle.sql.BLOB");
                oracleEmptyBlob = (Blob)clazz.getField("empty_lob").get(null);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new CacheException(classNotFoundException, "Oracle Driver not found.");
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new CacheException(noSuchFieldException, "Empty Blob for Oracle not found.");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new CacheException(illegalAccessException, "Empty Blob for Oracle not accessible.");
            }
        }
        return oracleEmptyBlob;
    }

    private final Blob getTempOracleBlob() throws CacheException {
        Blob blob;
        if (this.mProductType != 3) {
            return null;
        }
        if (createOracleTempBlob == null) {
            this.initOracleBlobFactory();
        }
        try {
            blob = (Blob)createOracleTempBlob.invoke(null, this.getConnection(), Boolean.FALSE, ORACLE_DURATION);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new CacheException(invocationTargetException.getTargetException(), "Error creating temporary Blob for Oracle.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CacheException(illegalAccessException, "Empty Blob for Oracle not accessible.");
        }
        return blob;
    }

    private void initOracleBlobFactory() throws CacheException {
        try {
            Class<?> clazz = Class.forName("oracle.sql.BLOB");
            ORACLE_DURATION = (Integer)clazz.getField("DURATION_SESSION").get(null);
            createOracleTempBlob = clazz.getMethod("createTemporary", Connection.class, Boolean.TYPE, Integer.TYPE);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CacheException(classNotFoundException, "Oracle Driver not found.");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new CacheException(noSuchFieldException, "Blob for Oracle not found.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CacheException(illegalAccessException, "Empty Blob for Oracle not accessible.");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new CacheException(noSuchMethodException, "Temp Blob for Oracle not found.");
        }
    }

    public void childTableRowRemove(String string, String string2, Object object, int n) throws CacheException {
        String string3 = string + "." + string2;
        PreparedStatement preparedStatement = (PreparedStatement)this.mDeleteChildStatements.get(string3);
        try {
            if (preparedStatement == null) {
                preparedStatement = this.prepareDeleteChildStatement(string3);
            }
            preparedStatement.setObject(1, object);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to delete rows from child table " + string3 + "with parent id = " + object);
        }
    }

    public Object childTableRowInsert(String string, String string2, int n, Object object, Object object2, int n2) throws CacheException {
        String string3 = string + "." + string2;
        TableBasedClass tableBasedClass = this.mDB.getCacheClass(null, string3);
        SQLColumn[] sQLColumnArray = tableBasedClass.getSQLTableMetadata().getColumns();
        PreparedStatement preparedStatement = (PreparedStatement)this.mInsertChildStatements.get(string3);
        try {
            if (preparedStatement == null) {
                preparedStatement = this.prepareInsertChildStatement(string3);
            }
            preparedStatement.setObject(1, object);
            SysListProxy.rewind(object2);
            int n3 = SysListProxy.getInteger(object2);
            int n4 = 3;
            String string4 = null;
            int n5 = 2;
            while (!SysListProxy.atEnd(object2) && n5 - 2 < n3) {
                if ("element_key".equals(sQLColumnArray[n5].getName())) {
                    string4 = SysListProxy.getString(object2);
                    preparedStatement.setString(n4++, string4);
                } else {
                    this.setParameter(sQLColumnArray[n5], object2, preparedStatement, n4++);
                }
                ++n5;
            }
            String string5 = object.toString() + "||" + string4;
            preparedStatement.setString(2, string5);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to insert rows into child table " + string3 + " with parent id = " + object);
        }
        return null;
    }

    private PreparedStatement prepareDeleteChildStatement(String string) throws SQLException, CacheException {
        TableBasedClass tableBasedClass = this.mDB.getCacheClass(null, string);
        SQLColumn sQLColumn = tableBasedClass.getSQLTableMetadata().getColumns()[0];
        String string2 = sQLColumn.getName();
        String string3 = "delete from " + string + " where " + string2 + " = ?";
        PreparedStatement preparedStatement = this.getConnection().prepareStatement(string3);
        this.mDeleteChildStatements.put(string, preparedStatement);
        return preparedStatement;
    }

    private PreparedStatement prepareInsertChildStatement(String string) throws SQLException, CacheException {
        Object object;
        TableBasedClass tableBasedClass = this.mDB.getCacheClass(null, string);
        SQLColumn[] sQLColumnArray = tableBasedClass.getSQLTableMetadata().getColumns();
        String string2 = null;
        String string3 = null;
        for (int i = 0; i < sQLColumnArray.length; ++i) {
            object = sQLColumnArray[i];
            String string4 = object.getName();
            if (string2 == null) {
                string2 = string4;
                string3 = "?";
                continue;
            }
            string2 = string2 + ", " + string4;
            string3 = string3 + ", ?";
        }
        String string5 = "insert into " + string + " (" + string2 + ") values (" + string3 + ")";
        object = this.getConnection().prepareStatement(string5);
        this.mInsertChildStatements.put(string, object);
        return object;
    }

    public HashMap getArrayAsChildTable(String string, String string2, Object object, int n, int n2, int n3, int n4) throws CacheException {
        HashMap hashMap = new HashMap();
        this.getCollectionAsChildTable(hashMap, true, string, string2, object);
        return hashMap;
    }

    public ArrayList getListAsChildTable(String string, String string2, Object object, int n, int n2, int n3, int n4) throws CacheException {
        ArrayList arrayList = new ArrayList();
        this.getCollectionAsChildTable(arrayList, false, string, string2, object);
        return arrayList;
    }

    private void getCollectionAsChildTable(Object object, boolean bl, String string, String string2, Object object2) throws CacheException {
        boolean bl2;
        String string3 = string + "." + string2;
        TableBasedClass tableBasedClass = this.mDB.getCacheClass(null, string3);
        SQLColumn[] sQLColumnArray = tableBasedClass.getSQLTableMetadata().getColumns();
        if (tableBasedClass.isDatatype() || tableBasedClass.isPersistent()) {
            bl2 = false;
        } else if (tableBasedClass.isSerial()) {
            bl2 = true;
        } else {
            throw new SystemError("Unknown type of element in table " + string3);
        }
        try {
            ResultSet resultSet = this.loadChildTable(string3, sQLColumnArray, object2, bl);
            while (resultSet.next()) {
                this.addElement(object, bl, resultSet, bl2, sQLColumnArray);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to load child table " + string3 + " with parent id = " + object2);
        }
    }

    private ResultSet loadChildTable(String string, SQLColumn[] sQLColumnArray, Object object, boolean bl) throws SQLException {
        PreparedStatement preparedStatement = (PreparedStatement)this.mLoadChildStatements.get(string);
        if (preparedStatement == null) {
            preparedStatement = this.prepareLoadChildStatement(string, sQLColumnArray, bl);
        }
        preparedStatement.setObject(1, object);
        ResultSet resultSet = preparedStatement.executeQuery();
        return resultSet;
    }

    private PreparedStatement prepareLoadChildStatement(String string, SQLColumn[] sQLColumnArray, boolean bl) throws SQLException {
        String string2 = "select element_key";
        for (int i = 1; i < sQLColumnArray.length; ++i) {
            SQLColumn sQLColumn = sQLColumnArray[i];
            String string3 = sQLColumn.getName();
            if (sQLColumn.isForSerialField() && !sQLColumn.isFromSerialField() || "element_key".equals(string3)) continue;
            string2 = string2 + ", " + string3;
        }
        string2 = string2 + " from " + string + " where " + sQLColumnArray[0].getName() + " = ?";
        if (!bl) {
            string2 = string2 + " order by element_key";
        }
        PreparedStatement preparedStatement = this.getConnection().prepareStatement(string2);
        this.mLoadChildStatements.put(string, preparedStatement);
        return preparedStatement;
    }

    private void addElement(Object object, boolean bl, ResultSet resultSet, boolean bl2, SQLColumn[] sQLColumnArray) throws SQLException {
        Object object2 = resultSet.getObject(1);
        Object object3 = bl2 ? this.getSerialChildRow(resultSet, object2, bl, sQLColumnArray) : resultSet.getObject(3);
        if (bl) {
            ((Map)object).put(object2, object3);
        } else {
            ((List)object).add(object3);
        }
    }

    private Object getSerialChildRow(ResultSet resultSet, Object object, boolean bl, SQLColumn[] sQLColumnArray) throws SQLException {
        Object object2 = SysListProxy.createSysList(DEFAULT_CONNECTION_INFO);
        String string = resultSet.getString(2);
        SysListProxy.setString(object2, string);
        if (bl) {
            SysListProxy.setObject(object2, object);
        }
        int n = 3;
        for (int i = 2; i < sQLColumnArray.length; ++i) {
            Object object3;
            SQLColumn sQLColumn = sQLColumnArray[i];
            if (sQLColumn.isForSerialField() && !sQLColumn.isFromSerialField() || "element_key".equals(sQLColumn.getName())) continue;
            if (sQLColumn.isCollection()) {
                object3 = this.getBytes(resultSet, n);
                SysListProxy.setByte(object2, (byte[])object3);
            } else {
                object3 = resultSet.getObject(n);
                SysListProxy.setObject(object2, object3);
            }
            ++n;
        }
        return object2;
    }

    private final boolean supportsUpdatebleViews() {
        return this.mProductType != 1;
    }

    private final boolean skipIdFromInsert() {
        return this.mProductType == 4;
    }

    private final boolean useSequnce() {
        return this.mProductType == 3;
    }

    public Object wrapCharacterStream(Reader reader, QuickCacheObject quickCacheObject) throws CacheException {
        return null;
    }

    private void putCreateStatement(Object object, Object object2, Object object3, boolean bl) {
        if (bl && this.useSequnce()) {
            this.mBulkCreateStatements.put(object, new StatementInfo(object2, object3));
        } else {
            this.mCreateStatements.put(object, new StatementInfo(object2, object3));
        }
    }

    public Object bulkCreate(String string, String string2, int n, Object object, int n2) throws CacheServerException {
        throw new UnsupportedOperationException("Method bulkCreate() is not implemented in class com.intersys.cache.quick.ThirdPartyDBAdapter");
    }

    public Object bulkLoad(String string, String string2, Object object, int n) throws CacheServerException {
        throw new UnsupportedOperationException("Method bulkLoad() is not implemented in class com.intersys.cache.quick.ThirdPartyDBAdapter");
    }

    public void bulkStore(String string, String string2, Object object, int n) throws CacheServerException {
        throw new UnsupportedOperationException("Method bulkStore() is not implemented in class com.intersys.cache.quick.ThirdPartyDBAdapter");
    }

    public Object wrapBinaryStream(InputStream inputStream, QuickCacheObject quickCacheObject) throws CacheException {
        throw new UnsupportedOperationException("Method wrapBinaryStream() is not implemented in class com.intersys.cache.quick.ThirdPartyDBAdapter");
    }

    public InputStream getBinaryStream(Object object) throws SQLException {
        throw new UnsupportedOperationException("Method getBinaryStream() is not implemented in class com.intersys.cache.quick.ThirdPartyDBAdapter");
    }

    public Reader getReader(Object object) throws SQLException {
        throw new UnsupportedOperationException("Method getReader() is not implemented in class com.intersys.cache.quick.ThirdPartyDBAdapter");
    }

    public void remove(String string, String string2, Object object, int n) throws CacheServerException {
        throw new UnsupportedOperationException("Method remove() is not implemented in class com.intersys.cache.quick.ThirdPartyDBAdapter");
    }

    public Connection getConnection() {
        return this.mConnection;
    }

    private static class StatementInfo {
        public Object statement;
        public Object whatever;

        public StatementInfo(Object object, Object object2) {
            this.statement = object;
            this.whatever = object2;
        }
    }
}

