/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.quick;

import com.intersys.cache.CacheObject;
import com.intersys.cache.Dataholder;
import com.intersys.cache.SysDatabase;
import com.intersys.cache.quick.ColumnBasedField;
import com.intersys.cache.quick.LightDatabase;
import com.intersys.cache.quick.Mappings;
import com.intersys.cache.quick.QuickCacheObject;
import com.intersys.cache.quick.QuickCollectionObject;
import com.intersys.cache.quick.QuickEmbeddedObject;
import com.intersys.cache.quick.QuickReaderObject;
import com.intersys.cache.quick.QuickRelationshipObject;
import com.intersys.cache.quick.QuickStreamObject;
import com.intersys.cache.quick.SerialStorage;
import com.intersys.cache.quick.TableBasedClass;
import com.intersys.classes.Persistent;
import com.intersys.classes.PersistentWrapper;
import com.intersys.classes.RegisteredObject;
import com.intersys.classes.RelationshipObject;
import com.intersys.jdbc.QuickStatement;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import com.intersys.objects.Id;
import com.intersys.objects.Logger;
import com.intersys.objects.Oid;
import com.intersys.objects.SystemError;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheField;
import com.intersys.objects.reflect.TypeModifierHelper;
import com.intersys.objects.reflect.TypeModifiers;
import com.jalapeno.runtime.DetachedObjectsManager;
import com.jalapeno.runtime.ObjectFactory;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class QuickPersistentObject
extends QuickCacheObject
implements Mappings {
    private static boolean ENABLE_DEBUG_CLOSED = false;
    private static final byte DIRTY = 1;
    private static final byte REF_DIRTY = 2;
    private static final byte INVALID = 4;
    private static final byte SAVED = 8;
    private static final byte CLEAN = 0;
    private static Object NULL_SYS_LIST = SysListProxy.createSysList();
    private Object mFieldValues;
    private Object[] mCachedValues;
    private byte[] mFieldState;
    private int mLoadMethod;
    protected boolean inSave = false;

    public QuickPersistentObject(TableBasedClass tableBasedClass) {
        super(tableBasedClass);
        this.mLoadMethod = 7503;
        int n = tableBasedClass.getNumberOfCachedElements();
        this.mCachedValues = new Object[n];
        this.mFieldState = new byte[n];
        Arrays.fill(this.mFieldState, (byte)0);
        this.mState = 65282;
    }

    public QuickPersistentObject(TableBasedClass tableBasedClass, Object object, int n) {
        super(tableBasedClass);
        this.mLoadMethod = n;
        if (Logger.getDebugCache()) {
            Logger.out.println("Loaded object: ");
            QuickPersistentObject.logData(object);
        }
        this.mFieldValues = object;
        int n2 = tableBasedClass.getNumberOfCachedElements();
        this.mCachedValues = new Object[n2];
        this.mFieldState = new byte[n2];
        Arrays.fill(this.mFieldState, (byte)0);
        this.mState = 65281;
    }

    public boolean isClosed() {
        return this.mCachedValues == null || super.isClosed();
    }

    private void assertNotClosed() {
        if (this.mCachedValues != null) {
            return;
        }
        this.throwClosedException("Access to closed object. Count = " + this.getCount());
    }

    protected void throwClosedException(String string) {
        throw new IllegalStateException(string);
    }

    public Id getId() throws CacheException {
        if (this.mCachedValues == null) {
            return null;
        }
        String string = this.getProperty(this.mClass.getIdField()).getString();
        if (string == null) {
            return null;
        }
        return new Id(string);
    }

    public Oid getOid() throws CacheException {
        if (this.mCachedValues == null) {
            return null;
        }
        String string = this.getProperty(this.mClass.getIdField()).getString();
        if (string == null) {
            return null;
        }
        return new Oid(string, this.mClass.getName());
    }

    public void forceClose() throws CacheException {
        ((LightDatabase)this.getDatabase()).closeObject(this.getOid(), this);
        this.cleanup();
        super.forceClose();
        this.mFieldValues = null;
        this.mState |= 0xFF02;
    }

    protected void cleanup() {
        if (this.mCachedValues != null) {
            for (int i = 0; i < this.mCachedValues.length; ++i) {
                try {
                    this.setCachedValue(i, null);
                }
                catch (CacheException cacheException) {
                    // empty catch block
                }
                this.mFieldState[i] = 4;
            }
        }
        this.mCachedValues = null;
        if (ENABLE_DEBUG_CLOSED) {
            // empty if block
        }
        this.mState = 65282;
        super.cleanup();
    }

    protected void finalize() throws Throwable {
        this.cleanup();
        super.finalize();
    }

    protected boolean isInSave() {
        return this.inSave;
    }

    public synchronized int save(boolean bl) throws CacheException {
        Object object = ((LightDatabase)this.getDatabase()).createSysList();
        this.save(object, false, bl);
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int save(Object object, boolean bl, boolean bl2) throws CacheException {
        Object object2;
        TypeModifiers typeModifiers;
        if (this.inSave) {
            if (bl) {
                try {
                    SysListProxy.setInteger(object, 0);
                }
                catch (SQLException sQLException) {
                    throw new SystemError("Failed to set number of columns");
                }
            }
            if (this.getId() != null) {
                if (!bl) return 1;
                return 0;
            }
            try {
                if (!bl) {
                    SysListProxy.setInteger(object, 0);
                }
            }
            catch (SQLException sQLException) {
                throw new SystemError("Failed to set number of columns");
            }
            Object object3 = ((LightDatabase)this.getDatabase()).create(this.mClass, object);
            this.setProperty(this.mClass.getIdField(), Dataholder.create(object3), false, true);
            if (!bl) return 1;
            return 0;
        }
        this.inSave = true;
        boolean bl3 = false;
        int n = this.mClass.isChild() ? 2 : 1;
        try {
            SysListProxy.setInteger(object, this.mClass.getNumberOfColumnsForSet() - n);
        }
        catch (SQLException sQLException) {
            throw new SystemError("Failed to set number of columns");
        }
        boolean bl4 = false;
        boolean bl5 = false;
        Object object4 = null;
        int n2 = 0;
        int n3 = -1234567;
        if (this.mClass.isChild()) {
            n3 = ((ColumnBasedField)this.mClass.getParentField()).getColumnIndexForSet();
        }
        int n4 = -1;
        Object object5 = this.mClass.getAllSettableFieldsIterator();
        while (object5.hasNext()) {
            block46: {
                try {
                    Dataholder dataholder;
                    boolean bl6;
                    typeModifiers = (ColumnBasedField)object5.next();
                    if (n2 != typeModifiers.getColumnIndexForSet()) {
                        throw new SystemError("Expected column " + n2 + ", instead got " + typeModifiers.getColumnIndexForSet());
                    }
                    if (n2 == this.mClass.getIdField().getColumnIndexForSet()) break block46;
                    this.assertNotClosed();
                    object2 = this.mCachedValues[n2];
                    if (typeModifiers.isVersionField()) {
                        if (object2 == null) {
                            object2 = this.getProperty((ColumnBasedField)typeModifiers);
                        }
                        if (object2 != null && object2 instanceof Dataholder) {
                            Dataholder dataholder2 = (Dataholder)object2;
                            if (dataholder2.getObject() == null || dataholder2.getLongValue() < 0L) {
                                dataholder2 = new Dataholder(0);
                            }
                            if (this.isSaved(n2)) {
                                SysListProxy.setUndefined(object);
                                break block46;
                            } else {
                                dataholder2.stuff(object);
                                this.markSaved(n2);
                                n4 = n2;
                            }
                            break block46;
                        }
                    }
                    boolean bl7 = bl6 = n2 == n3;
                    if (this.isSaved(n2)) {
                        object2 = null;
                    } else if (this.isRefDirty(n2)) {
                        if ((object2 = this.valueToSave((ColumnBasedField)typeModifiers, object2, bl2)) != null) {
                            if (typeModifiers.isCollection()) {
                                this.checkCollectionOldValue(n2, object2);
                            } else if (typeModifiers.isStream()) {
                                this.markDirty(n2);
                            }
                        }
                        if (typeModifiers.isOneToManyRelationship()) {
                            this.invalidate(n2);
                            bl5 = true;
                        }
                    }
                    if (object2 == null || !this.isDirty(n2) && !bl6) {
                        if (!typeModifiers.isChildTable()) {
                            SysListProxy.setUndefined(object);
                        }
                        break block46;
                    }
                    bl4 = true;
                    bl5 = true;
                    if (object2 instanceof Dataholder && (dataholder = (Dataholder)object2).getObject() == null) {
                        object2 = null;
                    }
                    if (object2 == UNCHANGED) {
                        bl3 = true;
                        if (!typeModifiers.isChildTable()) {
                            throw new SystemError("Unexpected value.");
                        }
                        break block46;
                    }
                    if (bl6) {
                        if (!typeModifiers.isObject()) {
                            throw new SystemError("Reference class expected  for parent column: class: " + this.mClass.getName() + ", column: " + typeModifiers.getName());
                        }
                        object4 = object2;
                    } else {
                        SysListProxy.setObject(object, object2);
                        this.markSaved(n2);
                    }
                }
                catch (SQLException sQLException) {
                    throw new SystemError(sQLException, "Failed to set value to col #" + n2 + " for Object of class " + this.mClass.getName() + "; id = " + this.getId());
                }
            }
            ++n2;
        }
        object5 = this.getProperty(this.mClass.getIdField());
        typeModifiers = (LightDatabase)this.getDatabase();
        if (bl) {
            this.inSave = false;
            if (!bl4) {
                if (n4 < 0) return 0;
                return 1;
            }
            ((LightDatabase)typeModifiers).myAdapter().clearStreamHandler(this);
            if (!bl3) return 1;
            return 2;
        }
        if (((Dataholder)object5).getObject() == null && this.mFieldValues == null) {
            if (this.mClass.isChild()) {
                object2 = ((LightDatabase)typeModifiers).createChild(this.mClass, object4, object);
                object5 = new Dataholder((String)object2);
            } else {
                object2 = ((LightDatabase)typeModifiers).create(this.mClass, object);
                object5 = Dataholder.create(object2);
                this.setId((Dataholder)object5);
            }
            bl4 = true;
        } else if (bl4) {
            ((LightDatabase)typeModifiers).save(this.getOid(), object);
        }
        this.inSave = false;
        if (bl3) {
            this.setId((Dataholder)object5);
            this.save(bl2);
        }
        if (bl4) {
            ((LightDatabase)typeModifiers).myAdapter().clearStreamHandler(this);
            this.invalidate((Dataholder)object5);
            return 1;
        }
        if (!bl5) return 1;
        this.mState |= 0xFF02;
        this.unswizzlePojo();
        return 1;
    }

    private void checkCollectionOldValue(int n, Object object) throws CacheException {
        if (object.equals(UNCHANGED)) {
            this.markDirty(n);
            return;
        }
        this.assertNotClosed();
        Dataholder dataholder = (Dataholder)this.mCachedValues[n];
        if (dataholder == null) {
            this.markDirty(n);
            return;
        }
        QuickCollectionObject quickCollectionObject = (QuickCollectionObject)dataholder.getObject();
        Object object2 = quickCollectionObject.getSerialValue();
        if (object.equals(object2)) {
            return;
        }
        if (SysListProxy.getBinaryLength(object) == 0 && NULL_SYS_LIST.equals(object2)) {
            return;
        }
        this.markDirty(n);
    }

    private void markDirty(int n) {
        int n2 = n;
        this.mFieldState[n2] = (byte)(this.mFieldState[n2] | 1);
    }

    private void makeDirty(int n) {
        this.mFieldState[n] = 1;
    }

    private void markSaved(int n) {
        int n2 = n;
        this.mFieldState[n2] = (byte)(this.mFieldState[n2] | 8);
    }

    private void clearSaved(int n) {
        int n2 = n;
        this.mFieldState[n2] = (byte)(this.mFieldState[n2] & 0xFFFFFFF7);
    }

    private void makeRefDirty(int n) {
        this.mFieldState[n] = 2;
    }

    private void makeClean(int n) {
        this.mFieldState[n] = 0;
    }

    private void invalidate(int n) {
        this.clearSaved(n);
        int n2 = n;
        this.mFieldState[n2] = (byte)(this.mFieldState[n2] | 4);
    }

    private boolean isDirty(int n) {
        return (this.mFieldState[n] & 1) != 0;
    }

    private boolean isSaved(int n) {
        return (this.mFieldState[n] & 8) != 0;
    }

    private boolean isValid(int n) {
        return (this.mFieldState[n] & 4) == 0;
    }

    private boolean isRefDirty(int n) {
        byte by = this.mFieldState[n];
        return (by & 1) != 0 || (by & 2) != 0;
    }

    protected Iterator getAllProperties() throws CacheException {
        HashMap<String, Dataholder> hashMap = new HashMap<String, Dataholder>(this.mClass.getNumberOfColumnsForSet());
        Iterator iterator = this.mClass.getAllSettableFieldsIterator();
        while (iterator.hasNext()) {
            Dataholder dataholder;
            ColumnBasedField columnBasedField = (ColumnBasedField)iterator.next();
            if (columnBasedField == null || columnBasedField.getColumnIndexForGet() <= 0 || columnBasedField.equals(this.mClass.getIdField()) || (dataholder = this.getProperty(columnBasedField)) == null) continue;
            hashMap.put(columnBasedField.getName(), dataholder);
        }
        return hashMap.entrySet().iterator();
    }

    protected void objectDeleted() throws CacheException {
        Iterator iterator = this.mClass.getAllSettableFieldsIterator();
        while (iterator.hasNext()) {
            ColumnBasedField columnBasedField = (ColumnBasedField)iterator.next();
            if (columnBasedField.getColumnIndexForSet() == 0) continue;
            Dataholder dataholder = this.getProperty(columnBasedField);
            this.setProperty(columnBasedField, dataholder, false, true);
        }
        this.setId(Dataholder.create(null));
        this.mFieldValues = null;
        this.mState |= 0xFF02;
    }

    protected void setId(Dataholder dataholder) throws CacheException {
        String string;
        ColumnBasedField columnBasedField = this.mClass.getIdField();
        String string2 = this.mClass.getName();
        LightDatabase lightDatabase = (LightDatabase)this.getDatabase();
        Dataholder dataholder2 = this.getProperty(columnBasedField);
        if (dataholder2 != null && dataholder2.equals(dataholder)) {
            return;
        }
        if (dataholder2 != null && (string = dataholder2.getString()) != null) {
            lightDatabase.removeFromMap(string2, string);
        }
        this.setProperty(columnBasedField, dataholder, false, true);
        if (dataholder != null && dataholder.getObject() != null) {
            lightDatabase.addToMap(this, null, string2, dataholder.getString());
        }
    }

    protected void invalidate(Dataholder dataholder) throws CacheException {
        if (dataholder == null) {
            dataholder = this.getProperty(this.mClass.getIdField());
        }
        this.mFieldValues = null;
        this.assertNotClosed();
        for (int i = 0; i < this.mCachedValues.length; ++i) {
            Object object = this.mCachedValues[i];
            if (object instanceof Dataholder) {
                object = ((Dataholder)object).getObject();
            }
            if (object instanceof QuickCollectionObject) {
                this.invalidate(i);
                continue;
            }
            this.mFieldState[i] = 4;
        }
        this.setProperty(this.mClass.getIdField(), dataholder, false, false);
        this.makeClean(this.mClass.getIdField().getColumnIndexForSet());
        this.mState |= 0xFF02;
        this.unswizzlePojo();
    }

    private void unswizzlePojo() throws CacheException {
        LightDatabase lightDatabase = (LightDatabase)this.getDatabase();
        DetachedObjectsManager detachedObjectsManager = lightDatabase.getDetachedObjectsManagerIfExists();
        if (detachedObjectsManager != null) {
            Object object = detachedObjectsManager.findPOJO(this.getOid(), true);
            ObjectFactory.unswizzle(object);
        }
    }

    public Dataholder getProperty(int n, int n2, int n3, String string) throws CacheException {
        ColumnBasedField columnBasedField = this.mClass.getField(string, n, n2);
        return this.getProperty(columnBasedField);
    }

    protected Dataholder getProperty(ColumnBasedField columnBasedField) throws CacheException {
        ColumnBasedField columnBasedField2;
        int n;
        Dataholder dataholder;
        int n2 = columnBasedField.getColumnIndexForSet();
        this.assertNotClosed();
        Object object = this.mCachedValues[n2];
        if (object != null && object != UNCHANGED && this.isValid(n2)) {
            return (Dataholder)object;
        }
        if (this.mFieldValues == null && (dataholder = (Dataholder)this.mCachedValues[n = (columnBasedField2 = this.mClass.getIdField()).getColumnIndexForSet()]) != null && dataholder.getObject() != null) {
            this.mFieldValues = ((LightDatabase)this.getDatabase()).loadObject(dataholder.getString(), this.mClass);
            this.mLoadMethod = 7502;
            this.mState |= 0xFF01;
        }
        int n3 = columnBasedField.getColumnIndexForGet();
        if (!this.isValid(n2)) {
            this.makeClean(n2);
        }
        if (columnBasedField.isEmbedded()) {
            object = this.getEmbeddedObject(columnBasedField);
        } else {
            if (n3 < 0 && columnBasedField.getChildTableName() == null) {
                throw new CacheException("Property " + columnBasedField.getName() + " of class " + this.mClass.getName() + " can not be accessed " + "with Quick interface");
            }
            if (this.mFieldValues == null && columnBasedField.getCollectionType() != 0) {
                object = SerialStorage.newCollection(columnBasedField);
                this.makeRefDirty(n2);
            } else if (this.mFieldValues == null) {
                object = new Dataholder();
            } else {
                if (columnBasedField.isCollection() || columnBasedField.isStream()) {
                    try {
                        object = this.getCollection(columnBasedField);
                        this.makeRefDirty(n2);
                    }
                    catch (SQLException sQLException) {
                        throw new CacheException(sQLException, "Failed to get collection or stream for field " + columnBasedField.getName());
                    }
                }
                if (columnBasedField.isObject()) {
                    return this.getReferenceObject(columnBasedField, n3, n2);
                }
                try {
                    Object object2 = SysListProxy.getWrappedItem(this.mFieldValues, n3 - 1);
                    object = columnBasedField.getTypeName().equals("%Library.List") ? QuickPersistentObject.getSList(object2) : new Dataholder(4096, object2);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    arrayIndexOutOfBoundsException.printStackTrace();
                }
                catch (SQLException sQLException) {
                    throw new CacheException(sQLException, "Failed to get property " + columnBasedField.getName());
                }
            }
        }
        this.setCachedValue(n2, object);
        return (Dataholder)object;
    }

    private static Dataholder getSList(Object object) throws SQLException {
        Object object2;
        try {
            object2 = SysListProxy.getSysList(object);
            SysListProxy.countItems(object2);
        }
        catch (Exception exception) {
            String string = SysListProxy.getString(object, 0);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
            object2 = SysListProxy.createSysList();
            while (stringTokenizer.hasMoreTokens()) {
                SysListProxy.setString(object2, stringTokenizer.nextToken());
            }
        }
        return new Dataholder(384, object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCachedValue(int n, Object object) throws CacheException {
        Object object2;
        Object object3 = this.mCachedValues[n];
        if (object3 != null && object != null && object3.equals(object)) {
            return;
        }
        if (object3 != null && object3 instanceof Dataholder) {
            object2 = ((Dataholder)object3).getObject();
            if (object2 instanceof QuickPersistentObject) {
                ((QuickPersistentObject)object2).decreaseCount();
            } else if (object2 instanceof QuickReaderObject) {
                ((QuickReaderObject)object2).close();
            }
        }
        if (object != null && object instanceof Dataholder && (object2 = ((Dataholder)object).getObject()) instanceof QuickPersistentObject) {
            LightDatabase lightDatabase;
            QuickPersistentObject quickPersistentObject = (QuickPersistentObject)object2;
            LightDatabase lightDatabase2 = lightDatabase = (LightDatabase)this.getDatabase();
            synchronized (lightDatabase2) {
                if (quickPersistentObject.isClosed()) {
                    Oid oid = quickPersistentObject.getOid();
                    quickPersistentObject = (QuickPersistentObject)lightDatabase.openCacheObject(oid, -1, 0);
                    object = new Dataholder(quickPersistentObject);
                }
                quickPersistentObject.increaseCount();
            }
        }
        this.mCachedValues[n] = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseCount() throws CacheException {
        LightDatabase lightDatabase;
        if (!this.getCacheClass().isPersistent()) {
            super.increaseCount();
            return;
        }
        LightDatabase lightDatabase2 = lightDatabase = (LightDatabase)this.getDatabase();
        synchronized (lightDatabase2) {
            Object object = this.getZRef();
            Object object2 = lightDatabase.isInCache(object);
            if (object2 == null) {
                throw new IllegalStateException("Increasing count on closed object");
            }
            if (object2 != this && object2 != object) {
                throw new IllegalStateException("Increasing count on closed object");
            }
            super.increaseCount();
        }
    }

    public void setProperty(int n, int n2, int n3, int n4, String string, Dataholder dataholder) throws CacheException {
        ColumnBasedField columnBasedField = this.mClass.getField(string, n, n2);
        this.setProperty(columnBasedField, dataholder, true, true);
    }

    protected void setProperty(ColumnBasedField columnBasedField, Dataholder dataholder, boolean bl, boolean bl2) throws CacheException {
        if (bl) {
            this.mState |= 0xFF10;
        }
        if (columnBasedField.isEmbedded() && !columnBasedField.equals(this.mClass.getIdField())) {
            this.setEmbeddedObject(columnBasedField, dataholder);
        } else if (columnBasedField.getCollectionType() != 0) {
            this.setCollection(columnBasedField, dataholder);
        }
        int n = columnBasedField.getColumnIndexForSet();
        this.assertNotClosed();
        Object object = this.mCachedValues[n];
        boolean bl3 = false;
        if (object == null) {
            if (dataholder != null) {
                bl3 = true;
            }
        } else if (!object.equals(dataholder)) {
            bl3 = true;
        }
        if (bl3) {
            this.setCachedValue(n, dataholder);
            if (bl) {
                this.makeDirty(n);
            }
        }
        if (!bl3 || !bl2 || dataholder == null || dataholder.getObject() == null) {
            return;
        }
        String string = columnBasedField.getInverseFieldName();
        if (string == null) {
            return;
        }
        if (columnBasedField.isRelationship()) {
            return;
        }
        if (dataholder.getType() == 1028) {
            return;
        }
        QuickPersistentObject quickPersistentObject = (QuickPersistentObject)dataholder.getCacheObject();
        CacheField cacheField = quickPersistentObject.getCacheClass().getField(string);
        Dataholder dataholder2 = quickPersistentObject.getProperty((ColumnBasedField)cacheField);
        RelationshipObject relationshipObject = (RelationshipObject)dataholder2.getCollection();
        relationshipObject.add(this.newJavaInstance(true));
    }

    private void setEmbeddedObject(ColumnBasedField columnBasedField, Dataholder dataholder) throws CacheException {
        QuickEmbeddedObject quickEmbeddedObject = (QuickEmbeddedObject)dataholder.getCacheObject();
        if (!columnBasedField.isEmbeddedSetUp()) {
            this.mClass.setupEmbeddedField(columnBasedField);
        }
        TableBasedClass tableBasedClass = (TableBasedClass)columnBasedField.getType();
        if (quickEmbeddedObject != null) {
            quickEmbeddedObject.onSetStore(this, columnBasedField, tableBasedClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dataholder getReferenceObject(ColumnBasedField columnBasedField, int n, int n2) throws CacheException {
        String string;
        try {
            string = SysListProxy.getString(this.mFieldValues, n - 1);
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Can not get id of object at field " + columnBasedField.getName());
        }
        if (string == null) {
            return new Dataholder();
        }
        SysDatabase sysDatabase = this.getDatabase();
        synchronized (sysDatabase) {
            CacheObject cacheObject = this.getDatabase().openCacheObject(columnBasedField.getTypeName(), string);
            cacheObject.assertNotClosed(true);
            Dataholder dataholder = new Dataholder(cacheObject);
            this.setCachedValue(n2, dataholder);
            this.makeRefDirty(n2);
            cacheObject.assertNotClosed(false);
            return dataholder;
        }
    }

    private void setCollection(ColumnBasedField columnBasedField, Dataholder dataholder) throws CacheException {
        int n = columnBasedField.getColumnIndexForSet();
        this.setCachedValue(n, dataholder);
        this.makeDirty(n);
    }

    private List emptyList(ColumnBasedField columnBasedField, int n) throws CacheException {
        ArrayList arrayList;
        int n2 = columnBasedField.getColumnIndexForSet();
        this.assertNotClosed();
        Object object = this.mCachedValues[n2];
        if (object instanceof Dataholder) {
            object = ((Dataholder)object).getObject();
        }
        if (object instanceof QuickCollectionObject) {
            object = ((QuickCollectionObject)object).getCollection();
        }
        if ((arrayList = (ArrayList)object) != null) {
            arrayList.clear();
        } else {
            arrayList = new ArrayList(n);
        }
        return arrayList;
    }

    private Map emptyMap(ColumnBasedField columnBasedField, int n) throws CacheException {
        HashMap hashMap;
        int n2 = columnBasedField.getColumnIndexForSet();
        this.assertNotClosed();
        Object object = this.mCachedValues[n2];
        if (object instanceof Dataholder) {
            object = ((Dataholder)object).getObject();
        }
        if (object instanceof QuickCollectionObject) {
            object = ((QuickCollectionObject)object).getCollection();
        }
        if ((hashMap = (HashMap)object) != null) {
            hashMap.clear();
        } else {
            hashMap = new HashMap(n);
        }
        return hashMap;
    }

    private Dataholder getCollection(ColumnBasedField columnBasedField) throws CacheException, SQLException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string;
        Object object5;
        block50: {
            object5 = null;
            int n = columnBasedField.getColumnIndexForGet();
            int n2 = columnBasedField.getCollectionType();
            String string2 = columnBasedField.getElementTypeName();
            string = columnBasedField.getChildTableName();
            LightDatabase lightDatabase = (LightDatabase)this.getDatabase();
            object4 = null;
            if (string == null) {
                object4 = SysListProxy.getWrappedItem(this.mFieldValues, n - 1);
            } else if (!columnBasedField.isRelationship() && !lightDatabase.isClassRegistered(string)) {
                lightDatabase.createQuickCacheClass(columnBasedField);
            }
            int n3 = columnBasedField.getElementType();
            int n4 = -1;
            if (!TypeModifierHelper.isStream(n2) && n3 == 256 && string2 != null && !string2.endsWith("String")) {
                object3 = this.getDatabase().getCacheClass(string2).getJavaClassName();
                n4 = Dataholder.toIntType((String)object3);
            }
            object3 = (TableBasedClass)columnBasedField.getType();
            if (string != null && columnBasedField.isList()) {
                object2 = this.getListOfReferencesAsChildTable(columnBasedField, n3);
                object = this.emptyList(columnBasedField, ((ArrayList)object2).size());
                Iterator iterator = ((ArrayList)object2).iterator();
                while (iterator.hasNext()) {
                    Object object6;
                    Object e = iterator.next();
                    if (e instanceof QuickStatement.ChildTableRow) {
                        QuickStatement.ChildTableRow childTableRow = (QuickStatement.ChildTableRow)e;
                        object6 = childTableRow.data;
                    } else {
                        object6 = e;
                    }
                    this.processRefListElem((List)object, columnBasedField, string2, n3, n4, object6);
                }
                object5 = object;
            } else if (string != null && n2 == 19) {
                object2 = this.getListOfReferencesAsChildTable(columnBasedField, n3);
                object = this.emptyList(columnBasedField, ((ArrayList)object2).size());
                Iterator iterator = ((ArrayList)object2).iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    QuickStatement.ChildTableRow childTableRow = (QuickStatement.ChildTableRow)e;
                    Object object7 = childTableRow.data;
                    this.processRefListElem((List)object, columnBasedField, string2, n3, n4, object7);
                }
                object5 = object;
            } else if (string != null && n2 == 21) {
                object5 = this.getMany(columnBasedField, string2);
            } else if (string != null && n2 == 1) {
                object2 = this.getArrayOfReferencesAsChildTable(columnBasedField, n3);
                object = this.emptyMap(columnBasedField, ((HashMap)object2).size());
                block15: for (Map.Entry entry : ((HashMap)object2).entrySet()) {
                    Object object8;
                    Object object9;
                    Object object10;
                    Object object11;
                    Object v = entry.getValue();
                    if (v instanceof QuickStatement.ChildTableRow) {
                        object11 = (QuickStatement.ChildTableRow)v;
                        int n5 = lightDatabase.getKeyColumn(string);
                        object10 = n5 == 0 ? ((QuickStatement.ChildTableRow)object11).data : entry.getKey();
                        object9 = n5 == 0 ? entry.getKey() : ((QuickStatement.ChildTableRow)object11).data;
                        object8 = ((QuickStatement.ChildTableRow)object11).data;
                    } else {
                        object10 = entry.getKey();
                        object8 = object9 = v;
                    }
                    switch (n3) {
                        case 256: {
                            if (n4 > 0) {
                                object11 = Dataholder.create(object9);
                                object9 = ((Dataholder)object11).getObject(n4);
                            }
                            object.put(object10, object9);
                            continue block15;
                        }
                        case 4608: {
                            object11 = object9.toString();
                            object.put(object10, this.getObjectInCollection((String)object11, string2));
                            continue block15;
                        }
                        case 8704: {
                            SysListProxy.rewind(object9);
                            object.put(object10, this.getObjectInCollection(object8, string2, string));
                            continue block15;
                        }
                    }
                    throw new CacheException("Unsupported collection element type");
                }
                object5 = object;
            } else if (columnBasedField.isList() && this.mLoadMethod == 7506) {
                try {
                    object5 = SerialStorage.getSerialList(this.emptyList(columnBasedField, 0), this.getDatabase(), string2, n3, object4, n4);
                    this.mLoadMethod = 7502;
                }
                catch (Exception exception) {
                    SysListProxy.rewind(object4);
                    object5 = SerialStorage.getCommaSeparatedSerialList(this.emptyList(columnBasedField, 0), this.getDatabase(), string2, n3, object4, n4);
                    this.mLoadMethod = 7501;
                    object4 = lightDatabase.wrapPrimList((List)object5);
                }
            } else {
                if (columnBasedField.isList() && this.mLoadMethod == 7502) {
                    try {
                        object5 = SerialStorage.getSerialList(this.emptyList(columnBasedField, 0), this.getDatabase(), string2, n3, object4, n4);
                    }
                    catch (SQLException sQLException) {
                        if (sQLException.getMessage().startsWith("Incorrect list")) {
                            SysListProxy.rewind(object4);
                            object5 = SerialStorage.getCommaSeparatedSerialList(null, this.getDatabase(), string2, n3, object4, n4);
                            object4 = lightDatabase.wrapPrimList((List)object5);
                        }
                        break block50;
                    }
                }
                if (columnBasedField.isList() && this.mLoadMethod == 7501) {
                    object5 = SerialStorage.getCommaSeparatedSerialList(null, this.getDatabase(), string2, n3, object4, n4);
                    object4 = lightDatabase.wrapPrimList((List)object5);
                } else if (n2 == 1 && this.mLoadMethod == 7501) {
                    object5 = SerialStorage.getCommaSeparatedSerialArray(null, this.getDatabase(), string2, n3, object4, n4);
                } else if (n2 == 1 && this.mLoadMethod == 7506) {
                    try {
                        object5 = SerialStorage.getCommaSeparatedSerialArray(this.emptyMap(columnBasedField, 0), this.getDatabase(), string2, n3, object4, n4);
                        this.mLoadMethod = 7501;
                    }
                    catch (Exception exception) {
                        object5 = SerialStorage.getSerialArray(this.emptyMap(columnBasedField, 0), this.getDatabase(), string2, n3, object4, n4);
                        this.mLoadMethod = 7502;
                    }
                } else if (n2 == 1 && this.mLoadMethod == 7502) {
                    object5 = SerialStorage.getSerialArray(this.emptyMap(columnBasedField, 0), this.getDatabase(), string2, n3, object4, n4);
                } else {
                    if (n2 == 32) {
                        InputStream inputStream = null;
                        try {
                            inputStream = ((LightDatabase)this.getDatabase()).getJDBCBinaryStream(object4);
                        }
                        catch (SQLException sQLException) {
                            inputStream = null;
                        }
                        QuickStreamObject quickStreamObject = new QuickStreamObject((TableBasedClass)object3, inputStream, new ByteArrayOutputStream());
                        return new Dataholder(quickStreamObject);
                    }
                    if (n2 == 64) {
                        Reader reader = ((LightDatabase)this.getDatabase()).getJDBCCharacterStream(object4);
                        QuickReaderObject quickReaderObject = new QuickReaderObject((TableBasedClass)object3, reader, new CharArrayWriter());
                        return new Dataholder(quickReaderObject);
                    }
                    throw new CacheException("Unsupported collection type: " + n2);
                }
            }
        }
        if (columnBasedField.isRelationship()) {
            object2 = new QuickRelationshipObject((TableBasedClass)object3, object5);
        } else {
            object2 = new QuickCollectionObject((TableBasedClass)object3, object5);
            if (string == null) {
                ((QuickCollectionObject)object2).setSerialValue(object4);
            }
        }
        object = new Dataholder((CacheObject)object2);
        return object;
    }

    private void processRefListElem(List list, ColumnBasedField columnBasedField, String string, int n, int n2, Object object) throws CacheException, SQLException {
        switch (n) {
            case 256: {
                if (n2 > 0) {
                    Dataholder dataholder = Dataholder.create(object);
                    object = dataholder.getObject(n2);
                }
                list.add(object);
                break;
            }
            case 4608: {
                String string2 = (String)object;
                list.add(this.getObjectInCollection(string2, string));
                break;
            }
            case 8704: {
                SysListProxy.rewind(object);
                list.add(this.getObjectInCollection(object, string, columnBasedField.getChildTableName()));
                break;
            }
            default: {
                throw new CacheException("Unsupported collection element type");
            }
        }
    }

    private List getMany(ColumnBasedField columnBasedField, String string) throws CacheException {
        List list = this.emptyList(columnBasedField, 0);
        String string2 = columnBasedField.getInverseFieldName();
        CacheClass cacheClass = this.getDatabase().getCacheClass(string);
        CacheField cacheField = cacheClass.getField(string2);
        String string3 = cacheField.getSQLColumn().getName();
        String string4 = string3 + " = ? ";
        Object[] objectArray = new String[]{this.getId().toString()};
        Iterator iterator = ((LightDatabase)this.getDatabase()).openByQuery(string, string4, objectArray);
        Dataholder dataholder = new Dataholder(this);
        while (iterator.hasNext()) {
            ColumnBasedField columnBasedField2;
            RegisteredObject registeredObject;
            Object e = iterator.next();
            if (e instanceof PersistentWrapper) {
                registeredObject = (PersistentWrapper)e;
                columnBasedField2 = (ColumnBasedField)registeredObject.getCacheClass().getField(string2);
                ((QuickPersistentObject)registeredObject.getProxy()).setProperty(columnBasedField2, dataholder, false, false);
            } else {
                registeredObject = (Persistent)e;
                columnBasedField2 = (ColumnBasedField)registeredObject.getCacheClass().getField(string2);
                ((QuickPersistentObject)registeredObject.getProxy()).setProperty(columnBasedField2, dataholder, false, false);
            }
            list.add(e);
        }
        return list;
    }

    private ArrayList getListOfReferencesAsChildTable(ColumnBasedField columnBasedField, int n) throws CacheException {
        String string = columnBasedField.getChildTableName();
        Id id = this.getId();
        if (id == null) {
            return new ArrayList();
        }
        LightDatabase lightDatabase = (LightDatabase)this.getDatabase();
        ArrayList arrayList = lightDatabase.getListOfReferencesAsChildTable(string, id.toString(), 12, 12, n);
        return arrayList;
    }

    private HashMap getArrayOfReferencesAsChildTable(ColumnBasedField columnBasedField, int n) throws CacheException {
        String string = columnBasedField.getChildTableName();
        Id id = this.getId();
        if (id == null) {
            return new HashMap();
        }
        LightDatabase lightDatabase = (LightDatabase)this.getDatabase();
        HashMap hashMap = lightDatabase.getArrayOfReferencesAsChildTable(string, id.toString(), 12, 12, n);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getObjectInCollection(Object object, String string, String string2) throws CacheException {
        TableBasedClass tableBasedClass = ((LightDatabase)this.getDatabase()).getCacheClass(string, string2);
        SysDatabase sysDatabase = this.getDatabase();
        synchronized (sysDatabase) {
            QuickPersistentObject quickPersistentObject = new QuickPersistentObject(tableBasedClass, object, 7502);
            quickPersistentObject.assertNotClosed(true);
            Object object2 = quickPersistentObject.newJavaInstance(true);
            quickPersistentObject.assertNotClosed(false);
            return object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getObjectInCollection(String string, String string2) throws CacheException {
        SysDatabase sysDatabase = this.getDatabase();
        synchronized (sysDatabase) {
            CacheObject cacheObject = this.getDatabase().openCacheObject(string2, string);
            cacheObject.assertNotClosed(true);
            Object object = cacheObject.newJavaInstance(true);
            cacheObject.assertNotClosed(false);
            return object;
        }
    }

    private Dataholder getEmbeddedObject(ColumnBasedField columnBasedField) throws CacheException {
        TableBasedClass tableBasedClass = (TableBasedClass)columnBasedField.getType();
        QuickEmbeddedObject quickEmbeddedObject = new QuickEmbeddedObject(tableBasedClass, this, columnBasedField);
        if (!columnBasedField.isEmbeddedSetUp()) {
            this.mClass.setupEmbeddedField(columnBasedField);
        }
        return new Dataholder(quickEmbeddedObject);
    }

    private static void logData(Object object) {
        try {
            SysListProxy.rewind(object);
            int n = 1;
            while (!SysListProxy.atEnd(object)) {
                Logger.out.println("\t" + n + ":\t" + SysListProxy.getObject(object));
                ++n;
            }
        }
        catch (SQLException sQLException) {
            Logger.out.println("Exception caught " + sQLException.getMessage());
        }
    }

    static {
        try {
            SysListProxy.setString(NULL_SYS_LIST, null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

