/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.quick;

import com.intersys.cache.jdbcutil.JDBCAdapter;
import com.intersys.cache.quick.DBAdapter;
import com.intersys.cache.quick.QuickCacheObject;
import com.intersys.cache.quick.TableBasedClass;
import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.CacheInputStream;
import com.intersys.jdbc.CacheReader;
import com.intersys.jdbc.QuickStatement;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheServerException;
import com.intersys.objects.CandidateKey;
import com.intersys.objects.ObjectServerInfo;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class QuickDBAdapter
extends JDBCAdapter
implements DBAdapter {
    private ObjectServerInfo mServerInfo;
    private Boolean mUseSeparateStreamQS = null;
    private QuickStatement mQS;
    private Map mStreamHandlers;

    public QuickDBAdapter(CacheConnection cacheConnection, ObjectServerInfo objectServerInfo) throws CacheException {
        super(cacheConnection);
        this.mServerInfo = objectServerInfo;
        try {
            this.mQS = cacheConnection.createQuickStatement();
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to initialize QuickStatement");
        }
        this.mStreamHandlers = new HashMap();
    }

    public Object load(String string, String string2, Object object, int n, TableBasedClass tableBasedClass) throws CacheServerException {
        Object object2;
        int n2 = mProfileFlag != null ? mProfileFlag.length : 0;
        long l = System.currentTimeMillis();
        try {
            object2 = this.mQS.load(string, string2, object, n);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to fetch row in table " + string + "." + string2 + " with id " + object);
        }
        long l2 = System.currentTimeMillis();
        ++mNumCalls;
        mElapsedTime += l2 - l;
        for (int i = 0; i < n2; ++i) {
            if (!mProfileFlag[i]) continue;
            int n3 = i;
            mNumCallsArray[n3] = mNumCallsArray[n3] + 1;
            int n4 = i;
            mElapsedTimeArray[n4] = mElapsedTimeArray[n4] + (l2 - l);
        }
        return object2;
    }

    public Object loadByKey(String string, String string2, CandidateKey candidateKey, int n, TableBasedClass tableBasedClass) throws CacheException {
        Object object;
        if (candidateKey.isIdKey()) {
            String string3 = candidateKey.toIdValue();
            return this.load(string, string2, string3, n, tableBasedClass);
        }
        int n2 = mProfileFlag != null ? mProfileFlag.length : 0;
        long l = System.currentTimeMillis();
        try {
            if (candidateKey.isPrimaryKey()) {
                object = this.mQS.loadByPk(string, string2, candidateKey.toSysList(), n);
            } else {
                Object object2 = this.mQS.findRowIdByConstraint(string, string2, candidateKey.getSQLName(), candidateKey.toSysList(), 12);
                if (object2 == null) {
                    return null;
                }
                object = this.mQS.load(string, string2, object2, n);
                ++mNumCalls;
                for (int i = 0; i < n2; ++i) {
                    if (!mProfileFlag[i]) continue;
                    int n3 = i;
                    mNumCallsArray[n3] = mNumCallsArray[n3] + 1;
                }
            }
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to fetch row in table " + string + "." + string2 + " with primary key " + candidateKey.toString());
        }
        long l2 = System.currentTimeMillis();
        ++mNumCalls;
        mElapsedTime += l2 - l;
        for (int i = 0; i < n2; ++i) {
            if (!mProfileFlag[i]) continue;
            int n4 = i;
            mNumCallsArray[n4] = mNumCallsArray[n4] + 1;
            int n5 = i;
            mElapsedTimeArray[n5] = mElapsedTimeArray[n5] + (l2 - l);
        }
        return object;
    }

    public boolean deleteByKey(String string, String string2, CandidateKey candidateKey, int n, TableBasedClass tableBasedClass) throws CacheException {
        int n2 = mProfileFlag != null ? mProfileFlag.length : 0;
        long l = System.currentTimeMillis();
        try {
            if (candidateKey.isPrimaryKey()) {
                this.mQS.removeByPk(string, string2, candidateKey.toSysList(), n);
            } else {
                Object object = this.mQS.findRowIdByConstraint(string, string2, candidateKey.getSQLName(), candidateKey.toSysList(), 12);
                this.mQS.remove(string, string2, object, n);
                ++mNumCalls;
                for (int i = 0; i < n2; ++i) {
                    if (!mProfileFlag[i]) continue;
                    int n3 = i;
                    mNumCallsArray[n3] = mNumCallsArray[n3] + 1;
                }
            }
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to delete row in table " + string + "." + string2 + " with primary key " + candidateKey.toString());
        }
        long l2 = System.currentTimeMillis();
        ++mNumCalls;
        mElapsedTime += l2 - l;
        for (int i = 0; i < n2; ++i) {
            if (!mProfileFlag[i]) continue;
            int n4 = i;
            mNumCallsArray[n4] = mNumCallsArray[n4] + 1;
            int n5 = i;
            mElapsedTimeArray[n5] = mElapsedTimeArray[n5] + (l2 - l);
        }
        return true;
    }

    public Object existsForKey(String string, String string2, CandidateKey candidateKey) throws CacheException {
        int n = mProfileFlag != null ? mProfileFlag.length : 0;
        long l = System.currentTimeMillis();
        Object object = null;
        try {
            object = candidateKey.isPrimaryKey() ? this.mQS.findRowIdByPrimaryKey(string, string2, candidateKey.toSysList(), 12) : this.mQS.findRowIdByConstraint(string, string2, candidateKey.getSQLName(), candidateKey.toSysList(), 12);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to find row in table " + string + "." + string2 + " with primary key " + candidateKey.toString());
        }
        long l2 = System.currentTimeMillis();
        ++mNumCalls;
        mElapsedTime += l2 - l;
        for (int i = 0; i < n; ++i) {
            if (!mProfileFlag[i]) continue;
            int n2 = i;
            mNumCallsArray[n2] = mNumCallsArray[n2] + 1;
            int n3 = i;
            mElapsedTimeArray[n3] = mElapsedTimeArray[n3] + (l2 - l);
        }
        return object;
    }

    public Object bulkLoad(String string, String string2, Object object, int n) throws CacheServerException {
        Object object2;
        int n2 = mProfileFlag != null ? mProfileFlag.length : 0;
        long l = System.currentTimeMillis();
        try {
            object2 = this.mQS.bulkLoad(string, string2, object, n);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to fetch rows in table " + string + "." + string2);
        }
        long l2 = System.currentTimeMillis();
        ++mNumCalls;
        mElapsedTime += l2 - l;
        for (int i = 0; i < n2; ++i) {
            if (!mProfileFlag[i]) continue;
            int n3 = i;
            mNumCallsArray[n3] = mNumCallsArray[n3] + 1;
            int n4 = i;
            mElapsedTimeArray[n4] = mElapsedTimeArray[n4] + (l2 - l);
        }
        return object2;
    }

    public ArrayList getListAsChildTable(String string, String string2, Object object, int n, int n2, int n3, int n4) throws CacheException {
        ArrayList arrayList;
        int n5 = mProfileFlag != null ? mProfileFlag.length : 0;
        long l = System.currentTimeMillis();
        try {
            switch (n4) {
                case 4608: {
                    arrayList = this.mQS.getListOfReferencesAsChildTable(string, string2, object, n, n2, n3);
                    break;
                }
                case 8704: {
                    arrayList = this.mQS.getListOfSerialsAsChildTable(string, string2, object, n, n3);
                    break;
                }
                case 256: {
                    arrayList = this.mQS.getListOfDatatypesAsChildTable(string, string2, object, n, n2, n3);
                    break;
                }
                default: {
                    throw new CacheException("Type not supported: " + n4);
                }
            }
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to load child table " + string2);
        }
        long l2 = System.currentTimeMillis();
        ++mNumCalls;
        mElapsedTime += l2 - l;
        for (int i = 0; i < n5; ++i) {
            if (!mProfileFlag[i]) continue;
            int n6 = i;
            mNumCallsArray[n6] = mNumCallsArray[n6] + 1;
            int n7 = i;
            mElapsedTimeArray[n7] = mElapsedTimeArray[n7] + (l2 - l);
        }
        return arrayList;
    }

    public HashMap getArrayAsChildTable(String string, String string2, Object object, int n, int n2, int n3, int n4) throws CacheException {
        HashMap hashMap;
        int n5 = mProfileFlag != null ? mProfileFlag.length : 0;
        long l = System.currentTimeMillis();
        try {
            switch (n4) {
                case 4608: {
                    hashMap = this.mQS.getArrayOfReferencesAsChildTable(string, string2, object, n, 12, n2, n3);
                    break;
                }
                case 8704: {
                    hashMap = this.mQS.getArrayOfSerialsAsChildTable(string, string2, object, n, 12, n3);
                    break;
                }
                case 256: {
                    hashMap = this.mQS.getArrayOfDatatypesAsChildTable(string, string2, object, n, 12, n2, n3);
                    break;
                }
                default: {
                    throw new CacheException("Type not supported: " + n4);
                }
            }
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to load child table " + string2);
        }
        long l2 = System.currentTimeMillis();
        ++mNumCalls;
        mElapsedTime += l2 - l;
        for (int i = 0; i < n5; ++i) {
            if (!mProfileFlag[i]) continue;
            int n6 = i;
            mNumCallsArray[n6] = mNumCallsArray[n6] + 1;
            int n7 = i;
            mElapsedTimeArray[n7] = mElapsedTimeArray[n7] + (l2 - l);
        }
        return hashMap;
    }

    public Object bulkCreate(String string, String string2, int n, Object object, int n2) throws CacheServerException {
        int n3 = mProfileFlag != null ? mProfileFlag.length : 0;
        long l = System.currentTimeMillis();
        Object object2 = null;
        try {
            object2 = this.mQS.bulkCreate(string, string2, n, object, n2);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Creating of objects failed.");
        }
        long l2 = System.currentTimeMillis();
        ++mNumCalls;
        mElapsedTime += l2 - l;
        for (int i = 0; i < n3; ++i) {
            if (!mProfileFlag[i]) continue;
            int n4 = i;
            mNumCallsArray[n4] = mNumCallsArray[n4] + 1;
            int n5 = i;
            mElapsedTimeArray[n5] = mElapsedTimeArray[n5] + (l2 - l);
        }
        return object2;
    }

    public void bulkStore(String string, String string2, Object object, int n) throws CacheServerException {
        int n2;
        Object object2;
        int n3 = mProfileFlag != null ? mProfileFlag.length : 0;
        long l = System.currentTimeMillis();
        try {
            object2 = this.mQS.bulkStore(string, string2, object, n);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Creating of objects failed");
        }
        long l2 = System.currentTimeMillis();
        ++mNumCalls;
        mElapsedTime += l2 - l;
        for (n2 = 0; n2 < n3; ++n2) {
            if (!mProfileFlag[n2]) continue;
            int n4 = n2;
            mNumCallsArray[n4] = mNumCallsArray[n4] + 1;
            int n5 = n2;
            mElapsedTimeArray[n5] = mElapsedTimeArray[n5] + (l2 - l);
        }
        n2 = 1;
        while (!SysListProxy.atEnd(object2)) {
            int n6 = 0;
            try {
                n6 = SysListProxy.getInteger(object2);
            }
            catch (SQLException sQLException) {
                throw new CacheServerException(sQLException, "Invalid response from BULK STORE request.");
            }
            if (n6 < 0) {
                throw new CacheServerException("Unidentified error occured storing object # " + n2 + " in store list");
            }
            ++n2;
        }
    }

    public Object create(String string, String string2, int n, Object object, int n2, TableBasedClass tableBasedClass) throws CacheServerException {
        Object object2;
        int n3 = mProfileFlag != null ? mProfileFlag.length : 0;
        long l = System.currentTimeMillis();
        try {
            object2 = this.mQS.create(string, string2, n, object, n2);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to create an object in table " + string + "." + string2);
        }
        long l2 = System.currentTimeMillis();
        ++mNumCalls;
        mElapsedTime += l2 - l;
        for (int i = 0; i < n3; ++i) {
            if (!mProfileFlag[i]) continue;
            int n4 = i;
            mNumCallsArray[n4] = mNumCallsArray[n4] + 1;
            int n5 = i;
            mElapsedTimeArray[n5] = mElapsedTimeArray[n5] + (l2 - l);
        }
        return object2;
    }

    public void childTableRowRemove(String string, String string2, Object object, int n) throws CacheServerException {
        int n2 = mProfileFlag != null ? mProfileFlag.length : 0;
        long l = System.currentTimeMillis();
        try {
            this.mQS.removeChildTable(string, string2, object, n);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to remove objects from table " + string + "." + string2 + " where parent id = " + object);
        }
        long l2 = System.currentTimeMillis();
        ++mNumCalls;
        mElapsedTime += l2 - l;
        for (int i = 0; i < n2; ++i) {
            if (!mProfileFlag[i]) continue;
            int n3 = i;
            mNumCallsArray[n3] = mNumCallsArray[n3] + 1;
            int n4 = i;
            mElapsedTimeArray[n4] = mElapsedTimeArray[n4] + (l2 - l);
        }
    }

    public Object childTableRowInsert(String string, String string2, int n, Object object, Object object2, int n2) throws CacheServerException {
        Object object3;
        int n3 = mProfileFlag != null ? mProfileFlag.length : 0;
        long l = System.currentTimeMillis();
        try {
            object3 = this.mQS.childTableRowInsert(string, string2, n, object, object2, n2);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to create an object in table " + string + "." + string2);
        }
        long l2 = System.currentTimeMillis();
        ++mNumCalls;
        mElapsedTime += l2 - l;
        for (int i = 0; i < n3; ++i) {
            if (!mProfileFlag[i]) continue;
            int n4 = i;
            mNumCallsArray[n4] = mNumCallsArray[n4] + 1;
            int n5 = i;
            mElapsedTimeArray[n5] = mElapsedTimeArray[n5] + (l2 - l);
        }
        return object3;
    }

    public void store(String string, String string2, Object object, Object object2, int n, TableBasedClass tableBasedClass) throws CacheServerException {
        int n2 = mProfileFlag != null ? mProfileFlag.length : 0;
        long l = System.currentTimeMillis();
        try {
            this.mQS.store(string, string2, object, object2, n);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to update an object in table " + string + "." + string2);
        }
        long l2 = System.currentTimeMillis();
        ++mNumCalls;
        mElapsedTime += l2 - l;
        for (int i = 0; i < n2; ++i) {
            if (!mProfileFlag[i]) continue;
            int n3 = i;
            mNumCallsArray[n3] = mNumCallsArray[n3] + 1;
            int n4 = i;
            mElapsedTimeArray[n4] = mElapsedTimeArray[n4] + (l2 - l);
        }
    }

    public Object wrapBinaryStream(InputStream inputStream, QuickCacheObject quickCacheObject) throws CacheException {
        Object object;
        if (inputStream == null) {
            return null;
        }
        int n = mProfileFlag != null ? mProfileFlag.length : 0;
        long l = System.currentTimeMillis();
        try {
            QuickStatement quickStatement = this.getStreamHandler(quickCacheObject);
            object = quickStatement.setStream(quickStatement.wrapBinaryStream(inputStream));
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to wrap binary stream");
        }
        long l2 = System.currentTimeMillis();
        ++mNumCalls;
        mElapsedTime += l2 - l;
        for (int i = 0; i < n; ++i) {
            if (!mProfileFlag[i]) continue;
            int n2 = i;
            mNumCallsArray[n2] = mNumCallsArray[n2] + 1;
            int n3 = i;
            mElapsedTimeArray[n3] = mElapsedTimeArray[n3] + (l2 - l);
        }
        return object;
    }

    public Object wrapCharacterStream(Reader reader, QuickCacheObject quickCacheObject) throws CacheException {
        Object object;
        int n = mProfileFlag != null ? mProfileFlag.length : 0;
        long l = System.currentTimeMillis();
        try {
            QuickStatement quickStatement = this.getStreamHandler(quickCacheObject);
            object = quickStatement.setReader(quickStatement.wrapReader(reader));
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to wrap reader");
        }
        long l2 = System.currentTimeMillis();
        ++mNumCalls;
        mElapsedTime += l2 - l;
        for (int i = 0; i < n; ++i) {
            if (!mProfileFlag[i]) continue;
            int n2 = i;
            mNumCallsArray[n2] = mNumCallsArray[n2] + 1;
            int n3 = i;
            mElapsedTimeArray[n3] = mElapsedTimeArray[n3] + (l2 - l);
        }
        return object;
    }

    private QuickStatement getStreamHandler(QuickCacheObject quickCacheObject) throws SQLException {
        if (!this.useSeparateStreamQS()) {
            return this.mQS;
        }
        QuickStatement quickStatement = (QuickStatement)this.mStreamHandlers.get(quickCacheObject);
        if (quickStatement == null) {
            CacheConnection cacheConnection = (CacheConnection)this.mConnection;
            quickStatement = cacheConnection.createQuickStatement();
            this.mStreamHandlers.put(quickCacheObject, quickStatement);
        }
        return quickStatement;
    }

    public void clearStreamHandler(QuickCacheObject quickCacheObject) throws CacheException {
        QuickStatement quickStatement = (QuickStatement)this.mStreamHandlers.get(quickCacheObject);
        if (quickStatement == null) {
            return;
        }
        try {
            quickStatement.close();
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException);
        }
        this.mStreamHandlers.remove(quickCacheObject);
    }

    public InputStream getBinaryStream(Object object) throws SQLException {
        int n = mProfileFlag != null ? mProfileFlag.length : 0;
        long l = System.currentTimeMillis();
        CacheInputStream cacheInputStream = this.mQS.getBinaryStream(object);
        long l2 = System.currentTimeMillis();
        ++mNumCalls;
        mElapsedTime += l2 - l;
        for (int i = 0; i < n; ++i) {
            if (!mProfileFlag[i]) continue;
            int n2 = i;
            mNumCallsArray[n2] = mNumCallsArray[n2] + 1;
            int n3 = i;
            mElapsedTimeArray[n3] = mElapsedTimeArray[n3] + (l2 - l);
        }
        return cacheInputStream;
    }

    public Reader getReader(Object object) throws SQLException {
        int n = mProfileFlag != null ? mProfileFlag.length : 0;
        long l = System.currentTimeMillis();
        CacheReader cacheReader = this.mQS.getReader(object);
        long l2 = System.currentTimeMillis();
        ++mNumCalls;
        mElapsedTime += l2 - l;
        for (int i = 0; i < n; ++i) {
            if (!mProfileFlag[i]) continue;
            int n2 = i;
            mNumCallsArray[n2] = mNumCallsArray[n2] + 1;
            int n3 = i;
            mElapsedTimeArray[n3] = mElapsedTimeArray[n3] + (l2 - l);
        }
        return cacheReader;
    }

    public void remove(String string, String string2, Object object, int n) throws CacheServerException {
        int n2 = mProfileFlag != null ? mProfileFlag.length : 0;
        long l = System.currentTimeMillis();
        try {
            this.mQS.remove(string, string2, object, n);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to delete object from table " + string + '.' + string2 + " with id: " + object);
        }
        long l2 = System.currentTimeMillis();
        ++mNumCalls;
        mElapsedTime += l2 - l;
        for (int i = 0; i < n2; ++i) {
            if (!mProfileFlag[i]) continue;
            int n3 = i;
            mNumCallsArray[n3] = mNumCallsArray[n3] + 1;
            int n4 = i;
            mElapsedTimeArray[n4] = mElapsedTimeArray[n4] + (l2 - l);
        }
    }

    public Connection getConnection() {
        return this.mConnection;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof QuickDBAdapter)) {
            return false;
        }
        QuickDBAdapter quickDBAdapter = (QuickDBAdapter)object;
        return this.mQS.equals(quickDBAdapter.mQS);
    }

    private boolean useSeparateStreamQS() {
        if (this.mUseSeparateStreamQS == null) {
            this.mUseSeparateStreamQS = this.mServerInfo.getMajorObjectVersion() < 2007 ? new Boolean(false) : (this.mServerInfo.getMajorObjectVersion() > 2007 ? new Boolean(true) : (this.mServerInfo.getMinorObjectVersion() > 1 ? new Boolean(true) : (this.mServerInfo.getMinorObjectBuildNumber() > 306 ? new Boolean(true) : new Boolean(false))));
        }
        return this.mUseSeparateStreamQS;
    }
}

