/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.oldmetadata;

import com.intersys.cache.jdbcutil.JDBCAdapter;
import com.intersys.cache.jdbcutil.ParseUtils;
import com.intersys.cache.jdbcutil.SQLReservedWords;
import com.intersys.cache.oldmetadata.ArrayIterator;
import com.intersys.cache.oldmetadata.GeneralCacheDescription;
import com.intersys.cache.oldmetadata.JDBCCacheClass;
import com.intersys.cache.oldmetadata.QuickCacheField;
import com.intersys.cache.quick.ColumnBasedField;
import com.intersys.cache.quick.QuickDatabase;
import com.intersys.cache.quick.TableBasedClass;
import com.intersys.objects.CacheException;
import com.intersys.objects.SystemError;
import com.intersys.objects.reflect.AbstractTypeInfoImpl;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheField;
import com.intersys.objects.reflect.CacheForeignKeyInfo;
import com.intersys.objects.reflect.CacheIndexInfo;
import com.intersys.objects.reflect.CacheMethod;
import com.intersys.objects.reflect.SQLColumn;
import com.intersys.objects.reflect.TypeModifierHelper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

class QuickCacheClass
extends JDBCCacheClass
implements TableBasedClass {
    private QuickCacheField[] mFields;
    private QuickCacheField[] mFieldsByIndex;
    private Map mFieldMap;
    private QuickCacheField[] mAllFields = null;
    private JDBCAdapter.TableInfo mFieldIndices;
    QuickDatabase mDB;
    private int mNumberOfColumnsForSet;
    private int mNumberOfCachedElements;
    private int mNumberOfColumnsForGet;
    private String mColumnsSQL = null;
    private QuickCacheField mIdField = null;
    private QuickCacheField mParentField = null;
    private QuickCacheField mXClassField = null;
    private boolean mHasSerialStorage = false;

    QuickCacheClass(QuickDatabase quickDatabase, String string) throws CacheException {
        this(quickDatabase, string, QuickCacheClass.className2tableName(string), 0);
    }

    QuickCacheClass(QuickDatabase quickDatabase, String string, String string2, int n) throws CacheException {
        super(string, quickDatabase.getAdapter(), quickDatabase);
        int n2;
        String string3;
        Object object;
        String string4;
        boolean bl = n > 0;
        this.mDB = quickDatabase;
        this.mDB.registerClass(this);
        String string5 = this.mDB.getClassType(QuickCacheClass.tableName2className(string));
        if (string5 == null || bl || string5.equals("persistent")) {
            this.mFieldIndices = this.mDB.getTableColumnNumbers(string2, !bl);
            if (string5 != null && !bl) {
                this.mPersistent = Boolean.TRUE;
            }
        } else if (string5.equals("serial")) {
            this.mFieldIndices = this.mDB.getSerialState(QuickCacheClass.tableName2className(string));
            if (this.mFieldIndices != null) {
                this.mSerial = Boolean.TRUE;
                this.mHasSerialStorage = true;
            }
        }
        if (this.mFieldIndices == null) {
            QuickCacheClass quickCacheClass = this;
            this.mFieldIndices = quickCacheClass.mDB.getEmptyTableInfo();
        }
        this.mColumnsSQL = this.mFieldIndices.getSQL();
        this.mNumberOfColumnsForGet = this.mFieldIndices.getColumnCount();
        this.mFieldMap = new TreeMap();
        Vector vector = this.getAllFieldsAsVector();
        for (QuickCacheField object2 : vector) {
            string4 = object2.getName();
            this.mFieldMap.put(string4, object2);
        }
        for (Map.Entry entry : this.mFieldIndices.entrySet()) {
            int string7;
            string4 = (String)entry.getKey();
            if (bl && (string7 = string4.lastIndexOf(95)) >= 0) {
                string4 = string4.substring(string7 + 1);
            }
            JDBCAdapter.TableColumnInfo quickCacheField = (JDBCAdapter.TableColumnInfo)entry.getValue();
            object = (QuickCacheField)this.mFieldMap.get(string4);
            if (object == null) {
                object = new QuickCacheField(this.mDB, string4, null, null, null, 0, 0, 0);
                ((QuickCacheField)object).setInvisible(true);
                this.mFieldMap.put(string4, object);
            }
            int n3 = quickCacheField.columnForGet;
            if (bl) {
                --n3;
            }
            if (TypeModifierHelper.isList(n)) {
                --n3;
            }
            if (n3 == 1) {
                this.mParentField = object;
            }
            ((QuickCacheField)object).setColumnIndexForGet(n3);
            ((QuickCacheField)object).setColumnIndexForSet(quickCacheField.columnForSet);
            ((QuickCacheField)object).setCollectionType(quickCacheField.collectionType);
            if (quickCacheField.referenceClass != null && quickCacheField.elementType == null) {
                ((GeneralCacheDescription)object).setElementTypeObject();
            }
            ((QuickCacheField)object).setElementType(quickCacheField.elementType);
            if (this.mIdField == null && string4.equalsIgnoreCase("ID")) {
                this.mIdField = object;
            }
            if (this.mXClassField == null && string4.equalsIgnoreCase("x__classname")) {
                this.mXClassField = object;
            }
            if ((string3 = ((GeneralCacheDescription)object).getTypeName()) == null || ((AbstractTypeInfoImpl)object).getCollectionType() != 0 || string3.indexOf("Stream") < 0) continue;
            if (string3.indexOf("BinaryStream") >= 0) {
                ((QuickCacheField)object).setCollectionType(32);
                continue;
            }
            if (string3.indexOf("CharacterStream") >= 0) {
                ((QuickCacheField)object).setCollectionType(64);
                continue;
            }
            throw new SystemError("Unknown Stream Type: " + string3);
        }
        this.mNumberOfCachedElements = this.mNumberOfColumnsForSet = this.mFieldIndices.size();
        for (QuickCacheField quickCacheField : vector) {
            string4 = quickCacheField.getName();
            int n4 = quickCacheField.getColumnIndexForSet();
            if (n4 >= 0) continue;
            object = QuickCacheClass.className2tableName(this.mTypeName) + '_' + string4;
            JDBCAdapter.TableInfo tableInfo = this.mDB.getTableColumnNumbers((String)object, false);
            if (tableInfo.size() == 0) {
                string3 = quickCacheField.getTypeName();
                if (!"%Collection.RelationshipObject".equals(string3) && !"%Library.RelationshipObject".equals(string3)) continue;
                string3 = quickCacheField.getElementTypeName();
                if (string3 == null) {
                    throw new CacheException("Element type is not available for Relationship field " + this.getName() + "." + quickCacheField.getName());
                }
                object = QuickCacheClass.className2tableName(string3);
                tableInfo = this.mDB.getTableColumnNumbers((String)object, true);
                if (tableInfo.size() == 0) {
                    throw new CacheException("Child table info is not available for Relationship field " + (String)object);
                }
                if (tableInfo.isChild()) {
                    quickCacheField.setCollectionType(19);
                } else {
                    quickCacheField.setCollectionType(21);
                    String string6 = this.mDB.getInverseRelated(this.getName(), string4);
                    if (string6 == null || string6.length() == 0) {
                        throw new CacheException("Can not determine Inverse  for relationship " + string4 + " in class " + this.getName());
                    }
                    quickCacheField.setInverseFieldName(string6);
                }
            }
            quickCacheField.setChildTableName((String)object);
            quickCacheField.setColumnIndexForSet(this.mNumberOfCachedElements);
            if (quickCacheField.getCollectionType() == 0) {
                string3 = quickCacheField.getTypeName();
                if (string3 != null && string3.indexOf("Array") >= 0) {
                    quickCacheField.setCollectionType(1);
                } else if (string3 != null && string3.indexOf("List") >= 0) {
                    quickCacheField.setCollectionType(8);
                }
            }
            ++this.mNumberOfCachedElements;
            if (quickCacheField.isChildTable()) continue;
            ++this.mNumberOfColumnsForSet;
        }
        int n6 = 0;
        int n5 = vector.size();
        for (n2 = 0; n2 < n5; ++n2) {
            int n7 = ((CacheField)vector.get(n2)).getII();
            if (n7 <= n6) continue;
            n6 = n7;
        }
        this.mFieldsByIndex = new QuickCacheField[n6 + 1];
        for (n2 = 0; n2 < n5; ++n2) {
            QuickCacheField quickCacheField = (QuickCacheField)vector.get(n2);
            int n8 = quickCacheField.getII();
            if (n8 < 0) continue;
            this.mFieldsByIndex[n8] = quickCacheField;
        }
        vector = this.getFieldsAsVector();
        this.mFields = new QuickCacheField[vector.size()];
        for (n2 = 0; n2 < this.mFields.length; ++n2) {
            QuickCacheField quickCacheField;
            String string7 = ((CacheField)vector.get(n2)).getName();
            this.mFields[n2] = quickCacheField = (QuickCacheField)this.mFieldMap.get(string7);
        }
    }

    public int getNumberOfCachedElements() {
        return this.mNumberOfCachedElements;
    }

    public int getNumberOfColumnsForGet() {
        return this.mNumberOfColumnsForGet;
    }

    public int getNumberOfColumnsForSet() {
        return this.mNumberOfColumnsForSet;
    }

    public String getColumnsSQL() {
        return this.mColumnsSQL;
    }

    public void close() {
        this.mFields = null;
        this.mFieldMap = null;
        this.mDB.removeClassFromMap(this.getName());
    }

    public CacheField[] getFields() {
        return this.mFields;
    }

    public CacheField getField(String string) throws CacheException {
        CacheField cacheField = (CacheField)this.mFieldMap.get(string);
        return cacheField;
    }

    public ColumnBasedField getField(String string, int n, int n2) throws CacheException {
        if (n < 0 || n >= this.mFieldsByIndex.length) {
            return (QuickCacheField)this.getField(string);
        }
        QuickCacheField quickCacheField = this.mFieldsByIndex[n];
        if (quickCacheField == null) {
            return (QuickCacheField)this.getField(string);
        }
        return quickCacheField;
    }

    public ColumnBasedField getIdField() {
        return this.mIdField;
    }

    public CacheField getParentField() {
        if (this.isChild()) {
            return this.mParentField;
        }
        return null;
    }

    public boolean isChild() {
        return this.mIdField.getColumnIndexForGet() != 1;
    }

    public boolean hasSerialStorage() {
        return this.mHasSerialStorage;
    }

    public int getXClassNameColumn() throws CacheException {
        return this.mXClassField.getColumnIndexForGet();
    }

    public Iterator getFieldNames() throws CacheException {
        return new FieldNameIterator(this.mFields);
    }

    public void setupEmbeddedField(ColumnBasedField columnBasedField) throws CacheException {
        QuickCacheClass quickCacheClass = (QuickCacheClass)columnBasedField.getType();
        CacheField[] cacheFieldArray = quickCacheClass.getFields();
        for (int i = 0; i < cacheFieldArray.length; ++i) {
            CacheField cacheField = cacheFieldArray[i];
            String string = cacheField.getName();
            String string2 = columnBasedField.columnNameForEmbProp(string);
            QuickCacheField quickCacheField = (QuickCacheField)this.getField(string2);
            quickCacheField.setTypes(cacheField.getTypeName(), cacheField.getJavaTypeName(), cacheField.getElementTypeName());
            ((QuickCacheField)columnBasedField).addChild(quickCacheField, cacheField);
        }
    }

    private Iterator getAllFieldsIterator() {
        return this.mFieldMap.values().iterator();
    }

    public Iterator getAllSettableFieldsIterator() {
        if (this.mAllFields == null) {
            this.mAllFields = new QuickCacheField[this.mFieldMap.size()];
            for (QuickCacheField quickCacheField : this.mFieldMap.values()) {
                int n = quickCacheField.getColumnIndexForSet();
                if (n < 0) continue;
                this.mAllFields[n] = quickCacheField;
            }
        }
        return Arrays.asList(this.mAllFields).iterator();
    }

    public Iterator getMethodSignatures() throws CacheException {
        throw new CacheException("Methods are not supported in Quick implementation.");
    }

    public CacheMethod[] getMethods() throws CacheException {
        throw new CacheException("Methods are not supported in Quick implementation.");
    }

    public CacheMethod getMethod(String string) throws CacheException {
        throw new CacheException("Methods are not supported in Quick implementation.");
    }

    public int getModifiers() {
        return 0;
    }

    protected Vector getAllFieldsAsVector() throws CacheException {
        Vector vector = this.getFieldsAsVector();
        HashSet<String> hashSet = new HashSet<String>();
        CacheClass[] cacheClassArray = vector.iterator();
        while (cacheClassArray.hasNext()) {
            hashSet.add(((CacheField)cacheClassArray.next()).getName());
        }
        cacheClassArray = this.getCacheSuperclasses();
        for (int i = 0; i < cacheClassArray.length; ++i) {
            Vector vector2 = ((QuickCacheClass)cacheClassArray[i]).getAllFieldsAsVector();
            for (CacheField cacheField : vector2) {
                if (hashSet.contains(cacheField.getName())) continue;
                vector.add(cacheField);
                hashSet.add(cacheField.getName());
            }
        }
        return vector;
    }

    public static String className2tableName(String string) {
        return ParseUtils.className2tableName(string);
    }

    public static String tableName2className(String string) {
        return ParseUtils.tableName2className(string);
    }

    public String getPackageName() {
        String string = this.getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            return string.substring(0, n);
        }
        return "";
    }

    public String getFullSQLTableName() {
        return QuickCacheClass.className2tableName(this.getName());
    }

    public String getSQLTableName() {
        return null;
    }

    public String getFullSQLTableNameQuoted() {
        String string;
        String string2 = this.getFullSQLTableName();
        int n = string2.indexOf(46);
        if (n < 0) {
            String string3 = string2;
            if (SQLReservedWords.isReserved(string3)) {
                string3 = "\"" + string3 + "\"";
            }
            return string3;
        }
        String string4 = string2.substring(0, n);
        if (SQLReservedWords.isReserved(string4)) {
            string4 = "\"" + string4 + "\"";
        }
        if (SQLReservedWords.isReserved(string = string2.substring(n + 1))) {
            string = "\"" + string + "\"";
        }
        return string4 + "." + string;
    }

    public String getIdPlaceholder() {
        throw new UnsupportedOperationException("Method getIdPlaceholder() is not implemented in class com.intersys.cache.oldmetadata.QuickCacheClass");
    }

    public CacheField isGetterForCalculatedProperty(String string) throws CacheException {
        Iterator iterator = this.getAllFieldsIterator();
        while (iterator.hasNext()) {
            ColumnBasedField columnBasedField = (ColumnBasedField)iterator.next();
            if (!columnBasedField.isReadOnly() || !string.startsWith(columnBasedField.getName())) continue;
            if (columnBasedField.getColumnIndexForSet() < 0) {
                throw new CacheException("Calculated property " + columnBasedField.getName() + " must be also SQLComputed to be " + "accessible from Light Java Binding");
            }
            return columnBasedField;
        }
        return null;
    }

    public int getNumberOfSerialElements() {
        return this.getNumberOfCachedElements();
    }

    public int getKeyColumn() throws CacheException {
        return -1;
    }

    public ColumnBasedField getColumnBasedField(String string) throws CacheException {
        return (ColumnBasedField)this.getField(string);
    }

    public boolean isDatatype() {
        throw new UnsupportedOperationException("Method isDatatype() is not implemented in class com.intersys.cache.oldmetadata.QuickCacheClass");
    }

    public boolean isAbstract() {
        throw new UnsupportedOperationException("Method isAbstract() is not implemented in class com.intersys.cache.oldmetadata.QuickCacheClass");
    }

    public CacheField[] getDeclaredFields() throws CacheException {
        throw new UnsupportedOperationException("Method getDeclaredFields() is not implemented in class com.intersys.cache.oldmetadata.QuickCacheClass");
    }

    public SQLColumn[] getSQLColumns() throws CacheException {
        throw new UnsupportedOperationException("Method getSQLColumns() is not implemented in class com.intersys.cache.oldmetadata.QuickCacheClass");
    }

    public String getJavaImplements() {
        throw new UnsupportedOperationException("Method getJavaImpelements() is not implemented in class com.intersys.cache.oldmetadata.QuickCacheClass");
    }

    public String getJavaInterfaceName() throws CacheException {
        throw new UnsupportedOperationException("Method getJavaInterfaceName() is not implemented in class com.intersys.cache.oldmetadata.QuickCacheClass");
    }

    public String getJavaPojoName() throws CacheException {
        throw new UnsupportedOperationException("Method getJavaPojoName() is not implemented in class com.intersys.cache.oldmetadata.QuickCacheClass");
    }

    public CacheIndexInfo[] getIndexInfo() throws CacheException {
        throw new UnsupportedOperationException("Method getIndexInfo() is not implemented in class com.intersys.cache.oldmetadata.QuickCacheClass");
    }

    public CacheForeignKeyInfo[] getForeignKeyInfo() throws CacheException {
        throw new UnsupportedOperationException("Method getForeignKeyInfo() is not implemented in class com.intersys.cache.oldmetadata.QuickCacheClass");
    }

    private static class FieldNameIterator
    extends ArrayIterator {
        FieldNameIterator(CacheField[] cacheFieldArray) {
            super(cacheFieldArray);
        }

        public Object next() {
            CacheField cacheField = (CacheField)super.next();
            return cacheField.getName();
        }
    }
}

