/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.oldmetadata;

import com.intersys.cache.Dataholder;
import com.intersys.cache.jbind.JBindDatabase;
import com.intersys.cache.oldmetadata.JBindCacheMethod;
import com.intersys.jdbc.ConnectionInfo;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheServerException;
import com.intersys.objects.InvalidClassException;
import com.intersys.objects.reflect.CacheClass;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;

class MethodIterator
implements Iterator {
    private final JBindDatabase mDB;
    private final CacheClass mClass;
    private final Object mSysList;
    private boolean hasServerOnlyField;

    MethodIterator(JBindDatabase jBindDatabase, CacheClass cacheClass, byte[] byArray) throws InvalidClassException, CacheServerException {
        this.hasServerOnlyField = jBindDatabase.getReflectionVersion() >= 3;
        this.mDB = jBindDatabase;
        this.mClass = cacheClass;
        try {
            this.mSysList = SysListProxy.createSysList(byArray, false, new ConnectionInfo());
            Object object = SysListProxy.getWrappedItem(this.mSysList);
            Dataholder dataholder = new Dataholder(4096, object);
            try {
                jBindDatabase.parseStatus(dataholder);
            }
            catch (CacheException cacheException) {
                String string = cacheException.getMessage();
                int n = cacheException.getCode();
                String string2 = cacheClass.getName();
                throw new InvalidClassException(this.mDB, string2, "Failed to get methods of the class " + string2 + ". Error message " + string, n, cacheException);
            }
        }
        catch (SQLException sQLException) {
            String string = sQLException.getMessage();
            int n = sQLException.getErrorCode();
            String string3 = cacheClass.getName();
            throw new InvalidClassException(this.mDB, string3, "Failed to get methods of the class " + string3 + ". Error message " + string, n, sQLException);
        }
    }

    public boolean hasNext() {
        return !SysListProxy.atEnd(this.mSysList);
    }

    public Object next() {
        try {
            boolean bl = SysListProxy.getBoolean(this.mSysList);
            String string = SysListProxy.getString(this.mSysList);
            String string2 = SysListProxy.getString(this.mSysList);
            boolean bl2 = SysListProxy.getBoolean(this.mSysList);
            boolean bl3 = this.hasServerOnlyField ? SysListProxy.getBoolean(this.mSysList) : false;
            String string3 = SysListProxy.getString(this.mSysList);
            int n = SysListProxy.getInteger(this.mSysList);
            JBindCacheMethod jBindCacheMethod = new JBindCacheMethod(this.mDB, this.mClass, string, string2, string3, n, this.mSysList);
            if (bl) {
                jBindCacheMethod.setModifier(1);
            }
            if (bl2) {
                jBindCacheMethod.setModifier(16);
            }
            if (bl3) {
                jBindCacheMethod.setModifier(32);
            }
            return jBindCacheMethod;
        }
        catch (SQLException sQLException) {
            throw new NoSuchElementException(sQLException.getMessage());
        }
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

