/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.metadata;

import com.intersys.cache.SysDatabase;
import com.intersys.cache.serial.SerialObjectFactory;
import com.intersys.classes.CPPStoredProc;
import com.intersys.objects.CacheException;
import com.intersys.objects.SysListHolder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Dictionary {
    private static Map STATIC_DICTIONARIES = new HashMap();
    private String[] mDictionary;
    private String[] mStaticDictionary;

    protected Dictionary(List list, SysDatabase sysDatabase) throws CacheException {
        this.mStaticDictionary = Dictionary.getStaticDictionary(sysDatabase);
        this.mDictionary = new String[list.size()];
        this.mDictionary = list.toArray(this.mDictionary);
    }

    private static String[] getStaticDictionary(SysDatabase sysDatabase) throws CacheException {
        String string = sysDatabase.getConnectionString();
        String[] stringArray = (String[])STATIC_DICTIONARIES.get(string);
        if (stringArray == null) {
            List list;
            if (sysDatabase instanceof SerialObjectFactory) {
                list = ((SerialObjectFactory)sysDatabase).getStaticDictionary();
            } else {
                SysListHolder sysListHolder = new SysListHolder(null);
                CPPStoredProc.getStaticDictionary(sysDatabase, sysListHolder);
                list = sysListHolder.value;
            }
            stringArray = new String[list.size()];
            stringArray = list.toArray(stringArray);
            STATIC_DICTIONARIES.put(string, stringArray);
        }
        return stringArray;
    }

    private String staticLookup(int n) {
        return this.mStaticDictionary[n];
    }

    public String lookup(Integer n) {
        if (n == null) {
            return null;
        }
        int n2 = n - 1;
        if (n2 < this.mStaticDictionary.length) {
            return this.staticLookup(n2);
        }
        return this.mDictionary[n2 - this.mStaticDictionary.length];
    }
}

