/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.metadata;

import com.intersys.cache.metadata.CacheArgumentMetadataImpl;
import com.intersys.cache.metadata.CacheClassMetadataImpl;
import com.intersys.cache.metadata.CacheElementMetadataImpl;
import com.intersys.cache.metadata.Dictionary;
import com.intersys.cache.metadata.MethodHelper;
import com.intersys.classes.Compiler.LG.JavaClassDefPointer;
import com.intersys.classes.Compiler.LG.JavaMethodDef;
import com.intersys.classes.Compiler.LG.JavaMtdArgDef;
import com.intersys.objects.CacheException;
import com.intersys.objects.Logger;
import com.intersys.objects.reflect.CacheArgument;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheClassMetadata;
import com.intersys.objects.reflect.CacheElementInfo;
import com.intersys.objects.reflect.CacheMethod;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

abstract class CacheMethodMetadataImpl
implements Comparable,
CacheMethod {
    private JavaMethodDef mJavaMethodDef;
    private CacheClassMetadataImpl mDeclaringClass;
    private CacheClassMetadataImpl mImplementationClass;
    private int mModifier;
    private String mName;
    private String mJavaName;
    private String mStoredProcName;
    private int mFirstDefaultArgument;
    private CacheElementMetadataImpl mReturnElement;
    private final int IS_STORED_PROCEDURE = 1;
    private final int HAS_SIGNATURE_CONFLICT = 2;
    private final int IS_CLASS_METHOD = 4;
    private final int IS_JAVA_METHOD = 8;
    private final int IS_SPECIAL_METHOD = 16;
    private int mMethodModifier;
    private String mReturnAccessorMethod;
    private CacheArgumentMetadataImpl[] mArguments;
    private boolean mIsDefinedInClass;

    public CacheMethodMetadataImpl(CacheClassMetadata cacheClassMetadata, CacheClassMetadata cacheClassMetadata2, JavaMethodDef javaMethodDef) throws CacheException {
        this.mImplementationClass = (CacheClassMetadataImpl)cacheClassMetadata;
        this.mDeclaringClass = (CacheClassMetadataImpl)cacheClassMetadata2;
        this.mJavaMethodDef = javaMethodDef;
        this.constructModifiers();
        this.mName = this.mJavaMethodDef.getmethodName();
        this.mJavaName = this.mJavaMethodDef.getjmethodName();
        this.mStoredProcName = this.mJavaMethodDef.getsqlName();
        this.mFirstDefaultArgument = this.mJavaMethodDef.getfirstDefaultArg();
        this.mMethodModifier = 0;
        this.mIsDefinedInClass = this.mJavaMethodDef.getisDefinedInClass();
        if (this.mJavaMethodDef.getisSQLProc()) {
            this.mMethodModifier |= 1;
        }
        if (this.mJavaMethodDef.getconflictingSignature()) {
            this.mMethodModifier |= 2;
        }
        if (this.mJavaMethodDef.getisClassMtd()) {
            this.mMethodModifier |= 4;
        }
        if (this.mJavaMethodDef.getisJavaMethod()) {
            this.mMethodModifier |= 4;
        }
        if (this.mJavaMethodDef.getisSpecialMethod()) {
            this.mMethodModifier |= 0x10;
        }
        Dictionary dictionary = this.getDictionary();
        this.mReturnAccessorMethod = dictionary.lookup(this.mJavaMethodDef.getjres().getAccessorName());
        this.mReturnElement = new CacheElementMetadataImpl((CacheClassMetadataImpl)cacheClassMetadata2, this.mJavaMethodDef.getjres(), this.mJavaMethodDef.get_res());
    }

    private final Dictionary getDictionary() {
        return ((CacheClassMetadataImpl)this.getDeclaringClass()).getDictionary();
    }

    private void constructModifiers() throws CacheException {
        boolean bl = this.mJavaMethodDef.getisClassMtd();
        boolean bl2 = false;
        Integer n = this.mJavaMethodDef.get_res().getclientTypeId();
        if (n != null) {
            this.addModifier(8);
        }
        if (CacheElementMetadataImpl.isLiteral(n)) {
            this.addModifier(16);
        }
        if (bl) {
            this.addModifier(1);
        }
        if (bl2) {
            this.addModifier(32);
        }
    }

    public final String getName() {
        return this.mName;
    }

    public final String getJavaName() {
        return this.mJavaName;
    }

    public final int getModifiers() {
        return this.mModifier;
    }

    public final CacheClass getImplementationClass() {
        return this.mImplementationClass;
    }

    public final CacheClass getDeclaringClass() {
        return this.mDeclaringClass;
    }

    public final CacheClass getReturnType() throws CacheException {
        JavaClassDefPointer javaClassDefPointer = this.mJavaMethodDef.getjres().getcacheType();
        return this.mDeclaringClass.getAClass(javaClassDefPointer);
    }

    public final String getSignature() throws CacheException {
        return MethodHelper.constructSignature(this.mName, this.getArgumentIterator(), false);
    }

    private String getSignature(boolean bl) throws CacheException {
        return MethodHelper.constructSignature(this.mName, this.getArgumentIterator(), bl);
    }

    public String getDeclaration() throws CacheException {
        String string = this.getReturnType().getName() + " " + this.getSignature(true);
        return string;
    }

    public Class getJavaReturnType() throws CacheException {
        return ((CacheClassMetadataImpl)this.getReturnType()).getJavaClass();
    }

    public CacheElementInfo getJavaReturnElement() throws CacheException {
        return this.mReturnElement;
    }

    public String getJavaReturnTypeName() throws CacheException {
        CacheClass cacheClass = this.getReturnType();
        return cacheClass.getJavaClassName();
    }

    public CacheArgument[] getArgumentTypes() throws CacheException {
        this.checkArguments();
        CacheArgument[] cacheArgumentArray = new CacheArgument[this.mArguments.length];
        System.arraycopy(this.mArguments, 0, cacheArgumentArray, 0, this.mArguments.length);
        return cacheArgumentArray;
    }

    public Iterator getArgumentIterator() throws CacheException {
        this.checkArguments();
        return Arrays.asList(this.mArguments).iterator();
    }

    private void addModifier(int n) {
        this.mModifier |= n;
    }

    private void checkArguments() throws CacheException {
        if (this.mArguments != null) {
            return;
        }
        List list = this.mJavaMethodDef.getjargs();
        this.mArguments = new CacheArgumentMetadataImpl[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            JavaMtdArgDef javaMtdArgDef = (JavaMtdArgDef)iterator.next();
            this.mArguments[n] = (CacheArgumentMetadataImpl)this.mDeclaringClass.createArgument(javaMtdArgDef);
            ++n;
        }
        n = 0;
        for (int i = 0; i < this.mArguments.length; ++i) {
            if (!this.mArguments[i].isByReference()) continue;
            this.mArguments[i].setRefOrdinal(n);
            ++n;
        }
    }

    public int compareTo(Object object) {
        try {
            if (object instanceof String) {
                return this.getSignature(false).compareTo((String)object);
            }
            CacheMethodMetadataImpl cacheMethodMetadataImpl = (CacheMethodMetadataImpl)object;
            return this.getSignature().compareTo(cacheMethodMetadataImpl.getSignature());
        }
        catch (CacheException cacheException) {
            if (Logger.debugOn()) {
                cacheException.printFullTrace(Logger.out);
            }
            throw new ClassCastException("Method definition is invalid:" + cacheException.getMessage());
        }
    }

    public boolean isStoredProcedure() {
        return (this.mMethodModifier & 1) != 0;
    }

    public String getStoredProcName() {
        return this.mStoredProcName;
    }

    public int getFirstDefaultArgument() {
        return this.mFirstDefaultArgument;
    }

    public boolean hasSignatureConflict() {
        return (this.mMethodModifier & 2) != 0;
    }

    public boolean isClassMethod() {
        return (this.mMethodModifier & 4) != 0;
    }

    public boolean isJavaMethod() {
        return (this.mMethodModifier & 8) != 0;
    }

    public String getReturnAccessorMethod() {
        return this.mReturnAccessorMethod;
    }

    public int getRefOrdinal(int n) {
        return this.mArguments[n].getRefOrdinal();
    }

    public boolean isDefinedInClass() {
        return this.mIsDefinedInClass;
    }

    public boolean isSpecialMethod() {
        return (this.mMethodModifier & 0x10) != 0;
    }

    public String toString() {
        try {
            return this.getImplementationClass() + ": " + this.getDeclaration();
        }
        catch (CacheException cacheException) {
            return this.mName + " <exception occured: " + cacheException.toString() + ">";
        }
    }

    public boolean equals(Object object) {
        try {
            String string = this.getSignature();
            if (object instanceof String) {
                String string2 = (String)object;
                if (string.equals(string2)) {
                    return true;
                }
                string = this.getSignature(false);
                return string.equals(string2);
            }
            if (object instanceof CacheMethod) {
                String string3 = ((CacheMethod)object).getSignature();
                return string.equals(string3);
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

