/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ClassAnalizer {
    private static MemeberComparator mc = null;

    public static Set getGetSetPairs(Class clazz, int n, boolean bl) {
        if (mc == null) {
            mc = new MemeberComparator();
        }
        HashSet<Method> hashSet = new HashSet<Method>();
        Method[] methodArray = clazz.getDeclaredMethods();
        Arrays.sort(methodArray, mc);
        int n2 = Arrays.binarySearch(methodArray, "get", mc);
        n2 = n2 < 0 ? -n2 - 1 : ++n2;
        while (n2 < methodArray.length) {
            Method method = methodArray[n2];
            int n3 = method.getModifiers();
            if (ClassAnalizer.checkAccess(n, n3) && !Modifier.isStatic(n3)) {
                String string = method.getName();
                if (!string.startsWith("get")) break;
                if (method.getParameterTypes().length == 0) {
                    Class<?> clazz2;
                    Method method2;
                    Class<?>[] classArray;
                    String string2;
                    int n4;
                    boolean bl2;
                    boolean bl3 = bl2 = !bl && !Collection.class.isAssignableFrom(method.getReturnType()) && !Map.class.isAssignableFrom(method.getReturnType());
                    if (!bl2 || (n4 = Arrays.binarySearch(methodArray, string2 = "set" + string.substring(3), mc)) >= 0 && (classArray = (method2 = methodArray[n4]).getParameterTypes()).length == 1 && (clazz2 = method.getReturnType()).equals(classArray[0])) {
                        hashSet.add(method);
                    }
                }
            }
            ++n2;
        }
        return hashSet;
    }

    public static Set getPersistableFields(Class clazz, Set hashSet, int n, boolean bl) {
        AccessibleObject[] accessibleObjectArray;
        if (hashSet == null) {
            hashSet = new HashSet<AccessibleObject>();
        }
        if (n == 1 && bl) {
            accessibleObjectArray = clazz.getFields();
        } else {
            accessibleObjectArray = clazz.getDeclaredFields();
            Field.setAccessible(accessibleObjectArray, true);
        }
        for (int i = 0; i < accessibleObjectArray.length; ++i) {
            AccessibleObject accessibleObject = accessibleObjectArray[i];
            int n2 = ((Field)accessibleObject).getModifiers();
            if (!ClassAnalizer.checkAccess(n, n2) || Modifier.isStatic(n2) || Modifier.isTransient(n2)) continue;
            hashSet.add(accessibleObject);
        }
        if (n == 1 || !bl) {
            return hashSet;
        }
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            ClassAnalizer.getPersistableFields(clazz2, hashSet, n, bl);
        }
        return hashSet;
    }

    public static Set getMethodDependentTypes(Class clazz, int n) {
        HashSet<Class> hashSet = new HashSet<Class>();
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (!ClassAnalizer.checkAccess(n, method.getModifiers())) continue;
            Class clazz2 = method.getReturnType();
            if ((clazz2 = ClassAnalizer.getElementClass(clazz2)) != Void.TYPE) {
                hashSet.add(clazz2);
            }
            Class<?>[] classArray = method.getParameterTypes();
            for (int j = 0; j < classArray.length; ++j) {
                Class clazz3 = ClassAnalizer.getElementClass(classArray[j]);
                hashSet.add(clazz3);
            }
        }
        return hashSet;
    }

    private static boolean checkAccess(int n, int n2) {
        if (Modifier.isPublic(n2)) {
            return true;
        }
        switch (n) {
            case 2: {
                return true;
            }
            case 4: {
                return Modifier.isProtected(n2);
            }
            case 1: {
                return false;
            }
        }
        return false;
    }

    private static Class getElementClass(Class clazz) {
        if (!clazz.isArray()) {
            return clazz;
        }
        clazz = clazz.getComponentType();
        return ClassAnalizer.getElementClass(clazz);
    }

    public static Map getAllClasses(Class classArray) {
        Object object;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = 0;
        for (object = classArray; object != null; object = object.getSuperclass()) {
            String string = object.getName();
            hashMap.put(String.valueOf(n++), string);
        }
        object = classArray.getInterfaces();
        for (int i = 0; i < ((Class<?>[])object).length; ++i) {
            String string = object[i].getName();
            hashMap.put(String.valueOf(n++), string);
        }
        return hashMap;
    }

    private static class MemeberComparator
    implements Comparator {
        private MemeberComparator() {
        }

        public int compare(Object object, Object object2) {
            String string = this.toString(object);
            String string2 = this.toString(object2);
            return string.compareTo(string2);
        }

        public boolean equals(Object object) {
            return this.getClass().isInstance(object);
        }

        private String toString(Object object) {
            if (object instanceof String) {
                return (String)object;
            }
            if (object instanceof Member) {
                return ((Member)object).getName();
            }
            throw new ClassCastException();
        }
    }
}

