/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.tds;

import com.sybase.jdbc3.tds.Tds;
import com.sybase.jdbc3.tds.TdsDataOutputStream;
import com.sybase.jdbc3.tds.TdsInputStream;
import com.sybase.jdbc3.tds.TdsOutputStream;
import com.sybase.jdbc3.tds.Token;
import java.io.IOException;
import java.sql.SQLException;

public class DynamicToken
extends Token {
    public static final int PREPARE = 1;
    public static final int EXEC = 2;
    public static final int DEALLOC = 4;
    public static final int EXEC_IMMED = 8;
    public static final int PROCNAME = 16;
    public static final int ACK = 32;
    public static final int DESCIN = 64;
    public static final int DESCOUT = 128;
    private static final int c = 0;
    private static final int d = 1;
    public static final int MAX_DYNAMIC_LENGTH = Short.MAX_VALUE;
    protected long _totalLen;
    protected long _totalOutLen;
    protected int _type;
    protected int _status;
    protected String _name;
    protected int _nameLen;
    protected String _body;
    protected long _bodyLen;

    public DynamicToken(int n, String string, String string2, boolean bl) throws SQLException {
        this._type = n;
        this._name = string;
        this._body = string2;
        this._status = bl ? 1 : 0;
    }

    public DynamicToken(TdsInputStream tdsInputStream) throws IOException {
        try {
            this._totalLen = this.readLength(tdsInputStream);
            this._type = tdsInputStream.readUnsignedByte();
            this._status = tdsInputStream.readUnsignedByte();
            this._nameLen = tdsInputStream.readUnsignedByte();
            this._name = tdsInputStream.readString(this._nameLen);
            long l = this._totalLen - (long)(3 + this._nameLen);
            if (l < 2L) {
                this._body = null;
                this._bodyLen = 0L;
            } else {
                this.readBodyLength(tdsInputStream);
            }
        }
        catch (IOException iOException) {
            DynamicToken.readSQE(iOException);
        }
    }

    protected DynamicToken() {
    }

    protected long readLength(TdsInputStream tdsInputStream) throws IOException {
        long l = tdsInputStream.readShort();
        return l;
    }

    protected void readBodyLength(TdsInputStream tdsInputStream) throws IOException {
        this._bodyLen = tdsInputStream.readShort();
        this._body = tdsInputStream.readString((int)this._bodyLen);
    }

    public void send(TdsDataOutputStream tdsDataOutputStream) throws IOException {
        try {
            Tds tds = tdsDataOutputStream._tds;
            this.sendTokenName(tdsDataOutputStream);
            byte[] byArray = tdsDataOutputStream.stringToByte(this._name);
            byte[] byArray2 = tdsDataOutputStream.stringToByte(this._body);
            this._totalOutLen = 3 + byArray.length;
            if (this._type != 32) {
                this._totalOutLen += (long)this.getStatementLengthFieldSize();
                if (byArray2 != null) {
                    this._totalOutLen += (long)byArray2.length;
                }
            }
            this.sendTotalLength(tdsDataOutputStream);
            tdsDataOutputStream.writeByte(this._type);
            tdsDataOutputStream.writeByte(this._status);
            tdsDataOutputStream.writeByte(byArray.length);
            tdsDataOutputStream.write(byArray);
            if (this._type != 32) {
                if (byArray2 == null) {
                    this.sendBodyLength(0L, tdsDataOutputStream);
                } else {
                    this.sendBodyLength(byArray2.length, tdsDataOutputStream);
                    tdsDataOutputStream.write(byArray2);
                }
            }
        }
        catch (IOException iOException) {
            DynamicToken.writeSQE(iOException);
        }
    }

    protected void sendTokenName(TdsOutputStream tdsOutputStream) throws IOException {
        tdsOutputStream.writeByte(231);
    }

    protected void sendTotalLength(TdsOutputStream tdsOutputStream) throws IOException {
        tdsOutputStream.writeShort((int)this._totalOutLen);
    }

    protected void sendBodyLength(long l, TdsOutputStream tdsOutputStream) throws IOException {
        tdsOutputStream.writeShort((int)l);
    }

    protected int getStatementLengthFieldSize() {
        return 2;
    }

    public String toString() {
        String string;
        switch (this._type) {
            case 1: {
                string = "PREPARE";
                break;
            }
            case 2: {
                string = "EXEC";
                break;
            }
            case 4: {
                string = "DEALLOC";
                break;
            }
            case 32: {
                string = "ACK";
                break;
            }
            default: {
                string = "Unknown!";
            }
        }
        return "DYNAMIC: type(" + this._type + ")=" + string + " name: >" + this._name + "< body: >" + this._body + ((this._status & 1) != 0 ? "< (Params)" : "< (No params)");
    }
}

