/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile;

import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sqlj.runtime.profile.Loader;

public class DefaultLoader
implements Loader {
    private ClassLoader m_loader;

    public DefaultLoader(ClassLoader classLoader) {
        this.m_loader = classLoader;
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        if (this.m_loader == null) {
            return Class.forName(string);
        }
        return this.m_loader.loadClass(string);
    }

    public InputStream getResourceAsStream(String string) {
        return (InputStream)AccessController.doPrivileged(new SqljPrivilegedAction(this.m_loader, string));
    }

    class SqljPrivilegedAction
    implements PrivilegedAction {
        private ClassLoader m_load;
        private String m_name;

        SqljPrivilegedAction(ClassLoader classLoader, String string) {
            this.m_load = classLoader;
            this.m_name = string;
        }

        public Object run() {
            try {
                if (this.m_load == null) {
                    return ClassLoader.getSystemResourceAsStream(this.m_name);
                }
                return DefaultLoader.this.m_loader.getResourceAsStream(this.m_name);
            }
            catch (SecurityException securityException) {
                return null;
            }
        }
    }
}

