/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.tds;

import com.sybase.jdbc3.tds.DataFormat;
import com.sybase.jdbc3.tds.SrvCapabilityToken;
import com.sybase.jdbc3.tds.SrvFormatToken;
import com.sybase.jdbc3.tds.SrvRowDataFormat2;
import com.sybase.jdbc3.tds.SrvSQLTypeFormatter;
import com.sybase.jdbc3.tds.SrvTypeException;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class SrvSQLTypeFormatter2
extends SrvSQLTypeFormatter {
    public SrvSQLTypeFormatter2(SrvFormatToken srvFormatToken, SrvCapabilityToken srvCapabilityToken) {
        super(srvFormatToken, srvCapabilityToken);
    }

    public DataFormat[] buildDataFormat(ResultSet resultSet) throws IOException {
        SrvRowDataFormat2[] srvRowDataFormat2Array = null;
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            if (n == 0) {
                throw new SrvTypeException("Cannot format result set with  0 columns");
            }
            srvRowDataFormat2Array = new SrvRowDataFormat2[n];
            for (int i = 1; i <= n; ++i) {
                int n2;
                Object v = _formatmap.get(new Integer(resultSetMetaData.getColumnType(i)));
                if (v == null) {
                    throw new SrvTypeException("Cannot map JDBC type " + resultSetMetaData.getColumnTypeName(i) + " to TDS type");
                }
                int[] nArray = (int[])v;
                if (this._cap.handlesDataType(nArray[1])) {
                    n2 = 0;
                    if (resultSetMetaData.isNullable(i) == 1) {
                        n2 |= 0x20;
                    }
                    if (resultSetMetaData.isWritable(i)) {
                        n2 |= 0x10;
                    }
                } else {
                    throw new SrvTypeException("Not handling client literal  conversion for JDBC types " + resultSetMetaData.getColumnTypeName(i));
                }
                String string = resultSetMetaData.getColumnLabel(i);
                String string2 = resultSetMetaData.getCatalogName(i);
                String string3 = resultSetMetaData.getSchemaName(i);
                String string4 = resultSetMetaData.getTableName(i);
                srvRowDataFormat2Array[i - 1] = new SrvRowDataFormat2(string, string2, string3, string4, resultSetMetaData.getColumnName(i), nArray[1], n2, nArray[2], resultSetMetaData.getPrecision(i), resultSetMetaData.getScale(i), null);
            }
        }
        catch (SQLException sQLException) {
            throw new SrvTypeException("SQL to TDS conversion error: " + sQLException);
        }
        return srvRowDataFormat2Array;
    }
}

