/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.tds;

import com.sybase.jdbc3.tds.DataFormat;
import com.sybase.jdbc3.tds.Dumpable;
import com.sybase.jdbc3.tds.ParamFormat2Token;
import com.sybase.jdbc3.tds.SrvDataFormat;
import com.sybase.jdbc3.tds.SrvFormatToken;
import com.sybase.jdbc3.tds.SrvParamDataFormat2;
import com.sybase.jdbc3.tds.TdsInputStream;
import com.sybase.jdbc3.tds.TdsOutputStream;
import com.sybase.jdbc3.utils.DumpFilter;
import com.sybase.jdbc3.utils.DumpInfo;
import com.sybase.jdbc3.utils.HexConverts;
import java.io.IOException;
import java.util.Vector;

public class SrvParamFormat2Token
extends ParamFormat2Token
implements SrvFormatToken,
Dumpable {
    protected Vector _dataformats = new Vector();
    private long _len;

    public SrvParamFormat2Token(TdsInputStream tdsInputStream) throws IOException {
        this._len = this.readLength(tdsInputStream);
        this._numParams = tdsInputStream.readShort();
        this.addDataFormats(tdsInputStream, this._numParams);
    }

    public SrvParamFormat2Token() {
    }

    public void addDataFormats(TdsInputStream tdsInputStream, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this._dataformats.addElement(this.dataFormatFactory(tdsInputStream));
        }
    }

    protected DataFormat dataFormatFactory(TdsInputStream tdsInputStream) throws IOException {
        return new SrvParamDataFormat2(tdsInputStream);
    }

    public long getLength() {
        long l = 2L;
        for (int i = 0; i < this._dataformats.size(); ++i) {
            SrvDataFormat srvDataFormat = (SrvDataFormat)this._dataformats.elementAt(i);
            l += (long)srvDataFormat.length();
        }
        return l;
    }

    public void addFormat(DataFormat dataFormat) {
        this._dataformats.addElement(dataFormat);
    }

    public int getFormatCount() {
        return this._dataformats.size();
    }

    public DataFormat formatAt(int n) {
        return (SrvParamDataFormat2)this._dataformats.elementAt(n);
    }

    public void sendFormat(TdsOutputStream tdsOutputStream) throws IOException {
        for (int i = 0; i < this._dataformats.size(); ++i) {
            SrvParamDataFormat2 srvParamDataFormat2 = (SrvParamDataFormat2)this._dataformats.elementAt(i);
            srvParamDataFormat2.send(tdsOutputStream);
        }
    }

    public int getByteLength(int n) {
        SrvParamDataFormat2 srvParamDataFormat2 = (SrvParamDataFormat2)this.formatAt(n);
        return SrvParamDataFormat2.lengthSize((int)srvParamDataFormat2._datatype);
    }

    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        DumpInfo dumpInfo = null;
        if (dumpFilter.includesToken(32)) {
            dumpInfo = dumpFilter.getDumpInfo();
            if (dumpFilter.includesDetail(0)) {
                dumpInfo.addInfo("Token", 1, "PARAMFMT2 Token (0x" + HexConverts.hexConvert((int)32, (int)1) + "); variable length.");
            } else {
                dumpInfo.addInfo("Token", 1, "PARAMFMT2 Token");
            }
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Length", 4, this._len);
            }
            dumpInfo.addInt("Number of Params", 2, this._numParams);
            for (int i = 0; i < this.getFormatCount(); ++i) {
                dumpInfo.addInfo("TDSFmt", 0, "Param " + (i + 1));
                SrvParamDataFormat2 srvParamDataFormat2 = (SrvParamDataFormat2)this.formatAt(i);
                dumpInfo.addInfo(srvParamDataFormat2.dump(dumpFilter));
            }
        }
        return dumpInfo;
    }

    public int getTokenType() {
        return 32;
    }
}

