/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.tds;

import com.sybase.jdbc3.tds.Dumpable;
import com.sybase.jdbc3.tds.TdsInputStream;
import com.sybase.jdbc3.tds.TdsOutputStream;
import com.sybase.jdbc3.tds.Token;
import com.sybase.jdbc3.utils.DumpFilter;
import com.sybase.jdbc3.utils.DumpInfo;
import com.sybase.jdbc3.utils.HexConverts;
import java.io.IOException;

public class SrvDebugToken
extends Token
implements Dumpable {
    protected int _totalLen;
    protected int _mysteryData;
    protected byte[] _serverData;

    public SrvDebugToken(TdsInputStream tdsInputStream) throws IOException {
        try {
            this._totalLen = tdsInputStream.readInt();
            this._mysteryData = tdsInputStream.readInt();
            tdsInputStream.read(this._serverData, 0, 2048);
        }
        catch (IOException iOException) {
            SrvDebugToken.readSQE((IOException)iOException);
        }
    }

    public SrvDebugToken(int n, byte[] byArray) {
        this._mysteryData = n;
        this._serverData = byArray;
        this._totalLen = 8 + this._serverData.length;
    }

    public void send(TdsOutputStream tdsOutputStream) throws IOException {
        tdsOutputStream.writeByte(96);
        tdsOutputStream.writeInt(this._totalLen);
        tdsOutputStream.writeInt(this._mysteryData);
        tdsOutputStream.write(this._serverData);
    }

    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        DumpInfo dumpInfo = null;
        if (dumpFilter.includesToken(96)) {
            dumpInfo = dumpFilter.getDumpInfo();
            if (dumpFilter.includesDetail(0)) {
                dumpInfo.addInfo("Token", 1, "DEBUG_CMD Token (0x" + HexConverts.hexConvert((int)96, (int)1) + "); variable length.");
            } else {
                dumpInfo.addInfo("Token", 1, "DEBUG_CMD Token");
            }
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Length", 4, this._totalLen);
            }
            if (dumpFilter.includesDetail(3)) {
                dumpInfo.addHex("Mystery Data", 4, (long)this._mysteryData);
                dumpInfo.addHex("Server Data", this._serverData.length, this._serverData);
            }
        }
        return dumpInfo;
    }

    public int getTokenType() {
        return 96;
    }
}

