/*
 * Decompiled with CFR 0.152.
 */
package com.informix.csm;

import com.informix.csm.IfxCSSException;
import com.informix.csm.IfxCsm;
import com.informix.csm.IfxCsm$Credentials;
import com.informix.csm.IfxCsm$Status;
import com.informix.csm.IfxCsmBuffer;
import com.informix.csm.IfxCsmDescriptor;
import com.informix.csm.IfxCsmException;
import com.informix.csm.IfxCsmReadBuffer;
import com.informix.csm.IfxCssInputStream;
import com.informix.csm.IfxCssOutputStream;
import com.informix.util.IfxErrMsg;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class IfxCsmContext {
    public static int CSM_SERVER = 262144;
    static int CSS_REQUEST_PENDING = 0;
    static int CSS_REQUEST_POSTED = 1;
    static int CSS_CSM_HAS_DATA = 0;
    static int CSS_CSM_NO_DATA = 1;
    static int CSS_CSM_FREE = 0;
    static int CSS_CSM_IN_USE = 1;
    static int CSS_CSM_DONE = 0;
    static int CSS_CSM_CALL = 1;
    IfxCsm$Status status;
    IfxCsm csm;
    IfxCsm$Credentials cred;
    IfxCsmDescriptor desc;
    String locale;
    int state_out = CSS_CSM_NO_DATA;
    int state_in = CSS_CSM_FREE;
    int state_obj = CSS_CSM_DONE;
    IfxCsmReadBuffer inHandShake;
    IfxCsmBuffer outHandShake;

    int createContext(IfxCsm$Credentials ifxCsm$Credentials) throws IfxCSSException {
        int n = CSS_REQUEST_PENDING;
        int n2 = 0;
        IfxCsm$Status ifxCsm$Status = new IfxCsm$Status();
        while ((n2 = this.csm.ifxCsmCreateContext(ifxCsm$Credentials, this.inHandShake, this.outHandShake, this.desc.getInitString(), ifxCsm$Status)) == 0) {
            this.setState(ifxCsm$Status);
            if (this.state_out != CSS_CSM_HAS_DATA) {
                if (this.state_obj == CSS_CSM_DONE) break;
                if (n == CSS_REQUEST_PENDING) {
                    throw IfxErrMsg.getLocIfxCSSException(-14513, this.locale);
                }
            }
            if (this.state_out == CSS_CSM_HAS_DATA) {
                this.putBytes(this.outHandShake.toByteArray());
                this.outHandShake.reset();
                n = CSS_REQUEST_POSTED;
            }
            if (this.state_in == CSS_CSM_IN_USE) continue;
            this.inHandShake = null;
            this.inHandShake = this.getBytes();
        }
        return n2;
    }

    private void putBytes(byte[] byArray) throws IfxCSSException {
        try {
            this.desc.getOutputStream().write(byArray);
            this.desc.getOutputStream().flush();
        }
        catch (IOException iOException) {
            throw IfxErrMsg.getLocIfxCSSException(-14563, this.locale);
        }
    }

    private IfxCsmReadBuffer getBytes() throws IfxCSSException {
        IfxCsmBuffer ifxCsmBuffer = new IfxCsmBuffer();
        byte[] byArray = new byte[4096];
        int n = -1;
        try {
            n = this.desc.getInputStream().read(byArray);
            if (n != -1) {
                ifxCsmBuffer.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw IfxErrMsg.getLocIfxCSSException(-14565, this.locale);
        }
        return new IfxCsmReadBuffer(ifxCsmBuffer);
    }

    private void setState(IfxCsm$Status ifxCsm$Status) {
        long l2 = ifxCsm$Status.getCsmCode();
        if (l2 == 1L) {
            this.state_out = CSS_CSM_NO_DATA;
            this.state_in = CSS_CSM_FREE;
            this.state_obj = CSS_CSM_DONE;
        } else if (l2 == 2L) {
            this.state_out = CSS_CSM_NO_DATA;
            this.state_in = CSS_CSM_FREE;
            this.state_obj = CSS_CSM_DONE;
        } else if (l2 == 3L) {
            this.state_out = CSS_CSM_HAS_DATA;
            this.state_in = CSS_CSM_FREE;
            this.state_obj = CSS_CSM_CALL;
        } else if (l2 == 4L) {
            this.state_out = CSS_CSM_HAS_DATA;
            this.state_in = CSS_CSM_IN_USE;
            this.state_obj = CSS_CSM_CALL;
        } else if (l2 == 5L) {
            this.state_out = CSS_CSM_NO_DATA;
            this.state_in = CSS_CSM_FREE;
            this.state_obj = CSS_CSM_CALL;
        }
    }

    public IfxCsmContext(IfxCsmDescriptor ifxCsmDescriptor, String string) throws IfxCSSException {
        this.desc = ifxCsmDescriptor;
        this.locale = string;
        this.status = new IfxCsm$Status();
        this.outHandShake = new IfxCsmBuffer();
        this.csm = this.createCsmObject();
    }

    private IfxCsm createCsmObject() throws IfxCSSException {
        IfxCsm ifxCsm = null;
        Class<?> clazz = null;
        this.desc.setLoadState(0);
        try {
            Class<?> clazz2 = Class.forName("com.informix.csm.IfxCsm");
            clazz = Class.forName(this.desc.getClassName());
            if (!clazz2.isAssignableFrom(clazz)) {
                this.desc.setLoadState(2);
                throw IfxErrMsg.getLocIfxCSSException(-14574, this.desc.getClassName() + "\n", this.locale);
            }
            Class[] classArray = new Class[]{this.desc.getClass()};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{this.desc};
            ifxCsm = (IfxCsm)constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.desc.setLoadState(2);
            throw IfxErrMsg.getLocIfxCSSException(-14574, this.desc.getClassName() + "\n" + classNotFoundException.toString(), this.locale);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.desc.setLoadState(2);
            throw IfxErrMsg.getLocIfxCSSException(-14574, this.desc.getClassName() + "\n" + illegalAccessException.toString(), this.locale);
        }
        catch (InstantiationException instantiationException) {
            this.desc.setLoadState(2);
            throw IfxErrMsg.getLocIfxCSSException(-14574, this.desc.getClassName() + "\n" + instantiationException.toString(), this.locale);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.desc.setLoadState(2);
            throw IfxErrMsg.getLocIfxCSSException(-14574, this.desc.getClassName() + "\n" + noSuchMethodException.toString(), this.locale);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.desc.setLoadState(2);
            throw IfxErrMsg.getLocIfxCSSException(-14574, this.desc.getClassName() + "\n" + invocationTargetException.toString(), this.locale);
        }
        this.desc.setLoadState(1);
        return ifxCsm;
    }

    public void init() throws IfxCSSException {
        try {
            this.csm.ifxCsmInit(this.desc.getInitString(), 0L, this.status);
        }
        catch (IfxCsmException ifxCsmException) {
            this.desc.setLoadState(this.status.csmErr);
            throw ifxCsmException;
        }
    }

    public IfxCsm$Status getStatus() {
        return this.status;
    }

    public FilterInputStream getInputStream() {
        return new IfxCssInputStream(this.desc.getInputStream(), this.csm);
    }

    public FilterOutputStream getOutputStream() {
        return new IfxCssOutputStream(this.desc.getOutputStream(), this.csm);
    }
}

