/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.tools.sql;

import com.intersys.cache.SysDatabase;
import com.intersys.cache.jbind.ExportDDL;
import com.intersys.cache.jbind.ReadOnlyDatabase;
import com.intersys.cache.metadata.CacheClassIntrospector;
import com.intersys.cache.serial.CacheMetadataFactory;
import com.intersys.cache.serial.SerialMetadataFactory;
import com.intersys.cache.util.ConnectionAnalyzer;
import com.intersys.cache.util.ThirdPartyConnections;
import com.intersys.classes.CPPStoredProc;
import com.intersys.objects.CacheException;
import com.intersys.objects.Database;
import com.intersys.objects.SysListHolder;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheClassMetadata;
import com.intersys.objects.reflect.CacheField;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class Importer
extends ConnectionAnalyzer
implements ThirdPartyConnections {
    protected CacheClassIntrospector[] mMetadata;
    protected String[] mClasses;
    private Set mUpdatedClasses;
    protected Triplet mMDStatements = new Triplet();
    protected Triplet mViewMapStatements = new Triplet();
    protected Triplet mSeqMapStatements = new Triplet();
    protected Database mDB;
    private ExportDDL mExport;
    private String mSequenceName;

    public Importer(String string, String string2, String string3) throws CacheException, SQLException {
        Connection connection = DriverManager.getConnection(string, string2, string3);
        this.mExport = new ExportDDL(connection);
        this.mDB = new ReadOnlyDatabase(this.mExport.getAdapter(), null, true);
        this.mSequenceName = null;
    }

    public void importAll(Connection connection) throws SQLException, CacheException {
        int n = Importer.getProductType(connection);
        this.importDDL(connection, n);
        this.importMetaData(connection, n);
    }

    private void closeMetadataImport() throws SQLException {
        this.mUpdatedClasses.clear();
        this.mMDStatements.close();
    }

    private void initMetadataImport(Connection connection) throws SQLException {
        if (!this.mMDStatements.init(connection, "CACHE_SYS", "METADATA", "CLASS_NAME", "CLASS_METADATA", "TABLE_NAME")) {
            return;
        }
        this.mUpdatedClasses = new HashSet();
    }

    public void importMetaData(String string, CacheClassIntrospector cacheClassIntrospector) throws SQLException, CacheException {
        if (this.mUpdatedClasses.contains(string)) {
            return;
        }
        this.mUpdatedClasses.add(string);
        byte[] byArray = cacheClassIntrospector.serialize();
        String string2 = cacheClassIntrospector.getFullSQLTableName();
        if (string2 == null) {
            string2 = "";
        }
        this.mMDStatements.insertUpdateRecord(string, byArray, string2);
        CacheClass[] cacheClassArray = cacheClassIntrospector.getCacheSuperclasses();
        for (int i = 0; i < cacheClassArray.length; ++i) {
            CacheClassIntrospector cacheClassIntrospector2 = (CacheClassIntrospector)cacheClassArray[i];
            this.importMetaData(cacheClassIntrospector2.getName(), cacheClassIntrospector2);
        }
        CacheField[] cacheFieldArray = cacheClassIntrospector.getFields();
        for (int i = 0; i < cacheFieldArray.length; ++i) {
            CacheClassIntrospector cacheClassIntrospector3 = (CacheClassIntrospector)cacheFieldArray[i].getType();
            this.importMetaData(cacheClassIntrospector3.getName(), cacheClassIntrospector3);
        }
    }

    public void importMetaData(Connection connection, int n) throws SQLException, CacheException {
        this.initMetadataImport(connection);
        for (int i = 0; i < this.mClasses.length; ++i) {
            this.importMetaData(this.mClasses[i], this.mMetadata[i]);
        }
        this.closeMetadataImport();
        this.importSystemMetadata(connection);
    }

    public void importSystemMetadata(Connection connection) throws SQLException, CacheException {
        byte[] byArray;
        String string;
        String string2 = "insert into CACHE_SYS.LG_CLASSES(CLASS_NAME, CLASS_METADATA) values ( ? , ? )";
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        CacheMetadataFactory cacheMetadataFactory = new CacheMetadataFactory((SysDatabase)this.mDB, this.mDB);
        for (int i = 0; i < SYS_MD_CLASSES.length; ++i) {
            string = "%Compiler.LG." + SYS_MD_CLASSES[i];
            byArray = ((SerialMetadataFactory)cacheMetadataFactory).getSerialInfo(string);
            System.out.println("Inserting metadata for class: " + string);
            preparedStatement.setString(1, string);
            preparedStatement.setBytes(2, byArray);
            preparedStatement.executeUpdate();
        }
        SysListHolder sysListHolder = new SysListHolder(null);
        CPPStoredProc.getStaticDictionary(this.mDB, sysListHolder);
        string = "%Compiler.LG.StaticDictionary";
        byArray = sysListHolder.value.getData();
        System.out.println("Inserting static dictionary: ");
        preparedStatement.setString(1, string);
        preparedStatement.setBytes(2, byArray);
        preparedStatement.executeUpdate();
        int n = ((SysDatabase)this.mDB).getReflectionVersion();
        preparedStatement.setString(1, "%Compiler.LG.___VERSION");
        byArray = String.valueOf(n).getBytes();
        preparedStatement.setBytes(2, byArray);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    public void importDDL(Connection connection, int n) throws SQLException {
        String[] stringArray = this.mExport.getDDLForExecute();
        Importer.createMetadataTables(connection, n);
        Statement statement = connection.createStatement();
        this.mViewMapStatements.init(connection, "CACHE_SYS", "HIERARCHY", "CLASS_VIEW", "CLASS_BASE_TABLE", null);
        this.mSeqMapStatements.init(connection, "CACHE_SYS", "METADATA", "CLASS_NAME", "CLASS_SEQUENCE", null);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string == null) continue;
            string = Importer.replace(string, "%Version", "_Version");
            switch (n) {
                case 2: {
                    string = Importer.toCache(string);
                    break;
                }
                case 4: {
                    string = Importer.toMS_SQL(string);
                    break;
                }
                case 1: {
                    string = Importer.toMySQL(string);
                    break;
                }
                case 3: {
                    string = Importer.lvc2l_vc(string);
                    string = Importer.lvb2Oracle(string);
                    break;
                }
            }
            string = this.createOrALter(connection, string, n);
            if (string == null) continue;
            System.out.println("Executing: '" + string + "'");
            statement.executeUpdate(string);
        }
        this.mViewMapStatements.close();
        this.mSeqMapStatements.close();
    }

    private String createOrALter(Connection connection, String string, int n) throws SQLException {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!stringTokenizer.hasMoreTokens()) {
            return string;
        }
        String string2 = stringTokenizer.nextToken();
        if (!"CREATE".equalsIgnoreCase(string2)) {
            return string;
        }
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        this.setIsView(string4, string3, stringTokenizer);
        this.mapSequence(string4, string3);
        boolean bl = false;
        StringTokenizer stringTokenizer2 = new StringTokenizer(string4, ".");
        int n2 = stringTokenizer2.countTokens();
        if (n == 3) {
            if (string3.equalsIgnoreCase("OR") && string4.equalsIgnoreCase("REPLACE")) {
                Statement statement = connection.createStatement();
                System.out.println("Executing: " + string);
                statement.execute(string + ";");
                statement.close();
                return null;
            }
            if (string3.equalsIgnoreCase("SEQUENCE")) {
                bl = true;
            }
        }
        if (!bl) {
            if (n2 > 1) {
                object = stringTokenizer2.nextToken();
                String string5 = stringTokenizer2.nextToken();
                bl = Importer.tableExists(connection, (String)object, string5, true);
            } else {
                String string6 = stringTokenizer2.nextToken();
                bl = Importer.tableExists(connection, "", string6, true);
            }
        }
        if (n == 1 && string3.equalsIgnoreCase("VIEW")) {
            string = string + " WITH LOCAL CHECK OPTION";
        }
        if (n == 3 && string3.equalsIgnoreCase("SEQUENCE") || !bl && n == 2 && string3.equalsIgnoreCase("VIEW")) {
            object = connection.createStatement();
            String string7 = "DROP " + string3 + " " + string4;
            System.out.println("Executing: " + string7);
            try {
                object.executeUpdate(string7);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            object.close();
            return string;
        }
        if (!bl) {
            return string;
        }
        object = connection.createStatement();
        String string8 = "DROP " + string3 + " " + string4;
        System.out.println("Executing: " + string8);
        object.executeUpdate(string8);
        object.close();
        return string;
    }

    private void setIsView(String string, String string2, StringTokenizer stringTokenizer) throws SQLException {
        if (!"VIEW".equalsIgnoreCase(string2)) {
            return;
        }
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            if (!stringTokenizer.nextToken().equalsIgnoreCase("FROM")) continue;
            string3 = stringTokenizer.nextToken();
            break;
        }
        if (string3 == null) {
            throw new SQLException("Base table for view " + string + " is not found");
        }
        System.out.println("Adding view-table mapping: " + string + " -> " + string3);
        this.mViewMapStatements.insertUpdateRecord(string, string3, null);
    }

    private void mapSequence(String string, String string2) throws SQLException {
        if ("SEQUENCE".equalsIgnoreCase(string2)) {
            this.mSequenceName = string;
            return;
        }
        if (this.mSequenceName == null) {
            return;
        }
        System.out.println("Adding view-sequence mapping: " + string + " -> " + this.mSequenceName);
        this.mSeqMapStatements.insertUpdateRecord(string, this.mSequenceName, null);
    }

    private static String lvc2l_vc(String string) {
        String string2 = "LONGVARCHAR";
        String string3 = "LONG VARCHAR";
        string = Importer.replace(string, string2, string3);
        return string;
    }

    private static String lvb2l_vb(String string) {
        String string2 = "LONGVARBINARY";
        String string3 = "LONG VARBINARY";
        return Importer.replace(string, string2, string3);
    }

    private static String lvb2Oracle(String string) {
        String string2 = "LONGVARBINARY";
        String string3 = "BLOB";
        return Importer.replace(string, string2, string3);
    }

    private static String toMySQL(String string) {
        string = Importer.lvc2l_vc(string);
        string = Importer.lvb2l_vb(string);
        string = Importer.replace(string, " INTEGER,", " BIGINT,");
        string = Importer.replace(string, " INTEGER NOT NULL,", " BIGINT NOT NULL,");
        return string;
    }

    private static String toMS_SQL(String string) {
        string = Importer.replace(string, " %Version", " _Version");
        string = Importer.replace(string, " LONGVARCHAR,", " TEXT,");
        string = Importer.replace(string, " LONGVARBINARY,", " IMAGE,");
        string = Importer.replace(string, " DATE,", " DATETIME,");
        string = Importer.replace(string, " TIME,", " DATETIME,");
        string = Importer.replace(string, " TIMESTAMP,", " DATETIME,");
        string = Importer.replace(string, " DOUBLE,", " FLOAT,");
        string = Importer.replace(string, " INTEGER,", " BIGINT,");
        string = Importer.replace(string, " INTEGER NOT NULL,", " BIGINT NOT NULL,");
        return string;
    }

    private static String toCache(String string) {
        String string2 = "x__classname";
        String string3 = "x___classname";
        return Importer.replace(string, string2, string3);
    }

    private static String replace(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.indexOf(string2);
        while (n > 0) {
            int n2 = n + string2.length();
            int n3 = n + string3.length();
            stringBuffer.replace(n, n2, string3);
            n = stringBuffer.indexOf(string2, n3);
        }
        return stringBuffer.toString();
    }

    public static void createMetadataTables(Connection connection, int n) throws SQLException {
        String string;
        String string2;
        Statement statement = null;
        statement = connection.createStatement();
        switch (n) {
            case 2: {
                string2 = " LONGVARBINARY ";
                break;
            }
            case 4: {
                string2 = " IMAGE ";
                break;
            }
            case 1: 
            case 3: {
                string2 = " BLOB ";
                break;
            }
            default: {
                string2 = " BLOB ";
            }
        }
        boolean bl = Importer.checkVersion(connection);
        if (!Importer.tableExists(connection, "CACHE_SYS", "METADATA", bl)) {
            string = "CREATE TABLE CACHE_SYS.METADATA (CLASS_NAME VARCHAR(128) NOT NULL,CLASS_METADATA" + string2 + ", " + "CLASS_SEQUENCE" + " VARCHAR(128), " + "TABLE_NAME" + " VARCHAR(128), " + "CLASS_JAVA_NAME" + " VARCHAR(128)" + ", CONSTRAINT MD_D_IDKEY UNIQUE (" + "CLASS_NAME" + "))";
            System.out.println("Executing: " + string);
            statement.executeUpdate(string);
        }
        if (!Importer.tableExists(connection, "CACHE_SYS", "HIERARCHY", bl)) {
            string = "CREATE TABLE CACHE_SYS.HIERARCHY (CLASS_VIEW VARCHAR(128) NOT NULL,CLASS_BASE_TABLE VARCHAR(128) NOT NULL, CONSTRAINT MD_V_IDKEY UNIQUE (CLASS_VIEW))";
            System.out.println("Executing: " + string);
            statement.executeUpdate(string);
        }
        if (Importer.tableExists(connection, "CACHE_SYS", "LG_CLASSES", true)) {
            string = "drop table CACHE_SYS.LG_CLASSES";
            System.out.println("Executing: " + string);
            statement.executeUpdate(string);
        }
        string = "CREATE TABLE CACHE_SYS.LG_CLASSES (CLASS_NAME VARCHAR(128) NOT NULL,CLASS_METADATA" + string2 + ", CONSTRAINT MD_S_IDKEY UNIQUE (" + "CLASS_NAME" + "))";
        System.out.println("Executing: " + string);
        statement.executeUpdate(string);
        statement.close();
    }

    public static void printTableExists(Connection connection, String string, String string2) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        System.out.println("Table " + string + "." + string2 + " exists in " + databaseMetaData.getDatabaseProductName() + "? " + Importer.tableExists(connection, string, string2, true));
    }

    public static boolean tableExists(Connection connection, String string, String string2, boolean bl) throws SQLException {
        String string3;
        AutoCloseable autoCloseable;
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ResultSet resultSet = null;
        boolean bl2 = databaseMetaData.supportsSchemasInTableDefinitions();
        String string4 = databaseMetaData.getSchemaTerm();
        if (bl2 && string4.length() == 0) {
            throw new SQLException("Can not determine whether shemas are supported.");
        }
        if (bl2) {
            if (Importer.getProductType(connection) == 3) {
                string = string.toUpperCase();
                string2 = string2.toUpperCase();
            }
            resultSet = databaseMetaData.getTables(null, string, string2, null);
        } else {
            String string5 = databaseMetaData.getCatalogTerm();
            if (string5.length() > 0) {
                autoCloseable = databaseMetaData.getCatalogs();
                while (autoCloseable.next()) {
                    string3 = autoCloseable.getString(1);
                    if (!string3.equalsIgnoreCase(string)) continue;
                    resultSet = databaseMetaData.getTables(string, null, string2, null);
                    autoCloseable.close();
                    break;
                }
                if (resultSet == null) {
                    autoCloseable.close();
                    return false;
                }
            } else {
                throw new SQLException("Looks like neither shemas nor catalogs are supported by " + databaseMetaData.getDatabaseProductName());
            }
        }
        boolean bl3 = resultSet.next();
        if (bl3 && !bl) {
            autoCloseable = connection.createStatement();
            string3 = "drop table " + string + "." + string2;
            System.out.println("Executing: " + string3);
            autoCloseable.executeUpdate(string3);
        }
        resultSet.close();
        System.out.println("Table: " + string + "." + string2 + " exists? - " + bl3 + "; up to date? - " + bl);
        return bl3 && bl;
    }

    private static boolean checkVersion(Connection connection) throws SQLException {
        String string;
        Statement statement = connection.createStatement();
        boolean bl = Importer.tableExists(connection, "CACHE_SYS", "METADATA_TABLE_VERSION", true);
        String string2 = "CACHE_SYS.METADATA_TABLE_VERSION";
        ResultSet resultSet = null;
        if (!bl) {
            string = "CREATE TABLE " + string2 + " (" + "VERSION" + " INTEGER )";
            statement.executeUpdate(string);
        } else {
            string = "SELECT VERSION FROM " + string2;
            resultSet = statement.executeQuery(string);
            if (!resultSet.next()) {
                bl = false;
            }
        }
        if (!bl) {
            string = "INSERT into " + string2 + " values (" + 2 + ")";
            statement.executeUpdate(string);
            statement.close();
            return false;
        }
        int n = resultSet.getInt(1);
        resultSet.close();
        boolean bl2 = bl = n == 2;
        if (!bl) {
            string = "UPDATE " + string2 + " set " + "VERSION" + " = " + 2;
            statement.executeUpdate(string);
        }
        statement.close();
        return bl;
    }

    public void exportDDL(String[] stringArray, String string, String string2, String string3) throws CacheException {
        int n;
        this.mClasses = stringArray;
        int n2 = stringArray.length;
        String[] stringArray2 = new String[n2];
        String[] stringArray3 = new String[n2];
        this.mMetadata = new CacheClassIntrospector[n2];
        for (n = 0; n < n2; ++n) {
            CacheClassIntrospector cacheClassIntrospector = new CacheClassIntrospector(this.mDB, stringArray[n], true);
            stringArray2[n] = cacheClassIntrospector.getSchemaName();
            stringArray3[n] = cacheClassIntrospector.getSQLTableName();
            this.mMetadata[n] = cacheClassIntrospector;
        }
        try {
            this.mExport.exportDDL(stringArray2, stringArray3, string, string2, string3);
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to export DDL");
        }
        for (n = 0; n < n2; ++n) {
            this.exportChildTables(this.mMetadata[n], string3);
        }
    }

    private void exportChildTables(CacheClassMetadata cacheClassMetadata, String string) throws CacheException {
        CacheField[] cacheFieldArray = cacheClassMetadata.getFields();
        String string2 = cacheClassMetadata.getSchemaName();
        String[] stringArray = new String[]{string2};
        for (int i = 0; i < cacheFieldArray.length; ++i) {
            if (!cacheFieldArray[i].isChildTable()) continue;
            String string3 = cacheFieldArray[i].getChildTableMetadata().getName();
            String[] stringArray2 = new String[]{string3};
            try {
                this.mExport.exportDDL(stringArray, stringArray2, string2, string3, string);
                continue;
            }
            catch (SQLException sQLException) {
                throw new CacheException(sQLException, "Failed to export DDL for child table: " + string2 + "." + string3);
            }
        }
    }

    public String[] getDDLForPrint() {
        return this.mExport.getDDLForPrint();
    }

    protected static class Triplet {
        public PreparedStatement insert;
        public PreparedStatement update;
        public PreparedStatement exists;
        protected boolean open;

        protected Triplet() {
        }

        public boolean init(Connection connection, String string, String string2, String string3, String string4, String string5) throws SQLException {
            if (this.open) {
                return false;
            }
            String string6 = string + "." + string2;
            String string7 = "INSERT INTO " + string6 + "(" + string3 + ", " + string4;
            if (string5 != null) {
                string7 = string7 + ", " + string5;
            }
            string7 = string7 + ") VALUES (?, ?";
            if (string5 != null) {
                string7 = string7 + ", ?";
            }
            string7 = string7 + ")";
            this.insert = connection.prepareStatement(string7);
            String string8 = "UPDATE " + string6 + " set " + string4 + " = ? ";
            if (string5 != null) {
                string8 = string8 + ", " + string5 + " = ? ";
            }
            string8 = string8 + "WHERE " + string3 + " = ?";
            this.update = connection.prepareStatement(string8);
            String string9 = "SELECT " + string3 + " FROM " + string6 + " WHERE " + string3 + " = ?";
            this.exists = connection.prepareStatement(string9);
            this.open = true;
            return true;
        }

        private void insertUpdateRecord(String string, Object object, Object object2) throws SQLException {
            this.exists.setString(1, string);
            ResultSet resultSet = this.exists.executeQuery();
            boolean bl = resultSet.next();
            resultSet.close();
            if (bl) {
                int n = 1;
                this.update.setObject(n++, object);
                if (object2 != null) {
                    this.update.setObject(n++, object2);
                }
                this.update.setString(n++, string);
                System.out.println("Updating metadata for class: " + string);
                int n2 = this.update.executeUpdate();
                if (n2 != 1) {
                    throw new SQLException("Error updating metadata for class " + string);
                }
            } else {
                this.insert.setString(1, string);
                this.insert.setObject(2, object);
                if (object2 != null) {
                    this.insert.setObject(3, object2);
                }
                System.out.println("Inserting metadata for class: " + string);
                int n = this.insert.executeUpdate();
                if (n != 1) {
                    throw new SQLException("Error inserting metadata for class " + string);
                }
            }
        }

        public void close() throws SQLException {
            this.insert.close();
            this.update.close();
            this.exists.close();
            this.open = false;
        }
    }
}

