/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.tools.objects.gui.wizard;

import com.jalapeno.tools.SchemaBuilderWizard;
import com.jalapeno.tools.objects.gui.wizard.Wizard;
import com.jalapeno.tools.objects.gui.wizard.WizardModel;
import com.jalapeno.tools.objects.gui.wizard.WizardPanelDescriptor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class WizardController
implements ActionListener {
    private Wizard wizard;

    public WizardController(Wizard wizard) {
        this.wizard = wizard;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("CancelButtonActionCommand")) {
            this.cancelButtonPressed();
        } else if (actionEvent.getActionCommand().equals("BackButtonActionCommand")) {
            this.backButtonPressed();
        } else if (actionEvent.getActionCommand().equals("NextButtonActionCommand")) {
            this.nextButtonPressed();
        }
    }

    private void cancelButtonPressed() {
        this.wizard.close(1);
    }

    private void nextButtonPressed() {
        WizardModel wizardModel = this.wizard.getModel();
        WizardPanelDescriptor wizardPanelDescriptor = wizardModel.getCurrentPanelDescriptor();
        Object object = wizardPanelDescriptor.getNextPanelDescriptor();
        if (object instanceof WizardPanelDescriptor.FinishIdentifier) {
            ((SchemaBuilderWizard)wizardPanelDescriptor.getParent()).writePropertiesToConfigFile();
            this.wizard.close(0);
        } else {
            this.wizard.setCurrentPanel(object);
        }
    }

    private void backButtonPressed() {
        WizardModel wizardModel = this.wizard.getModel();
        WizardPanelDescriptor wizardPanelDescriptor = wizardModel.getCurrentPanelDescriptor();
        Object object = wizardPanelDescriptor.getBackPanelDescriptor();
        this.wizard.setCurrentPanel(object);
    }

    void resetButtonsToPanelRules() {
        WizardModel wizardModel = this.wizard.getModel();
        WizardPanelDescriptor wizardPanelDescriptor = wizardModel.getCurrentPanelDescriptor();
        wizardModel.setCancelButtonText(Wizard.CANCEL_TEXT);
        wizardModel.setCancelButtonIcon(Wizard.CANCEL_ICON);
        wizardModel.setBackButtonText(Wizard.BACK_TEXT);
        wizardModel.setBackButtonIcon(Wizard.BACK_ICON);
        if (wizardPanelDescriptor.getBackPanelDescriptor() != null) {
            wizardModel.setBackButtonEnabled(Boolean.TRUE);
        } else {
            wizardModel.setBackButtonEnabled(Boolean.FALSE);
        }
        if (wizardPanelDescriptor.getNextPanelDescriptor() != null) {
            wizardModel.setNextFinishButtonEnabled(Boolean.TRUE);
        } else {
            wizardModel.setNextFinishButtonEnabled(Boolean.FALSE);
        }
        if (wizardPanelDescriptor.getNextPanelDescriptor() instanceof WizardPanelDescriptor.FinishIdentifier) {
            wizardModel.setNextFinishButtonText(Wizard.FINISH_TEXT);
            wizardModel.setNextFinishButtonIcon(Wizard.FINISH_ICON);
        } else {
            wizardModel.setNextFinishButtonText(Wizard.NEXT_TEXT);
            wizardModel.setNextFinishButtonIcon(Wizard.NEXT_ICON);
        }
    }
}

