/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.tools.objects.gui;

import com.jalapeno.tools.objects.common.Messages;
import java.awt.BorderLayout;
import java.awt.TextArea;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JPanel;

public class Console
extends JPanel {
    private TextArea ta;
    private PrintStream out;

    public Console() {
        this.setToolTipText(Messages.getString("GeneratorGUI.64"));
        this.ta = new TextArea();
        this.ta.setEditable(false);
        this.out = null;
        this.setLayout(new BorderLayout());
        this.add("Center", this.ta);
        this.setVisible(true);
        this.ta.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyChar()) {
                    case 'c': {
                        Console.this.ta.setText("");
                    }
                }
                keyEvent.consume();
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        });
    }

    public void println(int n) {
        this.println("" + n);
    }

    public void println(long l) {
        this.println("" + l);
    }

    public void println(double d) {
        this.println("" + d);
    }

    public void println(String string) {
        this.println((Object)string);
    }

    public void println(Object object) {
        this.showString(object.toString() + "\n");
    }

    public void print(int n) {
        this.print("" + n);
    }

    public void print(long l) {
        this.print("" + l);
    }

    public void print(double d) {
        this.print("" + d);
    }

    public void print(String string) {
        this.print((Object)string);
    }

    public void print(Object object) {
        this.showString(object.toString());
    }

    private void showString(Object object) {
        this.ta.append(object.toString());
    }

    public void closeit() {
        this.setVisible(false);
        this.out = null;
    }

    public PrintStream getOut() {
        if (this.out == null) {
            this.out = new PrintStream(new ConsoleOutputStream(), true);
        }
        return this.out;
    }

    private class ConsoleOutputStream
    extends OutputStream {
        private byte[] littlebuf = new byte[1];

        private ConsoleOutputStream() {
        }

        public void write(int n) throws IOException {
            this.littlebuf[0] = (byte)n;
            String string = new String(this.littlebuf, 0, 1);
            Console.this.print(string);
        }

        public void write(byte[] byArray) throws IOException {
            String string = new String(byArray, 0, byArray.length);
            Console.this.print(string);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            String string = new String(byArray, n, n2);
            Console.this.print(string);
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }
    }
}

