/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.tools.objects;

import com.intersys.cache.CacheClassBuilder;
import com.intersys.cache.SysDatabase;
import com.intersys.objects.CacheDatabase;
import com.intersys.objects.CacheException;
import com.intersys.objects.Database;
import com.jalapeno.tools.objects.CacheClassGenerator;
import com.jalapeno.tools.objects.ClassMergeTool;
import com.jalapeno.tools.objects.Configurator;
import com.jalapeno.tools.objects.DefaultConfiguratorForPath;
import com.jalapeno.tools.objects.DefaultMappingTool;
import com.jalapeno.tools.objects.Java2DBMapping;
import com.jalapeno.tools.objects.JavaCacheClassMapper;
import com.jalapeno.tools.objects.MappingToolInterface;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class Persister {
    public static final boolean DEFAULT_DO_MERGE = true;
    private static boolean USE_MERGE_TOOL = false;
    PrintStream mOut = System.out;
    private Configurator config;
    private Collection classesToPersist;
    private Connection connection;
    private Database database;
    private JavaCacheClassMapper mMapper = null;
    private ClassMergeTool mMerger;
    private String mGeneratedClasses;
    private Set mGeneratedClassesSet;
    private MappingToolInterface mMappingTool;
    private boolean doMerge;

    public Persister(Configurator configurator, Connection connection) {
        this.config = configurator;
        this.connection = connection;
        this.database = null;
        this.mMappingTool = new DefaultMappingTool();
        this.doMerge = true;
        this.classesToPersist = null;
    }

    public Persister(Configurator configurator, Database database) {
        this.config = configurator;
        this.connection = null;
        this.database = database;
        this.mMappingTool = new DefaultMappingTool();
        this.doMerge = true;
        this.classesToPersist = null;
    }

    public void addMetadataProvider(Java2DBMapping java2DBMapping) {
        this.mMappingTool.addMetadataProvider(java2DBMapping);
    }

    public void setDoMerge(boolean bl) {
        this.doMerge = bl;
    }

    public void setOutput(PrintStream printStream) {
        this.mOut = printStream == null ? System.out : printStream;
    }

    public void ignoreNestedGenerics() {
        this.mMappingTool.setIgnoreNestedGenerics(true);
    }

    public void useAnnotations() throws CacheException {
        Java2DBMapping java2DBMapping = Persister.createAnnotationsProvider();
        this.addMetadataProvider(java2DBMapping);
        if (this.config instanceof DefaultConfiguratorForPath) {
            ((DefaultConfiguratorForPath)this.config).setTransientFilterIfUnset(java2DBMapping);
        }
    }

    public void useHibernateXMLDescriptors() throws CacheException {
        Java2DBMapping java2DBMapping = Persister.createHibernateProvider();
        this.addMetadataProvider(java2DBMapping);
        if (this.config instanceof DefaultConfiguratorForPath) {
            ((DefaultConfiguratorForPath)this.config).setTransientFilterIfUnset(java2DBMapping);
        }
    }

    public void persist() throws Exception {
        Object object;
        this.classesToPersist = this.config.getJavaClassesToPersist();
        if (this.database == null) {
            this.database = CacheDatabase.getDatabase(this.connection);
        }
        this.database.setConsoleOutput(this.mOut);
        ((SysDatabase)this.database).setClassLoader(this.config.getLoader());
        this.mMappingTool.setDefaultAccessLevel(this.config.getDefaultAccessLevel());
        this.mMappingTool.setDefaultAccessType(this.config.getDefaultAccessType());
        this.mMappingTool.setUseGettersOnly(this.config.generateForGettersOnly());
        this.mMappingTool.setDefaultJavaProjectionPackage(this.config.getDefaultJavaProjectionPackage());
        this.mMappingTool.addExclusions(this.config.getExclusions());
        HashMap hashMap = new HashMap();
        Object object2 = new ArrayList();
        HashSet hashSet = new HashSet();
        if (USE_MERGE_TOOL && this.doMerge) {
            this.mMerger = new ClassMergeTool(this.database, this.mMappingTool);
            this.mMapper = new JavaCacheClassMapper();
            this.mMapper.setORMTool(this.mMerger);
            object2.addAll(this.classesToPersist);
            this.mOut.println("Starting data collection phase:");
            while (!object2.isEmpty()) {
                object = this.generateClasses((Collection)object2, false);
                hashMap.putAll(this.mMapper.getTypeMap());
                hashSet.addAll(object2);
                object.removeAll(hashSet);
                object2 = object;
            }
            this.mMappingTool.addMetadataProvider(this.mMerger.getCollectedDataProvider());
            hashMap = new HashMap();
            hashSet = new HashSet();
            object2.clear();
        }
        this.mOut.println("Starting generation phase:");
        this.mMapper = new CacheClassGenerator(CacheClassBuilder.createDirectClassBuilder(this.database));
        if (this.doMerge) {
            ((CacheClassGenerator)this.mMapper).deleteOldClasses(false);
        } else {
            ((CacheClassGenerator)this.mMapper).deleteOldClasses(true);
        }
        this.mMapper.setORMTool(this.mMappingTool);
        object2.addAll(this.classesToPersist);
        while (!object2.isEmpty()) {
            object = this.generateClasses((Collection)object2, true);
            hashMap.putAll(this.mMapper.getTypeMap());
            hashSet.addAll(object2);
            object.removeAll(hashSet);
            object2 = object;
        }
        object = hashMap.entrySet().iterator();
        while (object.hasNext()) {
            this.mOut.println(object.next());
        }
        object = new StringBuffer();
        if (this.mGeneratedClassesSet == null) {
            this.mGeneratedClassesSet = new HashSet(hashSet.size());
        }
        Object object3 = hashSet.iterator();
        while (object3.hasNext()) {
            Class clazz;
            if (((StringBuffer)object).length() > 0) {
                ((StringBuffer)object).append(',');
            }
            if (this.mMappingTool.isClassTransient(clazz = (Class)object3.next())) continue;
            String string = clazz.getName();
            String string2 = (String)hashMap.get(string);
            ((StringBuffer)object).append(string2);
            this.mGeneratedClassesSet.add(string);
        }
        object3 = ((StringBuffer)object).toString();
        if (object3 != null && ((String)object3).length() > 0) {
            this.database.utilities().compileCacheClass((String)object3, "+d");
        }
        this.mGeneratedClasses = this.mGeneratedClasses == null ? object3 : this.mGeneratedClasses + ", " + (String)object3;
    }

    public String getGeneratedClassesList() {
        return this.mGeneratedClasses;
    }

    public Set getGeneratedClassesSet() {
        return this.mGeneratedClassesSet;
    }

    public void generateStandardJavaProjections(String string) throws IOException, CacheException {
        if (this.database == null) {
            this.database = CacheDatabase.getDatabase(this.connection);
        }
        String string2 = this.config.getJavaSourceDir();
        this.database.utilities().generateClass(this.mGeneratedClasses, string2, "+d,/generationtype=" + string);
    }

    public void close() {
        this.connection = null;
        this.database = null;
        if (this.mMappingTool != null) {
            this.mMappingTool.close();
        }
        this.mMappingTool = null;
        if (this.mMapper != null) {
            this.mMapper.close();
        }
        this.mMapper = null;
        this.mMerger = null;
        this.mGeneratedClasses = null;
    }

    protected static Java2DBMapping createAnnotationsProvider() throws CacheException {
        return Persister.lookupProvider("com.jalapeno.tools.objects.AnnotationProvider");
    }

    protected static Java2DBMapping createHibernateProvider() throws CacheException {
        return Persister.lookupProvider("com.jalapeno.tools.objects.HibernateProvider");
    }

    public static Java2DBMapping lookupProvider(String string) throws CacheException {
        try {
            Class<?> clazz = Class.forName(string);
            Java2DBMapping java2DBMapping = (Java2DBMapping)clazz.newInstance();
            return java2DBMapping;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CacheException(classNotFoundException, "Class " + string + " can not be loaded");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CacheException(illegalAccessException, "Access violation. Class " + string + " can not be instanitated.");
        }
        catch (InstantiationException instantiationException) {
            throw new CacheException(instantiationException, "Class " + string + " can not be instantiated: " + instantiationException.getMessage());
        }
    }

    private Set generateClasses(Collection collection, boolean bl) throws Exception {
        HashSet hashSet = new HashSet();
        for (Object e : collection) {
            Class clazz = (Class)e;
            this.mOut.println("Generating " + clazz.getName());
            this.mMapper.mapClass(clazz);
            if (bl && !this.mMappingTool.isClassTransient(clazz)) {
                this.setupClass(clazz);
            }
            hashSet.addAll(this.mMapper.getDependencies(false));
        }
        return hashSet;
    }

    private void setupClass(Class clazz) throws Exception {
        CacheClassGenerator cacheClassGenerator = (CacheClassGenerator)this.mMapper;
        String string = clazz.isInterface() ? "com.intersys.classes.PersistentWrapper" : null;
        cacheClassGenerator.setupJavaBlock(string, clazz);
        cacheClassGenerator.save();
    }

    public static void main(String[] stringArray) throws Exception {
        DefaultConfiguratorForPath defaultConfiguratorForPath;
        Object object;
        boolean bl;
        String string = "jdbc:Cache://127.0.0.1:1972/USER";
        String string2 = "_SYSTEM";
        String string3 = "SYS";
        Class.forName("com.intersys.jdbc.CacheDriver");
        Connection connection = DriverManager.getConnection(string, string2, string3);
        boolean bl2 = bl = System.getProperty("P.HIBERNATE") != null;
        if (stringArray[0].equals("-classpath")) {
            object = new String[stringArray.length - 2];
            System.arraycopy(stringArray, 2, object, 0, ((String[])object).length);
            String[] stringArray2 = stringArray[1].split(File.pathSeparator);
            URL[] uRLArray = new URL[stringArray2.length];
            for (int i = 0; i < stringArray2.length; ++i) {
                uRLArray[i] = new File(stringArray2[i]).toURL();
            }
            defaultConfiguratorForPath = DefaultConfiguratorForPath.getInstance(uRLArray, (String[])object);
        } else {
            defaultConfiguratorForPath = stringArray.length > 1 ? DefaultConfiguratorForPath.getInstance(stringArray[0], stringArray[1]) : DefaultConfiguratorForPath.getInstance(stringArray[0], null);
        }
        object = new Persister((Configurator)defaultConfiguratorForPath, connection);
        ((Persister)object).setDoMerge(false);
        defaultConfiguratorForPath.setDefaultAccessType(12002);
        if (bl) {
            ((Persister)object).useHibernateXMLDescriptors();
        } else {
            ((Persister)object).useAnnotations();
        }
        ((Persister)object).ignoreNestedGenerics();
        ((Persister)object).persist();
    }
}

