/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.runtime;

import com.intersys.objects.CacheException;
import com.intersys.objects.StatusCode;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheField;
import com.intersys.objects.reflect.CacheMethod;
import com.jalapeno.ExtentManager;
import com.jalapeno.runtime.CacheObjectManager;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class CachePOJOExtentManager
implements ExtentManager {
    private CacheClass populatable = null;
    private CacheObjectManager mManager;

    public CachePOJOExtentManager(CacheObjectManager cacheObjectManager) {
        this.mManager = cacheObjectManager;
    }

    public int populate(Object object, int n) throws Exception {
        CacheClass cacheClass = this.findCacheClass(object);
        CacheMethod cacheMethod = cacheClass.getMethod("Populate", null);
        Object object2 = cacheMethod.invoke(null, new Object[]{new Integer(n)});
        return (Integer)object2;
    }

    public void deleteClassDefinition(Object object) throws Exception {
        String string;
        if (object instanceof CacheClass) {
            string = ((CacheClass)object).getName();
        } else if (object instanceof Class) {
            string = this.mManager.findImplementationName((Class)object);
        } else if (object instanceof String) {
            string = this.mManager.findImplementationName((String)object);
        } else {
            throw new IllegalArgumentException("Do not know how to infer Cache Class from " + object.getClass().getName());
        }
        this.mManager.deleteClassDefinition(string);
    }

    public boolean killExtent(Object object) throws Exception {
        CacheClass cacheClass = this.findCacheClass(object);
        if (!cacheClass.isPersistent()) {
            return false;
        }
        CacheClass cacheClass2 = cacheClass.getSuperclass();
        if (cacheClass2 == null) {
            return false;
        }
        String string = cacheClass2.getName();
        String string2 = string.startsWith("%") && string.endsWith("Persistent") ? "%KillExtent" : "%DeleteExtent";
        CacheMethod cacheMethod = cacheClass.getMethod(string2, null);
        Object object2 = cacheMethod.invoke(null, null);
        this.mManager.getFullDatabase().parseStatus((StatusCode)object2);
        return true;
    }

    public void rebuildIndices(Class clazz) throws Exception {
        CacheClass cacheClass = this.findImplementation(clazz);
        CacheMethod cacheMethod = cacheClass.getMethod("%BuildIndices", null);
        cacheMethod.invoke(null, null);
    }

    private CacheClass findImplementation(Class clazz) throws Exception {
        CacheClass cacheClass = this.mManager.findImplementation(clazz);
        cacheClass = this.mManager.getFullDatabase().getCacheClass(cacheClass.getName());
        return cacheClass;
    }

    public Map populate(Collection collection, int n, int n2) throws Exception {
        return this.populate(collection, n, n2, true);
    }

    public Map populate(Collection collection, int n, int n2, boolean bl) throws Exception {
        Object object;
        HashMap hashMap = new HashMap(collection.size());
        if (this.populatable == null) {
            this.populatable = this.mManager.findCacheClassForPOJO("%Library.Populate");
        }
        Object object2 = collection.iterator();
        while (object2.hasNext()) {
            object = this.findCacheClass(object2.next());
            if (!this.isPopulatable((CacheClass)object)) continue;
            this.calculateWeight((CacheClass)object, new HashSet(), hashMap, n2);
        }
        object2 = new PopComp(hashMap);
        object = new TreeMap(object2);
        TreeSet treeSet = new TreeSet(object2);
        treeSet.addAll(hashMap.keySet());
        int n3 = 0;
        for (CacheClass cacheClass : treeSet) {
            if (cacheClass.isAbstract()) continue;
            int n4 = (Integer)hashMap.get(cacheClass);
            int n5 = n * n4;
            if (bl) {
                CacheMethod cacheMethod = cacheClass.getMethod("Populate", null);
                Object object3 = cacheMethod.invoke(null, new Object[]{new Integer(n5)});
                n3 += ((Integer)object3).intValue();
                if (object == null) continue;
                object.put(cacheClass, object3);
                continue;
            }
            object.put(cacheClass, new Integer(n5));
        }
        if (bl) {
            object.put("TOTAL", new Integer(n3));
        }
        return object;
    }

    private Integer calculateWeight(CacheClass cacheClass, Set set, Map map, int n) throws CacheException {
        set.add(cacheClass);
        CacheField[] cacheFieldArray = cacheClass.getFields();
        int n2 = 0;
        for (int i = 0; i < cacheFieldArray.length; ++i) {
            CacheField cacheField = cacheFieldArray[i];
            CacheClass cacheClass2 = cacheField.getType();
            if (set.contains(cacheClass2) || !this.isPopulatable(cacheClass2)) continue;
            Integer n3 = (Integer)map.get(cacheClass2);
            if (n3 == null) {
                n3 = this.calculateWeight(cacheClass2, set, map, n);
            }
            n2 += n3 * n;
        }
        set.remove(cacheClass);
        if (n2 == 0) {
            n2 = 1;
        }
        Integer n4 = new Integer(n2);
        map.put(cacheClass, n4);
        return n4;
    }

    private boolean isPopulatable(CacheClass cacheClass) throws CacheException {
        if (!cacheClass.isPersistent()) {
            return false;
        }
        return this.populatable.isAssignableFrom(cacheClass);
    }

    private CacheClass findCacheClass(Object object) throws Exception {
        if (object instanceof CacheClass) {
            return (CacheClass)object;
        }
        if (object instanceof Class) {
            return this.findImplementation((Class)object);
        }
        if (object instanceof String) {
            CacheClass cacheClass = this.mManager.findCacheClassForPOJO((String)object);
            cacheClass = this.mManager.getFullDatabase().getCacheClass(cacheClass.getName());
            return cacheClass;
        }
        throw new IllegalArgumentException("Do not know how to find Cache Class for an instance of: " + object.getClass().getName());
    }

    private static class PopComp
    implements Comparator {
        private Map weights;

        public PopComp(Map map) {
            this.weights = map;
        }

        public int compare(Object object, Object object2) {
            int n;
            if (object.equals(object2)) {
                return 0;
            }
            if ("TOTAL".equals(object)) {
                return -1;
            }
            if ("TOTAL".equals(object2)) {
                return 1;
            }
            if (!(object instanceof CacheClass) || !(object2 instanceof CacheClass)) {
                throw new IllegalArgumentException();
            }
            int n2 = (Integer)this.weights.get(object);
            int n3 = n2 - (n = ((Integer)this.weights.get(object2)).intValue());
            if (n3 == 0) {
                n3 = object.toString().compareTo(object2.toString());
            }
            return n3;
        }
    }
}

