/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jsp;

import com.intersys.classes.Persistent;
import com.intersys.classes.RegisteredObject;
import com.intersys.classes.SerialStream;
import com.intersys.jsp.DBHelper;
import com.intersys.jsp.RuntimeEnvironment;
import com.intersys.objects.CacheException;
import com.intersys.objects.Database;
import com.intersys.objects.Id;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheField;
import com.intersys.objects.reflect.CacheModifier;
import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;

public class ObjectTagSupport
extends TagSupport {
    protected static final String SESSION_ID_PREFIX = "session.";
    protected static CacheClass PERSISTENT = null;
    protected static CacheClass STREAM = null;
    private String mId;
    private String mClassName;

    public String getId() {
        return this.mId;
    }

    public void setId(String string) {
        this.mId = string;
    }

    public String getClassname() {
        return this.mClassName;
    }

    public void setClassname(String string) {
        this.mClassName = string;
    }

    protected Persistent openObject() throws Exception {
        if (this.mId.startsWith(SESSION_ID_PREFIX)) {
            return this.fromSession();
        }
        CacheClass cacheClass = this.getCacheClass();
        Id id = new Id(this.mId);
        Persistent persistent = (Persistent)cacheClass.openObject(id);
        return persistent;
    }

    protected Persistent fromSession() throws Exception {
        String string = this.mId.substring(SESSION_ID_PREFIX.length());
        return (Persistent)DBHelper.retrieveFromSession(this.pageContext, string);
    }

    protected CacheClass getCacheClass() throws Exception {
        return this.getCacheClass(this.getClassname());
    }

    protected CacheClass getCacheClass(String string) throws Exception {
        RuntimeEnvironment runtimeEnvironment = DBHelper.getRTEnvironment(this.pageContext);
        Database database = runtimeEnvironment.getDBConnection();
        CacheClass cacheClass = database.getCacheClass(string);
        return cacheClass;
    }

    protected void setAttributesFromRequest() throws JspException {
        if (this.mClassName == null) {
            this.mClassName = DBHelper.getRequestParameter(this.pageContext, "classname");
        }
        if (this.mId == null) {
            this.mId = DBHelper.getRequestParameter(this.pageContext, this.mClassName + ".ID");
        }
        if (this.mId == null) {
            this.mId = DBHelper.getRequestParameter(this.pageContext, this.mClassName + ".id");
        }
        if (this.mId == null) {
            this.mId = DBHelper.getRequestParameter(this.pageContext, "id");
        }
        if (this.mId == null) {
            this.mId = DBHelper.getRequestParameter(this.pageContext, "ID");
        }
    }

    protected static void checkPersistentClass(Database database) throws CacheException {
        if (PERSISTENT == null) {
            PERSISTENT = database.getCacheClass(Persistent.getCacheClassName());
        }
    }

    protected static void checkStreamClass(Database database) throws CacheException {
        if (STREAM == null) {
            STREAM = database.getCacheClass(SerialStream.getCacheClassName());
        }
    }

    protected static String getDisplayName(RegisteredObject registeredObject) throws CacheException {
        if (registeredObject == null) {
            return null;
        }
        CacheClass cacheClass = registeredObject.getCacheClass();
        CacheField cacheField = ObjectTagSupport.getDisplayNameField(cacheClass);
        Object object = null;
        if (cacheField != null) {
            object = cacheField.get(registeredObject);
        }
        if (object != null) {
            return object.toString();
        }
        if (registeredObject instanceof Persistent) {
            object = ((Persistent)registeredObject).getId();
        }
        if (object != null) {
            return cacheClass.getName() + "[ID=" + object.toString() + ']';
        }
        return cacheClass.getName() + "[OREF=" + registeredObject + ']';
    }

    protected static String getDisplayName(CacheClass cacheClass) throws CacheException {
        CacheField cacheField = ObjectTagSupport.getDisplayNameField(cacheClass);
        if (cacheField == null) {
            return "ID";
        }
        return cacheField.getName();
    }

    protected static boolean isLiteralProperty(String string, String string2, PageContext pageContext) throws JspException {
        if (string.indexOf(95) > 0) {
            return true;
        }
        RuntimeEnvironment runtimeEnvironment = DBHelper.getRTEnvironment(pageContext);
        Database database = runtimeEnvironment.getDBConnection();
        try {
            CacheClass cacheClass = database.getCacheClass(string);
            CacheField cacheField = cacheClass.getField(string2);
            if (cacheField == null) {
                return true;
            }
            return CacheModifier.isLiteral(cacheField.getModifiers());
        }
        catch (CacheException cacheException) {
            throw new JspException("Can not determine property type" + string2 + " in table " + string + ": " + cacheException.getMessage(), (Throwable)cacheException);
        }
    }

    protected static String getDisplayName(String string, String string2, PageContext pageContext) throws JspException {
        RuntimeEnvironment runtimeEnvironment = DBHelper.getRTEnvironment(pageContext);
        Database database = runtimeEnvironment.getDBConnection();
        try {
            CacheClass cacheClass = database.getCacheClass(string);
            CacheField cacheField = cacheClass.getField(string2);
            if (cacheField == null) {
                return "ID";
            }
            cacheClass = cacheField.getType();
            String string3 = ObjectTagSupport.getDisplayName(cacheClass);
            return cacheClass.getName() + '.' + string3;
        }
        catch (CacheException cacheException) {
            throw new JspException("Can not determine display field for table " + string + " and property " + string2 + ": " + cacheException.getMessage(), (Throwable)cacheException);
        }
    }

    protected static String getCrossTable(String string, String string2, PageContext pageContext) throws JspException {
        RuntimeEnvironment runtimeEnvironment = DBHelper.getRTEnvironment(pageContext);
        Database database = runtimeEnvironment.getDBConnection();
        try {
            CacheClass cacheClass = database.getCacheClass(string);
            CacheField cacheField = cacheClass.getField(string2);
            if (cacheField == null) {
                return null;
            }
            cacheClass = cacheField.getType();
            return cacheClass.getName();
        }
        catch (CacheException cacheException) {
            throw new JspException("Can not determine cross table for table " + string + " and property " + string2 + ": " + cacheException.getMessage(), (Throwable)cacheException);
        }
    }

    protected static String getDisplayName(String string, PageContext pageContext) throws JspException {
        RuntimeEnvironment runtimeEnvironment = DBHelper.getRTEnvironment(pageContext);
        Database database = runtimeEnvironment.getDBConnection();
        try {
            CacheClass cacheClass = database.getCacheClass(string);
            return ObjectTagSupport.getDisplayName(cacheClass);
        }
        catch (CacheException cacheException) {
            throw new JspException("Can not determine display field for table " + string + ": " + cacheException.getMessage(), (Throwable)cacheException);
        }
    }

    protected static CacheField getDisplayNameField(CacheClass cacheClass) throws CacheException {
        CacheField cacheField = cacheClass.getField("DisplayName");
        if (cacheField != null) {
            return cacheField;
        }
        cacheField = cacheClass.getField("Name");
        if (cacheField != null) {
            return cacheField;
        }
        cacheField = cacheClass.getField("name");
        if (cacheField != null) {
            return cacheField;
        }
        cacheField = cacheClass.getField("Code");
        if (cacheField != null) {
            return cacheField;
        }
        cacheField = cacheClass.getField("code");
        if (cacheField != null) {
            return cacheField;
        }
        cacheField = cacheClass.getField("Description");
        if (cacheField != null) {
            return cacheField;
        }
        cacheField = cacheClass.getField("description");
        if (cacheField != null) {
            return cacheField;
        }
        cacheField = cacheClass.getField("Value");
        if (cacheField != null) {
            return cacheField;
        }
        cacheField = cacheClass.getField("value");
        return cacheField;
    }

    protected boolean isPersistent(CacheClass cacheClass) throws IOException {
        try {
            RuntimeEnvironment runtimeEnvironment = DBHelper.getRTEnvironment(this.pageContext);
            Database database = runtimeEnvironment.getDBConnection();
            ObjectTagSupport.checkPersistentClass(database);
            return PERSISTENT.isAssignableFrom(cacheClass);
        }
        catch (Exception exception) {
            JspWriter jspWriter = this.pageContext.getOut();
            jspWriter.println("ERROR: " + exception.getMessage());
            exception.printStackTrace(System.out);
            return true;
        }
    }

    protected boolean isStream(CacheClass cacheClass) throws IOException {
        try {
            RuntimeEnvironment runtimeEnvironment = DBHelper.getRTEnvironment(this.pageContext);
            Database database = runtimeEnvironment.getDBConnection();
            ObjectTagSupport.checkStreamClass(database);
            return STREAM.isAssignableFrom(cacheClass);
        }
        catch (Exception exception) {
            JspWriter jspWriter = this.pageContext.getOut();
            jspWriter.println("ERROR: " + exception.getMessage());
            exception.printStackTrace(System.out);
            return true;
        }
    }

    public void releaseRequestAttributes() {
        this.mId = null;
        this.mClassName = null;
    }
}

